# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccessPointPublicAccessBlockConfiguration',
    'AccessPointScope',
    'AccessPointVpcConfiguration',
    'DirectoryBucketAbortIncompleteMultipartUpload',
    'DirectoryBucketBucketEncryption',
    'DirectoryBucketLifecycleConfiguration',
    'DirectoryBucketRule',
    'DirectoryBucketServerSideEncryptionByDefault',
    'DirectoryBucketServerSideEncryptionRule',
]

@pulumi.output_type
class AccessPointPublicAccessBlockConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockPublicAcls":
            suggest = "block_public_acls"
        elif key == "blockPublicPolicy":
            suggest = "block_public_policy"
        elif key == "ignorePublicAcls":
            suggest = "ignore_public_acls"
        elif key == "restrictPublicBuckets":
            suggest = "restrict_public_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointPublicAccessBlockConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointPublicAccessBlockConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_public_acls: Optional[builtins.bool] = None,
                 block_public_policy: Optional[builtins.bool] = None,
                 ignore_public_acls: Optional[builtins.bool] = None,
                 restrict_public_buckets: Optional[builtins.bool] = None):
        """
        :param builtins.bool block_public_acls: Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to TRUE causes the following behavior:
               - PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
                - PUT Object calls fail if the request includes a public ACL.
               . - PUT Bucket calls fail if the request includes a public ACL.
               Enabling this setting doesn't affect existing policies or ACLs.
        :param builtins.bool block_public_policy: Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to TRUE causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. Enabling this setting doesn't affect existing bucket policies.
        :param builtins.bool ignore_public_acls: Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        :param builtins.bool restrict_public_buckets: Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to TRUE restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.
               Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        if block_public_acls is not None:
            pulumi.set(__self__, "block_public_acls", block_public_acls)
        if block_public_policy is not None:
            pulumi.set(__self__, "block_public_policy", block_public_policy)
        if ignore_public_acls is not None:
            pulumi.set(__self__, "ignore_public_acls", ignore_public_acls)
        if restrict_public_buckets is not None:
            pulumi.set(__self__, "restrict_public_buckets", restrict_public_buckets)

    @property
    @pulumi.getter(name="blockPublicAcls")
    def block_public_acls(self) -> Optional[builtins.bool]:
        """
        Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to TRUE causes the following behavior:
        - PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
         - PUT Object calls fail if the request includes a public ACL.
        . - PUT Bucket calls fail if the request includes a public ACL.
        Enabling this setting doesn't affect existing policies or ACLs.
        """
        return pulumi.get(self, "block_public_acls")

    @property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> Optional[builtins.bool]:
        """
        Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to TRUE causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. Enabling this setting doesn't affect existing bucket policies.
        """
        return pulumi.get(self, "block_public_policy")

    @property
    @pulumi.getter(name="ignorePublicAcls")
    def ignore_public_acls(self) -> Optional[builtins.bool]:
        """
        Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        """
        return pulumi.get(self, "ignore_public_acls")

    @property
    @pulumi.getter(name="restrictPublicBuckets")
    def restrict_public_buckets(self) -> Optional[builtins.bool]:
        """
        Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to TRUE restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.
        Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        return pulumi.get(self, "restrict_public_buckets")


@pulumi.output_type
class AccessPointScope(dict):
    def __init__(__self__, *,
                 permissions: Optional[Sequence['AccessPointScopePermissionsItem']] = None,
                 prefixes: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence['AccessPointScopePermissionsItem'] permissions: You can include one or more API operations as permissions
        :param Sequence[builtins.str] prefixes: You can specify any amount of preﬁxes, but the total length of characters of all preﬁxes must be less than 256 bytes in size.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if prefixes is not None:
            pulumi.set(__self__, "prefixes", prefixes)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence['AccessPointScopePermissionsItem']]:
        """
        You can include one or more API operations as permissions
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def prefixes(self) -> Optional[Sequence[builtins.str]]:
        """
        You can specify any amount of preﬁxes, but the total length of characters of all preﬁxes must be less than 256 bytes in size.
        """
        return pulumi.get(self, "prefixes")


@pulumi.output_type
class AccessPointVpcConfiguration(dict):
    """
    The Virtual Private Cloud (VPC) configuration for a bucket access point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPointVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPointVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPointVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: Optional[builtins.str] = None):
        """
        The Virtual Private Cloud (VPC) configuration for a bucket access point.
        :param builtins.str vpc_id: If this field is specified, this access point will only allow connections from the specified VPC ID.
        """
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[builtins.str]:
        """
        If this field is specified, this access point will only allow connections from the specified VPC ID.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class DirectoryBucketAbortIncompleteMultipartUpload(dict):
    """
    Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysAfterInitiation":
            suggest = "days_after_initiation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryBucketAbortIncompleteMultipartUpload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryBucketAbortIncompleteMultipartUpload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryBucketAbortIncompleteMultipartUpload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days_after_initiation: builtins.int):
        """
        Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
        :param builtins.int days_after_initiation: Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload.
        """
        pulumi.set(__self__, "days_after_initiation", days_after_initiation)

    @property
    @pulumi.getter(name="daysAfterInitiation")
    def days_after_initiation(self) -> builtins.int:
        """
        Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload.
        """
        return pulumi.get(self, "days_after_initiation")


@pulumi.output_type
class DirectoryBucketBucketEncryption(dict):
    """
    Specifies default encryption for a bucket using server-side encryption with Amazon S3 managed keys (SSE-S3) or AWS KMS keys (SSE-KMS).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverSideEncryptionConfiguration":
            suggest = "server_side_encryption_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryBucketBucketEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryBucketBucketEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryBucketBucketEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_side_encryption_configuration: Sequence['outputs.DirectoryBucketServerSideEncryptionRule']):
        """
        Specifies default encryption for a bucket using server-side encryption with Amazon S3 managed keys (SSE-S3) or AWS KMS keys (SSE-KMS).
        :param Sequence['DirectoryBucketServerSideEncryptionRule'] server_side_encryption_configuration: Specifies the default server-side-encryption configuration.
        """
        pulumi.set(__self__, "server_side_encryption_configuration", server_side_encryption_configuration)

    @property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> Sequence['outputs.DirectoryBucketServerSideEncryptionRule']:
        """
        Specifies the default server-side-encryption configuration.
        """
        return pulumi.get(self, "server_side_encryption_configuration")


@pulumi.output_type
class DirectoryBucketLifecycleConfiguration(dict):
    def __init__(__self__, *,
                 rules: Sequence['outputs.DirectoryBucketRule']):
        """
        :param Sequence['DirectoryBucketRule'] rules: A lifecycle rule for individual objects in an Amazon S3 Express bucket.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.DirectoryBucketRule']:
        """
        A lifecycle rule for individual objects in an Amazon S3 Express bucket.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class DirectoryBucketRule(dict):
    """
    You must specify at least one of the following properties: AbortIncompleteMultipartUpload, or ExpirationInDays.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUpload":
            suggest = "abort_incomplete_multipart_upload"
        elif key == "expirationInDays":
            suggest = "expiration_in_days"
        elif key == "objectSizeGreaterThan":
            suggest = "object_size_greater_than"
        elif key == "objectSizeLessThan":
            suggest = "object_size_less_than"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryBucketRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryBucketRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryBucketRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: 'DirectoryBucketRuleStatus',
                 abort_incomplete_multipart_upload: Optional['outputs.DirectoryBucketAbortIncompleteMultipartUpload'] = None,
                 expiration_in_days: Optional[builtins.int] = None,
                 id: Optional[builtins.str] = None,
                 object_size_greater_than: Optional[builtins.str] = None,
                 object_size_less_than: Optional[builtins.str] = None,
                 prefix: Optional[builtins.str] = None):
        """
        You must specify at least one of the following properties: AbortIncompleteMultipartUpload, or ExpirationInDays.
        :param 'DirectoryBucketRuleStatus' status: If `Enabled` , the rule is currently being applied. If `Disabled` , the rule is not currently being applied.
        :param 'DirectoryBucketAbortIncompleteMultipartUpload' abort_incomplete_multipart_upload: Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
        :param builtins.int expiration_in_days: Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon S3 Glacier. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
        :param builtins.str id: Unique identifier for the rule. The value can't be longer than 255 characters.
        :param builtins.str object_size_greater_than: Specifies the minimum object size in bytes for this rule to apply to. Objects must be larger than this value in bytes. For more information about size based rules, see [Lifecycle configuration using size-based rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules) in the *Amazon S3 User Guide* .
        :param builtins.str object_size_less_than: Specifies the maximum object size in bytes for this rule to apply to. Objects must be smaller than this value in bytes. For more information about sized based rules, see [Lifecycle configuration using size-based rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules) in the *Amazon S3 User Guide* .
        :param builtins.str prefix: Object key prefix that identifies one or more objects to which this rule applies.
               
               > Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints) .
        """
        pulumi.set(__self__, "status", status)
        if abort_incomplete_multipart_upload is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload", abort_incomplete_multipart_upload)
        if expiration_in_days is not None:
            pulumi.set(__self__, "expiration_in_days", expiration_in_days)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if object_size_greater_than is not None:
            pulumi.set(__self__, "object_size_greater_than", object_size_greater_than)
        if object_size_less_than is not None:
            pulumi.set(__self__, "object_size_less_than", object_size_less_than)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def status(self) -> 'DirectoryBucketRuleStatus':
        """
        If `Enabled` , the rule is currently being applied. If `Disabled` , the rule is not currently being applied.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="abortIncompleteMultipartUpload")
    def abort_incomplete_multipart_upload(self) -> Optional['outputs.DirectoryBucketAbortIncompleteMultipartUpload']:
        """
        Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload")

    @property
    @pulumi.getter(name="expirationInDays")
    def expiration_in_days(self) -> Optional[builtins.int]:
        """
        Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon S3 Glacier. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
        """
        return pulumi.get(self, "expiration_in_days")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Unique identifier for the rule. The value can't be longer than 255 characters.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="objectSizeGreaterThan")
    def object_size_greater_than(self) -> Optional[builtins.str]:
        """
        Specifies the minimum object size in bytes for this rule to apply to. Objects must be larger than this value in bytes. For more information about size based rules, see [Lifecycle configuration using size-based rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules) in the *Amazon S3 User Guide* .
        """
        return pulumi.get(self, "object_size_greater_than")

    @property
    @pulumi.getter(name="objectSizeLessThan")
    def object_size_less_than(self) -> Optional[builtins.str]:
        """
        Specifies the maximum object size in bytes for this rule to apply to. Objects must be smaller than this value in bytes. For more information about sized based rules, see [Lifecycle configuration using size-based rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules) in the *Amazon S3 User Guide* .
        """
        return pulumi.get(self, "object_size_less_than")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        Object key prefix that identifies one or more objects to which this rule applies.

        > Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints) .
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class DirectoryBucketServerSideEncryptionByDefault(dict):
    """
    Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseAlgorithm":
            suggest = "sse_algorithm"
        elif key == "kmsMasterKeyId":
            suggest = "kms_master_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryBucketServerSideEncryptionByDefault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryBucketServerSideEncryptionByDefault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryBucketServerSideEncryptionByDefault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_algorithm: 'DirectoryBucketServerSideEncryptionByDefaultSseAlgorithm',
                 kms_master_key_id: Optional[builtins.str] = None):
        """
        Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
        :param 'DirectoryBucketServerSideEncryptionByDefaultSseAlgorithm' sse_algorithm: Server-side encryption algorithm to use for the default encryption.
               
               > For directory buckets, there are only two supported values for server-side encryption: `AES256` and `aws:kms` .
        :param builtins.str kms_master_key_id: AWS Key Management Service (KMS) customer managed key ID to use for the default encryption. This parameter is allowed only if SSEAlgorithm is set to aws:kms. You can specify this parameter with the key ID or the Amazon Resource Name (ARN) of the KMS key
        """
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)

    @property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> 'DirectoryBucketServerSideEncryptionByDefaultSseAlgorithm':
        """
        Server-side encryption algorithm to use for the default encryption.

        > For directory buckets, there are only two supported values for server-side encryption: `AES256` and `aws:kms` .
        """
        return pulumi.get(self, "sse_algorithm")

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[builtins.str]:
        """
        AWS Key Management Service (KMS) customer managed key ID to use for the default encryption. This parameter is allowed only if SSEAlgorithm is set to aws:kms. You can specify this parameter with the key ID or the Amazon Resource Name (ARN) of the KMS key
        """
        return pulumi.get(self, "kms_master_key_id")


@pulumi.output_type
class DirectoryBucketServerSideEncryptionRule(dict):
    """
    Specifies the default server-side encryption configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketKeyEnabled":
            suggest = "bucket_key_enabled"
        elif key == "serverSideEncryptionByDefault":
            suggest = "server_side_encryption_by_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryBucketServerSideEncryptionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryBucketServerSideEncryptionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryBucketServerSideEncryptionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_key_enabled: Optional[builtins.bool] = None,
                 server_side_encryption_by_default: Optional['outputs.DirectoryBucketServerSideEncryptionByDefault'] = None):
        """
        Specifies the default server-side encryption configuration.
        :param builtins.bool bucket_key_enabled: Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Amazon S3 Express One Zone uses an S3 Bucket Key with SSE-KMS and S3 Bucket Key cannot be disabled. It's only allowed to set the BucketKeyEnabled element to true.
        :param 'DirectoryBucketServerSideEncryptionByDefault' server_side_encryption_by_default: Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
        """
        if bucket_key_enabled is not None:
            pulumi.set(__self__, "bucket_key_enabled", bucket_key_enabled)
        if server_side_encryption_by_default is not None:
            pulumi.set(__self__, "server_side_encryption_by_default", server_side_encryption_by_default)

    @property
    @pulumi.getter(name="bucketKeyEnabled")
    def bucket_key_enabled(self) -> Optional[builtins.bool]:
        """
        Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Amazon S3 Express One Zone uses an S3 Bucket Key with SSE-KMS and S3 Bucket Key cannot be disabled. It's only allowed to set the BucketKeyEnabled element to true.
        """
        return pulumi.get(self, "bucket_key_enabled")

    @property
    @pulumi.getter(name="serverSideEncryptionByDefault")
    def server_side_encryption_by_default(self) -> Optional['outputs.DirectoryBucketServerSideEncryptionByDefault']:
        """
        Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
        """
        return pulumi.get(self, "server_side_encryption_by_default")


