# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'AccessPointPublicAccessBlockConfigurationArgs',
    'AccessPointPublicAccessBlockConfigurationArgsDict',
    'AccessPointScopeArgs',
    'AccessPointScopeArgsDict',
    'AccessPointVpcConfigurationArgs',
    'AccessPointVpcConfigurationArgsDict',
    'DirectoryBucketAbortIncompleteMultipartUploadArgs',
    'DirectoryBucketAbortIncompleteMultipartUploadArgsDict',
    'DirectoryBucketBucketEncryptionArgs',
    'DirectoryBucketBucketEncryptionArgsDict',
    'DirectoryBucketLifecycleConfigurationArgs',
    'DirectoryBucketLifecycleConfigurationArgsDict',
    'DirectoryBucketRuleArgs',
    'DirectoryBucketRuleArgsDict',
    'DirectoryBucketServerSideEncryptionByDefaultArgs',
    'DirectoryBucketServerSideEncryptionByDefaultArgsDict',
    'DirectoryBucketServerSideEncryptionRuleArgs',
    'DirectoryBucketServerSideEncryptionRuleArgsDict',
]

MYPY = False

if not MYPY:
    class AccessPointPublicAccessBlockConfigurationArgsDict(TypedDict):
        block_public_acls: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to TRUE causes the following behavior:
        - PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
         - PUT Object calls fail if the request includes a public ACL.
        . - PUT Bucket calls fail if the request includes a public ACL.
        Enabling this setting doesn't affect existing policies or ACLs.
        """
        block_public_policy: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to TRUE causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. Enabling this setting doesn't affect existing bucket policies.
        """
        ignore_public_acls: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        """
        restrict_public_buckets: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to TRUE restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.
        Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
elif False:
    AccessPointPublicAccessBlockConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccessPointPublicAccessBlockConfigurationArgs:
    def __init__(__self__, *,
                 block_public_acls: Optional[pulumi.Input[builtins.bool]] = None,
                 block_public_policy: Optional[pulumi.Input[builtins.bool]] = None,
                 ignore_public_acls: Optional[pulumi.Input[builtins.bool]] = None,
                 restrict_public_buckets: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] block_public_acls: Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to TRUE causes the following behavior:
               - PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
                - PUT Object calls fail if the request includes a public ACL.
               . - PUT Bucket calls fail if the request includes a public ACL.
               Enabling this setting doesn't affect existing policies or ACLs.
        :param pulumi.Input[builtins.bool] block_public_policy: Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to TRUE causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. Enabling this setting doesn't affect existing bucket policies.
        :param pulumi.Input[builtins.bool] ignore_public_acls: Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        :param pulumi.Input[builtins.bool] restrict_public_buckets: Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to TRUE restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.
               Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        if block_public_acls is not None:
            pulumi.set(__self__, "block_public_acls", block_public_acls)
        if block_public_policy is not None:
            pulumi.set(__self__, "block_public_policy", block_public_policy)
        if ignore_public_acls is not None:
            pulumi.set(__self__, "ignore_public_acls", ignore_public_acls)
        if restrict_public_buckets is not None:
            pulumi.set(__self__, "restrict_public_buckets", restrict_public_buckets)

    @property
    @pulumi.getter(name="blockPublicAcls")
    def block_public_acls(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to TRUE causes the following behavior:
        - PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
         - PUT Object calls fail if the request includes a public ACL.
        . - PUT Bucket calls fail if the request includes a public ACL.
        Enabling this setting doesn't affect existing policies or ACLs.
        """
        return pulumi.get(self, "block_public_acls")

    @block_public_acls.setter
    def block_public_acls(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "block_public_acls", value)

    @property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to TRUE causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. Enabling this setting doesn't affect existing bucket policies.
        """
        return pulumi.get(self, "block_public_policy")

    @block_public_policy.setter
    def block_public_policy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "block_public_policy", value)

    @property
    @pulumi.getter(name="ignorePublicAcls")
    def ignore_public_acls(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to TRUE causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.
        """
        return pulumi.get(self, "ignore_public_acls")

    @ignore_public_acls.setter
    def ignore_public_acls(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ignore_public_acls", value)

    @property
    @pulumi.getter(name="restrictPublicBuckets")
    def restrict_public_buckets(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to TRUE restricts access to this bucket to only AWS services and authorized users within this account if the bucket has a public policy.
        Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.
        """
        return pulumi.get(self, "restrict_public_buckets")

    @restrict_public_buckets.setter
    def restrict_public_buckets(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "restrict_public_buckets", value)


if not MYPY:
    class AccessPointScopeArgsDict(TypedDict):
        permissions: NotRequired[pulumi.Input[Sequence[pulumi.Input['AccessPointScopePermissionsItem']]]]
        """
        You can include one or more API operations as permissions
        """
        prefixes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        You can specify any amount of preﬁxes, but the total length of characters of all preﬁxes must be less than 256 bytes in size.
        """
elif False:
    AccessPointScopeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccessPointScopeArgs:
    def __init__(__self__, *,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPointScopePermissionsItem']]]] = None,
                 prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['AccessPointScopePermissionsItem']]] permissions: You can include one or more API operations as permissions
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] prefixes: You can specify any amount of preﬁxes, but the total length of characters of all preﬁxes must be less than 256 bytes in size.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if prefixes is not None:
            pulumi.set(__self__, "prefixes", prefixes)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPointScopePermissionsItem']]]]:
        """
        You can include one or more API operations as permissions
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPointScopePermissionsItem']]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter
    def prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        You can specify any amount of preﬁxes, but the total length of characters of all preﬁxes must be less than 256 bytes in size.
        """
        return pulumi.get(self, "prefixes")

    @prefixes.setter
    def prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "prefixes", value)


if not MYPY:
    class AccessPointVpcConfigurationArgsDict(TypedDict):
        """
        The Virtual Private Cloud (VPC) configuration for a bucket access point.
        """
        vpc_id: NotRequired[pulumi.Input[builtins.str]]
        """
        If this field is specified, this access point will only allow connections from the specified VPC ID.
        """
elif False:
    AccessPointVpcConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccessPointVpcConfigurationArgs:
    def __init__(__self__, *,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The Virtual Private Cloud (VPC) configuration for a bucket access point.
        :param pulumi.Input[builtins.str] vpc_id: If this field is specified, this access point will only allow connections from the specified VPC ID.
        """
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If this field is specified, this access point will only allow connections from the specified VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_id", value)


if not MYPY:
    class DirectoryBucketAbortIncompleteMultipartUploadArgsDict(TypedDict):
        """
        Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
        """
        days_after_initiation: pulumi.Input[builtins.int]
        """
        Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload.
        """
elif False:
    DirectoryBucketAbortIncompleteMultipartUploadArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DirectoryBucketAbortIncompleteMultipartUploadArgs:
    def __init__(__self__, *,
                 days_after_initiation: pulumi.Input[builtins.int]):
        """
        Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
        :param pulumi.Input[builtins.int] days_after_initiation: Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload.
        """
        pulumi.set(__self__, "days_after_initiation", days_after_initiation)

    @property
    @pulumi.getter(name="daysAfterInitiation")
    def days_after_initiation(self) -> pulumi.Input[builtins.int]:
        """
        Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload.
        """
        return pulumi.get(self, "days_after_initiation")

    @days_after_initiation.setter
    def days_after_initiation(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "days_after_initiation", value)


if not MYPY:
    class DirectoryBucketBucketEncryptionArgsDict(TypedDict):
        """
        Specifies default encryption for a bucket using server-side encryption with Amazon S3 managed keys (SSE-S3) or AWS KMS keys (SSE-KMS).
        """
        server_side_encryption_configuration: pulumi.Input[Sequence[pulumi.Input['DirectoryBucketServerSideEncryptionRuleArgsDict']]]
        """
        Specifies the default server-side-encryption configuration.
        """
elif False:
    DirectoryBucketBucketEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DirectoryBucketBucketEncryptionArgs:
    def __init__(__self__, *,
                 server_side_encryption_configuration: pulumi.Input[Sequence[pulumi.Input['DirectoryBucketServerSideEncryptionRuleArgs']]]):
        """
        Specifies default encryption for a bucket using server-side encryption with Amazon S3 managed keys (SSE-S3) or AWS KMS keys (SSE-KMS).
        :param pulumi.Input[Sequence[pulumi.Input['DirectoryBucketServerSideEncryptionRuleArgs']]] server_side_encryption_configuration: Specifies the default server-side-encryption configuration.
        """
        pulumi.set(__self__, "server_side_encryption_configuration", server_side_encryption_configuration)

    @property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> pulumi.Input[Sequence[pulumi.Input['DirectoryBucketServerSideEncryptionRuleArgs']]]:
        """
        Specifies the default server-side-encryption configuration.
        """
        return pulumi.get(self, "server_side_encryption_configuration")

    @server_side_encryption_configuration.setter
    def server_side_encryption_configuration(self, value: pulumi.Input[Sequence[pulumi.Input['DirectoryBucketServerSideEncryptionRuleArgs']]]):
        pulumi.set(self, "server_side_encryption_configuration", value)


if not MYPY:
    class DirectoryBucketLifecycleConfigurationArgsDict(TypedDict):
        rules: pulumi.Input[Sequence[pulumi.Input['DirectoryBucketRuleArgsDict']]]
        """
        A lifecycle rule for individual objects in an Amazon S3 Express bucket.
        """
elif False:
    DirectoryBucketLifecycleConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DirectoryBucketLifecycleConfigurationArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['DirectoryBucketRuleArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['DirectoryBucketRuleArgs']]] rules: A lifecycle rule for individual objects in an Amazon S3 Express bucket.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['DirectoryBucketRuleArgs']]]:
        """
        A lifecycle rule for individual objects in an Amazon S3 Express bucket.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['DirectoryBucketRuleArgs']]]):
        pulumi.set(self, "rules", value)


if not MYPY:
    class DirectoryBucketRuleArgsDict(TypedDict):
        """
        You must specify at least one of the following properties: AbortIncompleteMultipartUpload, or ExpirationInDays.
        """
        status: pulumi.Input['DirectoryBucketRuleStatus']
        """
        If `Enabled` , the rule is currently being applied. If `Disabled` , the rule is not currently being applied.
        """
        abort_incomplete_multipart_upload: NotRequired[pulumi.Input['DirectoryBucketAbortIncompleteMultipartUploadArgsDict']]
        """
        Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
        """
        expiration_in_days: NotRequired[pulumi.Input[builtins.int]]
        """
        Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon S3 Glacier. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        Unique identifier for the rule. The value can't be longer than 255 characters.
        """
        object_size_greater_than: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the minimum object size in bytes for this rule to apply to. Objects must be larger than this value in bytes. For more information about size based rules, see [Lifecycle configuration using size-based rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules) in the *Amazon S3 User Guide* .
        """
        object_size_less_than: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the maximum object size in bytes for this rule to apply to. Objects must be smaller than this value in bytes. For more information about sized based rules, see [Lifecycle configuration using size-based rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules) in the *Amazon S3 User Guide* .
        """
        prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        Object key prefix that identifies one or more objects to which this rule applies.

        > Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints) .
        """
elif False:
    DirectoryBucketRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DirectoryBucketRuleArgs:
    def __init__(__self__, *,
                 status: pulumi.Input['DirectoryBucketRuleStatus'],
                 abort_incomplete_multipart_upload: Optional[pulumi.Input['DirectoryBucketAbortIncompleteMultipartUploadArgs']] = None,
                 expiration_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 object_size_greater_than: Optional[pulumi.Input[builtins.str]] = None,
                 object_size_less_than: Optional[pulumi.Input[builtins.str]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        You must specify at least one of the following properties: AbortIncompleteMultipartUpload, or ExpirationInDays.
        :param pulumi.Input['DirectoryBucketRuleStatus'] status: If `Enabled` , the rule is currently being applied. If `Disabled` , the rule is not currently being applied.
        :param pulumi.Input['DirectoryBucketAbortIncompleteMultipartUploadArgs'] abort_incomplete_multipart_upload: Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
        :param pulumi.Input[builtins.int] expiration_in_days: Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon S3 Glacier. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
        :param pulumi.Input[builtins.str] id: Unique identifier for the rule. The value can't be longer than 255 characters.
        :param pulumi.Input[builtins.str] object_size_greater_than: Specifies the minimum object size in bytes for this rule to apply to. Objects must be larger than this value in bytes. For more information about size based rules, see [Lifecycle configuration using size-based rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules) in the *Amazon S3 User Guide* .
        :param pulumi.Input[builtins.str] object_size_less_than: Specifies the maximum object size in bytes for this rule to apply to. Objects must be smaller than this value in bytes. For more information about sized based rules, see [Lifecycle configuration using size-based rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules) in the *Amazon S3 User Guide* .
        :param pulumi.Input[builtins.str] prefix: Object key prefix that identifies one or more objects to which this rule applies.
               
               > Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints) .
        """
        pulumi.set(__self__, "status", status)
        if abort_incomplete_multipart_upload is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload", abort_incomplete_multipart_upload)
        if expiration_in_days is not None:
            pulumi.set(__self__, "expiration_in_days", expiration_in_days)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if object_size_greater_than is not None:
            pulumi.set(__self__, "object_size_greater_than", object_size_greater_than)
        if object_size_less_than is not None:
            pulumi.set(__self__, "object_size_less_than", object_size_less_than)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input['DirectoryBucketRuleStatus']:
        """
        If `Enabled` , the rule is currently being applied. If `Disabled` , the rule is not currently being applied.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input['DirectoryBucketRuleStatus']):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="abortIncompleteMultipartUpload")
    def abort_incomplete_multipart_upload(self) -> Optional[pulumi.Input['DirectoryBucketAbortIncompleteMultipartUploadArgs']]:
        """
        Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload")

    @abort_incomplete_multipart_upload.setter
    def abort_incomplete_multipart_upload(self, value: Optional[pulumi.Input['DirectoryBucketAbortIncompleteMultipartUploadArgs']]):
        pulumi.set(self, "abort_incomplete_multipart_upload", value)

    @property
    @pulumi.getter(name="expirationInDays")
    def expiration_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon S3 Glacier. If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
        """
        return pulumi.get(self, "expiration_in_days")

    @expiration_in_days.setter
    def expiration_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "expiration_in_days", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier for the rule. The value can't be longer than 255 characters.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="objectSizeGreaterThan")
    def object_size_greater_than(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the minimum object size in bytes for this rule to apply to. Objects must be larger than this value in bytes. For more information about size based rules, see [Lifecycle configuration using size-based rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules) in the *Amazon S3 User Guide* .
        """
        return pulumi.get(self, "object_size_greater_than")

    @object_size_greater_than.setter
    def object_size_greater_than(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_size_greater_than", value)

    @property
    @pulumi.getter(name="objectSizeLessThan")
    def object_size_less_than(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the maximum object size in bytes for this rule to apply to. Objects must be smaller than this value in bytes. For more information about sized based rules, see [Lifecycle configuration using size-based rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules) in the *Amazon S3 User Guide* .
        """
        return pulumi.get(self, "object_size_less_than")

    @object_size_less_than.setter
    def object_size_less_than(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_size_less_than", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Object key prefix that identifies one or more objects to which this rule applies.

        > Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints) .
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefix", value)


if not MYPY:
    class DirectoryBucketServerSideEncryptionByDefaultArgsDict(TypedDict):
        """
        Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
        """
        sse_algorithm: pulumi.Input['DirectoryBucketServerSideEncryptionByDefaultSseAlgorithm']
        """
        Server-side encryption algorithm to use for the default encryption.

        > For directory buckets, there are only two supported values for server-side encryption: `AES256` and `aws:kms` .
        """
        kms_master_key_id: NotRequired[pulumi.Input[builtins.str]]
        """
        AWS Key Management Service (KMS) customer managed key ID to use for the default encryption. This parameter is allowed only if SSEAlgorithm is set to aws:kms. You can specify this parameter with the key ID or the Amazon Resource Name (ARN) of the KMS key
        """
elif False:
    DirectoryBucketServerSideEncryptionByDefaultArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DirectoryBucketServerSideEncryptionByDefaultArgs:
    def __init__(__self__, *,
                 sse_algorithm: pulumi.Input['DirectoryBucketServerSideEncryptionByDefaultSseAlgorithm'],
                 kms_master_key_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
        :param pulumi.Input['DirectoryBucketServerSideEncryptionByDefaultSseAlgorithm'] sse_algorithm: Server-side encryption algorithm to use for the default encryption.
               
               > For directory buckets, there are only two supported values for server-side encryption: `AES256` and `aws:kms` .
        :param pulumi.Input[builtins.str] kms_master_key_id: AWS Key Management Service (KMS) customer managed key ID to use for the default encryption. This parameter is allowed only if SSEAlgorithm is set to aws:kms. You can specify this parameter with the key ID or the Amazon Resource Name (ARN) of the KMS key
        """
        pulumi.set(__self__, "sse_algorithm", sse_algorithm)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)

    @property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> pulumi.Input['DirectoryBucketServerSideEncryptionByDefaultSseAlgorithm']:
        """
        Server-side encryption algorithm to use for the default encryption.

        > For directory buckets, there are only two supported values for server-side encryption: `AES256` and `aws:kms` .
        """
        return pulumi.get(self, "sse_algorithm")

    @sse_algorithm.setter
    def sse_algorithm(self, value: pulumi.Input['DirectoryBucketServerSideEncryptionByDefaultSseAlgorithm']):
        pulumi.set(self, "sse_algorithm", value)

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS Key Management Service (KMS) customer managed key ID to use for the default encryption. This parameter is allowed only if SSEAlgorithm is set to aws:kms. You can specify this parameter with the key ID or the Amazon Resource Name (ARN) of the KMS key
        """
        return pulumi.get(self, "kms_master_key_id")

    @kms_master_key_id.setter
    def kms_master_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_master_key_id", value)


if not MYPY:
    class DirectoryBucketServerSideEncryptionRuleArgsDict(TypedDict):
        """
        Specifies the default server-side encryption configuration.
        """
        bucket_key_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Amazon S3 Express One Zone uses an S3 Bucket Key with SSE-KMS and S3 Bucket Key cannot be disabled. It's only allowed to set the BucketKeyEnabled element to true.
        """
        server_side_encryption_by_default: NotRequired[pulumi.Input['DirectoryBucketServerSideEncryptionByDefaultArgsDict']]
        """
        Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
        """
elif False:
    DirectoryBucketServerSideEncryptionRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DirectoryBucketServerSideEncryptionRuleArgs:
    def __init__(__self__, *,
                 bucket_key_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 server_side_encryption_by_default: Optional[pulumi.Input['DirectoryBucketServerSideEncryptionByDefaultArgs']] = None):
        """
        Specifies the default server-side encryption configuration.
        :param pulumi.Input[builtins.bool] bucket_key_enabled: Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Amazon S3 Express One Zone uses an S3 Bucket Key with SSE-KMS and S3 Bucket Key cannot be disabled. It's only allowed to set the BucketKeyEnabled element to true.
        :param pulumi.Input['DirectoryBucketServerSideEncryptionByDefaultArgs'] server_side_encryption_by_default: Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
        """
        if bucket_key_enabled is not None:
            pulumi.set(__self__, "bucket_key_enabled", bucket_key_enabled)
        if server_side_encryption_by_default is not None:
            pulumi.set(__self__, "server_side_encryption_by_default", server_side_encryption_by_default)

    @property
    @pulumi.getter(name="bucketKeyEnabled")
    def bucket_key_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Amazon S3 Express One Zone uses an S3 Bucket Key with SSE-KMS and S3 Bucket Key cannot be disabled. It's only allowed to set the BucketKeyEnabled element to true.
        """
        return pulumi.get(self, "bucket_key_enabled")

    @bucket_key_enabled.setter
    def bucket_key_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "bucket_key_enabled", value)

    @property
    @pulumi.getter(name="serverSideEncryptionByDefault")
    def server_side_encryption_by_default(self) -> Optional[pulumi.Input['DirectoryBucketServerSideEncryptionByDefaultArgs']]:
        """
        Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
        """
        return pulumi.get(self, "server_side_encryption_by_default")

    @server_side_encryption_by_default.setter
    def server_side_encryption_by_default(self, value: Optional[pulumi.Input['DirectoryBucketServerSideEncryptionByDefaultArgs']]):
        pulumi.set(self, "server_side_encryption_by_default", value)


