# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetBucketResult',
    'AwaitableGetBucketResult',
    'get_bucket',
    'get_bucket_output',
]

@pulumi.output_type
class GetBucketResult:
    def __init__(__self__, accelerate_configuration=None, analytics_configurations=None, arn=None, bucket_encryption=None, cors_configuration=None, domain_name=None, dual_stack_domain_name=None, intelligent_tiering_configurations=None, inventory_configurations=None, lifecycle_configuration=None, logging_configuration=None, metadata_table_configuration=None, metrics_configurations=None, notification_configuration=None, object_lock_configuration=None, object_lock_enabled=None, ownership_controls=None, public_access_block_configuration=None, regional_domain_name=None, replication_configuration=None, tags=None, versioning_configuration=None, website_configuration=None, website_url=None):
        if accelerate_configuration and not isinstance(accelerate_configuration, dict):
            raise TypeError("Expected argument 'accelerate_configuration' to be a dict")
        pulumi.set(__self__, "accelerate_configuration", accelerate_configuration)
        if analytics_configurations and not isinstance(analytics_configurations, list):
            raise TypeError("Expected argument 'analytics_configurations' to be a list")
        pulumi.set(__self__, "analytics_configurations", analytics_configurations)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if bucket_encryption and not isinstance(bucket_encryption, dict):
            raise TypeError("Expected argument 'bucket_encryption' to be a dict")
        pulumi.set(__self__, "bucket_encryption", bucket_encryption)
        if cors_configuration and not isinstance(cors_configuration, dict):
            raise TypeError("Expected argument 'cors_configuration' to be a dict")
        pulumi.set(__self__, "cors_configuration", cors_configuration)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if dual_stack_domain_name and not isinstance(dual_stack_domain_name, str):
            raise TypeError("Expected argument 'dual_stack_domain_name' to be a str")
        pulumi.set(__self__, "dual_stack_domain_name", dual_stack_domain_name)
        if intelligent_tiering_configurations and not isinstance(intelligent_tiering_configurations, list):
            raise TypeError("Expected argument 'intelligent_tiering_configurations' to be a list")
        pulumi.set(__self__, "intelligent_tiering_configurations", intelligent_tiering_configurations)
        if inventory_configurations and not isinstance(inventory_configurations, list):
            raise TypeError("Expected argument 'inventory_configurations' to be a list")
        pulumi.set(__self__, "inventory_configurations", inventory_configurations)
        if lifecycle_configuration and not isinstance(lifecycle_configuration, dict):
            raise TypeError("Expected argument 'lifecycle_configuration' to be a dict")
        pulumi.set(__self__, "lifecycle_configuration", lifecycle_configuration)
        if logging_configuration and not isinstance(logging_configuration, dict):
            raise TypeError("Expected argument 'logging_configuration' to be a dict")
        pulumi.set(__self__, "logging_configuration", logging_configuration)
        if metadata_table_configuration and not isinstance(metadata_table_configuration, dict):
            raise TypeError("Expected argument 'metadata_table_configuration' to be a dict")
        pulumi.set(__self__, "metadata_table_configuration", metadata_table_configuration)
        if metrics_configurations and not isinstance(metrics_configurations, list):
            raise TypeError("Expected argument 'metrics_configurations' to be a list")
        pulumi.set(__self__, "metrics_configurations", metrics_configurations)
        if notification_configuration and not isinstance(notification_configuration, dict):
            raise TypeError("Expected argument 'notification_configuration' to be a dict")
        pulumi.set(__self__, "notification_configuration", notification_configuration)
        if object_lock_configuration and not isinstance(object_lock_configuration, dict):
            raise TypeError("Expected argument 'object_lock_configuration' to be a dict")
        pulumi.set(__self__, "object_lock_configuration", object_lock_configuration)
        if object_lock_enabled and not isinstance(object_lock_enabled, bool):
            raise TypeError("Expected argument 'object_lock_enabled' to be a bool")
        pulumi.set(__self__, "object_lock_enabled", object_lock_enabled)
        if ownership_controls and not isinstance(ownership_controls, dict):
            raise TypeError("Expected argument 'ownership_controls' to be a dict")
        pulumi.set(__self__, "ownership_controls", ownership_controls)
        if public_access_block_configuration and not isinstance(public_access_block_configuration, dict):
            raise TypeError("Expected argument 'public_access_block_configuration' to be a dict")
        pulumi.set(__self__, "public_access_block_configuration", public_access_block_configuration)
        if regional_domain_name and not isinstance(regional_domain_name, str):
            raise TypeError("Expected argument 'regional_domain_name' to be a str")
        pulumi.set(__self__, "regional_domain_name", regional_domain_name)
        if replication_configuration and not isinstance(replication_configuration, dict):
            raise TypeError("Expected argument 'replication_configuration' to be a dict")
        pulumi.set(__self__, "replication_configuration", replication_configuration)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if versioning_configuration and not isinstance(versioning_configuration, dict):
            raise TypeError("Expected argument 'versioning_configuration' to be a dict")
        pulumi.set(__self__, "versioning_configuration", versioning_configuration)
        if website_configuration and not isinstance(website_configuration, dict):
            raise TypeError("Expected argument 'website_configuration' to be a dict")
        pulumi.set(__self__, "website_configuration", website_configuration)
        if website_url and not isinstance(website_url, str):
            raise TypeError("Expected argument 'website_url' to be a str")
        pulumi.set(__self__, "website_url", website_url)

    @property
    @pulumi.getter(name="accelerateConfiguration")
    def accelerate_configuration(self) -> Optional['outputs.BucketAccelerateConfiguration']:
        """
        Configures the transfer acceleration state for an Amazon S3 bucket. For more information, see [Amazon S3 Transfer Acceleration](https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "accelerate_configuration")

    @property
    @pulumi.getter(name="analyticsConfigurations")
    def analytics_configurations(self) -> Optional[Sequence['outputs.BucketAnalyticsConfiguration']]:
        """
        Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.
        """
        return pulumi.get(self, "analytics_configurations")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Returns the Amazon Resource Name (ARN) of the specified bucket.

        Example: `arn:aws:s3:::DOC-EXAMPLE-BUCKET`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="bucketEncryption")
    def bucket_encryption(self) -> Optional['outputs.BucketEncryption']:
        """
        Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3), AWS KMS-managed keys (SSE-KMS), or dual-layer server-side encryption with KMS-managed keys (DSSE-KMS). For information about the Amazon S3 default encryption feature, see [Amazon S3 Default Encryption for S3 Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "bucket_encryption")

    @property
    @pulumi.getter(name="corsConfiguration")
    def cors_configuration(self) -> Optional['outputs.BucketCorsConfiguration']:
        """
        Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see [Enabling Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "cors_configuration")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[builtins.str]:
        """
        Returns the IPv4 DNS name of the specified bucket.

        Example: `DOC-EXAMPLE-BUCKET.s3.amazonaws.com`
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="dualStackDomainName")
    def dual_stack_domain_name(self) -> Optional[builtins.str]:
        """
        Returns the IPv6 DNS name of the specified bucket.

        Example: `DOC-EXAMPLE-BUCKET.s3.dualstack.us-east-2.amazonaws.com`

        For more information about dual-stack endpoints, see [Using Amazon S3 Dual-Stack Endpoints](https://docs.aws.amazon.com/AmazonS3/latest/dev/dual-stack-endpoints.html) .
        """
        return pulumi.get(self, "dual_stack_domain_name")

    @property
    @pulumi.getter(name="intelligentTieringConfigurations")
    def intelligent_tiering_configurations(self) -> Optional[Sequence['outputs.BucketIntelligentTieringConfiguration']]:
        """
        Defines how Amazon S3 handles Intelligent-Tiering storage.
        """
        return pulumi.get(self, "intelligent_tiering_configurations")

    @property
    @pulumi.getter(name="inventoryConfigurations")
    def inventory_configurations(self) -> Optional[Sequence['outputs.BucketInventoryConfiguration']]:
        """
        Specifies the inventory configuration for an Amazon S3 bucket. For more information, see [GET Bucket inventory](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html) in the *Amazon S3 API Reference*.
        """
        return pulumi.get(self, "inventory_configurations")

    @property
    @pulumi.getter(name="lifecycleConfiguration")
    def lifecycle_configuration(self) -> Optional['outputs.BucketLifecycleConfiguration']:
        """
        Specifies the lifecycle configuration for objects in an Amazon S3 bucket. For more information, see [Object Lifecycle Management](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html) in the *Amazon S3 User Guide*.
        """
        return pulumi.get(self, "lifecycle_configuration")

    @property
    @pulumi.getter(name="loggingConfiguration")
    def logging_configuration(self) -> Optional['outputs.BucketLoggingConfiguration']:
        """
        Settings that define where logs are stored.
        """
        return pulumi.get(self, "logging_configuration")

    @property
    @pulumi.getter(name="metadataTableConfiguration")
    def metadata_table_configuration(self) -> Optional['outputs.BucketMetadataTableConfiguration']:
        """
        The metadata table configuration of an S3 general purpose bucket.
        """
        return pulumi.get(self, "metadata_table_configuration")

    @property
    @pulumi.getter(name="metricsConfigurations")
    def metrics_configurations(self) -> Optional[Sequence['outputs.BucketMetricsConfiguration']]:
        """
        Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket. If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For more information, see [PutBucketMetricsConfiguration](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html).
        """
        return pulumi.get(self, "metrics_configurations")

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> Optional['outputs.BucketNotificationConfiguration']:
        """
        Configuration that defines how Amazon S3 handles bucket notifications.
        """
        return pulumi.get(self, "notification_configuration")

    @property
    @pulumi.getter(name="objectLockConfiguration")
    def object_lock_configuration(self) -> Optional['outputs.BucketObjectLockConfiguration']:
        """
        This operation is not supported for directory buckets.
          Places an Object Lock configuration on the specified bucket. The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see [Locking Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). 
           +  The ``DefaultRetention`` settings require both a mode and a period.
          +  The ``DefaultRetention`` period can be either ``Days`` or ``Years`` but you must select one. You cannot specify ``Days`` and ``Years`` at the same time.
          +  You can enable Object Lock for new or existing buckets. For more information, see [Configuring Object Lock](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-configure.html).
        """
        return pulumi.get(self, "object_lock_configuration")

    @property
    @pulumi.getter(name="objectLockEnabled")
    def object_lock_enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether this bucket has an Object Lock configuration enabled. Enable ``ObjectLockEnabled`` when you apply ``ObjectLockConfiguration`` to a bucket.
        """
        return pulumi.get(self, "object_lock_enabled")

    @property
    @pulumi.getter(name="ownershipControls")
    def ownership_controls(self) -> Optional['outputs.BucketOwnershipControls']:
        """
        Configuration that defines how Amazon S3 handles Object Ownership rules.
        """
        return pulumi.get(self, "ownership_controls")

    @property
    @pulumi.getter(name="publicAccessBlockConfiguration")
    def public_access_block_configuration(self) -> Optional['outputs.BucketPublicAccessBlockConfiguration']:
        """
        Configuration that defines how Amazon S3 handles public access.
        """
        return pulumi.get(self, "public_access_block_configuration")

    @property
    @pulumi.getter(name="regionalDomainName")
    def regional_domain_name(self) -> Optional[builtins.str]:
        """
        Returns the regional domain name of the specified bucket.

        Example: `DOC-EXAMPLE-BUCKET.s3.us-east-2.amazonaws.com`
        """
        return pulumi.get(self, "regional_domain_name")

    @property
    @pulumi.getter(name="replicationConfiguration")
    def replication_configuration(self) -> Optional['outputs.BucketReplicationConfiguration']:
        """
        Configuration for replicating objects in an S3 bucket. To enable replication, you must also enable versioning by using the ``VersioningConfiguration`` property.
         Amazon S3 can store replicated objects in a single destination bucket or multiple destination buckets. The destination bucket or buckets must already exist.
        """
        return pulumi.get(self, "replication_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An arbitrary set of tags (key-value pairs) for this S3 bucket.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="versioningConfiguration")
    def versioning_configuration(self) -> Optional['outputs.BucketVersioningConfiguration']:
        """
        Enables multiple versions of all objects in this bucket. You might enable versioning to prevent objects from being deleted or overwritten by mistake or to archive objects so that you can retrieve previous versions of them.
          When you enable versioning on a bucket for the first time, it might take a short amount of time for the change to be fully propagated. We recommend that you wait for 15 minutes after enabling versioning before issuing write operations (``PUT`` or ``DELETE``) on objects in the bucket.
        """
        return pulumi.get(self, "versioning_configuration")

    @property
    @pulumi.getter(name="websiteConfiguration")
    def website_configuration(self) -> Optional['outputs.BucketWebsiteConfiguration']:
        """
        Information used to configure the bucket as a static website. For more information, see [Hosting Websites on Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html).
        """
        return pulumi.get(self, "website_configuration")

    @property
    @pulumi.getter(name="websiteUrl")
    def website_url(self) -> Optional[builtins.str]:
        """
        Returns the Amazon S3 website endpoint for the specified bucket.

        Example (IPv4): `http://DOC-EXAMPLE-BUCKET.s3-website.us-east-2.amazonaws.com`

        Example (IPv6): `http://DOC-EXAMPLE-BUCKET.s3.dualstack.us-east-2.amazonaws.com`
        """
        return pulumi.get(self, "website_url")


class AwaitableGetBucketResult(GetBucketResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBucketResult(
            accelerate_configuration=self.accelerate_configuration,
            analytics_configurations=self.analytics_configurations,
            arn=self.arn,
            bucket_encryption=self.bucket_encryption,
            cors_configuration=self.cors_configuration,
            domain_name=self.domain_name,
            dual_stack_domain_name=self.dual_stack_domain_name,
            intelligent_tiering_configurations=self.intelligent_tiering_configurations,
            inventory_configurations=self.inventory_configurations,
            lifecycle_configuration=self.lifecycle_configuration,
            logging_configuration=self.logging_configuration,
            metadata_table_configuration=self.metadata_table_configuration,
            metrics_configurations=self.metrics_configurations,
            notification_configuration=self.notification_configuration,
            object_lock_configuration=self.object_lock_configuration,
            object_lock_enabled=self.object_lock_enabled,
            ownership_controls=self.ownership_controls,
            public_access_block_configuration=self.public_access_block_configuration,
            regional_domain_name=self.regional_domain_name,
            replication_configuration=self.replication_configuration,
            tags=self.tags,
            versioning_configuration=self.versioning_configuration,
            website_configuration=self.website_configuration,
            website_url=self.website_url)


def get_bucket(bucket_name: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBucketResult:
    """
    The ``AWS::S3::Bucket`` resource creates an Amazon S3 bucket in the same AWS Region where you create the AWS CloudFormation stack.
     To control how AWS CloudFormation handles the bucket when the stack is deleted, you can set a deletion policy for your bucket. You can choose to *retain* the bucket or to *delete* the bucket. For more information, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html).
      You can only delete empty buckets. Deletion fails for buckets that have contents.


    :param builtins.str bucket_name: A name for the bucket. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. The bucket name must contain only lowercase letters, numbers, periods (.), and dashes (-) and must follow [Amazon S3 bucket restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html). For more information, see [Rules for naming Amazon S3 buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html) in the *Amazon S3 User Guide*. 
             If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
    """
    __args__ = dict()
    __args__['bucketName'] = bucket_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:s3:getBucket', __args__, opts=opts, typ=GetBucketResult).value

    return AwaitableGetBucketResult(
        accelerate_configuration=pulumi.get(__ret__, 'accelerate_configuration'),
        analytics_configurations=pulumi.get(__ret__, 'analytics_configurations'),
        arn=pulumi.get(__ret__, 'arn'),
        bucket_encryption=pulumi.get(__ret__, 'bucket_encryption'),
        cors_configuration=pulumi.get(__ret__, 'cors_configuration'),
        domain_name=pulumi.get(__ret__, 'domain_name'),
        dual_stack_domain_name=pulumi.get(__ret__, 'dual_stack_domain_name'),
        intelligent_tiering_configurations=pulumi.get(__ret__, 'intelligent_tiering_configurations'),
        inventory_configurations=pulumi.get(__ret__, 'inventory_configurations'),
        lifecycle_configuration=pulumi.get(__ret__, 'lifecycle_configuration'),
        logging_configuration=pulumi.get(__ret__, 'logging_configuration'),
        metadata_table_configuration=pulumi.get(__ret__, 'metadata_table_configuration'),
        metrics_configurations=pulumi.get(__ret__, 'metrics_configurations'),
        notification_configuration=pulumi.get(__ret__, 'notification_configuration'),
        object_lock_configuration=pulumi.get(__ret__, 'object_lock_configuration'),
        object_lock_enabled=pulumi.get(__ret__, 'object_lock_enabled'),
        ownership_controls=pulumi.get(__ret__, 'ownership_controls'),
        public_access_block_configuration=pulumi.get(__ret__, 'public_access_block_configuration'),
        regional_domain_name=pulumi.get(__ret__, 'regional_domain_name'),
        replication_configuration=pulumi.get(__ret__, 'replication_configuration'),
        tags=pulumi.get(__ret__, 'tags'),
        versioning_configuration=pulumi.get(__ret__, 'versioning_configuration'),
        website_configuration=pulumi.get(__ret__, 'website_configuration'),
        website_url=pulumi.get(__ret__, 'website_url'))
def get_bucket_output(bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBucketResult]:
    """
    The ``AWS::S3::Bucket`` resource creates an Amazon S3 bucket in the same AWS Region where you create the AWS CloudFormation stack.
     To control how AWS CloudFormation handles the bucket when the stack is deleted, you can set a deletion policy for your bucket. You can choose to *retain* the bucket or to *delete* the bucket. For more information, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html).
      You can only delete empty buckets. Deletion fails for buckets that have contents.


    :param builtins.str bucket_name: A name for the bucket. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. The bucket name must contain only lowercase letters, numbers, periods (.), and dashes (-) and must follow [Amazon S3 bucket restrictions and limitations](https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html). For more information, see [Rules for naming Amazon S3 buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html) in the *Amazon S3 User Guide*. 
             If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
    """
    __args__ = dict()
    __args__['bucketName'] = bucket_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:s3:getBucket', __args__, opts=opts, typ=GetBucketResult)
    return __ret__.apply(lambda __response__: GetBucketResult(
        accelerate_configuration=pulumi.get(__response__, 'accelerate_configuration'),
        analytics_configurations=pulumi.get(__response__, 'analytics_configurations'),
        arn=pulumi.get(__response__, 'arn'),
        bucket_encryption=pulumi.get(__response__, 'bucket_encryption'),
        cors_configuration=pulumi.get(__response__, 'cors_configuration'),
        domain_name=pulumi.get(__response__, 'domain_name'),
        dual_stack_domain_name=pulumi.get(__response__, 'dual_stack_domain_name'),
        intelligent_tiering_configurations=pulumi.get(__response__, 'intelligent_tiering_configurations'),
        inventory_configurations=pulumi.get(__response__, 'inventory_configurations'),
        lifecycle_configuration=pulumi.get(__response__, 'lifecycle_configuration'),
        logging_configuration=pulumi.get(__response__, 'logging_configuration'),
        metadata_table_configuration=pulumi.get(__response__, 'metadata_table_configuration'),
        metrics_configurations=pulumi.get(__response__, 'metrics_configurations'),
        notification_configuration=pulumi.get(__response__, 'notification_configuration'),
        object_lock_configuration=pulumi.get(__response__, 'object_lock_configuration'),
        object_lock_enabled=pulumi.get(__response__, 'object_lock_enabled'),
        ownership_controls=pulumi.get(__response__, 'ownership_controls'),
        public_access_block_configuration=pulumi.get(__response__, 'public_access_block_configuration'),
        regional_domain_name=pulumi.get(__response__, 'regional_domain_name'),
        replication_configuration=pulumi.get(__response__, 'replication_configuration'),
        tags=pulumi.get(__response__, 'tags'),
        versioning_configuration=pulumi.get(__response__, 'versioning_configuration'),
        website_configuration=pulumi.get(__response__, 'website_configuration'),
        website_url=pulumi.get(__response__, 'website_url')))
