# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAccessGrantsLocationResult',
    'AwaitableGetAccessGrantsLocationResult',
    'get_access_grants_location',
    'get_access_grants_location_output',
]

@pulumi.output_type
class GetAccessGrantsLocationResult:
    def __init__(__self__, access_grants_location_arn=None, access_grants_location_id=None, iam_role_arn=None, location_scope=None):
        if access_grants_location_arn and not isinstance(access_grants_location_arn, str):
            raise TypeError("Expected argument 'access_grants_location_arn' to be a str")
        pulumi.set(__self__, "access_grants_location_arn", access_grants_location_arn)
        if access_grants_location_id and not isinstance(access_grants_location_id, str):
            raise TypeError("Expected argument 'access_grants_location_id' to be a str")
        pulumi.set(__self__, "access_grants_location_id", access_grants_location_id)
        if iam_role_arn and not isinstance(iam_role_arn, str):
            raise TypeError("Expected argument 'iam_role_arn' to be a str")
        pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if location_scope and not isinstance(location_scope, str):
            raise TypeError("Expected argument 'location_scope' to be a str")
        pulumi.set(__self__, "location_scope", location_scope)

    @property
    @pulumi.getter(name="accessGrantsLocationArn")
    def access_grants_location_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the specified Access Grants location.
        """
        return pulumi.get(self, "access_grants_location_arn")

    @property
    @pulumi.getter(name="accessGrantsLocationId")
    def access_grants_location_id(self) -> Optional[builtins.str]:
        """
        The unique identifier for the specified Access Grants location.
        """
        return pulumi.get(self, "access_grants_location_id")

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the access grant location's associated IAM role.
        """
        return pulumi.get(self, "iam_role_arn")

    @property
    @pulumi.getter(name="locationScope")
    def location_scope(self) -> Optional[builtins.str]:
        """
        Descriptor for where the location actually points
        """
        return pulumi.get(self, "location_scope")


class AwaitableGetAccessGrantsLocationResult(GetAccessGrantsLocationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessGrantsLocationResult(
            access_grants_location_arn=self.access_grants_location_arn,
            access_grants_location_id=self.access_grants_location_id,
            iam_role_arn=self.iam_role_arn,
            location_scope=self.location_scope)


def get_access_grants_location(access_grants_location_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessGrantsLocationResult:
    """
    The AWS::S3::AccessGrantsLocation resource is an Amazon S3 resource type hosted in an access grants instance which can be the target of S3 access grants.


    :param builtins.str access_grants_location_id: The unique identifier for the specified Access Grants location.
    """
    __args__ = dict()
    __args__['accessGrantsLocationId'] = access_grants_location_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:s3:getAccessGrantsLocation', __args__, opts=opts, typ=GetAccessGrantsLocationResult).value

    return AwaitableGetAccessGrantsLocationResult(
        access_grants_location_arn=pulumi.get(__ret__, 'access_grants_location_arn'),
        access_grants_location_id=pulumi.get(__ret__, 'access_grants_location_id'),
        iam_role_arn=pulumi.get(__ret__, 'iam_role_arn'),
        location_scope=pulumi.get(__ret__, 'location_scope'))
def get_access_grants_location_output(access_grants_location_id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccessGrantsLocationResult]:
    """
    The AWS::S3::AccessGrantsLocation resource is an Amazon S3 resource type hosted in an access grants instance which can be the target of S3 access grants.


    :param builtins.str access_grants_location_id: The unique identifier for the specified Access Grants location.
    """
    __args__ = dict()
    __args__['accessGrantsLocationId'] = access_grants_location_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:s3:getAccessGrantsLocation', __args__, opts=opts, typ=GetAccessGrantsLocationResult)
    return __ret__.apply(lambda __response__: GetAccessGrantsLocationResult(
        access_grants_location_arn=pulumi.get(__response__, 'access_grants_location_arn'),
        access_grants_location_id=pulumi.get(__response__, 'access_grants_location_id'),
        iam_role_arn=pulumi.get(__response__, 'iam_role_arn'),
        location_scope=pulumi.get(__response__, 'location_scope')))
