# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['AccessGrantArgs', 'AccessGrant']

@pulumi.input_type
class AccessGrantArgs:
    def __init__(__self__, *,
                 access_grants_location_id: pulumi.Input[builtins.str],
                 grantee: pulumi.Input['AccessGrantGranteeArgs'],
                 permission: pulumi.Input['AccessGrantPermission'],
                 access_grants_location_configuration: Optional[pulumi.Input['AccessGrantsLocationConfigurationArgs']] = None,
                 application_arn: Optional[pulumi.Input[builtins.str]] = None,
                 s3_prefix_type: Optional[pulumi.Input['AccessGrantS3PrefixType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]] = None):
        """
        The set of arguments for constructing a AccessGrant resource.
        :param pulumi.Input[builtins.str] access_grants_location_id: The custom S3 location to be accessed by the grantee
        :param pulumi.Input['AccessGrantGranteeArgs'] grantee: The principal who will be granted permission to access S3.
        :param pulumi.Input['AccessGrantPermission'] permission: The level of access to be afforded to the grantee
        :param pulumi.Input['AccessGrantsLocationConfigurationArgs'] access_grants_location_configuration: The configuration options of the grant location, which is the S3 path to the data to which you are granting access.
        :param pulumi.Input[builtins.str] application_arn: The ARN of the application grantees will use to access the location
        :param pulumi.Input['AccessGrantS3PrefixType'] s3_prefix_type: The type of S3SubPrefix.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]] tags: The AWS resource tags that you are adding to the access grant. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
        """
        pulumi.set(__self__, "access_grants_location_id", access_grants_location_id)
        pulumi.set(__self__, "grantee", grantee)
        pulumi.set(__self__, "permission", permission)
        if access_grants_location_configuration is not None:
            pulumi.set(__self__, "access_grants_location_configuration", access_grants_location_configuration)
        if application_arn is not None:
            pulumi.set(__self__, "application_arn", application_arn)
        if s3_prefix_type is not None:
            pulumi.set(__self__, "s3_prefix_type", s3_prefix_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accessGrantsLocationId")
    def access_grants_location_id(self) -> pulumi.Input[builtins.str]:
        """
        The custom S3 location to be accessed by the grantee
        """
        return pulumi.get(self, "access_grants_location_id")

    @access_grants_location_id.setter
    def access_grants_location_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "access_grants_location_id", value)

    @property
    @pulumi.getter
    def grantee(self) -> pulumi.Input['AccessGrantGranteeArgs']:
        """
        The principal who will be granted permission to access S3.
        """
        return pulumi.get(self, "grantee")

    @grantee.setter
    def grantee(self, value: pulumi.Input['AccessGrantGranteeArgs']):
        pulumi.set(self, "grantee", value)

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Input['AccessGrantPermission']:
        """
        The level of access to be afforded to the grantee
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input['AccessGrantPermission']):
        pulumi.set(self, "permission", value)

    @property
    @pulumi.getter(name="accessGrantsLocationConfiguration")
    def access_grants_location_configuration(self) -> Optional[pulumi.Input['AccessGrantsLocationConfigurationArgs']]:
        """
        The configuration options of the grant location, which is the S3 path to the data to which you are granting access.
        """
        return pulumi.get(self, "access_grants_location_configuration")

    @access_grants_location_configuration.setter
    def access_grants_location_configuration(self, value: Optional[pulumi.Input['AccessGrantsLocationConfigurationArgs']]):
        pulumi.set(self, "access_grants_location_configuration", value)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the application grantees will use to access the location
        """
        return pulumi.get(self, "application_arn")

    @application_arn.setter
    def application_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_arn", value)

    @property
    @pulumi.getter(name="s3PrefixType")
    def s3_prefix_type(self) -> Optional[pulumi.Input['AccessGrantS3PrefixType']]:
        """
        The type of S3SubPrefix.
        """
        return pulumi.get(self, "s3_prefix_type")

    @s3_prefix_type.setter
    def s3_prefix_type(self, value: Optional[pulumi.Input['AccessGrantS3PrefixType']]):
        pulumi.set(self, "s3_prefix_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]:
        """
        The AWS resource tags that you are adding to the access grant. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:s3:AccessGrant")
class AccessGrant(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_grants_location_configuration: Optional[pulumi.Input[Union['AccessGrantsLocationConfigurationArgs', 'AccessGrantsLocationConfigurationArgsDict']]] = None,
                 access_grants_location_id: Optional[pulumi.Input[builtins.str]] = None,
                 application_arn: Optional[pulumi.Input[builtins.str]] = None,
                 grantee: Optional[pulumi.Input[Union['AccessGrantGranteeArgs', 'AccessGrantGranteeArgsDict']]] = None,
                 permission: Optional[pulumi.Input['AccessGrantPermission']] = None,
                 s3_prefix_type: Optional[pulumi.Input['AccessGrantS3PrefixType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 __props__=None):
        """
        The AWS::S3::AccessGrant resource is an Amazon S3 resource type representing permissions to a specific S3 bucket or prefix hosted in an S3 Access Grants instance.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AccessGrantsLocationConfigurationArgs', 'AccessGrantsLocationConfigurationArgsDict']] access_grants_location_configuration: The configuration options of the grant location, which is the S3 path to the data to which you are granting access.
        :param pulumi.Input[builtins.str] access_grants_location_id: The custom S3 location to be accessed by the grantee
        :param pulumi.Input[builtins.str] application_arn: The ARN of the application grantees will use to access the location
        :param pulumi.Input[Union['AccessGrantGranteeArgs', 'AccessGrantGranteeArgsDict']] grantee: The principal who will be granted permission to access S3.
        :param pulumi.Input['AccessGrantPermission'] permission: The level of access to be afforded to the grantee
        :param pulumi.Input['AccessGrantS3PrefixType'] s3_prefix_type: The type of S3SubPrefix.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]] tags: The AWS resource tags that you are adding to the access grant. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessGrantArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::S3::AccessGrant resource is an Amazon S3 resource type representing permissions to a specific S3 bucket or prefix hosted in an S3 Access Grants instance.

        :param str resource_name: The name of the resource.
        :param AccessGrantArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessGrantArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_grants_location_configuration: Optional[pulumi.Input[Union['AccessGrantsLocationConfigurationArgs', 'AccessGrantsLocationConfigurationArgsDict']]] = None,
                 access_grants_location_id: Optional[pulumi.Input[builtins.str]] = None,
                 application_arn: Optional[pulumi.Input[builtins.str]] = None,
                 grantee: Optional[pulumi.Input[Union['AccessGrantGranteeArgs', 'AccessGrantGranteeArgsDict']]] = None,
                 permission: Optional[pulumi.Input['AccessGrantPermission']] = None,
                 s3_prefix_type: Optional[pulumi.Input['AccessGrantS3PrefixType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessGrantArgs.__new__(AccessGrantArgs)

            __props__.__dict__["access_grants_location_configuration"] = access_grants_location_configuration
            if access_grants_location_id is None and not opts.urn:
                raise TypeError("Missing required property 'access_grants_location_id'")
            __props__.__dict__["access_grants_location_id"] = access_grants_location_id
            __props__.__dict__["application_arn"] = application_arn
            if grantee is None and not opts.urn:
                raise TypeError("Missing required property 'grantee'")
            __props__.__dict__["grantee"] = grantee
            if permission is None and not opts.urn:
                raise TypeError("Missing required property 'permission'")
            __props__.__dict__["permission"] = permission
            __props__.__dict__["s3_prefix_type"] = s3_prefix_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["access_grant_arn"] = None
            __props__.__dict__["access_grant_id"] = None
            __props__.__dict__["grant_scope"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["s3PrefixType", "tags[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AccessGrant, __self__).__init__(
            'aws-native:s3:AccessGrant',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AccessGrant':
        """
        Get an existing AccessGrant resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AccessGrantArgs.__new__(AccessGrantArgs)

        __props__.__dict__["access_grant_arn"] = None
        __props__.__dict__["access_grant_id"] = None
        __props__.__dict__["access_grants_location_configuration"] = None
        __props__.__dict__["access_grants_location_id"] = None
        __props__.__dict__["application_arn"] = None
        __props__.__dict__["grant_scope"] = None
        __props__.__dict__["grantee"] = None
        __props__.__dict__["permission"] = None
        __props__.__dict__["s3_prefix_type"] = None
        __props__.__dict__["tags"] = None
        return AccessGrant(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessGrantArn")
    def access_grant_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the specified access grant.
        """
        return pulumi.get(self, "access_grant_arn")

    @property
    @pulumi.getter(name="accessGrantId")
    def access_grant_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID assigned to this access grant.
        """
        return pulumi.get(self, "access_grant_id")

    @property
    @pulumi.getter(name="accessGrantsLocationConfiguration")
    def access_grants_location_configuration(self) -> pulumi.Output[Optional['outputs.AccessGrantsLocationConfiguration']]:
        """
        The configuration options of the grant location, which is the S3 path to the data to which you are granting access.
        """
        return pulumi.get(self, "access_grants_location_configuration")

    @property
    @pulumi.getter(name="accessGrantsLocationId")
    def access_grants_location_id(self) -> pulumi.Output[builtins.str]:
        """
        The custom S3 location to be accessed by the grantee
        """
        return pulumi.get(self, "access_grants_location_id")

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARN of the application grantees will use to access the location
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="grantScope")
    def grant_scope(self) -> pulumi.Output[builtins.str]:
        """
        The S3 path of the data to which you are granting access. It is a combination of the S3 path of the registered location and the subprefix.
        """
        return pulumi.get(self, "grant_scope")

    @property
    @pulumi.getter
    def grantee(self) -> pulumi.Output['outputs.AccessGrantGrantee']:
        """
        The principal who will be granted permission to access S3.
        """
        return pulumi.get(self, "grantee")

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Output['AccessGrantPermission']:
        """
        The level of access to be afforded to the grantee
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter(name="s3PrefixType")
    def s3_prefix_type(self) -> pulumi.Output[Optional['AccessGrantS3PrefixType']]:
        """
        The type of S3SubPrefix.
        """
        return pulumi.get(self, "s3_prefix_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.CreateOnlyTag']]]:
        """
        The AWS resource tags that you are adding to the access grant. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources.
        """
        return pulumi.get(self, "tags")

