# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetAppMonitorResult',
    'AwaitableGetAppMonitorResult',
    'get_app_monitor',
    'get_app_monitor_output',
]

@pulumi.output_type
class GetAppMonitorResult:
    def __init__(__self__, app_monitor_configuration=None, custom_events=None, cw_log_enabled=None, deobfuscation_configuration=None, domain=None, domain_list=None, id=None, resource_policy=None, tags=None):
        if app_monitor_configuration and not isinstance(app_monitor_configuration, dict):
            raise TypeError("Expected argument 'app_monitor_configuration' to be a dict")
        pulumi.set(__self__, "app_monitor_configuration", app_monitor_configuration)
        if custom_events and not isinstance(custom_events, dict):
            raise TypeError("Expected argument 'custom_events' to be a dict")
        pulumi.set(__self__, "custom_events", custom_events)
        if cw_log_enabled and not isinstance(cw_log_enabled, bool):
            raise TypeError("Expected argument 'cw_log_enabled' to be a bool")
        pulumi.set(__self__, "cw_log_enabled", cw_log_enabled)
        if deobfuscation_configuration and not isinstance(deobfuscation_configuration, dict):
            raise TypeError("Expected argument 'deobfuscation_configuration' to be a dict")
        pulumi.set(__self__, "deobfuscation_configuration", deobfuscation_configuration)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if domain_list and not isinstance(domain_list, list):
            raise TypeError("Expected argument 'domain_list' to be a list")
        pulumi.set(__self__, "domain_list", domain_list)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_policy and not isinstance(resource_policy, dict):
            raise TypeError("Expected argument 'resource_policy' to be a dict")
        pulumi.set(__self__, "resource_policy", resource_policy)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="appMonitorConfiguration")
    def app_monitor_configuration(self) -> Optional['outputs.AppMonitorConfiguration']:
        """
        A structure that contains much of the configuration data for the app monitor. If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include `AppMonitorConfiguration` , you must set up your own authorization method. For more information, see [Authorize your application to send data to AWS](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html) .

        If you omit this argument, the sample rate used for CloudWatch RUM is set to 10% of the user sessions.
        """
        return pulumi.get(self, "app_monitor_configuration")

    @property
    @pulumi.getter(name="customEvents")
    def custom_events(self) -> Optional['outputs.AppMonitorCustomEvents']:
        """
        Specifies whether this app monitor allows the web client to define and send custom events. If you omit this parameter, custom events are `DISABLED` .
        """
        return pulumi.get(self, "custom_events")

    @property
    @pulumi.getter(name="cwLogEnabled")
    def cw_log_enabled(self) -> Optional[builtins.bool]:
        """
        Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to CWLlong in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur CWLlong charges. If you omit this parameter, the default is false
        """
        return pulumi.get(self, "cw_log_enabled")

    @property
    @pulumi.getter(name="deobfuscationConfiguration")
    def deobfuscation_configuration(self) -> Optional['outputs.AppMonitorDeobfuscationConfiguration']:
        """
        A structure that contains the configuration for how an app monitor can deobfuscate stack traces.
        """
        return pulumi.get(self, "deobfuscation_configuration")

    @property
    @pulumi.getter
    def domain(self) -> Optional[builtins.str]:
        """
        The top-level internet domain name for which your application has administrative authority. The CreateAppMonitor requires either the domain or the domain list.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainList")
    def domain_list(self) -> Optional[Sequence[builtins.str]]:
        """
        The top-level internet domain names for which your application has administrative authority. The CreateAppMonitor requires either the domain or the domain list.
        """
        return pulumi.get(self, "domain_list")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The unique ID of the new app monitor.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourcePolicy")
    def resource_policy(self) -> Optional['outputs.AppMonitorResourcePolicy']:
        """
        Use this structure to assign a resource-based policy to a CloudWatch RUM app monitor to control access to it. Each app monitor can have one resource-based policy. The maximum size of the policy is 4 KB. To learn more about using resource policies with RUM, see [Using resource-based policies with CloudWatch RUM](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html) .
        """
        return pulumi.get(self, "resource_policy")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Assigns one or more tags (key-value pairs) to the app monitor.

        Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.

        Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.

        You can associate as many as 50 tags with an app monitor.

        For more information, see [Tagging AWS resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) .
        """
        return pulumi.get(self, "tags")


class AwaitableGetAppMonitorResult(GetAppMonitorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppMonitorResult(
            app_monitor_configuration=self.app_monitor_configuration,
            custom_events=self.custom_events,
            cw_log_enabled=self.cw_log_enabled,
            deobfuscation_configuration=self.deobfuscation_configuration,
            domain=self.domain,
            domain_list=self.domain_list,
            id=self.id,
            resource_policy=self.resource_policy,
            tags=self.tags)


def get_app_monitor(name: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppMonitorResult:
    """
    Resource Type definition for AWS::RUM::AppMonitor


    :param builtins.str name: A name for the app monitor
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:rum:getAppMonitor', __args__, opts=opts, typ=GetAppMonitorResult).value

    return AwaitableGetAppMonitorResult(
        app_monitor_configuration=pulumi.get(__ret__, 'app_monitor_configuration'),
        custom_events=pulumi.get(__ret__, 'custom_events'),
        cw_log_enabled=pulumi.get(__ret__, 'cw_log_enabled'),
        deobfuscation_configuration=pulumi.get(__ret__, 'deobfuscation_configuration'),
        domain=pulumi.get(__ret__, 'domain'),
        domain_list=pulumi.get(__ret__, 'domain_list'),
        id=pulumi.get(__ret__, 'id'),
        resource_policy=pulumi.get(__ret__, 'resource_policy'),
        tags=pulumi.get(__ret__, 'tags'))
def get_app_monitor_output(name: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppMonitorResult]:
    """
    Resource Type definition for AWS::RUM::AppMonitor


    :param builtins.str name: A name for the app monitor
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:rum:getAppMonitor', __args__, opts=opts, typ=GetAppMonitorResult)
    return __ret__.apply(lambda __response__: GetAppMonitorResult(
        app_monitor_configuration=pulumi.get(__response__, 'app_monitor_configuration'),
        custom_events=pulumi.get(__response__, 'custom_events'),
        cw_log_enabled=pulumi.get(__response__, 'cw_log_enabled'),
        deobfuscation_configuration=pulumi.get(__response__, 'deobfuscation_configuration'),
        domain=pulumi.get(__response__, 'domain'),
        domain_list=pulumi.get(__response__, 'domain_list'),
        id=pulumi.get(__response__, 'id'),
        resource_policy=pulumi.get(__response__, 'resource_policy'),
        tags=pulumi.get(__response__, 'tags')))
