# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ResolverRuleArgs', 'ResolverRule']

@pulumi.input_type
class ResolverRuleArgs:
    def __init__(__self__, *,
                 rule_type: pulumi.Input['ResolverRuleRuleType'],
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resolver_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 target_ips: Optional[pulumi.Input[Sequence[pulumi.Input['ResolverRuleTargetAddressArgs']]]] = None):
        """
        The set of arguments for constructing a ResolverRule resource.
        :param pulumi.Input['ResolverRuleRuleType'] rule_type: When you want to forward DNS queries for specified domain name to resolvers on your network, specify FORWARD. When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for a subdomain of that domain, specify SYSTEM.
        :param pulumi.Input[builtins.str] domain_name: DNS queries for this domain name are forwarded to the IP addresses that are specified in TargetIps
        :param pulumi.Input[builtins.str] name: The name for the Resolver rule
        :param pulumi.Input[builtins.str] resolver_endpoint_id: The ID of the endpoint that the rule is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[Sequence[pulumi.Input['ResolverRuleTargetAddressArgs']]] target_ips: An array that contains the IP addresses and ports that an outbound endpoint forwards DNS queries to. Typically, these are the IP addresses of DNS resolvers on your network. Specify IPv4 addresses. IPv6 is not supported.
        """
        pulumi.set(__self__, "rule_type", rule_type)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resolver_endpoint_id is not None:
            pulumi.set(__self__, "resolver_endpoint_id", resolver_endpoint_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_ips is not None:
            pulumi.set(__self__, "target_ips", target_ips)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input['ResolverRuleRuleType']:
        """
        When you want to forward DNS queries for specified domain name to resolvers on your network, specify FORWARD. When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for a subdomain of that domain, specify SYSTEM.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input['ResolverRuleRuleType']):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DNS queries for this domain name are forwarded to the IP addresses that are specified in TargetIps
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the Resolver rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resolverEndpointId")
    def resolver_endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the endpoint that the rule is associated with.
        """
        return pulumi.get(self, "resolver_endpoint_id")

    @resolver_endpoint_id.setter
    def resolver_endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resolver_endpoint_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetIps")
    def target_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResolverRuleTargetAddressArgs']]]]:
        """
        An array that contains the IP addresses and ports that an outbound endpoint forwards DNS queries to. Typically, these are the IP addresses of DNS resolvers on your network. Specify IPv4 addresses. IPv6 is not supported.
        """
        return pulumi.get(self, "target_ips")

    @target_ips.setter
    def target_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResolverRuleTargetAddressArgs']]]]):
        pulumi.set(self, "target_ips", value)


@pulumi.type_token("aws-native:route53resolver:ResolverRule")
class ResolverRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resolver_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 rule_type: Optional[pulumi.Input['ResolverRuleRuleType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 target_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResolverRuleTargetAddressArgs', 'ResolverRuleTargetAddressArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Route53Resolver::ResolverRule

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] domain_name: DNS queries for this domain name are forwarded to the IP addresses that are specified in TargetIps
        :param pulumi.Input[builtins.str] name: The name for the Resolver rule
        :param pulumi.Input[builtins.str] resolver_endpoint_id: The ID of the endpoint that the rule is associated with.
        :param pulumi.Input['ResolverRuleRuleType'] rule_type: When you want to forward DNS queries for specified domain name to resolvers on your network, specify FORWARD. When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for a subdomain of that domain, specify SYSTEM.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResolverRuleTargetAddressArgs', 'ResolverRuleTargetAddressArgsDict']]]] target_ips: An array that contains the IP addresses and ports that an outbound endpoint forwards DNS queries to. Typically, these are the IP addresses of DNS resolvers on your network. Specify IPv4 addresses. IPv6 is not supported.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResolverRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Route53Resolver::ResolverRule

        :param str resource_name: The name of the resource.
        :param ResolverRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResolverRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resolver_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 rule_type: Optional[pulumi.Input['ResolverRuleRuleType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 target_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResolverRuleTargetAddressArgs', 'ResolverRuleTargetAddressArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResolverRuleArgs.__new__(ResolverRuleArgs)

            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["name"] = name
            __props__.__dict__["resolver_endpoint_id"] = resolver_endpoint_id
            if rule_type is None and not opts.urn:
                raise TypeError("Missing required property 'rule_type'")
            __props__.__dict__["rule_type"] = rule_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_ips"] = target_ips
            __props__.__dict__["arn"] = None
            __props__.__dict__["resolver_rule_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["ruleType"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ResolverRule, __self__).__init__(
            'aws-native:route53resolver:ResolverRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ResolverRule':
        """
        Get an existing ResolverRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ResolverRuleArgs.__new__(ResolverRuleArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["domain_name"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["resolver_endpoint_id"] = None
        __props__.__dict__["resolver_rule_id"] = None
        __props__.__dict__["rule_type"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["target_ips"] = None
        return ResolverRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the resolver rule.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        DNS queries for this domain name are forwarded to the IP addresses that are specified in TargetIps
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name for the Resolver rule
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resolverEndpointId")
    def resolver_endpoint_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the endpoint that the rule is associated with.
        """
        return pulumi.get(self, "resolver_endpoint_id")

    @property
    @pulumi.getter(name="resolverRuleId")
    def resolver_rule_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the endpoint that the rule is associated with.
        """
        return pulumi.get(self, "resolver_rule_id")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Output['ResolverRuleRuleType']:
        """
        When you want to forward DNS queries for specified domain name to resolvers on your network, specify FORWARD. When you have a forwarding rule to forward DNS queries for a domain to your network and you want Resolver to process queries for a subdomain of that domain, specify SYSTEM.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetIps")
    def target_ips(self) -> pulumi.Output[Optional[Sequence['outputs.ResolverRuleTargetAddress']]]:
        """
        An array that contains the IP addresses and ports that an outbound endpoint forwards DNS queries to. Typically, these are the IP addresses of DNS resolvers on your network. Specify IPv4 addresses. IPv6 is not supported.
        """
        return pulumi.get(self, "target_ips")

