# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ResolverEndpointArgs', 'ResolverEndpoint']

@pulumi.input_type
class ResolverEndpointArgs:
    def __init__(__self__, *,
                 direction: pulumi.Input[builtins.str],
                 ip_addresses: pulumi.Input[Sequence[pulumi.Input['ResolverEndpointIpAddressRequestArgs']]],
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 outpost_arn: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resolver_endpoint_type: Optional[pulumi.Input['ResolverEndpointType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a ResolverEndpoint resource.
        :param pulumi.Input[builtins.str] direction: Indicates whether the Resolver endpoint allows inbound or outbound DNS queries:
               - INBOUND: allows DNS queries to your VPC from your network 
               - OUTBOUND: allows DNS queries from your VPC to your network
        :param pulumi.Input[Sequence[pulumi.Input['ResolverEndpointIpAddressRequestArgs']]] ip_addresses: The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: The ID of one or more security groups that control access to this VPC. The security group must include one or more inbound rules (for inbound endpoints) or outbound rules (for outbound endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.
        :param pulumi.Input[builtins.str] name: A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.
        :param pulumi.Input[builtins.str] outpost_arn: The ARN (Amazon Resource Name) for the Outpost.
        :param pulumi.Input[builtins.str] preferred_instance_type: The Amazon EC2 instance type.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] protocols: Protocols used for the endpoint. DoH-FIPS is applicable for inbound endpoints only.
        :param pulumi.Input['ResolverEndpointType'] resolver_endpoint_type: The Resolver endpoint IP address type.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outpost_arn is not None:
            pulumi.set(__self__, "outpost_arn", outpost_arn)
        if preferred_instance_type is not None:
            pulumi.set(__self__, "preferred_instance_type", preferred_instance_type)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if resolver_endpoint_type is not None:
            pulumi.set(__self__, "resolver_endpoint_type", resolver_endpoint_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[builtins.str]:
        """
        Indicates whether the Resolver endpoint allows inbound or outbound DNS queries:
        - INBOUND: allows DNS queries to your VPC from your network 
        - OUTBOUND: allows DNS queries from your VPC to your network
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Input[Sequence[pulumi.Input['ResolverEndpointIpAddressRequestArgs']]]:
        """
        The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: pulumi.Input[Sequence[pulumi.Input['ResolverEndpointIpAddressRequestArgs']]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The ID of one or more security groups that control access to this VPC. The security group must include one or more inbound rules (for inbound endpoints) or outbound rules (for outbound endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN (Amazon Resource Name) for the Outpost.
        """
        return pulumi.get(self, "outpost_arn")

    @outpost_arn.setter
    def outpost_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "outpost_arn", value)

    @property
    @pulumi.getter(name="preferredInstanceType")
    def preferred_instance_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon EC2 instance type.
        """
        return pulumi.get(self, "preferred_instance_type")

    @preferred_instance_type.setter
    def preferred_instance_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_instance_type", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Protocols used for the endpoint. DoH-FIPS is applicable for inbound endpoints only.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="resolverEndpointType")
    def resolver_endpoint_type(self) -> Optional[pulumi.Input['ResolverEndpointType']]:
        """
        The Resolver endpoint IP address type.
        """
        return pulumi.get(self, "resolver_endpoint_type")

    @resolver_endpoint_type.setter
    def resolver_endpoint_type(self, value: Optional[pulumi.Input['ResolverEndpointType']]):
        pulumi.set(self, "resolver_endpoint_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:route53resolver:ResolverEndpoint")
class ResolverEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResolverEndpointIpAddressRequestArgs', 'ResolverEndpointIpAddressRequestArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 outpost_arn: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resolver_endpoint_type: Optional[pulumi.Input['ResolverEndpointType']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource type definition for AWS::Route53Resolver::ResolverEndpoint

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] direction: Indicates whether the Resolver endpoint allows inbound or outbound DNS queries:
               - INBOUND: allows DNS queries to your VPC from your network 
               - OUTBOUND: allows DNS queries from your VPC to your network
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResolverEndpointIpAddressRequestArgs', 'ResolverEndpointIpAddressRequestArgsDict']]]] ip_addresses: The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
        :param pulumi.Input[builtins.str] name: A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.
        :param pulumi.Input[builtins.str] outpost_arn: The ARN (Amazon Resource Name) for the Outpost.
        :param pulumi.Input[builtins.str] preferred_instance_type: The Amazon EC2 instance type.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] protocols: Protocols used for the endpoint. DoH-FIPS is applicable for inbound endpoints only.
        :param pulumi.Input['ResolverEndpointType'] resolver_endpoint_type: The Resolver endpoint IP address type.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: The ID of one or more security groups that control access to this VPC. The security group must include one or more inbound rules (for inbound endpoints) or outbound rules (for outbound endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResolverEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource type definition for AWS::Route53Resolver::ResolverEndpoint

        :param str resource_name: The name of the resource.
        :param ResolverEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResolverEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResolverEndpointIpAddressRequestArgs', 'ResolverEndpointIpAddressRequestArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 outpost_arn: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_instance_type: Optional[pulumi.Input[builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resolver_endpoint_type: Optional[pulumi.Input['ResolverEndpointType']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResolverEndpointArgs.__new__(ResolverEndpointArgs)

            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            if ip_addresses is None and not opts.urn:
                raise TypeError("Missing required property 'ip_addresses'")
            __props__.__dict__["ip_addresses"] = ip_addresses
            __props__.__dict__["name"] = name
            __props__.__dict__["outpost_arn"] = outpost_arn
            __props__.__dict__["preferred_instance_type"] = preferred_instance_type
            __props__.__dict__["protocols"] = protocols
            __props__.__dict__["resolver_endpoint_type"] = resolver_endpoint_type
            if security_group_ids is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_ids'")
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["host_vpc_id"] = None
            __props__.__dict__["ip_address_count"] = None
            __props__.__dict__["resolver_endpoint_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["direction", "outpostArn", "preferredInstanceType", "securityGroupIds[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ResolverEndpoint, __self__).__init__(
            'aws-native:route53resolver:ResolverEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ResolverEndpoint':
        """
        Get an existing ResolverEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ResolverEndpointArgs.__new__(ResolverEndpointArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["direction"] = None
        __props__.__dict__["host_vpc_id"] = None
        __props__.__dict__["ip_address_count"] = None
        __props__.__dict__["ip_addresses"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["outpost_arn"] = None
        __props__.__dict__["preferred_instance_type"] = None
        __props__.__dict__["protocols"] = None
        __props__.__dict__["resolver_endpoint_id"] = None
        __props__.__dict__["resolver_endpoint_type"] = None
        __props__.__dict__["security_group_ids"] = None
        __props__.__dict__["tags"] = None
        return ResolverEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the resolver endpoint, such as arn:aws:route53resolver:us-east-1:123456789012:resolver-endpoint/resolver-endpoint-a1bzhi.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[builtins.str]:
        """
        Indicates whether the Resolver endpoint allows inbound or outbound DNS queries:
        - INBOUND: allows DNS queries to your VPC from your network 
        - OUTBOUND: allows DNS queries from your VPC to your network
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="hostVpcId")
    def host_vpc_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the VPC that you want to create the resolver endpoint in.
        """
        return pulumi.get(self, "host_vpc_id")

    @property
    @pulumi.getter(name="ipAddressCount")
    def ip_address_count(self) -> pulumi.Output[builtins.str]:
        """
        The number of IP addresses that the resolver endpoint can use for DNS queries.
        """
        return pulumi.get(self, "ip_address_count")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Output[Sequence['outputs.ResolverEndpointIpAddressRequest']]:
        """
        The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARN (Amazon Resource Name) for the Outpost.
        """
        return pulumi.get(self, "outpost_arn")

    @property
    @pulumi.getter(name="preferredInstanceType")
    def preferred_instance_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon EC2 instance type.
        """
        return pulumi.get(self, "preferred_instance_type")

    @property
    @pulumi.getter
    def protocols(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Protocols used for the endpoint. DoH-FIPS is applicable for inbound endpoints only.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="resolverEndpointId")
    def resolver_endpoint_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the resolver endpoint.
        """
        return pulumi.get(self, "resolver_endpoint_id")

    @property
    @pulumi.getter(name="resolverEndpointType")
    def resolver_endpoint_type(self) -> pulumi.Output[Optional['ResolverEndpointType']]:
        """
        The Resolver endpoint IP address type.
        """
        return pulumi.get(self, "resolver_endpoint_type")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The ID of one or more security groups that control access to this VPC. The security group must include one or more inbound rules (for inbound endpoints) or outbound rules (for outbound endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

