# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'FirewallRuleGroupFirewallRule',
    'ResolverEndpointIpAddressRequest',
    'ResolverRuleTargetAddress',
]

@pulumi.output_type
class FirewallRuleGroupFirewallRule(dict):
    """
    Firewall Rule associating the Rule Group to a Domain List
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockOverrideDnsType":
            suggest = "block_override_dns_type"
        elif key == "blockOverrideDomain":
            suggest = "block_override_domain"
        elif key == "blockOverrideTtl":
            suggest = "block_override_ttl"
        elif key == "blockResponse":
            suggest = "block_response"
        elif key == "confidenceThreshold":
            suggest = "confidence_threshold"
        elif key == "dnsThreatProtection":
            suggest = "dns_threat_protection"
        elif key == "firewallDomainListId":
            suggest = "firewall_domain_list_id"
        elif key == "firewallDomainRedirectionAction":
            suggest = "firewall_domain_redirection_action"
        elif key == "firewallThreatProtectionId":
            suggest = "firewall_threat_protection_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallRuleGroupFirewallRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallRuleGroupFirewallRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallRuleGroupFirewallRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: 'FirewallRuleGroupFirewallRuleAction',
                 priority: builtins.int,
                 block_override_dns_type: Optional['FirewallRuleGroupFirewallRuleBlockOverrideDnsType'] = None,
                 block_override_domain: Optional[builtins.str] = None,
                 block_override_ttl: Optional[builtins.int] = None,
                 block_response: Optional['FirewallRuleGroupFirewallRuleBlockResponse'] = None,
                 confidence_threshold: Optional['FirewallRuleGroupFirewallRuleConfidenceThreshold'] = None,
                 dns_threat_protection: Optional['FirewallRuleGroupFirewallRuleDnsThreatProtection'] = None,
                 firewall_domain_list_id: Optional[builtins.str] = None,
                 firewall_domain_redirection_action: Optional['FirewallRuleGroupFirewallRuleFirewallDomainRedirectionAction'] = None,
                 firewall_threat_protection_id: Optional[builtins.str] = None,
                 qtype: Optional[builtins.str] = None):
        """
        Firewall Rule associating the Rule Group to a Domain List
        :param 'FirewallRuleGroupFirewallRuleAction' action: Rule Action
        :param builtins.int priority: Rule Priority
        :param 'FirewallRuleGroupFirewallRuleBlockOverrideDnsType' block_override_dns_type: BlockOverrideDnsType
        :param builtins.str block_override_domain: BlockOverrideDomain
        :param builtins.int block_override_ttl: BlockOverrideTtl
        :param 'FirewallRuleGroupFirewallRuleBlockResponse' block_response: BlockResponse
        :param 'FirewallRuleGroupFirewallRuleConfidenceThreshold' confidence_threshold: FirewallDomainRedirectionAction
        :param 'FirewallRuleGroupFirewallRuleDnsThreatProtection' dns_threat_protection: FirewallDomainRedirectionAction
        :param builtins.str firewall_domain_list_id: ResourceId
        :param 'FirewallRuleGroupFirewallRuleFirewallDomainRedirectionAction' firewall_domain_redirection_action: FirewallDomainRedirectionAction
        :param builtins.str firewall_threat_protection_id: ResourceId
        :param builtins.str qtype: Qtype
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "priority", priority)
        if block_override_dns_type is not None:
            pulumi.set(__self__, "block_override_dns_type", block_override_dns_type)
        if block_override_domain is not None:
            pulumi.set(__self__, "block_override_domain", block_override_domain)
        if block_override_ttl is not None:
            pulumi.set(__self__, "block_override_ttl", block_override_ttl)
        if block_response is not None:
            pulumi.set(__self__, "block_response", block_response)
        if confidence_threshold is not None:
            pulumi.set(__self__, "confidence_threshold", confidence_threshold)
        if dns_threat_protection is not None:
            pulumi.set(__self__, "dns_threat_protection", dns_threat_protection)
        if firewall_domain_list_id is not None:
            pulumi.set(__self__, "firewall_domain_list_id", firewall_domain_list_id)
        if firewall_domain_redirection_action is not None:
            pulumi.set(__self__, "firewall_domain_redirection_action", firewall_domain_redirection_action)
        if firewall_threat_protection_id is not None:
            pulumi.set(__self__, "firewall_threat_protection_id", firewall_threat_protection_id)
        if qtype is not None:
            pulumi.set(__self__, "qtype", qtype)

    @property
    @pulumi.getter
    def action(self) -> 'FirewallRuleGroupFirewallRuleAction':
        """
        Rule Action
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def priority(self) -> builtins.int:
        """
        Rule Priority
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="blockOverrideDnsType")
    def block_override_dns_type(self) -> Optional['FirewallRuleGroupFirewallRuleBlockOverrideDnsType']:
        """
        BlockOverrideDnsType
        """
        return pulumi.get(self, "block_override_dns_type")

    @property
    @pulumi.getter(name="blockOverrideDomain")
    def block_override_domain(self) -> Optional[builtins.str]:
        """
        BlockOverrideDomain
        """
        return pulumi.get(self, "block_override_domain")

    @property
    @pulumi.getter(name="blockOverrideTtl")
    def block_override_ttl(self) -> Optional[builtins.int]:
        """
        BlockOverrideTtl
        """
        return pulumi.get(self, "block_override_ttl")

    @property
    @pulumi.getter(name="blockResponse")
    def block_response(self) -> Optional['FirewallRuleGroupFirewallRuleBlockResponse']:
        """
        BlockResponse
        """
        return pulumi.get(self, "block_response")

    @property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> Optional['FirewallRuleGroupFirewallRuleConfidenceThreshold']:
        """
        FirewallDomainRedirectionAction
        """
        return pulumi.get(self, "confidence_threshold")

    @property
    @pulumi.getter(name="dnsThreatProtection")
    def dns_threat_protection(self) -> Optional['FirewallRuleGroupFirewallRuleDnsThreatProtection']:
        """
        FirewallDomainRedirectionAction
        """
        return pulumi.get(self, "dns_threat_protection")

    @property
    @pulumi.getter(name="firewallDomainListId")
    def firewall_domain_list_id(self) -> Optional[builtins.str]:
        """
        ResourceId
        """
        return pulumi.get(self, "firewall_domain_list_id")

    @property
    @pulumi.getter(name="firewallDomainRedirectionAction")
    def firewall_domain_redirection_action(self) -> Optional['FirewallRuleGroupFirewallRuleFirewallDomainRedirectionAction']:
        """
        FirewallDomainRedirectionAction
        """
        return pulumi.get(self, "firewall_domain_redirection_action")

    @property
    @pulumi.getter(name="firewallThreatProtectionId")
    def firewall_threat_protection_id(self) -> Optional[builtins.str]:
        """
        ResourceId
        """
        return pulumi.get(self, "firewall_threat_protection_id")

    @property
    @pulumi.getter
    def qtype(self) -> Optional[builtins.str]:
        """
        Qtype
        """
        return pulumi.get(self, "qtype")


@pulumi.output_type
class ResolverEndpointIpAddressRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverEndpointIpAddressRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverEndpointIpAddressRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverEndpointIpAddressRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: builtins.str,
                 ip: Optional[builtins.str] = None,
                 ipv6: Optional[builtins.str] = None):
        """
        :param builtins.str subnet_id: The ID of the subnet that contains the IP address.
        :param builtins.str ip: The IPv4 address that you want to use for DNS queries.
        :param builtins.str ipv6: The IPv6 address that you want to use for DNS queries.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The ID of the subnet that contains the IP address.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def ip(self) -> Optional[builtins.str]:
        """
        The IPv4 address that you want to use for DNS queries.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def ipv6(self) -> Optional[builtins.str]:
        """
        The IPv6 address that you want to use for DNS queries.
        """
        return pulumi.get(self, "ipv6")


@pulumi.output_type
class ResolverRuleTargetAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverNameIndication":
            suggest = "server_name_indication"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverRuleTargetAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverRuleTargetAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverRuleTargetAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip: Optional[builtins.str] = None,
                 ipv6: Optional[builtins.str] = None,
                 port: Optional[builtins.str] = None,
                 protocol: Optional['ResolverRuleTargetAddressProtocol'] = None,
                 server_name_indication: Optional[builtins.str] = None):
        """
        :param builtins.str ip: One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses. 
        :param builtins.str ipv6: One IPv6 address that you want to forward DNS queries to. You can specify only IPv6 addresses. 
        :param builtins.str port: The port at Ip that you want to forward DNS queries to. 
        :param 'ResolverRuleTargetAddressProtocol' protocol: The protocol that you want to use to forward DNS queries. 
        :param builtins.str server_name_indication: The SNI of the target name servers for DoH/DoH-FIPS outbound endpoints
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if server_name_indication is not None:
            pulumi.set(__self__, "server_name_indication", server_name_indication)

    @property
    @pulumi.getter
    def ip(self) -> Optional[builtins.str]:
        """
        One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses. 
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def ipv6(self) -> Optional[builtins.str]:
        """
        One IPv6 address that you want to forward DNS queries to. You can specify only IPv6 addresses. 
        """
        return pulumi.get(self, "ipv6")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.str]:
        """
        The port at Ip that you want to forward DNS queries to. 
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional['ResolverRuleTargetAddressProtocol']:
        """
        The protocol that you want to use to forward DNS queries. 
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="serverNameIndication")
    def server_name_indication(self) -> Optional[builtins.str]:
        """
        The SNI of the target name servers for DoH/DoH-FIPS outbound endpoints
        """
        return pulumi.get(self, "server_name_indication")


