# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetResolverEndpointResult',
    'AwaitableGetResolverEndpointResult',
    'get_resolver_endpoint',
    'get_resolver_endpoint_output',
]

@pulumi.output_type
class GetResolverEndpointResult:
    def __init__(__self__, arn=None, host_vpc_id=None, ip_address_count=None, ip_addresses=None, name=None, protocols=None, resolver_endpoint_id=None, resolver_endpoint_type=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if host_vpc_id and not isinstance(host_vpc_id, str):
            raise TypeError("Expected argument 'host_vpc_id' to be a str")
        pulumi.set(__self__, "host_vpc_id", host_vpc_id)
        if ip_address_count and not isinstance(ip_address_count, str):
            raise TypeError("Expected argument 'ip_address_count' to be a str")
        pulumi.set(__self__, "ip_address_count", ip_address_count)
        if ip_addresses and not isinstance(ip_addresses, list):
            raise TypeError("Expected argument 'ip_addresses' to be a list")
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if protocols and not isinstance(protocols, list):
            raise TypeError("Expected argument 'protocols' to be a list")
        pulumi.set(__self__, "protocols", protocols)
        if resolver_endpoint_id and not isinstance(resolver_endpoint_id, str):
            raise TypeError("Expected argument 'resolver_endpoint_id' to be a str")
        pulumi.set(__self__, "resolver_endpoint_id", resolver_endpoint_id)
        if resolver_endpoint_type and not isinstance(resolver_endpoint_type, str):
            raise TypeError("Expected argument 'resolver_endpoint_type' to be a str")
        pulumi.set(__self__, "resolver_endpoint_type", resolver_endpoint_type)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the resolver endpoint, such as arn:aws:route53resolver:us-east-1:123456789012:resolver-endpoint/resolver-endpoint-a1bzhi.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="hostVpcId")
    def host_vpc_id(self) -> Optional[builtins.str]:
        """
        The ID of the VPC that you want to create the resolver endpoint in.
        """
        return pulumi.get(self, "host_vpc_id")

    @property
    @pulumi.getter(name="ipAddressCount")
    def ip_address_count(self) -> Optional[builtins.str]:
        """
        The number of IP addresses that the resolver endpoint can use for DNS queries.
        """
        return pulumi.get(self, "ip_address_count")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence['outputs.ResolverEndpointIpAddressRequest']]:
        """
        The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence[builtins.str]]:
        """
        Protocols used for the endpoint. DoH-FIPS is applicable for inbound endpoints only.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="resolverEndpointId")
    def resolver_endpoint_id(self) -> Optional[builtins.str]:
        """
        The ID of the resolver endpoint.
        """
        return pulumi.get(self, "resolver_endpoint_id")

    @property
    @pulumi.getter(name="resolverEndpointType")
    def resolver_endpoint_type(self) -> Optional['ResolverEndpointType']:
        """
        The Resolver endpoint IP address type.
        """
        return pulumi.get(self, "resolver_endpoint_type")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetResolverEndpointResult(GetResolverEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResolverEndpointResult(
            arn=self.arn,
            host_vpc_id=self.host_vpc_id,
            ip_address_count=self.ip_address_count,
            ip_addresses=self.ip_addresses,
            name=self.name,
            protocols=self.protocols,
            resolver_endpoint_id=self.resolver_endpoint_id,
            resolver_endpoint_type=self.resolver_endpoint_type,
            tags=self.tags)


def get_resolver_endpoint(resolver_endpoint_id: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResolverEndpointResult:
    """
    Resource type definition for AWS::Route53Resolver::ResolverEndpoint


    :param builtins.str resolver_endpoint_id: The ID of the resolver endpoint.
    """
    __args__ = dict()
    __args__['resolverEndpointId'] = resolver_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:route53resolver:getResolverEndpoint', __args__, opts=opts, typ=GetResolverEndpointResult).value

    return AwaitableGetResolverEndpointResult(
        arn=pulumi.get(__ret__, 'arn'),
        host_vpc_id=pulumi.get(__ret__, 'host_vpc_id'),
        ip_address_count=pulumi.get(__ret__, 'ip_address_count'),
        ip_addresses=pulumi.get(__ret__, 'ip_addresses'),
        name=pulumi.get(__ret__, 'name'),
        protocols=pulumi.get(__ret__, 'protocols'),
        resolver_endpoint_id=pulumi.get(__ret__, 'resolver_endpoint_id'),
        resolver_endpoint_type=pulumi.get(__ret__, 'resolver_endpoint_type'),
        tags=pulumi.get(__ret__, 'tags'))
def get_resolver_endpoint_output(resolver_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResolverEndpointResult]:
    """
    Resource type definition for AWS::Route53Resolver::ResolverEndpoint


    :param builtins.str resolver_endpoint_id: The ID of the resolver endpoint.
    """
    __args__ = dict()
    __args__['resolverEndpointId'] = resolver_endpoint_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:route53resolver:getResolverEndpoint', __args__, opts=opts, typ=GetResolverEndpointResult)
    return __ret__.apply(lambda __response__: GetResolverEndpointResult(
        arn=pulumi.get(__response__, 'arn'),
        host_vpc_id=pulumi.get(__response__, 'host_vpc_id'),
        ip_address_count=pulumi.get(__response__, 'ip_address_count'),
        ip_addresses=pulumi.get(__response__, 'ip_addresses'),
        name=pulumi.get(__response__, 'name'),
        protocols=pulumi.get(__response__, 'protocols'),
        resolver_endpoint_id=pulumi.get(__response__, 'resolver_endpoint_id'),
        resolver_endpoint_type=pulumi.get(__response__, 'resolver_endpoint_type'),
        tags=pulumi.get(__response__, 'tags')))
