# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ResourceSetDnsTargetResourceArgs',
    'ResourceSetDnsTargetResourceArgsDict',
    'ResourceSetNlbResourceArgs',
    'ResourceSetNlbResourceArgsDict',
    'ResourceSetR53ResourceRecordArgs',
    'ResourceSetR53ResourceRecordArgsDict',
    'ResourceSetResourceArgs',
    'ResourceSetResourceArgsDict',
    'ResourceSetTargetResourceArgs',
    'ResourceSetTargetResourceArgsDict',
]

MYPY = False

if not MYPY:
    class ResourceSetDnsTargetResourceArgsDict(TypedDict):
        """
        A component for DNS/routing control readiness checks.
        """
        domain_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The domain name that acts as an ingress point to a portion of the customer application.
        """
        hosted_zone_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the target resource.
        """
        record_set_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Route 53 record set ID that will uniquely identify a DNS record, given a name and a type.
        """
        record_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of DNS record of the target resource.
        """
        target_resource: NotRequired[pulumi.Input['ResourceSetTargetResourceArgsDict']]
        """
        The target resource that the Route 53 record points to.
        """
elif False:
    ResourceSetDnsTargetResourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceSetDnsTargetResourceArgs:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 hosted_zone_arn: Optional[pulumi.Input[builtins.str]] = None,
                 record_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 record_type: Optional[pulumi.Input[builtins.str]] = None,
                 target_resource: Optional[pulumi.Input['ResourceSetTargetResourceArgs']] = None):
        """
        A component for DNS/routing control readiness checks.
        :param pulumi.Input[builtins.str] domain_name: The domain name that acts as an ingress point to a portion of the customer application.
        :param pulumi.Input[builtins.str] hosted_zone_arn: The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the target resource.
        :param pulumi.Input[builtins.str] record_set_id: The Route 53 record set ID that will uniquely identify a DNS record, given a name and a type.
        :param pulumi.Input[builtins.str] record_type: The type of DNS record of the target resource.
        :param pulumi.Input['ResourceSetTargetResourceArgs'] target_resource: The target resource that the Route 53 record points to.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if hosted_zone_arn is not None:
            pulumi.set(__self__, "hosted_zone_arn", hosted_zone_arn)
        if record_set_id is not None:
            pulumi.set(__self__, "record_set_id", record_set_id)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if target_resource is not None:
            pulumi.set(__self__, "target_resource", target_resource)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The domain name that acts as an ingress point to a portion of the customer application.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="hostedZoneArn")
    def hosted_zone_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the target resource.
        """
        return pulumi.get(self, "hosted_zone_arn")

    @hosted_zone_arn.setter
    def hosted_zone_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hosted_zone_arn", value)

    @property
    @pulumi.getter(name="recordSetId")
    def record_set_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Route 53 record set ID that will uniquely identify a DNS record, given a name and a type.
        """
        return pulumi.get(self, "record_set_id")

    @record_set_id.setter
    def record_set_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "record_set_id", value)

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of DNS record of the target resource.
        """
        return pulumi.get(self, "record_type")

    @record_type.setter
    def record_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "record_type", value)

    @property
    @pulumi.getter(name="targetResource")
    def target_resource(self) -> Optional[pulumi.Input['ResourceSetTargetResourceArgs']]:
        """
        The target resource that the Route 53 record points to.
        """
        return pulumi.get(self, "target_resource")

    @target_resource.setter
    def target_resource(self, value: Optional[pulumi.Input['ResourceSetTargetResourceArgs']]):
        pulumi.set(self, "target_resource", value)


if not MYPY:
    class ResourceSetNlbResourceArgsDict(TypedDict):
        """
        The Network Load Balancer resource that a DNS target resource points to.
        """
        arn: NotRequired[pulumi.Input[builtins.str]]
        """
        A Network Load Balancer resource Amazon Resource Name (ARN).
        """
elif False:
    ResourceSetNlbResourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceSetNlbResourceArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        The Network Load Balancer resource that a DNS target resource points to.
        :param pulumi.Input[builtins.str] arn: A Network Load Balancer resource Amazon Resource Name (ARN).
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A Network Load Balancer resource Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)


if not MYPY:
    class ResourceSetR53ResourceRecordArgsDict(TypedDict):
        """
        The Route 53 resource that a DNS target resource record points to.
        """
        domain_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The DNS target domain name.
        """
        record_set_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Resource Record set id.
        """
elif False:
    ResourceSetR53ResourceRecordArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceSetR53ResourceRecordArgs:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 record_set_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The Route 53 resource that a DNS target resource record points to.
        :param pulumi.Input[builtins.str] domain_name: The DNS target domain name.
        :param pulumi.Input[builtins.str] record_set_id: The Resource Record set id.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if record_set_id is not None:
            pulumi.set(__self__, "record_set_id", record_set_id)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DNS target domain name.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="recordSetId")
    def record_set_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Resource Record set id.
        """
        return pulumi.get(self, "record_set_id")

    @record_set_id.setter
    def record_set_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "record_set_id", value)


if not MYPY:
    class ResourceSetResourceArgsDict(TypedDict):
        """
        The resource element of a ResourceSet
        """
        component_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The component identifier of the resource, generated when DNS target resource is used.
        """
        dns_target_resource: NotRequired[pulumi.Input['ResourceSetDnsTargetResourceArgsDict']]
        """
        A component for DNS/routing control readiness checks. This is a required setting when `ResourceSet` `ResourceSetType` is set to `AWS::Route53RecoveryReadiness::DNSTargetResource` . Do not set it for any other `ResourceSetType` setting.
        """
        readiness_scopes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that this resource is contained within.
        """
        resource_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the AWS resource.
        """
elif False:
    ResourceSetResourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceSetResourceArgs:
    def __init__(__self__, *,
                 component_id: Optional[pulumi.Input[builtins.str]] = None,
                 dns_target_resource: Optional[pulumi.Input['ResourceSetDnsTargetResourceArgs']] = None,
                 readiness_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        The resource element of a ResourceSet
        :param pulumi.Input[builtins.str] component_id: The component identifier of the resource, generated when DNS target resource is used.
        :param pulumi.Input['ResourceSetDnsTargetResourceArgs'] dns_target_resource: A component for DNS/routing control readiness checks. This is a required setting when `ResourceSet` `ResourceSetType` is set to `AWS::Route53RecoveryReadiness::DNSTargetResource` . Do not set it for any other `ResourceSetType` setting.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] readiness_scopes: A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that this resource is contained within.
        :param pulumi.Input[builtins.str] resource_arn: The Amazon Resource Name (ARN) of the AWS resource.
        """
        if component_id is not None:
            pulumi.set(__self__, "component_id", component_id)
        if dns_target_resource is not None:
            pulumi.set(__self__, "dns_target_resource", dns_target_resource)
        if readiness_scopes is not None:
            pulumi.set(__self__, "readiness_scopes", readiness_scopes)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The component identifier of the resource, generated when DNS target resource is used.
        """
        return pulumi.get(self, "component_id")

    @component_id.setter
    def component_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "component_id", value)

    @property
    @pulumi.getter(name="dnsTargetResource")
    def dns_target_resource(self) -> Optional[pulumi.Input['ResourceSetDnsTargetResourceArgs']]:
        """
        A component for DNS/routing control readiness checks. This is a required setting when `ResourceSet` `ResourceSetType` is set to `AWS::Route53RecoveryReadiness::DNSTargetResource` . Do not set it for any other `ResourceSetType` setting.
        """
        return pulumi.get(self, "dns_target_resource")

    @dns_target_resource.setter
    def dns_target_resource(self, value: Optional[pulumi.Input['ResourceSetDnsTargetResourceArgs']]):
        pulumi.set(self, "dns_target_resource", value)

    @property
    @pulumi.getter(name="readinessScopes")
    def readiness_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of recovery group Amazon Resource Names (ARNs) and cell ARNs that this resource is contained within.
        """
        return pulumi.get(self, "readiness_scopes")

    @readiness_scopes.setter
    def readiness_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "readiness_scopes", value)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the AWS resource.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_arn", value)


if not MYPY:
    class ResourceSetTargetResourceArgsDict(TypedDict):
        """
        The target resource that the Route 53 record points to.
        """
        nlb_resource: NotRequired[pulumi.Input['ResourceSetNlbResourceArgsDict']]
        """
        The Network Load Balancer resource that a DNS target resource points to.
        """
        r53_resource: NotRequired[pulumi.Input['ResourceSetR53ResourceRecordArgsDict']]
        """
        The Route 53 resource that a DNS target resource record points to.
        """
elif False:
    ResourceSetTargetResourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceSetTargetResourceArgs:
    def __init__(__self__, *,
                 nlb_resource: Optional[pulumi.Input['ResourceSetNlbResourceArgs']] = None,
                 r53_resource: Optional[pulumi.Input['ResourceSetR53ResourceRecordArgs']] = None):
        """
        The target resource that the Route 53 record points to.
        :param pulumi.Input['ResourceSetNlbResourceArgs'] nlb_resource: The Network Load Balancer resource that a DNS target resource points to.
        :param pulumi.Input['ResourceSetR53ResourceRecordArgs'] r53_resource: The Route 53 resource that a DNS target resource record points to.
        """
        if nlb_resource is not None:
            pulumi.set(__self__, "nlb_resource", nlb_resource)
        if r53_resource is not None:
            pulumi.set(__self__, "r53_resource", r53_resource)

    @property
    @pulumi.getter(name="nlbResource")
    def nlb_resource(self) -> Optional[pulumi.Input['ResourceSetNlbResourceArgs']]:
        """
        The Network Load Balancer resource that a DNS target resource points to.
        """
        return pulumi.get(self, "nlb_resource")

    @nlb_resource.setter
    def nlb_resource(self, value: Optional[pulumi.Input['ResourceSetNlbResourceArgs']]):
        pulumi.set(self, "nlb_resource", value)

    @property
    @pulumi.getter(name="r53Resource")
    def r53_resource(self) -> Optional[pulumi.Input['ResourceSetR53ResourceRecordArgs']]:
        """
        The Route 53 resource that a DNS target resource record points to.
        """
        return pulumi.get(self, "r53_resource")

    @r53_resource.setter
    def r53_resource(self, value: Optional[pulumi.Input['ResourceSetR53ResourceRecordArgs']]):
        pulumi.set(self, "r53_resource", value)


