# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'SafetyRuleAssertionRuleArgs',
    'SafetyRuleAssertionRuleArgsDict',
    'SafetyRuleGatingRuleArgs',
    'SafetyRuleGatingRuleArgsDict',
    'SafetyRuleRuleConfigArgs',
    'SafetyRuleRuleConfigArgsDict',
]

MYPY = False

if not MYPY:
    class SafetyRuleAssertionRuleArgsDict(TypedDict):
        """
        An assertion rule enforces that, when a routing control state is changed, that the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.
        """
        asserted_controls: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed. For example, you might include three routing controls, one for each of three AWS Regions.
        """
        wait_period_ms: pulumi.Input[builtins.int]
        """
        An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.
        """
elif False:
    SafetyRuleAssertionRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SafetyRuleAssertionRuleArgs:
    def __init__(__self__, *,
                 asserted_controls: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 wait_period_ms: pulumi.Input[builtins.int]):
        """
        An assertion rule enforces that, when a routing control state is changed, that the criteria set by the rule configuration is met. Otherwise, the change to the routing control is not accepted.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] asserted_controls: The routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed. For example, you might include three routing controls, one for each of three AWS Regions.
        :param pulumi.Input[builtins.int] wait_period_ms: An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.
        """
        pulumi.set(__self__, "asserted_controls", asserted_controls)
        pulumi.set(__self__, "wait_period_ms", wait_period_ms)

    @property
    @pulumi.getter(name="assertedControls")
    def asserted_controls(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed. For example, you might include three routing controls, one for each of three AWS Regions.
        """
        return pulumi.get(self, "asserted_controls")

    @asserted_controls.setter
    def asserted_controls(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "asserted_controls", value)

    @property
    @pulumi.getter(name="waitPeriodMs")
    def wait_period_ms(self) -> pulumi.Input[builtins.int]:
        """
        An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.
        """
        return pulumi.get(self, "wait_period_ms")

    @wait_period_ms.setter
    def wait_period_ms(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "wait_period_ms", value)


if not MYPY:
    class SafetyRuleGatingRuleArgsDict(TypedDict):
        """
        A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.
        """
        gating_controls: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The gating controls for the gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
        """
        target_controls: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the specified GatingControls. For example, say you have three gating controls, one for each of three AWS Regions. Now you specify AtLeast 2 as your RuleConfig. With these settings, you can only change (set or unset) the routing controls that you have specified as TargetControls if that rule evaluates to true. 
        In other words, your ability to change the routing controls that you have specified as TargetControls is gated by the rule that you set for the routing controls in GatingControls.
        """
        wait_period_ms: pulumi.Input[builtins.int]
        """
        An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.
        """
elif False:
    SafetyRuleGatingRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SafetyRuleGatingRuleArgs:
    def __init__(__self__, *,
                 gating_controls: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 target_controls: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 wait_period_ms: pulumi.Input[builtins.int]):
        """
        A gating rule verifies that a set of gating controls evaluates as true, based on a rule configuration that you specify. If the gating rule evaluates to true, Amazon Route 53 Application Recovery Controller allows a set of routing control state changes to run and complete against the set of target controls.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] gating_controls: The gating controls for the gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_controls: Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the specified GatingControls. For example, say you have three gating controls, one for each of three AWS Regions. Now you specify AtLeast 2 as your RuleConfig. With these settings, you can only change (set or unset) the routing controls that you have specified as TargetControls if that rule evaluates to true. 
               In other words, your ability to change the routing controls that you have specified as TargetControls is gated by the rule that you set for the routing controls in GatingControls.
        :param pulumi.Input[builtins.int] wait_period_ms: An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.
        """
        pulumi.set(__self__, "gating_controls", gating_controls)
        pulumi.set(__self__, "target_controls", target_controls)
        pulumi.set(__self__, "wait_period_ms", wait_period_ms)

    @property
    @pulumi.getter(name="gatingControls")
    def gating_controls(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The gating controls for the gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
        """
        return pulumi.get(self, "gating_controls")

    @gating_controls.setter
    def gating_controls(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "gating_controls", value)

    @property
    @pulumi.getter(name="targetControls")
    def target_controls(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Routing controls that can only be set or unset if the specified RuleConfig evaluates to true for the specified GatingControls. For example, say you have three gating controls, one for each of three AWS Regions. Now you specify AtLeast 2 as your RuleConfig. With these settings, you can only change (set or unset) the routing controls that you have specified as TargetControls if that rule evaluates to true. 
        In other words, your ability to change the routing controls that you have specified as TargetControls is gated by the rule that you set for the routing controls in GatingControls.
        """
        return pulumi.get(self, "target_controls")

    @target_controls.setter
    def target_controls(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "target_controls", value)

    @property
    @pulumi.getter(name="waitPeriodMs")
    def wait_period_ms(self) -> pulumi.Input[builtins.int]:
        """
        An evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail. This helps prevent "flapping" of state. The wait period is 5000 ms by default, but you can choose a custom value.
        """
        return pulumi.get(self, "wait_period_ms")

    @wait_period_ms.setter
    def wait_period_ms(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "wait_period_ms", value)


if not MYPY:
    class SafetyRuleRuleConfigArgsDict(TypedDict):
        """
        The rule configuration for an assertion rule or gating rule. This is the criteria that you set for specific assertion controls (routing controls) or gating controls. This configuration specifies how many controls must be enabled after a transaction completes.
        """
        inverted: pulumi.Input[builtins.bool]
        """
        Logical negation of the rule. If the rule would usually evaluate true, it's evaluated as false, and vice versa.
        """
        threshold: pulumi.Input[builtins.int]
        """
        The value of N, when you specify an ATLEAST rule type. That is, Threshold is the number of controls that must be set when you specify an ATLEAST type.
        """
        type: pulumi.Input['SafetyRuleRuleType']
        """
        A rule can be one of the following: `ATLEAST` , `AND` , or `OR` .
        """
elif False:
    SafetyRuleRuleConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SafetyRuleRuleConfigArgs:
    def __init__(__self__, *,
                 inverted: pulumi.Input[builtins.bool],
                 threshold: pulumi.Input[builtins.int],
                 type: pulumi.Input['SafetyRuleRuleType']):
        """
        The rule configuration for an assertion rule or gating rule. This is the criteria that you set for specific assertion controls (routing controls) or gating controls. This configuration specifies how many controls must be enabled after a transaction completes.
        :param pulumi.Input[builtins.bool] inverted: Logical negation of the rule. If the rule would usually evaluate true, it's evaluated as false, and vice versa.
        :param pulumi.Input[builtins.int] threshold: The value of N, when you specify an ATLEAST rule type. That is, Threshold is the number of controls that must be set when you specify an ATLEAST type.
        :param pulumi.Input['SafetyRuleRuleType'] type: A rule can be one of the following: `ATLEAST` , `AND` , or `OR` .
        """
        pulumi.set(__self__, "inverted", inverted)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def inverted(self) -> pulumi.Input[builtins.bool]:
        """
        Logical negation of the rule. If the rule would usually evaluate true, it's evaluated as false, and vice versa.
        """
        return pulumi.get(self, "inverted")

    @inverted.setter
    def inverted(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "inverted", value)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[builtins.int]:
        """
        The value of N, when you specify an ATLEAST rule type. That is, Threshold is the number of controls that must be set when you specify an ATLEAST type.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['SafetyRuleRuleType']:
        """
        A rule can be one of the following: `ATLEAST` , `AND` , or `OR` .
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['SafetyRuleRuleType']):
        pulumi.set(self, "type", value)


