# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CidrCollectionLocation',
    'HealthCheckAlarmIdentifier',
    'HealthCheckConfigProperties',
    'HealthCheckTag',
    'HostedZoneConfig',
    'HostedZoneQueryLoggingConfig',
    'HostedZoneVpc',
]

@pulumi.output_type
class CidrCollectionLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrList":
            suggest = "cidr_list"
        elif key == "locationName":
            suggest = "location_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CidrCollectionLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CidrCollectionLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CidrCollectionLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_list: Sequence[builtins.str],
                 location_name: builtins.str):
        """
        :param Sequence[builtins.str] cidr_list: A list of CIDR blocks.
        :param builtins.str location_name: The name of the location that is associated with the CIDR collection.
        """
        pulumi.set(__self__, "cidr_list", cidr_list)
        pulumi.set(__self__, "location_name", location_name)

    @property
    @pulumi.getter(name="cidrList")
    def cidr_list(self) -> Sequence[builtins.str]:
        """
        A list of CIDR blocks.
        """
        return pulumi.get(self, "cidr_list")

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> builtins.str:
        """
        The name of the location that is associated with the CIDR collection.
        """
        return pulumi.get(self, "location_name")


@pulumi.output_type
class HealthCheckAlarmIdentifier(dict):
    """
    A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
    """
    def __init__(__self__, *,
                 name: builtins.str,
                 region: builtins.str):
        """
        A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
        :param builtins.str name: The name of the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether this health check is healthy.
        :param builtins.str region: For the CloudWatch alarm that you want Route 53 health checkers to use to determine whether this health check is healthy, the region that the alarm was created in.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether this health check is healthy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        For the CloudWatch alarm that you want Route 53 health checkers to use to determine whether this health check is healthy, the region that the alarm was created in.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class HealthCheckConfigProperties(dict):
    """
    A complex type that contains information about the health check.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alarmIdentifier":
            suggest = "alarm_identifier"
        elif key == "childHealthChecks":
            suggest = "child_health_checks"
        elif key == "enableSni":
            suggest = "enable_sni"
        elif key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "fullyQualifiedDomainName":
            suggest = "fully_qualified_domain_name"
        elif key == "healthThreshold":
            suggest = "health_threshold"
        elif key == "insufficientDataHealthStatus":
            suggest = "insufficient_data_health_status"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "measureLatency":
            suggest = "measure_latency"
        elif key == "requestInterval":
            suggest = "request_interval"
        elif key == "resourcePath":
            suggest = "resource_path"
        elif key == "routingControlArn":
            suggest = "routing_control_arn"
        elif key == "searchString":
            suggest = "search_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HealthCheckConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HealthCheckConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HealthCheckConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'HealthCheckConfigPropertiesType',
                 alarm_identifier: Optional['outputs.HealthCheckAlarmIdentifier'] = None,
                 child_health_checks: Optional[Sequence[builtins.str]] = None,
                 enable_sni: Optional[builtins.bool] = None,
                 failure_threshold: Optional[builtins.int] = None,
                 fully_qualified_domain_name: Optional[builtins.str] = None,
                 health_threshold: Optional[builtins.int] = None,
                 insufficient_data_health_status: Optional['HealthCheckConfigPropertiesInsufficientDataHealthStatus'] = None,
                 inverted: Optional[builtins.bool] = None,
                 ip_address: Optional[builtins.str] = None,
                 measure_latency: Optional[builtins.bool] = None,
                 port: Optional[builtins.int] = None,
                 regions: Optional[Sequence[builtins.str]] = None,
                 request_interval: Optional[builtins.int] = None,
                 resource_path: Optional[builtins.str] = None,
                 routing_control_arn: Optional[builtins.str] = None,
                 search_string: Optional[builtins.str] = None):
        """
        A complex type that contains information about the health check.
        :param 'HealthCheckConfigPropertiesType' type: The type of health check that you want to create, which indicates how Amazon Route 53 determines whether an endpoint is healthy.
               
               > You can't change the value of `Type` after you create a health check. 
               
               You can create the following types of health checks:
               
               - *HTTP* : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.
               - *HTTPS* : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.
               
               > If you specify `HTTPS` for the value of `Type` , the endpoint must support TLS v1.0 or later.
               - *HTTP_STR_MATCH* : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and searches the first 5,120 bytes of the response body for the string that you specify in `SearchString` .
               - *HTTPS_STR_MATCH* : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an `HTTPS` request and searches the first 5,120 bytes of the response body for the string that you specify in `SearchString` .
               - *TCP* : Route 53 tries to establish a TCP connection.
               - *CLOUDWATCH_METRIC* : The health check is associated with a CloudWatch alarm. If the state of the alarm is `OK` , the health check is considered healthy. If the state is `ALARM` , the health check is considered unhealthy. If CloudWatch doesn't have sufficient data to determine whether the state is `OK` or `ALARM` , the health check status depends on the setting for `InsufficientDataHealthStatus` : `Healthy` , `Unhealthy` , or `LastKnownStatus` .
               
               > Route 53 supports CloudWatch alarms with the following features:
               > 
               > - Standard-resolution metrics. High-resolution metrics aren't supported. For more information, see [High-Resolution Metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/publishingMetrics.html#high-resolution-metrics) in the *Amazon CloudWatch User Guide* .
               > - Statistics: Average, Minimum, Maximum, Sum, and SampleCount. Extended statistics aren't supported.
               - *CALCULATED* : For health checks that monitor the status of other health checks, Route 53 adds up the number of health checks that Route 53 health checkers consider to be healthy and compares that number with the value of `HealthThreshold` .
               - *RECOVERY_CONTROL* : The health check is assocated with a Route53 Application Recovery Controller routing control. If the routing control state is `ON` , the health check is considered healthy. If the state is `OFF` , the health check is considered unhealthy.
               
               For more information, see [How Route 53 Determines Whether an Endpoint Is Healthy](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html) in the *Amazon Route 53 Developer Guide* .
        :param 'HealthCheckAlarmIdentifier' alarm_identifier: A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
        :param Sequence[builtins.str] child_health_checks: (CALCULATED Health Checks Only) A complex type that contains one `ChildHealthCheck` element for each health check that you want to associate with a `CALCULATED` health check.
        :param builtins.bool enable_sni: Specify whether you want Amazon Route 53 to send the value of `FullyQualifiedDomainName` to the endpoint in the `client_hello` message during TLS negotiation. This allows the endpoint to respond to `HTTPS` health check requests with the applicable SSL/TLS certificate.
               
               Some endpoints require that `HTTPS` requests include the host name in the `client_hello` message. If you don't enable SNI, the status of the health check will be `SSL alert handshake_failure` . A health check can also have that status for other reasons. If SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.
               
               The SSL/TLS certificate on your endpoint includes a domain name in the `Common Name` field and possibly several more in the `Subject Alternative Names` field. One of the domain names in the certificate should match the value that you specify for `FullyQualifiedDomainName` . If the endpoint responds to the `client_hello` message with a certificate that does not include the domain name that you specified in `FullyQualifiedDomainName` , a health checker will retry the handshake. In the second attempt, the health checker will omit `FullyQualifiedDomainName` from the `client_hello` message.
        :param builtins.int failure_threshold: The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa. For more information, see [How Amazon Route 53 Determines Whether an Endpoint Is Healthy](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html) in the *Amazon Route 53 Developer Guide* .
               
               If you don't specify a value for `FailureThreshold` , the default value is three health checks.
        :param builtins.str fully_qualified_domain_name: Amazon Route 53 behavior depends on whether you specify a value for `IPAddress` .
               
               *If you specify a value for* `IPAddress` :
               
               Amazon Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of `FullyQualifiedDomainName` in the `Host` header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint on which you want Route 53 to perform health checks.
               
               When Route 53 checks the health of an endpoint, here is how it constructs the `Host` header:
               
               - If you specify a value of `80` for `Port` and `HTTP` or `HTTP_STR_MATCH` for `Type` , Route 53 passes the value of `FullyQualifiedDomainName` to the endpoint in the Host header.
               - If you specify a value of `443` for `Port` and `HTTPS` or `HTTPS_STR_MATCH` for `Type` , Route 53 passes the value of `FullyQualifiedDomainName` to the endpoint in the `Host` header.
               - If you specify another value for `Port` and any value except `TCP` for `Type` , Route 53 passes `FullyQualifiedDomainName:Port` to the endpoint in the `Host` header.
               
               If you don't specify a value for `FullyQualifiedDomainName` , Route 53 substitutes the value of `IPAddress` in the `Host` header in each of the preceding cases.
               
               *If you don't specify a value for `IPAddress`* :
               
               Route 53 sends a DNS request to the domain that you specify for `FullyQualifiedDomainName` at the interval that you specify for `RequestInterval` . Using an IPv4 address that DNS returns, Route 53 then checks the health of the endpoint.
               
               > If you don't specify a value for `IPAddress` , Route 53 uses only IPv4 to send health checks to the endpoint. If there's no record with a type of A for the name that you specify for `FullyQualifiedDomainName` , the health check fails with a "DNS resolution failed" error. 
               
               If you want to check the health of multiple records that have the same name and type, such as multiple weighted records, and if you choose to specify the endpoint only by `FullyQualifiedDomainName` , we recommend that you create a separate health check for each endpoint. For example, create a health check for each HTTP server that is serving content for www.example.com. For the value of `FullyQualifiedDomainName` , specify the domain name of the server (such as us-east-2-www.example.com), not the name of the records (www.example.com).
               
               > In this configuration, if you create a health check for which the value of `FullyQualifiedDomainName` matches the name of the records and you then associate the health check with those records, health check results will be unpredictable. 
               
               In addition, if the value that you specify for `Type` is `HTTP` , `HTTPS` , `HTTP_STR_MATCH` , or `HTTPS_STR_MATCH` , Route 53 passes the value of `FullyQualifiedDomainName` in the `Host` header, as it does when you specify a value for `IPAddress` . If the value of `Type` is `TCP` , Route 53 doesn't pass a `Host` header.
        :param builtins.int health_threshold: The number of child health checks that are associated with a `CALCULATED` health check that Amazon Route 53 must consider healthy for the `CALCULATED` health check to be considered healthy. To specify the child health checks that you want to associate with a `CALCULATED` health check, use the [ChildHealthChecks](https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-ChildHealthChecks) element.
               
               Note the following:
               
               - If you specify a number greater than the number of child health checks, Route 53 always considers this health check to be unhealthy.
               - If you specify `0` , Route 53 always considers this health check to be healthy.
        :param 'HealthCheckConfigPropertiesInsufficientDataHealthStatus' insufficient_data_health_status: When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign to the health check:
               
               - `Healthy` : Route 53 considers the health check to be healthy.
               - `Unhealthy` : Route 53 considers the health check to be unhealthy.
               - `LastKnownStatus` : Route 53 uses the status of the health check from the last time that CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last known status, the default status for the health check is healthy.
        :param builtins.bool inverted: Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it otherwise would be considered healthy.
        :param builtins.str ip_address: The IPv4 or IPv6 IP address of the endpoint that you want Amazon Route 53 to perform health checks on. If you don't specify a value for `IPAddress` , Route 53 sends a DNS request to resolve the domain name that you specify in `FullyQualifiedDomainName` at the interval that you specify in `RequestInterval` . Using an IP address returned by DNS, Route 53 then checks the health of the endpoint.
               
               Use one of the following formats for the value of `IPAddress` :
               
               - *IPv4 address* : four values between 0 and 255, separated by periods (.), for example, `192.0.2.44` .
               - *IPv6 address* : eight groups of four hexadecimal values, separated by colons (:), for example, `2001:0db8:85a3:0000:0000:abcd:0001:2345` . You can also shorten IPv6 addresses as described in RFC 5952, for example, `2001:db8:85a3::abcd:1:2345` .
               
               If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your EC2 instance, and specify the Elastic IP address for `IPAddress` . This ensures that the IP address of your instance will never change.
               
               For more information, see [FullyQualifiedDomainName](https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName) .
               
               Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private, non-routable, or multicast ranges. For more information about IP addresses for which you can't create health checks, see the following documents:
               
               - [RFC 5735, Special Use IPv4 Addresses](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc5735)
               - [RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6598)
               - [RFC 5156, Special-Use IPv6 Addresses](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc5156)
               
               When the value of `Type` is `CALCULATED` or `CLOUDWATCH_METRIC` , omit `IPAddress` .
        :param builtins.bool measure_latency: Specify whether you want Amazon Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint, and to display CloudWatch latency graphs on the *Health Checks* page in the Route 53 console.
               
               > You can't change the value of `MeasureLatency` after you create a health check.
        :param builtins.int port: The port on the endpoint that you want Amazon Route 53 to perform health checks on.
               
               > Don't specify a value for `Port` when you specify a value for [Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-type) of `CLOUDWATCH_METRIC` or `CALCULATED` .
        :param Sequence[builtins.str] regions: A complex type that contains one `Region` element for each region from which you want Amazon Route 53 health checkers to check the specified endpoint.
               
               If you don't specify any regions, Route 53 health checkers automatically performs checks from all of the regions that are listed under *Valid Values* .
               
               If you update a health check to remove a region that has been performing health checks, Route 53 will briefly continue to perform checks from that region to ensure that some health checkers are always checking the endpoint (for example, if you replace three regions with four different regions).
        :param builtins.int request_interval: The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health check request. Each Route 53 health checker makes requests at this interval.
               
               > You can't change the value of `RequestInterval` after you create a health check. 
               
               If you don't specify a value for `RequestInterval` , the default value is `30` seconds.
        :param builtins.str resource_path: The path, if any, that you want Amazon Route 53 to request when performing health checks. The path can be any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example, the file /docs/route53-health-check.html. You can also include query string parameters, for example, `/welcome.html?language=jp&login=y` .
        :param builtins.str routing_control_arn: The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control.
               
               For more information about Route 53 Application Recovery Controller, see [Route 53 Application Recovery Controller Developer Guide.](https://docs.aws.amazon.com/r53recovery/latest/dg/what-is-route-53-recovery.html) .
        :param builtins.str search_string: If the value of Type is `HTTP_STR_MATCH` or `HTTPS_STR_MATCH` , the string that you want Amazon Route 53 to search for in the response body from the specified resource. If the string appears in the response body, Route 53 considers the resource healthy.
               
               Route 53 considers case when searching for `SearchString` in the response body.
        """
        pulumi.set(__self__, "type", type)
        if alarm_identifier is not None:
            pulumi.set(__self__, "alarm_identifier", alarm_identifier)
        if child_health_checks is not None:
            pulumi.set(__self__, "child_health_checks", child_health_checks)
        if enable_sni is not None:
            pulumi.set(__self__, "enable_sni", enable_sni)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if fully_qualified_domain_name is not None:
            pulumi.set(__self__, "fully_qualified_domain_name", fully_qualified_domain_name)
        if health_threshold is not None:
            pulumi.set(__self__, "health_threshold", health_threshold)
        if insufficient_data_health_status is not None:
            pulumi.set(__self__, "insufficient_data_health_status", insufficient_data_health_status)
        if inverted is not None:
            pulumi.set(__self__, "inverted", inverted)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if measure_latency is not None:
            pulumi.set(__self__, "measure_latency", measure_latency)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if request_interval is not None:
            pulumi.set(__self__, "request_interval", request_interval)
        if resource_path is not None:
            pulumi.set(__self__, "resource_path", resource_path)
        if routing_control_arn is not None:
            pulumi.set(__self__, "routing_control_arn", routing_control_arn)
        if search_string is not None:
            pulumi.set(__self__, "search_string", search_string)

    @property
    @pulumi.getter
    def type(self) -> 'HealthCheckConfigPropertiesType':
        """
        The type of health check that you want to create, which indicates how Amazon Route 53 determines whether an endpoint is healthy.

        > You can't change the value of `Type` after you create a health check. 

        You can create the following types of health checks:

        - *HTTP* : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and waits for an HTTP status code of 200 or greater and less than 400.
        - *HTTPS* : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS request and waits for an HTTP status code of 200 or greater and less than 400.

        > If you specify `HTTPS` for the value of `Type` , the endpoint must support TLS v1.0 or later.
        - *HTTP_STR_MATCH* : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and searches the first 5,120 bytes of the response body for the string that you specify in `SearchString` .
        - *HTTPS_STR_MATCH* : Route 53 tries to establish a TCP connection. If successful, Route 53 submits an `HTTPS` request and searches the first 5,120 bytes of the response body for the string that you specify in `SearchString` .
        - *TCP* : Route 53 tries to establish a TCP connection.
        - *CLOUDWATCH_METRIC* : The health check is associated with a CloudWatch alarm. If the state of the alarm is `OK` , the health check is considered healthy. If the state is `ALARM` , the health check is considered unhealthy. If CloudWatch doesn't have sufficient data to determine whether the state is `OK` or `ALARM` , the health check status depends on the setting for `InsufficientDataHealthStatus` : `Healthy` , `Unhealthy` , or `LastKnownStatus` .

        > Route 53 supports CloudWatch alarms with the following features:
        > 
        > - Standard-resolution metrics. High-resolution metrics aren't supported. For more information, see [High-Resolution Metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/publishingMetrics.html#high-resolution-metrics) in the *Amazon CloudWatch User Guide* .
        > - Statistics: Average, Minimum, Maximum, Sum, and SampleCount. Extended statistics aren't supported.
        - *CALCULATED* : For health checks that monitor the status of other health checks, Route 53 adds up the number of health checks that Route 53 health checkers consider to be healthy and compares that number with the value of `HealthThreshold` .
        - *RECOVERY_CONTROL* : The health check is assocated with a Route53 Application Recovery Controller routing control. If the routing control state is `ON` , the health check is considered healthy. If the state is `OFF` , the health check is considered unhealthy.

        For more information, see [How Route 53 Determines Whether an Endpoint Is Healthy](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html) in the *Amazon Route 53 Developer Guide* .
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="alarmIdentifier")
    def alarm_identifier(self) -> Optional['outputs.HealthCheckAlarmIdentifier']:
        """
        A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether the specified health check is healthy.
        """
        return pulumi.get(self, "alarm_identifier")

    @property
    @pulumi.getter(name="childHealthChecks")
    def child_health_checks(self) -> Optional[Sequence[builtins.str]]:
        """
        (CALCULATED Health Checks Only) A complex type that contains one `ChildHealthCheck` element for each health check that you want to associate with a `CALCULATED` health check.
        """
        return pulumi.get(self, "child_health_checks")

    @property
    @pulumi.getter(name="enableSni")
    def enable_sni(self) -> Optional[builtins.bool]:
        """
        Specify whether you want Amazon Route 53 to send the value of `FullyQualifiedDomainName` to the endpoint in the `client_hello` message during TLS negotiation. This allows the endpoint to respond to `HTTPS` health check requests with the applicable SSL/TLS certificate.

        Some endpoints require that `HTTPS` requests include the host name in the `client_hello` message. If you don't enable SNI, the status of the health check will be `SSL alert handshake_failure` . A health check can also have that status for other reasons. If SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.

        The SSL/TLS certificate on your endpoint includes a domain name in the `Common Name` field and possibly several more in the `Subject Alternative Names` field. One of the domain names in the certificate should match the value that you specify for `FullyQualifiedDomainName` . If the endpoint responds to the `client_hello` message with a certificate that does not include the domain name that you specified in `FullyQualifiedDomainName` , a health checker will retry the handshake. In the second attempt, the health checker will omit `FullyQualifiedDomainName` from the `client_hello` message.
        """
        return pulumi.get(self, "enable_sni")

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[builtins.int]:
        """
        The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint from unhealthy to healthy or vice versa. For more information, see [How Amazon Route 53 Determines Whether an Endpoint Is Healthy](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html) in the *Amazon Route 53 Developer Guide* .

        If you don't specify a value for `FailureThreshold` , the default value is three health checks.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="fullyQualifiedDomainName")
    def fully_qualified_domain_name(self) -> Optional[builtins.str]:
        """
        Amazon Route 53 behavior depends on whether you specify a value for `IPAddress` .

        *If you specify a value for* `IPAddress` :

        Amazon Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of `FullyQualifiedDomainName` in the `Host` header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint on which you want Route 53 to perform health checks.

        When Route 53 checks the health of an endpoint, here is how it constructs the `Host` header:

        - If you specify a value of `80` for `Port` and `HTTP` or `HTTP_STR_MATCH` for `Type` , Route 53 passes the value of `FullyQualifiedDomainName` to the endpoint in the Host header.
        - If you specify a value of `443` for `Port` and `HTTPS` or `HTTPS_STR_MATCH` for `Type` , Route 53 passes the value of `FullyQualifiedDomainName` to the endpoint in the `Host` header.
        - If you specify another value for `Port` and any value except `TCP` for `Type` , Route 53 passes `FullyQualifiedDomainName:Port` to the endpoint in the `Host` header.

        If you don't specify a value for `FullyQualifiedDomainName` , Route 53 substitutes the value of `IPAddress` in the `Host` header in each of the preceding cases.

        *If you don't specify a value for `IPAddress`* :

        Route 53 sends a DNS request to the domain that you specify for `FullyQualifiedDomainName` at the interval that you specify for `RequestInterval` . Using an IPv4 address that DNS returns, Route 53 then checks the health of the endpoint.

        > If you don't specify a value for `IPAddress` , Route 53 uses only IPv4 to send health checks to the endpoint. If there's no record with a type of A for the name that you specify for `FullyQualifiedDomainName` , the health check fails with a "DNS resolution failed" error. 

        If you want to check the health of multiple records that have the same name and type, such as multiple weighted records, and if you choose to specify the endpoint only by `FullyQualifiedDomainName` , we recommend that you create a separate health check for each endpoint. For example, create a health check for each HTTP server that is serving content for www.example.com. For the value of `FullyQualifiedDomainName` , specify the domain name of the server (such as us-east-2-www.example.com), not the name of the records (www.example.com).

        > In this configuration, if you create a health check for which the value of `FullyQualifiedDomainName` matches the name of the records and you then associate the health check with those records, health check results will be unpredictable. 

        In addition, if the value that you specify for `Type` is `HTTP` , `HTTPS` , `HTTP_STR_MATCH` , or `HTTPS_STR_MATCH` , Route 53 passes the value of `FullyQualifiedDomainName` in the `Host` header, as it does when you specify a value for `IPAddress` . If the value of `Type` is `TCP` , Route 53 doesn't pass a `Host` header.
        """
        return pulumi.get(self, "fully_qualified_domain_name")

    @property
    @pulumi.getter(name="healthThreshold")
    def health_threshold(self) -> Optional[builtins.int]:
        """
        The number of child health checks that are associated with a `CALCULATED` health check that Amazon Route 53 must consider healthy for the `CALCULATED` health check to be considered healthy. To specify the child health checks that you want to associate with a `CALCULATED` health check, use the [ChildHealthChecks](https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-ChildHealthChecks) element.

        Note the following:

        - If you specify a number greater than the number of child health checks, Route 53 always considers this health check to be unhealthy.
        - If you specify `0` , Route 53 always considers this health check to be healthy.
        """
        return pulumi.get(self, "health_threshold")

    @property
    @pulumi.getter(name="insufficientDataHealthStatus")
    def insufficient_data_health_status(self) -> Optional['HealthCheckConfigPropertiesInsufficientDataHealthStatus']:
        """
        When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign to the health check:

        - `Healthy` : Route 53 considers the health check to be healthy.
        - `Unhealthy` : Route 53 considers the health check to be unhealthy.
        - `LastKnownStatus` : Route 53 uses the status of the health check from the last time that CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last known status, the default status for the health check is healthy.
        """
        return pulumi.get(self, "insufficient_data_health_status")

    @property
    @pulumi.getter
    def inverted(self) -> Optional[builtins.bool]:
        """
        Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it otherwise would be considered healthy.
        """
        return pulumi.get(self, "inverted")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[builtins.str]:
        """
        The IPv4 or IPv6 IP address of the endpoint that you want Amazon Route 53 to perform health checks on. If you don't specify a value for `IPAddress` , Route 53 sends a DNS request to resolve the domain name that you specify in `FullyQualifiedDomainName` at the interval that you specify in `RequestInterval` . Using an IP address returned by DNS, Route 53 then checks the health of the endpoint.

        Use one of the following formats for the value of `IPAddress` :

        - *IPv4 address* : four values between 0 and 255, separated by periods (.), for example, `192.0.2.44` .
        - *IPv6 address* : eight groups of four hexadecimal values, separated by colons (:), for example, `2001:0db8:85a3:0000:0000:abcd:0001:2345` . You can also shorten IPv6 addresses as described in RFC 5952, for example, `2001:db8:85a3::abcd:1:2345` .

        If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your EC2 instance, and specify the Elastic IP address for `IPAddress` . This ensures that the IP address of your instance will never change.

        For more information, see [FullyQualifiedDomainName](https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName) .

        Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private, non-routable, or multicast ranges. For more information about IP addresses for which you can't create health checks, see the following documents:

        - [RFC 5735, Special Use IPv4 Addresses](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc5735)
        - [RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6598)
        - [RFC 5156, Special-Use IPv6 Addresses](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc5156)

        When the value of `Type` is `CALCULATED` or `CLOUDWATCH_METRIC` , omit `IPAddress` .
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="measureLatency")
    def measure_latency(self) -> Optional[builtins.bool]:
        """
        Specify whether you want Amazon Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint, and to display CloudWatch latency graphs on the *Health Checks* page in the Route 53 console.

        > You can't change the value of `MeasureLatency` after you create a health check.
        """
        return pulumi.get(self, "measure_latency")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port on the endpoint that you want Amazon Route 53 to perform health checks on.

        > Don't specify a value for `Port` when you specify a value for [Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-type) of `CLOUDWATCH_METRIC` or `CALCULATED` .
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def regions(self) -> Optional[Sequence[builtins.str]]:
        """
        A complex type that contains one `Region` element for each region from which you want Amazon Route 53 health checkers to check the specified endpoint.

        If you don't specify any regions, Route 53 health checkers automatically performs checks from all of the regions that are listed under *Valid Values* .

        If you update a health check to remove a region that has been performing health checks, Route 53 will briefly continue to perform checks from that region to ensure that some health checkers are always checking the endpoint (for example, if you replace three regions with four different regions).
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="requestInterval")
    def request_interval(self) -> Optional[builtins.int]:
        """
        The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health check request. Each Route 53 health checker makes requests at this interval.

        > You can't change the value of `RequestInterval` after you create a health check. 

        If you don't specify a value for `RequestInterval` , the default value is `30` seconds.
        """
        return pulumi.get(self, "request_interval")

    @property
    @pulumi.getter(name="resourcePath")
    def resource_path(self) -> Optional[builtins.str]:
        """
        The path, if any, that you want Amazon Route 53 to request when performing health checks. The path can be any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example, the file /docs/route53-health-check.html. You can also include query string parameters, for example, `/welcome.html?language=jp&login=y` .
        """
        return pulumi.get(self, "resource_path")

    @property
    @pulumi.getter(name="routingControlArn")
    def routing_control_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control.

        For more information about Route 53 Application Recovery Controller, see [Route 53 Application Recovery Controller Developer Guide.](https://docs.aws.amazon.com/r53recovery/latest/dg/what-is-route-53-recovery.html) .
        """
        return pulumi.get(self, "routing_control_arn")

    @property
    @pulumi.getter(name="searchString")
    def search_string(self) -> Optional[builtins.str]:
        """
        If the value of Type is `HTTP_STR_MATCH` or `HTTPS_STR_MATCH` , the string that you want Amazon Route 53 to search for in the response body from the specified resource. If the string appears in the response body, Route 53 considers the resource healthy.

        Route 53 considers case when searching for `SearchString` in the response body.
        """
        return pulumi.get(self, "search_string")


@pulumi.output_type
class HealthCheckTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        A key-value pair to associate with a resource.
        :param builtins.str key: The key name of the tag.
        :param builtins.str value: The value for the tag.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key name of the tag.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value for the tag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HostedZoneConfig(dict):
    """
    A complex type that contains an optional comment about your hosted zone. If you don't want to specify a comment, omit both the ``HostedZoneConfig`` and ``Comment`` elements.
    """
    def __init__(__self__, *,
                 comment: Optional[builtins.str] = None):
        """
        A complex type that contains an optional comment about your hosted zone. If you don't want to specify a comment, omit both the ``HostedZoneConfig`` and ``Comment`` elements.
        :param builtins.str comment: Any comments that you want to include about the hosted zone.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        Any comments that you want to include about the hosted zone.
        """
        return pulumi.get(self, "comment")


@pulumi.output_type
class HostedZoneQueryLoggingConfig(dict):
    """
    A complex type that contains information about a configuration for DNS query logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchLogsLogGroupArn":
            suggest = "cloud_watch_logs_log_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostedZoneQueryLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostedZoneQueryLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostedZoneQueryLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_logs_log_group_arn: builtins.str):
        """
        A complex type that contains information about a configuration for DNS query logging.
        :param builtins.str cloud_watch_logs_log_group_arn: The Amazon Resource Name (ARN) of the CloudWatch Logs log group that Amazon Route 53 is publishing logs to.
        """
        pulumi.set(__self__, "cloud_watch_logs_log_group_arn", cloud_watch_logs_log_group_arn)

    @property
    @pulumi.getter(name="cloudWatchLogsLogGroupArn")
    def cloud_watch_logs_log_group_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the CloudWatch Logs log group that Amazon Route 53 is publishing logs to.
        """
        return pulumi.get(self, "cloud_watch_logs_log_group_arn")


@pulumi.output_type
class HostedZoneVpc(dict):
    """
    *Private hosted zones only:* A complex type that contains information about an Amazon VPC. Route 53 Resolver uses the records in the private hosted zone to route traffic in that VPC. 
      For public hosted zones, omit ``VPCs``, ``VPCId``, and ``VPCRegion``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"
        elif key == "vpcRegion":
            suggest = "vpc_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostedZoneVpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostedZoneVpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostedZoneVpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: builtins.str,
                 vpc_region: builtins.str):
        """
        *Private hosted zones only:* A complex type that contains information about an Amazon VPC. Route 53 Resolver uses the records in the private hosted zone to route traffic in that VPC. 
          For public hosted zones, omit ``VPCs``, ``VPCId``, and ``VPCRegion``.
        :param builtins.str vpc_id: *Private hosted zones only:* The ID of an Amazon VPC.
                 For public hosted zones, omit ``VPCs``, ``VPCId``, and ``VPCRegion``.
        :param builtins.str vpc_region: *Private hosted zones only:* The region that an Amazon VPC was created in.
                 For public hosted zones, omit ``VPCs``, ``VPCId``, and ``VPCRegion``.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_region", vpc_region)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        """
        *Private hosted zones only:* The ID of an Amazon VPC.
          For public hosted zones, omit ``VPCs``, ``VPCId``, and ``VPCRegion``.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcRegion")
    def vpc_region(self) -> builtins.str:
        """
        *Private hosted zones only:* The region that an Amazon VPC was created in.
          For public hosted zones, omit ``VPCs``, ``VPCId``, and ``VPCRegion``.
        """
        return pulumi.get(self, "vpc_region")


