# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['CrlArgs', 'Crl']

@pulumi.input_type
class CrlArgs:
    def __init__(__self__, *,
                 crl_data: pulumi.Input[builtins.str],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 trust_anchor_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Crl resource.
        :param pulumi.Input[builtins.str] crl_data: The x509 v3 specified certificate revocation list (CRL).
        :param pulumi.Input[builtins.bool] enabled: Specifies whether the certificate revocation list (CRL) is enabled.
        :param pulumi.Input[builtins.str] name: The name of the certificate revocation list (CRL).
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of tags to attach to the certificate revocation list (CRL).
        :param pulumi.Input[builtins.str] trust_anchor_arn: The ARN of the TrustAnchor the certificate revocation list (CRL) will provide revocation for.
        """
        pulumi.set(__self__, "crl_data", crl_data)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trust_anchor_arn is not None:
            pulumi.set(__self__, "trust_anchor_arn", trust_anchor_arn)

    @property
    @pulumi.getter(name="crlData")
    def crl_data(self) -> pulumi.Input[builtins.str]:
        """
        The x509 v3 specified certificate revocation list (CRL).
        """
        return pulumi.get(self, "crl_data")

    @crl_data.setter
    def crl_data(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "crl_data", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the certificate revocation list (CRL) is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the certificate revocation list (CRL).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of tags to attach to the certificate revocation list (CRL).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="trustAnchorArn")
    def trust_anchor_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the TrustAnchor the certificate revocation list (CRL) will provide revocation for.
        """
        return pulumi.get(self, "trust_anchor_arn")

    @trust_anchor_arn.setter
    def trust_anchor_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trust_anchor_arn", value)


@pulumi.type_token("aws-native:rolesanywhere:Crl")
class Crl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crl_data: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 trust_anchor_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Definition of AWS::RolesAnywhere::CRL Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] crl_data: The x509 v3 specified certificate revocation list (CRL).
        :param pulumi.Input[builtins.bool] enabled: Specifies whether the certificate revocation list (CRL) is enabled.
        :param pulumi.Input[builtins.str] name: The name of the certificate revocation list (CRL).
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of tags to attach to the certificate revocation list (CRL).
        :param pulumi.Input[builtins.str] trust_anchor_arn: The ARN of the TrustAnchor the certificate revocation list (CRL) will provide revocation for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CrlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::RolesAnywhere::CRL Resource Type

        :param str resource_name: The name of the resource.
        :param CrlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CrlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crl_data: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 trust_anchor_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CrlArgs.__new__(CrlArgs)

            if crl_data is None and not opts.urn:
                raise TypeError("Missing required property 'crl_data'")
            __props__.__dict__["crl_data"] = crl_data
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["trust_anchor_arn"] = trust_anchor_arn
            __props__.__dict__["crl_id"] = None
        super(Crl, __self__).__init__(
            'aws-native:rolesanywhere:Crl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Crl':
        """
        Get an existing Crl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CrlArgs.__new__(CrlArgs)

        __props__.__dict__["crl_data"] = None
        __props__.__dict__["crl_id"] = None
        __props__.__dict__["enabled"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["trust_anchor_arn"] = None
        return Crl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="crlData")
    def crl_data(self) -> pulumi.Output[builtins.str]:
        """
        The x509 v3 specified certificate revocation list (CRL).
        """
        return pulumi.get(self, "crl_data")

    @property
    @pulumi.getter(name="crlId")
    def crl_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique primary identifier of the Crl
        """
        return pulumi.get(self, "crl_id")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the certificate revocation list (CRL) is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the certificate revocation list (CRL).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of tags to attach to the certificate revocation list (CRL).
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trustAnchorArn")
    def trust_anchor_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARN of the TrustAnchor the certificate revocation list (CRL) will provide revocation for.
        """
        return pulumi.get(self, "trust_anchor_arn")

