# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRobotApplicationVersionResult',
    'AwaitableGetRobotApplicationVersionResult',
    'get_robot_application_version',
    'get_robot_application_version_output',
]

@pulumi.output_type
class GetRobotApplicationVersionResult:
    def __init__(__self__, application_version=None, arn=None):
        if application_version and not isinstance(application_version, str):
            raise TypeError("Expected argument 'application_version' to be a str")
        pulumi.set(__self__, "application_version", application_version)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter(name="applicationVersion")
    def application_version(self) -> Optional[builtins.str]:
        """
        The robot application version.
        """
        return pulumi.get(self, "application_version")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the robot application version.
        """
        return pulumi.get(self, "arn")


class AwaitableGetRobotApplicationVersionResult(GetRobotApplicationVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRobotApplicationVersionResult(
            application_version=self.application_version,
            arn=self.arn)


def get_robot_application_version(arn: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRobotApplicationVersionResult:
    """
    AWS::RoboMaker::RobotApplicationVersion resource creates an AWS RoboMaker RobotApplicationVersion. This helps you control which code your robot uses.


    :param builtins.str arn: The Amazon Resource Name (ARN) of the robot application version.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:robomaker:getRobotApplicationVersion', __args__, opts=opts, typ=GetRobotApplicationVersionResult).value

    return AwaitableGetRobotApplicationVersionResult(
        application_version=pulumi.get(__ret__, 'application_version'),
        arn=pulumi.get(__ret__, 'arn'))
def get_robot_application_version_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRobotApplicationVersionResult]:
    """
    AWS::RoboMaker::RobotApplicationVersion resource creates an AWS RoboMaker RobotApplicationVersion. This helps you control which code your robot uses.


    :param builtins.str arn: The Amazon Resource Name (ARN) of the robot application version.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:robomaker:getRobotApplicationVersion', __args__, opts=opts, typ=GetRobotApplicationVersionResult)
    return __ret__.apply(lambda __response__: GetRobotApplicationVersionResult(
        application_version=pulumi.get(__response__, 'application_version'),
        arn=pulumi.get(__response__, 'arn')))
