# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetRobotApplicationResult',
    'AwaitableGetRobotApplicationResult',
    'get_robot_application',
    'get_robot_application_output',
]

@pulumi.output_type
class GetRobotApplicationResult:
    def __init__(__self__, arn=None, current_revision_id=None, environment=None, robot_software_suite=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if current_revision_id and not isinstance(current_revision_id, str):
            raise TypeError("Expected argument 'current_revision_id' to be a str")
        pulumi.set(__self__, "current_revision_id", current_revision_id)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if robot_software_suite and not isinstance(robot_software_suite, dict):
            raise TypeError("Expected argument 'robot_software_suite' to be a dict")
        pulumi.set(__self__, "robot_software_suite", robot_software_suite)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the robot application.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="currentRevisionId")
    def current_revision_id(self) -> Optional[builtins.str]:
        """
        The revision ID of robot application.
        """
        return pulumi.get(self, "current_revision_id")

    @property
    @pulumi.getter
    def environment(self) -> Optional[builtins.str]:
        """
        The URI of the Docker image for the robot application.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="robotSoftwareSuite")
    def robot_software_suite(self) -> Optional['outputs.RobotApplicationRobotSoftwareSuite']:
        """
        The robot software suite used by the robot application.
        """
        return pulumi.get(self, "robot_software_suite")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A map that contains tag keys and tag values that are attached to the robot application.
        """
        return pulumi.get(self, "tags")


class AwaitableGetRobotApplicationResult(GetRobotApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRobotApplicationResult(
            arn=self.arn,
            current_revision_id=self.current_revision_id,
            environment=self.environment,
            robot_software_suite=self.robot_software_suite,
            tags=self.tags)


def get_robot_application(arn: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRobotApplicationResult:
    """
    This schema is for testing purpose only.


    :param builtins.str arn: The Amazon Resource Name (ARN) of the robot application.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:robomaker:getRobotApplication', __args__, opts=opts, typ=GetRobotApplicationResult).value

    return AwaitableGetRobotApplicationResult(
        arn=pulumi.get(__ret__, 'arn'),
        current_revision_id=pulumi.get(__ret__, 'current_revision_id'),
        environment=pulumi.get(__ret__, 'environment'),
        robot_software_suite=pulumi.get(__ret__, 'robot_software_suite'),
        tags=pulumi.get(__ret__, 'tags'))
def get_robot_application_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRobotApplicationResult]:
    """
    This schema is for testing purpose only.


    :param builtins.str arn: The Amazon Resource Name (ARN) of the robot application.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:robomaker:getRobotApplication', __args__, opts=opts, typ=GetRobotApplicationResult)
    return __ret__.apply(lambda __response__: GetRobotApplicationResult(
        arn=pulumi.get(__response__, 'arn'),
        current_revision_id=pulumi.get(__response__, 'current_revision_id'),
        environment=pulumi.get(__response__, 'environment'),
        robot_software_suite=pulumi.get(__response__, 'robot_software_suite'),
        tags=pulumi.get(__response__, 'tags')))
