# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FleetArgs', 'Fleet']

@pulumi.input_type
class FleetArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Fleet resource.
        :param pulumi.Input[builtins.str] name: The name of the fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: The list of all tags added to the fleet.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the fleet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The list of all tags added to the fleet.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:robomaker:Fleet")
class Fleet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        AWS::RoboMaker::Fleet resource creates an AWS RoboMaker fleet. Fleets contain robots and can receive deployments.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        basic_fleet = aws_native.robomaker.Fleet("basicFleet",
            name="MyFleet",
            tags={
                "name": "BasicFleet",
                "type": "CFN",
            })
        pulumi.export("fleet", "BasicFleet")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        basic_fleet = aws_native.robomaker.Fleet("basicFleet",
            name="MyFleet",
            tags={
                "name": "BasicFleet",
                "type": "CFN",
            })
        pulumi.export("fleet", basic_fleet.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        basic_fleet = aws_native.robomaker.Fleet("basicFleet", name="MyFleet")
        basic_robot = aws_native.robomaker.Robot("basicRobot",
            name="MyRobot",
            greengrass_group_id="51229986-abdc-4ca6-94f8-04735a0c9f07",
            architecture=aws_native.robomaker.RobotArchitecture.ARMHF,
            fleet=basic_fleet.arn,
            tags={
                "name": "BasicRobot",
                "type": "CFN",
            })
        pulumi.export("robot", "BasicRobot")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        basic_fleet = aws_native.robomaker.Fleet("basicFleet", name="MyFleet")
        basic_robot = aws_native.robomaker.Robot("basicRobot",
            name="MyRobot",
            greengrass_group_id="51229986-abdc-4ca6-94f8-04735a0c9f07",
            architecture=aws_native.robomaker.RobotArchitecture.ARMHF,
            fleet=basic_fleet.arn,
            tags={
                "name": "BasicRobot",
                "type": "CFN",
            })
        pulumi.export("robot", basic_robot.id)

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: The list of all tags added to the fleet.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FleetArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AWS::RoboMaker::Fleet resource creates an AWS RoboMaker fleet. Fleets contain robots and can receive deployments.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        basic_fleet = aws_native.robomaker.Fleet("basicFleet",
            name="MyFleet",
            tags={
                "name": "BasicFleet",
                "type": "CFN",
            })
        pulumi.export("fleet", "BasicFleet")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        basic_fleet = aws_native.robomaker.Fleet("basicFleet",
            name="MyFleet",
            tags={
                "name": "BasicFleet",
                "type": "CFN",
            })
        pulumi.export("fleet", basic_fleet.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        basic_fleet = aws_native.robomaker.Fleet("basicFleet", name="MyFleet")
        basic_robot = aws_native.robomaker.Robot("basicRobot",
            name="MyRobot",
            greengrass_group_id="51229986-abdc-4ca6-94f8-04735a0c9f07",
            architecture=aws_native.robomaker.RobotArchitecture.ARMHF,
            fleet=basic_fleet.arn,
            tags={
                "name": "BasicRobot",
                "type": "CFN",
            })
        pulumi.export("robot", "BasicRobot")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        basic_fleet = aws_native.robomaker.Fleet("basicFleet", name="MyFleet")
        basic_robot = aws_native.robomaker.Robot("basicRobot",
            name="MyRobot",
            greengrass_group_id="51229986-abdc-4ca6-94f8-04735a0c9f07",
            architecture=aws_native.robomaker.RobotArchitecture.ARMHF,
            fleet=basic_fleet.arn,
            tags={
                "name": "BasicRobot",
                "type": "CFN",
            })
        pulumi.export("robot", basic_robot.id)

        ```

        :param str resource_name: The name of the resource.
        :param FleetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetArgs.__new__(FleetArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Fleet, __self__).__init__(
            'aws-native:robomaker:Fleet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Fleet':
        """
        Get an existing Fleet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FleetArgs.__new__(FleetArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        return Fleet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the fleet, such as `arn:aws:robomaker:us-west-2:123456789012:deployment-fleet/MyFleet/1539894765711` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the fleet.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The list of all tags added to the fleet.
        """
        return pulumi.get(self, "tags")

