# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['TagSyncTaskArgs', 'TagSyncTask']

@pulumi.input_type
class TagSyncTaskArgs:
    def __init__(__self__, *,
                 group: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str],
                 tag_key: pulumi.Input[builtins.str],
                 tag_value: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a TagSyncTask resource.
        :param pulumi.Input[builtins.str] group: The Amazon resource name (ARN) or name of the application group for which you want to create a tag-sync task
        :param pulumi.Input[builtins.str] role_arn: The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your behalf.
        :param pulumi.Input[builtins.str] tag_key: The tag key. Resources tagged with this tag key-value pair will be added to the application. If a resource with this tag is later untagged, the tag-sync task removes the resource from the application.
        :param pulumi.Input[builtins.str] tag_value: The tag value. Resources tagged with this tag key-value pair will be added to the application. If a resource with this tag is later untagged, the tag-sync task removes the resource from the application.
        """
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "tag_key", tag_key)
        pulumi.set(__self__, "tag_value", tag_value)

    @property
    @pulumi.getter
    def group(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon resource name (ARN) or name of the application group for which you want to create a tag-sync task
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> pulumi.Input[builtins.str]:
        """
        The tag key. Resources tagged with this tag key-value pair will be added to the application. If a resource with this tag is later untagged, the tag-sync task removes the resource from the application.
        """
        return pulumi.get(self, "tag_key")

    @tag_key.setter
    def tag_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tag_key", value)

    @property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> pulumi.Input[builtins.str]:
        """
        The tag value. Resources tagged with this tag key-value pair will be added to the application. If a resource with this tag is later untagged, the tag-sync task removes the resource from the application.
        """
        return pulumi.get(self, "tag_value")

    @tag_value.setter
    def tag_value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tag_value", value)


@pulumi.type_token("aws-native:resourcegroups:TagSyncTask")
class TagSyncTask(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tag_key: Optional[pulumi.Input[builtins.str]] = None,
                 tag_value: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Schema for ResourceGroups::TagSyncTask

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] group: The Amazon resource name (ARN) or name of the application group for which you want to create a tag-sync task
        :param pulumi.Input[builtins.str] role_arn: The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your behalf.
        :param pulumi.Input[builtins.str] tag_key: The tag key. Resources tagged with this tag key-value pair will be added to the application. If a resource with this tag is later untagged, the tag-sync task removes the resource from the application.
        :param pulumi.Input[builtins.str] tag_value: The tag value. Resources tagged with this tag key-value pair will be added to the application. If a resource with this tag is later untagged, the tag-sync task removes the resource from the application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TagSyncTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Schema for ResourceGroups::TagSyncTask

        :param str resource_name: The name of the resource.
        :param TagSyncTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TagSyncTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tag_key: Optional[pulumi.Input[builtins.str]] = None,
                 tag_value: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TagSyncTaskArgs.__new__(TagSyncTaskArgs)

            if group is None and not opts.urn:
                raise TypeError("Missing required property 'group'")
            __props__.__dict__["group"] = group
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            if tag_key is None and not opts.urn:
                raise TypeError("Missing required property 'tag_key'")
            __props__.__dict__["tag_key"] = tag_key
            if tag_value is None and not opts.urn:
                raise TypeError("Missing required property 'tag_value'")
            __props__.__dict__["tag_value"] = tag_value
            __props__.__dict__["group_arn"] = None
            __props__.__dict__["group_name"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["task_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["group", "roleArn", "tagKey", "tagValue"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(TagSyncTask, __self__).__init__(
            'aws-native:resourcegroups:TagSyncTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'TagSyncTask':
        """
        Get an existing TagSyncTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TagSyncTaskArgs.__new__(TagSyncTaskArgs)

        __props__.__dict__["group"] = None
        __props__.__dict__["group_arn"] = None
        __props__.__dict__["group_name"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tag_key"] = None
        __props__.__dict__["tag_value"] = None
        __props__.__dict__["task_arn"] = None
        return TagSyncTask(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon resource name (ARN) or name of the application group for which you want to create a tag-sync task
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="groupArn")
    def group_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon resource name (ARN) of the ApplicationGroup for which the TagSyncTask is created
        """
        return pulumi.get(self, "group_arn")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[builtins.str]:
        """
        The Name of the application group for which the TagSyncTask is created
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['TagSyncTaskStatus']:
        """
        The status of the TagSyncTask
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> pulumi.Output[builtins.str]:
        """
        The tag key. Resources tagged with this tag key-value pair will be added to the application. If a resource with this tag is later untagged, the tag-sync task removes the resource from the application.
        """
        return pulumi.get(self, "tag_key")

    @property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> pulumi.Output[builtins.str]:
        """
        The tag value. Resources tagged with this tag key-value pair will be added to the application. If a resource with this tag is later untagged, the tag-sync task removes the resource from the application.
        """
        return pulumi.get(self, "tag_value")

    @property
    @pulumi.getter(name="taskArn")
    def task_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the TagSyncTask resource
        """
        return pulumi.get(self, "task_arn")

