# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetTagSyncTaskResult',
    'AwaitableGetTagSyncTaskResult',
    'get_tag_sync_task',
    'get_tag_sync_task_output',
]

@pulumi.output_type
class GetTagSyncTaskResult:
    def __init__(__self__, group_arn=None, group_name=None, status=None, task_arn=None):
        if group_arn and not isinstance(group_arn, str):
            raise TypeError("Expected argument 'group_arn' to be a str")
        pulumi.set(__self__, "group_arn", group_arn)
        if group_name and not isinstance(group_name, str):
            raise TypeError("Expected argument 'group_name' to be a str")
        pulumi.set(__self__, "group_name", group_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if task_arn and not isinstance(task_arn, str):
            raise TypeError("Expected argument 'task_arn' to be a str")
        pulumi.set(__self__, "task_arn", task_arn)

    @property
    @pulumi.getter(name="groupArn")
    def group_arn(self) -> Optional[builtins.str]:
        """
        The Amazon resource name (ARN) of the ApplicationGroup for which the TagSyncTask is created
        """
        return pulumi.get(self, "group_arn")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[builtins.str]:
        """
        The Name of the application group for which the TagSyncTask is created
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def status(self) -> Optional['TagSyncTaskStatus']:
        """
        The status of the TagSyncTask
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="taskArn")
    def task_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the TagSyncTask resource
        """
        return pulumi.get(self, "task_arn")


class AwaitableGetTagSyncTaskResult(GetTagSyncTaskResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTagSyncTaskResult(
            group_arn=self.group_arn,
            group_name=self.group_name,
            status=self.status,
            task_arn=self.task_arn)


def get_tag_sync_task(task_arn: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTagSyncTaskResult:
    """
    Schema for ResourceGroups::TagSyncTask


    :param builtins.str task_arn: The ARN of the TagSyncTask resource
    """
    __args__ = dict()
    __args__['taskArn'] = task_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:resourcegroups:getTagSyncTask', __args__, opts=opts, typ=GetTagSyncTaskResult).value

    return AwaitableGetTagSyncTaskResult(
        group_arn=pulumi.get(__ret__, 'group_arn'),
        group_name=pulumi.get(__ret__, 'group_name'),
        status=pulumi.get(__ret__, 'status'),
        task_arn=pulumi.get(__ret__, 'task_arn'))
def get_tag_sync_task_output(task_arn: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTagSyncTaskResult]:
    """
    Schema for ResourceGroups::TagSyncTask


    :param builtins.str task_arn: The ARN of the TagSyncTask resource
    """
    __args__ = dict()
    __args__['taskArn'] = task_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:resourcegroups:getTagSyncTask', __args__, opts=opts, typ=GetTagSyncTaskResult)
    return __ret__.apply(lambda __response__: GetTagSyncTaskResult(
        group_arn=pulumi.get(__response__, 'group_arn'),
        group_name=pulumi.get(__response__, 'group_name'),
        status=pulumi.get(__response__, 'status'),
        task_arn=pulumi.get(__response__, 'task_arn')))
