# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetGroupResult',
    'AwaitableGetGroupResult',
    'get_group',
    'get_group_output',
]

@pulumi.output_type
class GetGroupResult:
    def __init__(__self__, arn=None, configuration=None, description=None, resource_query=None, resources=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if configuration and not isinstance(configuration, list):
            raise TypeError("Expected argument 'configuration' to be a list")
        pulumi.set(__self__, "configuration", configuration)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if resource_query and not isinstance(resource_query, dict):
            raise TypeError("Expected argument 'resource_query' to be a dict")
        pulumi.set(__self__, "resource_query", resource_query)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Resource Group ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Sequence['outputs.GroupConfigurationItem']]:
        """
        The service configuration currently associated with the resource group and in effect for the members of the resource group. A `Configuration` consists of one or more `ConfigurationItem` entries. For information about service configurations for resource groups and how to construct them, see [Service configurations for resource groups](https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html) in the *AWS Resource Groups User Guide* .

        > You can include either a `Configuration` or a `ResourceQuery` , but not both.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the resource group
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="resourceQuery")
    def resource_query(self) -> Optional['outputs.GroupResourceQuery']:
        """
        The resource query structure that is used to dynamically determine which AWS resources are members of the associated resource group. For more information about queries and how to construct them, see [Build queries and groups in AWS Resource Groups](https://docs.aws.amazon.com//ARG/latest/userguide/gettingstarted-query.html) in the *AWS Resource Groups User Guide*

        > - You can include either a `ResourceQuery` or a `Configuration` , but not both.
        > - You can specify the group's membership either by using a `ResourceQuery` or by using a list of `Resources` , but not both.
        """
        return pulumi.get(self, "resource_query")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of the Amazon Resource Names (ARNs) of AWS resources that you want to add to the specified group.

        > - You can specify the group membership either by using a list of `Resources` or by using a `ResourceQuery` , but not both.
        > - You can include a `Resources` property only if you also specify a `Configuration` property.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tag key and value pairs that are attached to the resource group.
        """
        return pulumi.get(self, "tags")


class AwaitableGetGroupResult(GetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupResult(
            arn=self.arn,
            configuration=self.configuration,
            description=self.description,
            resource_query=self.resource_query,
            resources=self.resources,
            tags=self.tags)


def get_group(name: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupResult:
    """
    Schema for ResourceGroups::Group


    :param builtins.str name: The name of the resource group
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:resourcegroups:getGroup', __args__, opts=opts, typ=GetGroupResult).value

    return AwaitableGetGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        configuration=pulumi.get(__ret__, 'configuration'),
        description=pulumi.get(__ret__, 'description'),
        resource_query=pulumi.get(__ret__, 'resource_query'),
        resources=pulumi.get(__ret__, 'resources'),
        tags=pulumi.get(__ret__, 'tags'))
def get_group_output(name: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupResult]:
    """
    Schema for ResourceGroups::Group


    :param builtins.str name: The name of the resource group
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:resourcegroups:getGroup', __args__, opts=opts, typ=GetGroupResult)
    return __ret__.apply(lambda __response__: GetGroupResult(
        arn=pulumi.get(__response__, 'arn'),
        configuration=pulumi.get(__response__, 'configuration'),
        description=pulumi.get(__response__, 'description'),
        resource_query=pulumi.get(__response__, 'resource_query'),
        resources=pulumi.get(__response__, 'resources'),
        tags=pulumi.get(__response__, 'tags')))
