# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetIndexResult',
    'AwaitableGetIndexResult',
    'get_index',
    'get_index_output',
]

@pulumi.output_type
class GetIndexResult:
    def __init__(__self__, arn=None, index_state=None, tags=None, type=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if index_state and not isinstance(index_state, str):
            raise TypeError("Expected argument 'index_state' to be a str")
        pulumi.set(__self__, "index_state", index_state)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of the new index for the AWS Region . For example:

        `arn:aws:resource-explorer-2:us-east-1:123456789012:index/EXAMPLE8-90ab-cdef-fedc-EXAMPLE22222`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="indexState")
    def index_state(self) -> Optional['IndexState']:
        """
        Indicates the current state of the index. For example:

        `CREATING`
        """
        return pulumi.get(self, "index_state")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The specified tags are attached to only the index created in this AWS Region . The tags don't attach to any of the resources listed in the index.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional['IndexType']:
        """
        Specifies the type of the index in this Region. For information about the aggregator index and how it differs from a local index, see [Turning on cross-Region search by creating an aggregator index](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html) in the *AWS Resource Explorer User Guide.* .
        """
        return pulumi.get(self, "type")


class AwaitableGetIndexResult(GetIndexResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIndexResult(
            arn=self.arn,
            index_state=self.index_state,
            tags=self.tags,
            type=self.type)


def get_index(arn: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIndexResult:
    """
    Definition of AWS::ResourceExplorer2::Index Resource Type


    :param builtins.str arn: The ARN of the new index for the AWS Region . For example:
           
           `arn:aws:resource-explorer-2:us-east-1:123456789012:index/EXAMPLE8-90ab-cdef-fedc-EXAMPLE22222`
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:resourceexplorer2:getIndex', __args__, opts=opts, typ=GetIndexResult).value

    return AwaitableGetIndexResult(
        arn=pulumi.get(__ret__, 'arn'),
        index_state=pulumi.get(__ret__, 'index_state'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'))
def get_index_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIndexResult]:
    """
    Definition of AWS::ResourceExplorer2::Index Resource Type


    :param builtins.str arn: The ARN of the new index for the AWS Region . For example:
           
           `arn:aws:resource-explorer-2:us-east-1:123456789012:index/EXAMPLE8-90ab-cdef-fedc-EXAMPLE22222`
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:resourceexplorer2:getIndex', __args__, opts=opts, typ=GetIndexResult)
    return __ret__.apply(lambda __response__: GetIndexResult(
        arn=pulumi.get(__response__, 'arn'),
        index_state=pulumi.get(__response__, 'index_state'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type')))
