# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDefaultViewAssociationResult',
    'AwaitableGetDefaultViewAssociationResult',
    'get_default_view_association',
    'get_default_view_association_output',
]

@pulumi.output_type
class GetDefaultViewAssociationResult:
    def __init__(__self__, associated_aws_principal=None, view_arn=None):
        if associated_aws_principal and not isinstance(associated_aws_principal, str):
            raise TypeError("Expected argument 'associated_aws_principal' to be a str")
        pulumi.set(__self__, "associated_aws_principal", associated_aws_principal)
        if view_arn and not isinstance(view_arn, str):
            raise TypeError("Expected argument 'view_arn' to be a str")
        pulumi.set(__self__, "view_arn", view_arn)

    @property
    @pulumi.getter(name="associatedAwsPrincipal")
    def associated_aws_principal(self) -> Optional[builtins.str]:
        """
        The AWS principal that the default view is associated with, used as the unique identifier for this resource.
        """
        return pulumi.get(self, "associated_aws_principal")

    @property
    @pulumi.getter(name="viewArn")
    def view_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the view to set as the default for the AWS Region and AWS account in which you call this operation. The specified view must already exist in the specified Region.
        """
        return pulumi.get(self, "view_arn")


class AwaitableGetDefaultViewAssociationResult(GetDefaultViewAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDefaultViewAssociationResult(
            associated_aws_principal=self.associated_aws_principal,
            view_arn=self.view_arn)


def get_default_view_association(associated_aws_principal: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDefaultViewAssociationResult:
    """
    Definition of AWS::ResourceExplorer2::DefaultViewAssociation Resource Type


    :param builtins.str associated_aws_principal: The AWS principal that the default view is associated with, used as the unique identifier for this resource.
    """
    __args__ = dict()
    __args__['associatedAwsPrincipal'] = associated_aws_principal
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:resourceexplorer2:getDefaultViewAssociation', __args__, opts=opts, typ=GetDefaultViewAssociationResult).value

    return AwaitableGetDefaultViewAssociationResult(
        associated_aws_principal=pulumi.get(__ret__, 'associated_aws_principal'),
        view_arn=pulumi.get(__ret__, 'view_arn'))
def get_default_view_association_output(associated_aws_principal: Optional[pulumi.Input[builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDefaultViewAssociationResult]:
    """
    Definition of AWS::ResourceExplorer2::DefaultViewAssociation Resource Type


    :param builtins.str associated_aws_principal: The AWS principal that the default view is associated with, used as the unique identifier for this resource.
    """
    __args__ = dict()
    __args__['associatedAwsPrincipal'] = associated_aws_principal
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:resourceexplorer2:getDefaultViewAssociation', __args__, opts=opts, typ=GetDefaultViewAssociationResult)
    return __ret__.apply(lambda __response__: GetDefaultViewAssociationResult(
        associated_aws_principal=pulumi.get(__response__, 'associated_aws_principal'),
        view_arn=pulumi.get(__response__, 'view_arn')))
