# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['StreamProcessorArgs', 'StreamProcessor']

@pulumi.input_type
class StreamProcessorArgs:
    def __init__(__self__, *,
                 kinesis_video_stream: pulumi.Input['StreamProcessorKinesisVideoStreamArgs'],
                 role_arn: pulumi.Input[builtins.str],
                 bounding_box_regions_of_interest: Optional[pulumi.Input[Sequence[pulumi.Input['StreamProcessorBoundingBoxArgs']]]] = None,
                 connected_home_settings: Optional[pulumi.Input['StreamProcessorConnectedHomeSettingsArgs']] = None,
                 data_sharing_preference: Optional[pulumi.Input['StreamProcessorDataSharingPreferenceArgs']] = None,
                 face_search_settings: Optional[pulumi.Input['StreamProcessorFaceSearchSettingsArgs']] = None,
                 kinesis_data_stream: Optional[pulumi.Input['StreamProcessorKinesisDataStreamArgs']] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_channel: Optional[pulumi.Input['StreamProcessorNotificationChannelArgs']] = None,
                 polygon_regions_of_interest: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['StreamProcessorPointArgs']]]]]] = None,
                 s3_destination: Optional[pulumi.Input['StreamProcessorS3DestinationArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a StreamProcessor resource.
        :param pulumi.Input['StreamProcessorKinesisVideoStreamArgs'] kinesis_video_stream: The Kinesis video stream that provides the source of the streaming video for an Amazon Rekognition Video stream processor. For more information, see [KinesisVideoStream](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisVideoStream) .
        :param pulumi.Input[builtins.str] role_arn: ARN of the IAM role that allows access to the stream processor, and provides Rekognition read permissions for KVS stream and write permissions to S3 bucket and SNS topic.
        :param pulumi.Input[Sequence[pulumi.Input['StreamProcessorBoundingBoxArgs']]] bounding_box_regions_of_interest: The BoundingBoxRegionsOfInterest specifies an array of bounding boxes of interest in the video frames to analyze, as part of connected home feature. If an object is partially in a region of interest, Rekognition will tag it as detected if the overlap of the object with the region-of-interest is greater than 20%.
        :param pulumi.Input['StreamProcessorConnectedHomeSettingsArgs'] connected_home_settings: Connected home settings to use on a streaming video. You can use a stream processor for connected home features and select what you want the stream processor to detect, such as people or pets. When the stream processor has started, one notification is sent for each object class specified. For more information, see the ConnectedHome section of [StreamProcessorSettings](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorSettings) .
        :param pulumi.Input['StreamProcessorDataSharingPreferenceArgs'] data_sharing_preference: Allows you to opt in or opt out to share data with Rekognition to improve model performance. You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. For more information, see [StreamProcessorDataSharingPreference](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorDataSharingPreference) .
        :param pulumi.Input['StreamProcessorFaceSearchSettingsArgs'] face_search_settings: The input parameters used to recognize faces in a streaming video analyzed by an Amazon Rekognition stream processor. For more information regarding the contents of the parameters, see [FaceSearchSettings](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_FaceSearchSettings) .
        :param pulumi.Input['StreamProcessorKinesisDataStreamArgs'] kinesis_data_stream: Amazon Rekognition's Video Stream Processor takes a Kinesis video stream as input. This is the Amazon Kinesis Data Streams instance to which the Amazon Rekognition stream processor streams the analysis results. This must be created within the constraints specified at [KinesisDataStream](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisDataStream) .
        :param pulumi.Input[builtins.str] kms_key_id: The KMS key that is used by Rekognition to encrypt any intermediate customer metadata and store in the customer's S3 bucket.
        :param pulumi.Input[builtins.str] name: Name of the stream processor. It's an identifier you assign to the stream processor. You can use it to manage the stream processor.
        :param pulumi.Input['StreamProcessorNotificationChannelArgs'] notification_channel: The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation. Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. Amazon Rekognition also publishes an end-of-session notification with a summary when the stream processing session is complete. For more information, see [StreamProcessorNotificationChannel](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorNotificationChannel) .
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['StreamProcessorPointArgs']]]]] polygon_regions_of_interest: The PolygonRegionsOfInterest specifies a set of polygon areas of interest in the video frames to analyze, as part of connected home feature. Each polygon is in turn, an ordered list of Point
        :param pulumi.Input['StreamProcessorS3DestinationArgs'] s3_destination: The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation. For more information, see the S3Destination section of [StreamProcessorOutput](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorOutput) .
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "kinesis_video_stream", kinesis_video_stream)
        pulumi.set(__self__, "role_arn", role_arn)
        if bounding_box_regions_of_interest is not None:
            pulumi.set(__self__, "bounding_box_regions_of_interest", bounding_box_regions_of_interest)
        if connected_home_settings is not None:
            pulumi.set(__self__, "connected_home_settings", connected_home_settings)
        if data_sharing_preference is not None:
            pulumi.set(__self__, "data_sharing_preference", data_sharing_preference)
        if face_search_settings is not None:
            pulumi.set(__self__, "face_search_settings", face_search_settings)
        if kinesis_data_stream is not None:
            pulumi.set(__self__, "kinesis_data_stream", kinesis_data_stream)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_channel is not None:
            pulumi.set(__self__, "notification_channel", notification_channel)
        if polygon_regions_of_interest is not None:
            pulumi.set(__self__, "polygon_regions_of_interest", polygon_regions_of_interest)
        if s3_destination is not None:
            pulumi.set(__self__, "s3_destination", s3_destination)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="kinesisVideoStream")
    def kinesis_video_stream(self) -> pulumi.Input['StreamProcessorKinesisVideoStreamArgs']:
        """
        The Kinesis video stream that provides the source of the streaming video for an Amazon Rekognition Video stream processor. For more information, see [KinesisVideoStream](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisVideoStream) .
        """
        return pulumi.get(self, "kinesis_video_stream")

    @kinesis_video_stream.setter
    def kinesis_video_stream(self, value: pulumi.Input['StreamProcessorKinesisVideoStreamArgs']):
        pulumi.set(self, "kinesis_video_stream", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the IAM role that allows access to the stream processor, and provides Rekognition read permissions for KVS stream and write permissions to S3 bucket and SNS topic.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="boundingBoxRegionsOfInterest")
    def bounding_box_regions_of_interest(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StreamProcessorBoundingBoxArgs']]]]:
        """
        The BoundingBoxRegionsOfInterest specifies an array of bounding boxes of interest in the video frames to analyze, as part of connected home feature. If an object is partially in a region of interest, Rekognition will tag it as detected if the overlap of the object with the region-of-interest is greater than 20%.
        """
        return pulumi.get(self, "bounding_box_regions_of_interest")

    @bounding_box_regions_of_interest.setter
    def bounding_box_regions_of_interest(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StreamProcessorBoundingBoxArgs']]]]):
        pulumi.set(self, "bounding_box_regions_of_interest", value)

    @property
    @pulumi.getter(name="connectedHomeSettings")
    def connected_home_settings(self) -> Optional[pulumi.Input['StreamProcessorConnectedHomeSettingsArgs']]:
        """
        Connected home settings to use on a streaming video. You can use a stream processor for connected home features and select what you want the stream processor to detect, such as people or pets. When the stream processor has started, one notification is sent for each object class specified. For more information, see the ConnectedHome section of [StreamProcessorSettings](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorSettings) .
        """
        return pulumi.get(self, "connected_home_settings")

    @connected_home_settings.setter
    def connected_home_settings(self, value: Optional[pulumi.Input['StreamProcessorConnectedHomeSettingsArgs']]):
        pulumi.set(self, "connected_home_settings", value)

    @property
    @pulumi.getter(name="dataSharingPreference")
    def data_sharing_preference(self) -> Optional[pulumi.Input['StreamProcessorDataSharingPreferenceArgs']]:
        """
        Allows you to opt in or opt out to share data with Rekognition to improve model performance. You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. For more information, see [StreamProcessorDataSharingPreference](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorDataSharingPreference) .
        """
        return pulumi.get(self, "data_sharing_preference")

    @data_sharing_preference.setter
    def data_sharing_preference(self, value: Optional[pulumi.Input['StreamProcessorDataSharingPreferenceArgs']]):
        pulumi.set(self, "data_sharing_preference", value)

    @property
    @pulumi.getter(name="faceSearchSettings")
    def face_search_settings(self) -> Optional[pulumi.Input['StreamProcessorFaceSearchSettingsArgs']]:
        """
        The input parameters used to recognize faces in a streaming video analyzed by an Amazon Rekognition stream processor. For more information regarding the contents of the parameters, see [FaceSearchSettings](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_FaceSearchSettings) .
        """
        return pulumi.get(self, "face_search_settings")

    @face_search_settings.setter
    def face_search_settings(self, value: Optional[pulumi.Input['StreamProcessorFaceSearchSettingsArgs']]):
        pulumi.set(self, "face_search_settings", value)

    @property
    @pulumi.getter(name="kinesisDataStream")
    def kinesis_data_stream(self) -> Optional[pulumi.Input['StreamProcessorKinesisDataStreamArgs']]:
        """
        Amazon Rekognition's Video Stream Processor takes a Kinesis video stream as input. This is the Amazon Kinesis Data Streams instance to which the Amazon Rekognition stream processor streams the analysis results. This must be created within the constraints specified at [KinesisDataStream](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisDataStream) .
        """
        return pulumi.get(self, "kinesis_data_stream")

    @kinesis_data_stream.setter
    def kinesis_data_stream(self, value: Optional[pulumi.Input['StreamProcessorKinesisDataStreamArgs']]):
        pulumi.set(self, "kinesis_data_stream", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The KMS key that is used by Rekognition to encrypt any intermediate customer metadata and store in the customer's S3 bucket.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the stream processor. It's an identifier you assign to the stream processor. You can use it to manage the stream processor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationChannel")
    def notification_channel(self) -> Optional[pulumi.Input['StreamProcessorNotificationChannelArgs']]:
        """
        The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation. Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. Amazon Rekognition also publishes an end-of-session notification with a summary when the stream processing session is complete. For more information, see [StreamProcessorNotificationChannel](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorNotificationChannel) .
        """
        return pulumi.get(self, "notification_channel")

    @notification_channel.setter
    def notification_channel(self, value: Optional[pulumi.Input['StreamProcessorNotificationChannelArgs']]):
        pulumi.set(self, "notification_channel", value)

    @property
    @pulumi.getter(name="polygonRegionsOfInterest")
    def polygon_regions_of_interest(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['StreamProcessorPointArgs']]]]]]:
        """
        The PolygonRegionsOfInterest specifies a set of polygon areas of interest in the video frames to analyze, as part of connected home feature. Each polygon is in turn, an ordered list of Point
        """
        return pulumi.get(self, "polygon_regions_of_interest")

    @polygon_regions_of_interest.setter
    def polygon_regions_of_interest(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input['StreamProcessorPointArgs']]]]]]):
        pulumi.set(self, "polygon_regions_of_interest", value)

    @property
    @pulumi.getter(name="s3Destination")
    def s3_destination(self) -> Optional[pulumi.Input['StreamProcessorS3DestinationArgs']]:
        """
        The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation. For more information, see the S3Destination section of [StreamProcessorOutput](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorOutput) .
        """
        return pulumi.get(self, "s3_destination")

    @s3_destination.setter
    def s3_destination(self, value: Optional[pulumi.Input['StreamProcessorS3DestinationArgs']]):
        pulumi.set(self, "s3_destination", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:rekognition:StreamProcessor")
class StreamProcessor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bounding_box_regions_of_interest: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StreamProcessorBoundingBoxArgs', 'StreamProcessorBoundingBoxArgsDict']]]]] = None,
                 connected_home_settings: Optional[pulumi.Input[Union['StreamProcessorConnectedHomeSettingsArgs', 'StreamProcessorConnectedHomeSettingsArgsDict']]] = None,
                 data_sharing_preference: Optional[pulumi.Input[Union['StreamProcessorDataSharingPreferenceArgs', 'StreamProcessorDataSharingPreferenceArgsDict']]] = None,
                 face_search_settings: Optional[pulumi.Input[Union['StreamProcessorFaceSearchSettingsArgs', 'StreamProcessorFaceSearchSettingsArgsDict']]] = None,
                 kinesis_data_stream: Optional[pulumi.Input[Union['StreamProcessorKinesisDataStreamArgs', 'StreamProcessorKinesisDataStreamArgsDict']]] = None,
                 kinesis_video_stream: Optional[pulumi.Input[Union['StreamProcessorKinesisVideoStreamArgs', 'StreamProcessorKinesisVideoStreamArgsDict']]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_channel: Optional[pulumi.Input[Union['StreamProcessorNotificationChannelArgs', 'StreamProcessorNotificationChannelArgsDict']]] = None,
                 polygon_regions_of_interest: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[Union['StreamProcessorPointArgs', 'StreamProcessorPointArgsDict']]]]]]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 s3_destination: Optional[pulumi.Input[Union['StreamProcessorS3DestinationArgs', 'StreamProcessorS3DestinationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        The AWS::Rekognition::StreamProcessor type is used to create an Amazon Rekognition StreamProcessor that you can use to analyze streaming videos.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StreamProcessorBoundingBoxArgs', 'StreamProcessorBoundingBoxArgsDict']]]] bounding_box_regions_of_interest: The BoundingBoxRegionsOfInterest specifies an array of bounding boxes of interest in the video frames to analyze, as part of connected home feature. If an object is partially in a region of interest, Rekognition will tag it as detected if the overlap of the object with the region-of-interest is greater than 20%.
        :param pulumi.Input[Union['StreamProcessorConnectedHomeSettingsArgs', 'StreamProcessorConnectedHomeSettingsArgsDict']] connected_home_settings: Connected home settings to use on a streaming video. You can use a stream processor for connected home features and select what you want the stream processor to detect, such as people or pets. When the stream processor has started, one notification is sent for each object class specified. For more information, see the ConnectedHome section of [StreamProcessorSettings](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorSettings) .
        :param pulumi.Input[Union['StreamProcessorDataSharingPreferenceArgs', 'StreamProcessorDataSharingPreferenceArgsDict']] data_sharing_preference: Allows you to opt in or opt out to share data with Rekognition to improve model performance. You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. For more information, see [StreamProcessorDataSharingPreference](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorDataSharingPreference) .
        :param pulumi.Input[Union['StreamProcessorFaceSearchSettingsArgs', 'StreamProcessorFaceSearchSettingsArgsDict']] face_search_settings: The input parameters used to recognize faces in a streaming video analyzed by an Amazon Rekognition stream processor. For more information regarding the contents of the parameters, see [FaceSearchSettings](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_FaceSearchSettings) .
        :param pulumi.Input[Union['StreamProcessorKinesisDataStreamArgs', 'StreamProcessorKinesisDataStreamArgsDict']] kinesis_data_stream: Amazon Rekognition's Video Stream Processor takes a Kinesis video stream as input. This is the Amazon Kinesis Data Streams instance to which the Amazon Rekognition stream processor streams the analysis results. This must be created within the constraints specified at [KinesisDataStream](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisDataStream) .
        :param pulumi.Input[Union['StreamProcessorKinesisVideoStreamArgs', 'StreamProcessorKinesisVideoStreamArgsDict']] kinesis_video_stream: The Kinesis video stream that provides the source of the streaming video for an Amazon Rekognition Video stream processor. For more information, see [KinesisVideoStream](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisVideoStream) .
        :param pulumi.Input[builtins.str] kms_key_id: The KMS key that is used by Rekognition to encrypt any intermediate customer metadata and store in the customer's S3 bucket.
        :param pulumi.Input[builtins.str] name: Name of the stream processor. It's an identifier you assign to the stream processor. You can use it to manage the stream processor.
        :param pulumi.Input[Union['StreamProcessorNotificationChannelArgs', 'StreamProcessorNotificationChannelArgsDict']] notification_channel: The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation. Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. Amazon Rekognition also publishes an end-of-session notification with a summary when the stream processing session is complete. For more information, see [StreamProcessorNotificationChannel](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorNotificationChannel) .
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[Union['StreamProcessorPointArgs', 'StreamProcessorPointArgsDict']]]]]] polygon_regions_of_interest: The PolygonRegionsOfInterest specifies a set of polygon areas of interest in the video frames to analyze, as part of connected home feature. Each polygon is in turn, an ordered list of Point
        :param pulumi.Input[builtins.str] role_arn: ARN of the IAM role that allows access to the stream processor, and provides Rekognition read permissions for KVS stream and write permissions to S3 bucket and SNS topic.
        :param pulumi.Input[Union['StreamProcessorS3DestinationArgs', 'StreamProcessorS3DestinationArgsDict']] s3_destination: The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation. For more information, see the S3Destination section of [StreamProcessorOutput](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorOutput) .
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamProcessorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::Rekognition::StreamProcessor type is used to create an Amazon Rekognition StreamProcessor that you can use to analyze streaming videos.

        :param str resource_name: The name of the resource.
        :param StreamProcessorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamProcessorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bounding_box_regions_of_interest: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StreamProcessorBoundingBoxArgs', 'StreamProcessorBoundingBoxArgsDict']]]]] = None,
                 connected_home_settings: Optional[pulumi.Input[Union['StreamProcessorConnectedHomeSettingsArgs', 'StreamProcessorConnectedHomeSettingsArgsDict']]] = None,
                 data_sharing_preference: Optional[pulumi.Input[Union['StreamProcessorDataSharingPreferenceArgs', 'StreamProcessorDataSharingPreferenceArgsDict']]] = None,
                 face_search_settings: Optional[pulumi.Input[Union['StreamProcessorFaceSearchSettingsArgs', 'StreamProcessorFaceSearchSettingsArgsDict']]] = None,
                 kinesis_data_stream: Optional[pulumi.Input[Union['StreamProcessorKinesisDataStreamArgs', 'StreamProcessorKinesisDataStreamArgsDict']]] = None,
                 kinesis_video_stream: Optional[pulumi.Input[Union['StreamProcessorKinesisVideoStreamArgs', 'StreamProcessorKinesisVideoStreamArgsDict']]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_channel: Optional[pulumi.Input[Union['StreamProcessorNotificationChannelArgs', 'StreamProcessorNotificationChannelArgsDict']]] = None,
                 polygon_regions_of_interest: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[Union['StreamProcessorPointArgs', 'StreamProcessorPointArgsDict']]]]]]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 s3_destination: Optional[pulumi.Input[Union['StreamProcessorS3DestinationArgs', 'StreamProcessorS3DestinationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamProcessorArgs.__new__(StreamProcessorArgs)

            __props__.__dict__["bounding_box_regions_of_interest"] = bounding_box_regions_of_interest
            __props__.__dict__["connected_home_settings"] = connected_home_settings
            __props__.__dict__["data_sharing_preference"] = data_sharing_preference
            __props__.__dict__["face_search_settings"] = face_search_settings
            __props__.__dict__["kinesis_data_stream"] = kinesis_data_stream
            if kinesis_video_stream is None and not opts.urn:
                raise TypeError("Missing required property 'kinesis_video_stream'")
            __props__.__dict__["kinesis_video_stream"] = kinesis_video_stream
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_channel"] = notification_channel
            __props__.__dict__["polygon_regions_of_interest"] = polygon_regions_of_interest
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["s3_destination"] = s3_destination
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_message"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["boundingBoxRegionsOfInterest[*]", "connectedHomeSettings", "dataSharingPreference", "faceSearchSettings", "kinesisDataStream", "kinesisVideoStream", "kmsKeyId", "name", "notificationChannel", "polygonRegionsOfInterest[*]", "roleArn", "s3Destination"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(StreamProcessor, __self__).__init__(
            'aws-native:rekognition:StreamProcessor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'StreamProcessor':
        """
        Get an existing StreamProcessor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = StreamProcessorArgs.__new__(StreamProcessorArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["bounding_box_regions_of_interest"] = None
        __props__.__dict__["connected_home_settings"] = None
        __props__.__dict__["data_sharing_preference"] = None
        __props__.__dict__["face_search_settings"] = None
        __props__.__dict__["kinesis_data_stream"] = None
        __props__.__dict__["kinesis_video_stream"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["notification_channel"] = None
        __props__.__dict__["polygon_regions_of_interest"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["s3_destination"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["status_message"] = None
        __props__.__dict__["tags"] = None
        return StreamProcessor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Amazon Resource Name for the newly created stream processor.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="boundingBoxRegionsOfInterest")
    def bounding_box_regions_of_interest(self) -> pulumi.Output[Optional[Sequence['outputs.StreamProcessorBoundingBox']]]:
        """
        The BoundingBoxRegionsOfInterest specifies an array of bounding boxes of interest in the video frames to analyze, as part of connected home feature. If an object is partially in a region of interest, Rekognition will tag it as detected if the overlap of the object with the region-of-interest is greater than 20%.
        """
        return pulumi.get(self, "bounding_box_regions_of_interest")

    @property
    @pulumi.getter(name="connectedHomeSettings")
    def connected_home_settings(self) -> pulumi.Output[Optional['outputs.StreamProcessorConnectedHomeSettings']]:
        """
        Connected home settings to use on a streaming video. You can use a stream processor for connected home features and select what you want the stream processor to detect, such as people or pets. When the stream processor has started, one notification is sent for each object class specified. For more information, see the ConnectedHome section of [StreamProcessorSettings](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorSettings) .
        """
        return pulumi.get(self, "connected_home_settings")

    @property
    @pulumi.getter(name="dataSharingPreference")
    def data_sharing_preference(self) -> pulumi.Output[Optional['outputs.StreamProcessorDataSharingPreference']]:
        """
        Allows you to opt in or opt out to share data with Rekognition to improve model performance. You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. For more information, see [StreamProcessorDataSharingPreference](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorDataSharingPreference) .
        """
        return pulumi.get(self, "data_sharing_preference")

    @property
    @pulumi.getter(name="faceSearchSettings")
    def face_search_settings(self) -> pulumi.Output[Optional['outputs.StreamProcessorFaceSearchSettings']]:
        """
        The input parameters used to recognize faces in a streaming video analyzed by an Amazon Rekognition stream processor. For more information regarding the contents of the parameters, see [FaceSearchSettings](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_FaceSearchSettings) .
        """
        return pulumi.get(self, "face_search_settings")

    @property
    @pulumi.getter(name="kinesisDataStream")
    def kinesis_data_stream(self) -> pulumi.Output[Optional['outputs.StreamProcessorKinesisDataStream']]:
        """
        Amazon Rekognition's Video Stream Processor takes a Kinesis video stream as input. This is the Amazon Kinesis Data Streams instance to which the Amazon Rekognition stream processor streams the analysis results. This must be created within the constraints specified at [KinesisDataStream](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisDataStream) .
        """
        return pulumi.get(self, "kinesis_data_stream")

    @property
    @pulumi.getter(name="kinesisVideoStream")
    def kinesis_video_stream(self) -> pulumi.Output['outputs.StreamProcessorKinesisVideoStream']:
        """
        The Kinesis video stream that provides the source of the streaming video for an Amazon Rekognition Video stream processor. For more information, see [KinesisVideoStream](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisVideoStream) .
        """
        return pulumi.get(self, "kinesis_video_stream")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The KMS key that is used by Rekognition to encrypt any intermediate customer metadata and store in the customer's S3 bucket.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of the stream processor. It's an identifier you assign to the stream processor. You can use it to manage the stream processor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationChannel")
    def notification_channel(self) -> pulumi.Output[Optional['outputs.StreamProcessorNotificationChannel']]:
        """
        The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation. Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. Amazon Rekognition also publishes an end-of-session notification with a summary when the stream processing session is complete. For more information, see [StreamProcessorNotificationChannel](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorNotificationChannel) .
        """
        return pulumi.get(self, "notification_channel")

    @property
    @pulumi.getter(name="polygonRegionsOfInterest")
    def polygon_regions_of_interest(self) -> pulumi.Output[Optional[Sequence[Sequence['outputs.StreamProcessorPoint']]]]:
        """
        The PolygonRegionsOfInterest specifies a set of polygon areas of interest in the video frames to analyze, as part of connected home feature. Each polygon is in turn, an ordered list of Point
        """
        return pulumi.get(self, "polygon_regions_of_interest")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the IAM role that allows access to the stream processor, and provides Rekognition read permissions for KVS stream and write permissions to S3 bucket and SNS topic.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="s3Destination")
    def s3_destination(self) -> pulumi.Output[Optional['outputs.StreamProcessorS3Destination']]:
        """
        The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation. For more information, see the S3Destination section of [StreamProcessorOutput](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorOutput) .
        """
        return pulumi.get(self, "s3_destination")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Current status of the stream processor.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> pulumi.Output[builtins.str]:
        """
        Detailed status message about the stream processor.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

