# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'StreamProcessorBoundingBoxArgs',
    'StreamProcessorBoundingBoxArgsDict',
    'StreamProcessorConnectedHomeSettingsArgs',
    'StreamProcessorConnectedHomeSettingsArgsDict',
    'StreamProcessorDataSharingPreferenceArgs',
    'StreamProcessorDataSharingPreferenceArgsDict',
    'StreamProcessorFaceSearchSettingsArgs',
    'StreamProcessorFaceSearchSettingsArgsDict',
    'StreamProcessorKinesisDataStreamArgs',
    'StreamProcessorKinesisDataStreamArgsDict',
    'StreamProcessorKinesisVideoStreamArgs',
    'StreamProcessorKinesisVideoStreamArgsDict',
    'StreamProcessorNotificationChannelArgs',
    'StreamProcessorNotificationChannelArgsDict',
    'StreamProcessorPointArgs',
    'StreamProcessorPointArgsDict',
    'StreamProcessorS3DestinationArgs',
    'StreamProcessorS3DestinationArgsDict',
]

MYPY = False

if not MYPY:
    class StreamProcessorBoundingBoxArgsDict(TypedDict):
        """
        A bounding box denoting a region of interest in the frame to be analyzed.
        """
        height: pulumi.Input[builtins.float]
        """
        Height of the bounding box as a ratio of the overall image height.
        """
        left: pulumi.Input[builtins.float]
        """
        Left coordinate of the bounding box as a ratio of overall image width.
        """
        top: pulumi.Input[builtins.float]
        """
        Top coordinate of the bounding box as a ratio of overall image height.
        """
        width: pulumi.Input[builtins.float]
        """
        Width of the bounding box as a ratio of the overall image width.
        """
elif False:
    StreamProcessorBoundingBoxArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamProcessorBoundingBoxArgs:
    def __init__(__self__, *,
                 height: pulumi.Input[builtins.float],
                 left: pulumi.Input[builtins.float],
                 top: pulumi.Input[builtins.float],
                 width: pulumi.Input[builtins.float]):
        """
        A bounding box denoting a region of interest in the frame to be analyzed.
        :param pulumi.Input[builtins.float] height: Height of the bounding box as a ratio of the overall image height.
        :param pulumi.Input[builtins.float] left: Left coordinate of the bounding box as a ratio of overall image width.
        :param pulumi.Input[builtins.float] top: Top coordinate of the bounding box as a ratio of overall image height.
        :param pulumi.Input[builtins.float] width: Width of the bounding box as a ratio of the overall image width.
        """
        pulumi.set(__self__, "height", height)
        pulumi.set(__self__, "left", left)
        pulumi.set(__self__, "top", top)
        pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> pulumi.Input[builtins.float]:
        """
        Height of the bounding box as a ratio of the overall image height.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def left(self) -> pulumi.Input[builtins.float]:
        """
        Left coordinate of the bounding box as a ratio of overall image width.
        """
        return pulumi.get(self, "left")

    @left.setter
    def left(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "left", value)

    @property
    @pulumi.getter
    def top(self) -> pulumi.Input[builtins.float]:
        """
        Top coordinate of the bounding box as a ratio of overall image height.
        """
        return pulumi.get(self, "top")

    @top.setter
    def top(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "top", value)

    @property
    @pulumi.getter
    def width(self) -> pulumi.Input[builtins.float]:
        """
        Width of the bounding box as a ratio of the overall image width.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "width", value)


if not MYPY:
    class StreamProcessorConnectedHomeSettingsArgsDict(TypedDict):
        """
        Connected home settings to use on a streaming video. Note that either ConnectedHomeSettings or FaceSearchSettings should be set. Not both
        """
        labels: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels you can include in this list are: "PERSON", "PET", "PACKAGE", and "ALL".
        """
        min_confidence: NotRequired[pulumi.Input[builtins.float]]
        """
        Minimum object class match confidence score that must be met to return a result for a recognized object.
        """
elif False:
    StreamProcessorConnectedHomeSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamProcessorConnectedHomeSettingsArgs:
    def __init__(__self__, *,
                 labels: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 min_confidence: Optional[pulumi.Input[builtins.float]] = None):
        """
        Connected home settings to use on a streaming video. Note that either ConnectedHomeSettings or FaceSearchSettings should be set. Not both
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] labels: Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels you can include in this list are: "PERSON", "PET", "PACKAGE", and "ALL".
        :param pulumi.Input[builtins.float] min_confidence: Minimum object class match confidence score that must be met to return a result for a recognized object.
        """
        pulumi.set(__self__, "labels", labels)
        if min_confidence is not None:
            pulumi.set(__self__, "min_confidence", min_confidence)

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels you can include in this list are: "PERSON", "PET", "PACKAGE", and "ALL".
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="minConfidence")
    def min_confidence(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Minimum object class match confidence score that must be met to return a result for a recognized object.
        """
        return pulumi.get(self, "min_confidence")

    @min_confidence.setter
    def min_confidence(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "min_confidence", value)


if not MYPY:
    class StreamProcessorDataSharingPreferenceArgsDict(TypedDict):
        """
        Indicates whether Rekognition is allowed to store the video stream data for model-training.
        """
        opt_in: pulumi.Input[builtins.bool]
        """
        Flag to enable data-sharing
        """
elif False:
    StreamProcessorDataSharingPreferenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamProcessorDataSharingPreferenceArgs:
    def __init__(__self__, *,
                 opt_in: pulumi.Input[builtins.bool]):
        """
        Indicates whether Rekognition is allowed to store the video stream data for model-training.
        :param pulumi.Input[builtins.bool] opt_in: Flag to enable data-sharing
        """
        pulumi.set(__self__, "opt_in", opt_in)

    @property
    @pulumi.getter(name="optIn")
    def opt_in(self) -> pulumi.Input[builtins.bool]:
        """
        Flag to enable data-sharing
        """
        return pulumi.get(self, "opt_in")

    @opt_in.setter
    def opt_in(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "opt_in", value)


if not MYPY:
    class StreamProcessorFaceSearchSettingsArgsDict(TypedDict):
        """
        Face search settings to use on a streaming video. Note that either FaceSearchSettings or ConnectedHomeSettings should be set. Not both
        """
        collection_id: pulumi.Input[builtins.str]
        """
        The ID of a collection that contains faces that you want to search for.
        """
        face_match_threshold: NotRequired[pulumi.Input[builtins.float]]
        """
        Minimum face match confidence score percentage that must be met to return a result for a recognized face. The default is 80. 0 is the lowest confidence. 100 is the highest confidence. Values between 0 and 100 are accepted.
        """
elif False:
    StreamProcessorFaceSearchSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamProcessorFaceSearchSettingsArgs:
    def __init__(__self__, *,
                 collection_id: pulumi.Input[builtins.str],
                 face_match_threshold: Optional[pulumi.Input[builtins.float]] = None):
        """
        Face search settings to use on a streaming video. Note that either FaceSearchSettings or ConnectedHomeSettings should be set. Not both
        :param pulumi.Input[builtins.str] collection_id: The ID of a collection that contains faces that you want to search for.
        :param pulumi.Input[builtins.float] face_match_threshold: Minimum face match confidence score percentage that must be met to return a result for a recognized face. The default is 80. 0 is the lowest confidence. 100 is the highest confidence. Values between 0 and 100 are accepted.
        """
        pulumi.set(__self__, "collection_id", collection_id)
        if face_match_threshold is not None:
            pulumi.set(__self__, "face_match_threshold", face_match_threshold)

    @property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of a collection that contains faces that you want to search for.
        """
        return pulumi.get(self, "collection_id")

    @collection_id.setter
    def collection_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "collection_id", value)

    @property
    @pulumi.getter(name="faceMatchThreshold")
    def face_match_threshold(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Minimum face match confidence score percentage that must be met to return a result for a recognized face. The default is 80. 0 is the lowest confidence. 100 is the highest confidence. Values between 0 and 100 are accepted.
        """
        return pulumi.get(self, "face_match_threshold")

    @face_match_threshold.setter
    def face_match_threshold(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "face_match_threshold", value)


if not MYPY:
    class StreamProcessorKinesisDataStreamArgsDict(TypedDict):
        """
        The Amazon Kinesis Data Stream stream to which the Amazon Rekognition stream processor streams the analysis results, as part of face search feature.
        """
        arn: pulumi.Input[builtins.str]
        """
        ARN of the Kinesis Data Stream stream.
        """
elif False:
    StreamProcessorKinesisDataStreamArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamProcessorKinesisDataStreamArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[builtins.str]):
        """
        The Amazon Kinesis Data Stream stream to which the Amazon Rekognition stream processor streams the analysis results, as part of face search feature.
        :param pulumi.Input[builtins.str] arn: ARN of the Kinesis Data Stream stream.
        """
        pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the Kinesis Data Stream stream.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "arn", value)


if not MYPY:
    class StreamProcessorKinesisVideoStreamArgsDict(TypedDict):
        """
        The Kinesis Video Stream that streams the source video.
        """
        arn: pulumi.Input[builtins.str]
        """
        ARN of the Kinesis Video Stream that streams the source video.
        """
elif False:
    StreamProcessorKinesisVideoStreamArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamProcessorKinesisVideoStreamArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[builtins.str]):
        """
        The Kinesis Video Stream that streams the source video.
        :param pulumi.Input[builtins.str] arn: ARN of the Kinesis Video Stream that streams the source video.
        """
        pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the Kinesis Video Stream that streams the source video.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "arn", value)


if not MYPY:
    class StreamProcessorNotificationChannelArgsDict(TypedDict):
        """
        The ARN of the SNS notification channel where events of interests are published, as part of connected home feature.
        """
        arn: pulumi.Input[builtins.str]
        """
        ARN of the SNS topic.
        """
elif False:
    StreamProcessorNotificationChannelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamProcessorNotificationChannelArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[builtins.str]):
        """
        The ARN of the SNS notification channel where events of interests are published, as part of connected home feature.
        :param pulumi.Input[builtins.str] arn: ARN of the SNS topic.
        """
        pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the SNS topic.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "arn", value)


if not MYPY:
    class StreamProcessorPointArgsDict(TypedDict):
        """
        An (X, Y) cartesian coordinate denoting a point on the frame
        """
        x: pulumi.Input[builtins.float]
        """
        The X coordinate of the point.
        """
        y: pulumi.Input[builtins.float]
        """
        The Y coordinate of the point.
        """
elif False:
    StreamProcessorPointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamProcessorPointArgs:
    def __init__(__self__, *,
                 x: pulumi.Input[builtins.float],
                 y: pulumi.Input[builtins.float]):
        """
        An (X, Y) cartesian coordinate denoting a point on the frame
        :param pulumi.Input[builtins.float] x: The X coordinate of the point.
        :param pulumi.Input[builtins.float] y: The Y coordinate of the point.
        """
        pulumi.set(__self__, "x", x)
        pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def x(self) -> pulumi.Input[builtins.float]:
        """
        The X coordinate of the point.
        """
        return pulumi.get(self, "x")

    @x.setter
    def x(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "x", value)

    @property
    @pulumi.getter
    def y(self) -> pulumi.Input[builtins.float]:
        """
        The Y coordinate of the point.
        """
        return pulumi.get(self, "y")

    @y.setter
    def y(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "y", value)


if not MYPY:
    class StreamProcessorS3DestinationArgsDict(TypedDict):
        """
        The S3 location in customer's account where inference output & artifacts are stored, as part of connected home feature.
        """
        bucket_name: pulumi.Input[builtins.str]
        """
        Name of the S3 bucket.
        """
        object_key_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        The object key prefix path where the results will be stored. Default is no prefix path
        """
elif False:
    StreamProcessorS3DestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StreamProcessorS3DestinationArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[builtins.str],
                 object_key_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        The S3 location in customer's account where inference output & artifacts are stored, as part of connected home feature.
        :param pulumi.Input[builtins.str] bucket_name: Name of the S3 bucket.
        :param pulumi.Input[builtins.str] object_key_prefix: The object key prefix path where the results will be stored. Default is no prefix path
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if object_key_prefix is not None:
            pulumi.set(__self__, "object_key_prefix", object_key_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the S3 bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="objectKeyPrefix")
    def object_key_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The object key prefix path where the results will be stored. Default is no prefix path
        """
        return pulumi.get(self, "object_key_prefix")

    @object_key_prefix.setter
    def object_key_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_key_prefix", value)


