# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetServiceResult',
    'AwaitableGetServiceResult',
    'get_service',
    'get_service_output',
]

@pulumi.output_type
class GetServiceResult:
    def __init__(__self__, arn=None, service_identifier=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if service_identifier and not isinstance(service_identifier, str):
            raise TypeError("Expected argument 'service_identifier' to be a str")
        pulumi.set(__self__, "service_identifier", service_identifier)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the service.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="serviceIdentifier")
    def service_identifier(self) -> Optional[builtins.str]:
        """
        The unique identifier of the service.
        """
        return pulumi.get(self, "service_identifier")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Metadata that you can assign to help organize the frameworks that you create. Each tag is a key-value pair.
        """
        return pulumi.get(self, "tags")


class AwaitableGetServiceResult(GetServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceResult(
            arn=self.arn,
            service_identifier=self.service_identifier,
            tags=self.tags)


def get_service(application_identifier: Optional[builtins.str] = None,
                environment_identifier: Optional[builtins.str] = None,
                service_identifier: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceResult:
    """
    Definition of AWS::RefactorSpaces::Service Resource Type


    :param builtins.str application_identifier: The unique identifier of the application.
    :param builtins.str environment_identifier: The unique identifier of the environment.
    :param builtins.str service_identifier: The unique identifier of the service.
    """
    __args__ = dict()
    __args__['applicationIdentifier'] = application_identifier
    __args__['environmentIdentifier'] = environment_identifier
    __args__['serviceIdentifier'] = service_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:refactorspaces:getService', __args__, opts=opts, typ=GetServiceResult).value

    return AwaitableGetServiceResult(
        arn=pulumi.get(__ret__, 'arn'),
        service_identifier=pulumi.get(__ret__, 'service_identifier'),
        tags=pulumi.get(__ret__, 'tags'))
def get_service_output(application_identifier: Optional[pulumi.Input[builtins.str]] = None,
                       environment_identifier: Optional[pulumi.Input[builtins.str]] = None,
                       service_identifier: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceResult]:
    """
    Definition of AWS::RefactorSpaces::Service Resource Type


    :param builtins.str application_identifier: The unique identifier of the application.
    :param builtins.str environment_identifier: The unique identifier of the environment.
    :param builtins.str service_identifier: The unique identifier of the service.
    """
    __args__ = dict()
    __args__['applicationIdentifier'] = application_identifier
    __args__['environmentIdentifier'] = environment_identifier
    __args__['serviceIdentifier'] = service_identifier
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:refactorspaces:getService', __args__, opts=opts, typ=GetServiceResult)
    return __ret__.apply(lambda __response__: GetServiceResult(
        arn=pulumi.get(__response__, 'arn'),
        service_identifier=pulumi.get(__response__, 'service_identifier'),
        tags=pulumi.get(__response__, 'tags')))
