# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'NamespaceSnapshotCopyConfigurationArgs',
    'NamespaceSnapshotCopyConfigurationArgsDict',
    'WorkgroupConfigParameterArgs',
    'WorkgroupConfigParameterArgsDict',
    'WorkgroupEndpointArgs',
    'WorkgroupEndpointArgsDict',
    'WorkgroupNetworkInterfaceArgs',
    'WorkgroupNetworkInterfaceArgsDict',
    'WorkgroupPerformanceTargetArgs',
    'WorkgroupPerformanceTargetArgsDict',
    'WorkgroupVpcEndpointArgs',
    'WorkgroupVpcEndpointArgsDict',
    'WorkgroupArgs',
    'WorkgroupArgsDict',
]

MYPY = False

if not MYPY:
    class NamespaceSnapshotCopyConfigurationArgsDict(TypedDict):
        destination_region: pulumi.Input[builtins.str]
        """
        The destination AWS Region to copy snapshots to.
        """
        destination_kms_key_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the KMS key to use to encrypt your snapshots in the destination AWS Region .
        """
        snapshot_retention_period: NotRequired[pulumi.Input[builtins.int]]
        """
        The retention period of snapshots that are copied to the destination AWS Region .
        """
elif False:
    NamespaceSnapshotCopyConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NamespaceSnapshotCopyConfigurationArgs:
    def __init__(__self__, *,
                 destination_region: pulumi.Input[builtins.str],
                 destination_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_retention_period: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] destination_region: The destination AWS Region to copy snapshots to.
        :param pulumi.Input[builtins.str] destination_kms_key_id: The ID of the KMS key to use to encrypt your snapshots in the destination AWS Region .
        :param pulumi.Input[builtins.int] snapshot_retention_period: The retention period of snapshots that are copied to the destination AWS Region .
        """
        pulumi.set(__self__, "destination_region", destination_region)
        if destination_kms_key_id is not None:
            pulumi.set(__self__, "destination_kms_key_id", destination_kms_key_id)
        if snapshot_retention_period is not None:
            pulumi.set(__self__, "snapshot_retention_period", snapshot_retention_period)

    @property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> pulumi.Input[builtins.str]:
        """
        The destination AWS Region to copy snapshots to.
        """
        return pulumi.get(self, "destination_region")

    @destination_region.setter
    def destination_region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "destination_region", value)

    @property
    @pulumi.getter(name="destinationKmsKeyId")
    def destination_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the KMS key to use to encrypt your snapshots in the destination AWS Region .
        """
        return pulumi.get(self, "destination_kms_key_id")

    @destination_kms_key_id.setter
    def destination_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_kms_key_id", value)

    @property
    @pulumi.getter(name="snapshotRetentionPeriod")
    def snapshot_retention_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The retention period of snapshots that are copied to the destination AWS Region .
        """
        return pulumi.get(self, "snapshot_retention_period")

    @snapshot_retention_period.setter
    def snapshot_retention_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "snapshot_retention_period", value)


if not MYPY:
    class WorkgroupConfigParameterArgsDict(TypedDict):
        parameter_key: NotRequired[pulumi.Input[builtins.str]]
        """
        The key of the parameter. The options are `auto_mv` , `datestyle` , `enable_case_sensitive_identifier` , `enable_user_activity_logging` , `query_group` , `search_path` , `require_ssl` , `use_fips_ssl` , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see [Query monitoring metrics for Amazon Redshift Serverless](https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless) .
        """
        parameter_value: NotRequired[pulumi.Input[builtins.str]]
        """
        The value of the parameter to set.
        """
elif False:
    WorkgroupConfigParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkgroupConfigParameterArgs:
    def __init__(__self__, *,
                 parameter_key: Optional[pulumi.Input[builtins.str]] = None,
                 parameter_value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] parameter_key: The key of the parameter. The options are `auto_mv` , `datestyle` , `enable_case_sensitive_identifier` , `enable_user_activity_logging` , `query_group` , `search_path` , `require_ssl` , `use_fips_ssl` , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see [Query monitoring metrics for Amazon Redshift Serverless](https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless) .
        :param pulumi.Input[builtins.str] parameter_value: The value of the parameter to set.
        """
        if parameter_key is not None:
            pulumi.set(__self__, "parameter_key", parameter_key)
        if parameter_value is not None:
            pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterKey")
    def parameter_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key of the parameter. The options are `auto_mv` , `datestyle` , `enable_case_sensitive_identifier` , `enable_user_activity_logging` , `query_group` , `search_path` , `require_ssl` , `use_fips_ssl` , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see [Query monitoring metrics for Amazon Redshift Serverless](https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless) .
        """
        return pulumi.get(self, "parameter_key")

    @parameter_key.setter
    def parameter_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parameter_key", value)

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of the parameter to set.
        """
        return pulumi.get(self, "parameter_value")

    @parameter_value.setter
    def parameter_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parameter_value", value)


if not MYPY:
    class WorkgroupEndpointArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[builtins.str]]
        """
        The DNS address of the VPC endpoint.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port that Amazon Redshift Serverless listens on.
        """
        vpc_endpoints: NotRequired[pulumi.Input[Sequence[pulumi.Input['WorkgroupVpcEndpointArgsDict']]]]
        """
        An array of `VpcEndpoint` objects.
        """
elif False:
    WorkgroupEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkgroupEndpointArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 vpc_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupVpcEndpointArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] address: The DNS address of the VPC endpoint.
        :param pulumi.Input[builtins.int] port: The port that Amazon Redshift Serverless listens on.
        :param pulumi.Input[Sequence[pulumi.Input['WorkgroupVpcEndpointArgs']]] vpc_endpoints: An array of `VpcEndpoint` objects.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if vpc_endpoints is not None:
            pulumi.set(__self__, "vpc_endpoints", vpc_endpoints)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DNS address of the VPC endpoint.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port that Amazon Redshift Serverless listens on.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="vpcEndpoints")
    def vpc_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupVpcEndpointArgs']]]]:
        """
        An array of `VpcEndpoint` objects.
        """
        return pulumi.get(self, "vpc_endpoints")

    @vpc_endpoints.setter
    def vpc_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupVpcEndpointArgs']]]]):
        pulumi.set(self, "vpc_endpoints", value)


if not MYPY:
    class WorkgroupNetworkInterfaceArgsDict(TypedDict):
        availability_zone: NotRequired[pulumi.Input[builtins.str]]
        """
        The availability Zone.
        """
        network_interface_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The unique identifier of the network interface.
        """
        private_ip_address: NotRequired[pulumi.Input[builtins.str]]
        """
        The IPv4 address of the network interface within the subnet.
        """
        subnet_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The unique identifier of the subnet.
        """
elif False:
    WorkgroupNetworkInterfaceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkgroupNetworkInterfaceArgs:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] availability_zone: The availability Zone.
        :param pulumi.Input[builtins.str] network_interface_id: The unique identifier of the network interface.
        :param pulumi.Input[builtins.str] private_ip_address: The IPv4 address of the network interface within the subnet.
        :param pulumi.Input[builtins.str] subnet_id: The unique identifier of the subnet.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability Zone.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_interface_id", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IPv4 address of the network interface within the subnet.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)


if not MYPY:
    class WorkgroupPerformanceTargetArgsDict(TypedDict):
        level: NotRequired[pulumi.Input[builtins.int]]
        """
        The target price performance level for the workgroup. Valid values include 1, 25, 50, 75, and 100. These correspond to the price performance levels LOW_COST, ECONOMICAL, BALANCED, RESOURCEFUL, and HIGH_PERFORMANCE.
        """
        status: NotRequired[pulumi.Input['WorkgroupPerformanceTargetStatus']]
        """
        Whether the price performance target is enabled for the workgroup.
        """
elif False:
    WorkgroupPerformanceTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkgroupPerformanceTargetArgs:
    def __init__(__self__, *,
                 level: Optional[pulumi.Input[builtins.int]] = None,
                 status: Optional[pulumi.Input['WorkgroupPerformanceTargetStatus']] = None):
        """
        :param pulumi.Input[builtins.int] level: The target price performance level for the workgroup. Valid values include 1, 25, 50, 75, and 100. These correspond to the price performance levels LOW_COST, ECONOMICAL, BALANCED, RESOURCEFUL, and HIGH_PERFORMANCE.
        :param pulumi.Input['WorkgroupPerformanceTargetStatus'] status: Whether the price performance target is enabled for the workgroup.
        """
        if level is not None:
            pulumi.set(__self__, "level", level)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The target price performance level for the workgroup. Valid values include 1, 25, 50, 75, and 100. These correspond to the price performance levels LOW_COST, ECONOMICAL, BALANCED, RESOURCEFUL, and HIGH_PERFORMANCE.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['WorkgroupPerformanceTargetStatus']]:
        """
        Whether the price performance target is enabled for the workgroup.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['WorkgroupPerformanceTargetStatus']]):
        pulumi.set(self, "status", value)


if not MYPY:
    class WorkgroupVpcEndpointArgsDict(TypedDict):
        network_interfaces: NotRequired[pulumi.Input[Sequence[pulumi.Input['WorkgroupNetworkInterfaceArgsDict']]]]
        """
        One or more network interfaces of the endpoint. Also known as an interface endpoint.
        """
        vpc_endpoint_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The connection endpoint ID for connecting to Amazon Redshift Serverless.
        """
        vpc_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The VPC identifier that the endpoint is associated with.
        """
elif False:
    WorkgroupVpcEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkgroupVpcEndpointArgs:
    def __init__(__self__, *,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupNetworkInterfaceArgs']]]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['WorkgroupNetworkInterfaceArgs']]] network_interfaces: One or more network interfaces of the endpoint. Also known as an interface endpoint.
        :param pulumi.Input[builtins.str] vpc_endpoint_id: The connection endpoint ID for connecting to Amazon Redshift Serverless.
        :param pulumi.Input[builtins.str] vpc_id: The VPC identifier that the endpoint is associated with.
        """
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if vpc_endpoint_id is not None:
            pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupNetworkInterfaceArgs']]]]:
        """
        One or more network interfaces of the endpoint. Also known as an interface endpoint.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The connection endpoint ID for connecting to Amazon Redshift Serverless.
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @vpc_endpoint_id.setter
    def vpc_endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_endpoint_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The VPC identifier that the endpoint is associated with.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_id", value)


if not MYPY:
    class WorkgroupArgsDict(TypedDict):
        base_capacity: NotRequired[pulumi.Input[builtins.int]]
        """
        The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
        """
        config_parameters: NotRequired[pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgsDict']]]]
        """
        An array of parameters to set for advanced control over a database. The options are `auto_mv` , `datestyle` , `enable_case_sensitive_identifier` , `enable_user_activity_logging` , `query_group` , `search_path` , `require_ssl` , `use_fips_ssl` , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see [Query monitoring metrics for Amazon Redshift Serverless](https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless) .
        """
        creation_date: NotRequired[pulumi.Input[builtins.str]]
        """
        The creation date of the workgroup.
        """
        endpoint: NotRequired[pulumi.Input['WorkgroupEndpointArgsDict']]
        """
        The endpoint that is created from the workgroup.
        """
        enhanced_vpc_routing: NotRequired[pulumi.Input[builtins.bool]]
        """
        The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
        """
        max_capacity: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity is specified in RPUs.
        """
        namespace_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The namespace the workgroup is associated with.
        """
        price_performance_target: NotRequired[pulumi.Input['WorkgroupPerformanceTargetArgsDict']]
        """
        An object that represents the price performance target settings for the workgroup.
        """
        publicly_accessible: NotRequired[pulumi.Input[builtins.bool]]
        """
        A value that specifies whether the workgroup can be accessible from a public network.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        An array of security group IDs to associate with the workgroup.
        """
        status: NotRequired[pulumi.Input['WorkgroupStatus']]
        """
        The status of the workgroup.
        """
        subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        An array of subnet IDs the workgroup is associated with.
        """
        track_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the track for the workgroup.
        """
        workgroup_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) that links to the workgroup.
        """
        workgroup_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The unique identifier of the workgroup.
        """
        workgroup_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the workgroup.
        """
elif False:
    WorkgroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkgroupArgs:
    def __init__(__self__, *,
                 base_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 config_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]]] = None,
                 creation_date: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint: Optional[pulumi.Input['WorkgroupEndpointArgs']] = None,
                 enhanced_vpc_routing: Optional[pulumi.Input[builtins.bool]] = None,
                 max_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 namespace_name: Optional[pulumi.Input[builtins.str]] = None,
                 price_performance_target: Optional[pulumi.Input['WorkgroupPerformanceTargetArgs']] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 status: Optional[pulumi.Input['WorkgroupStatus']] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 track_name: Optional[pulumi.Input[builtins.str]] = None,
                 workgroup_arn: Optional[pulumi.Input[builtins.str]] = None,
                 workgroup_id: Optional[pulumi.Input[builtins.str]] = None,
                 workgroup_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] base_capacity: The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
        :param pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]] config_parameters: An array of parameters to set for advanced control over a database. The options are `auto_mv` , `datestyle` , `enable_case_sensitive_identifier` , `enable_user_activity_logging` , `query_group` , `search_path` , `require_ssl` , `use_fips_ssl` , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see [Query monitoring metrics for Amazon Redshift Serverless](https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless) .
        :param pulumi.Input[builtins.str] creation_date: The creation date of the workgroup.
        :param pulumi.Input['WorkgroupEndpointArgs'] endpoint: The endpoint that is created from the workgroup.
        :param pulumi.Input[builtins.bool] enhanced_vpc_routing: The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
        :param pulumi.Input[builtins.int] max_capacity: The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity is specified in RPUs.
        :param pulumi.Input[builtins.str] namespace_name: The namespace the workgroup is associated with.
        :param pulumi.Input['WorkgroupPerformanceTargetArgs'] price_performance_target: An object that represents the price performance target settings for the workgroup.
        :param pulumi.Input[builtins.bool] publicly_accessible: A value that specifies whether the workgroup can be accessible from a public network.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: An array of security group IDs to associate with the workgroup.
        :param pulumi.Input['WorkgroupStatus'] status: The status of the workgroup.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: An array of subnet IDs the workgroup is associated with.
        :param pulumi.Input[builtins.str] track_name: The name of the track for the workgroup.
        :param pulumi.Input[builtins.str] workgroup_arn: The Amazon Resource Name (ARN) that links to the workgroup.
        :param pulumi.Input[builtins.str] workgroup_id: The unique identifier of the workgroup.
        :param pulumi.Input[builtins.str] workgroup_name: The name of the workgroup.
        """
        if base_capacity is not None:
            pulumi.set(__self__, "base_capacity", base_capacity)
        if config_parameters is not None:
            pulumi.set(__self__, "config_parameters", config_parameters)
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if enhanced_vpc_routing is not None:
            pulumi.set(__self__, "enhanced_vpc_routing", enhanced_vpc_routing)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)
        if price_performance_target is not None:
            pulumi.set(__self__, "price_performance_target", price_performance_target)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if track_name is not None:
            pulumi.set(__self__, "track_name", track_name)
        if workgroup_arn is not None:
            pulumi.set(__self__, "workgroup_arn", workgroup_arn)
        if workgroup_id is not None:
            pulumi.set(__self__, "workgroup_id", workgroup_id)
        if workgroup_name is not None:
            pulumi.set(__self__, "workgroup_name", workgroup_name)

    @property
    @pulumi.getter(name="baseCapacity")
    def base_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
        """
        return pulumi.get(self, "base_capacity")

    @base_capacity.setter
    def base_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "base_capacity", value)

    @property
    @pulumi.getter(name="configParameters")
    def config_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]]]:
        """
        An array of parameters to set for advanced control over a database. The options are `auto_mv` , `datestyle` , `enable_case_sensitive_identifier` , `enable_user_activity_logging` , `query_group` , `search_path` , `require_ssl` , `use_fips_ssl` , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see [Query monitoring metrics for Amazon Redshift Serverless](https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless) .
        """
        return pulumi.get(self, "config_parameters")

    @config_parameters.setter
    def config_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]]]):
        pulumi.set(self, "config_parameters", value)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation date of the workgroup.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_date", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input['WorkgroupEndpointArgs']]:
        """
        The endpoint that is created from the workgroup.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input['WorkgroupEndpointArgs']]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="enhancedVpcRouting")
    def enhanced_vpc_routing(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
        """
        return pulumi.get(self, "enhanced_vpc_routing")

    @enhanced_vpc_routing.setter
    def enhanced_vpc_routing(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enhanced_vpc_routing", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity is specified in RPUs.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The namespace the workgroup is associated with.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace_name", value)

    @property
    @pulumi.getter(name="pricePerformanceTarget")
    def price_performance_target(self) -> Optional[pulumi.Input['WorkgroupPerformanceTargetArgs']]:
        """
        An object that represents the price performance target settings for the workgroup.
        """
        return pulumi.get(self, "price_performance_target")

    @price_performance_target.setter
    def price_performance_target(self, value: Optional[pulumi.Input['WorkgroupPerformanceTargetArgs']]):
        pulumi.set(self, "price_performance_target", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that specifies whether the workgroup can be accessible from a public network.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of security group IDs to associate with the workgroup.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['WorkgroupStatus']]:
        """
        The status of the workgroup.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['WorkgroupStatus']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of subnet IDs the workgroup is associated with.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="trackName")
    def track_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the track for the workgroup.
        """
        return pulumi.get(self, "track_name")

    @track_name.setter
    def track_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "track_name", value)

    @property
    @pulumi.getter(name="workgroupArn")
    def workgroup_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) that links to the workgroup.
        """
        return pulumi.get(self, "workgroup_arn")

    @workgroup_arn.setter
    def workgroup_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workgroup_arn", value)

    @property
    @pulumi.getter(name="workgroupId")
    def workgroup_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of the workgroup.
        """
        return pulumi.get(self, "workgroup_id")

    @workgroup_id.setter
    def workgroup_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workgroup_id", value)

    @property
    @pulumi.getter(name="workgroupName")
    def workgroup_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the workgroup.
        """
        return pulumi.get(self, "workgroup_name")

    @workgroup_name.setter
    def workgroup_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workgroup_name", value)


