# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 cluster_type: pulumi.Input[builtins.str],
                 db_name: pulumi.Input[builtins.str],
                 master_username: pulumi.Input[builtins.str],
                 node_type: pulumi.Input[builtins.str],
                 allow_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 aqua_configuration_status: Optional[pulumi.Input[builtins.str]] = None,
                 automated_snapshot_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 availability_zone_relocation: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone_relocation_status: Optional[pulumi.Input[builtins.str]] = None,
                 classic: Optional[pulumi.Input[builtins.bool]] = None,
                 cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cluster_subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_version: Optional[pulumi.Input[builtins.str]] = None,
                 defer_maintenance: Optional[pulumi.Input[builtins.bool]] = None,
                 defer_maintenance_duration: Optional[pulumi.Input[builtins.int]] = None,
                 defer_maintenance_end_time: Optional[pulumi.Input[builtins.str]] = None,
                 defer_maintenance_start_time: Optional[pulumi.Input[builtins.str]] = None,
                 destination_region: Optional[pulumi.Input[builtins.str]] = None,
                 elastic_ip: Optional[pulumi.Input[builtins.str]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint: Optional[pulumi.Input['ClusterEndpointArgs']] = None,
                 enhanced_vpc_routing: Optional[pulumi.Input[builtins.bool]] = None,
                 hsm_client_certificate_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 hsm_configuration_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 iam_roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 logging_properties: Optional[pulumi.Input['ClusterLoggingPropertiesArgs']] = None,
                 maintenance_track_name: Optional[pulumi.Input[builtins.str]] = None,
                 manage_master_password: Optional[pulumi.Input[builtins.bool]] = None,
                 manual_snapshot_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 master_password_secret_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 master_user_password: Optional[pulumi.Input[builtins.str]] = None,
                 multi_az: Optional[pulumi.Input[builtins.bool]] = None,
                 namespace_resource_policy: Optional[Any] = None,
                 number_of_nodes: Optional[pulumi.Input[builtins.int]] = None,
                 owner_account: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_action: Optional[pulumi.Input[builtins.str]] = None,
                 revision_target: Optional[pulumi.Input[builtins.str]] = None,
                 rotate_encryption_key: Optional[pulumi.Input[builtins.bool]] = None,
                 snapshot_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_copy_grant_name: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_copy_manual: Optional[pulumi.Input[builtins.bool]] = None,
                 snapshot_copy_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[builtins.str] cluster_type: The type of the cluster. When cluster type is specified as single-node, the NumberOfNodes parameter is not required and if multi-node, the NumberOfNodes parameter is required
        :param pulumi.Input[builtins.str] db_name: The name of the first database to be created when the cluster is created. To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database.
        :param pulumi.Input[builtins.str] master_username: The user name associated with the master user account for the cluster that is being created. The user name can't be PUBLIC and first character must be a letter.
        :param pulumi.Input[builtins.str] node_type: The node type to be provisioned for the cluster.Valid Values: ds2.xlarge | ds2.8xlarge | dc1.large | dc1.8xlarge | dc2.large | dc2.8xlarge | ra3.large | ra3.4xlarge | ra3.16xlarge
        :param pulumi.Input[builtins.bool] allow_version_upgrade: Major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default value is True
        :param pulumi.Input[builtins.str] aqua_configuration_status: The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored. Possible values include the following.
               
               enabled - Use AQUA if it is available for the current Region and Amazon Redshift node type.
               disabled - Don't use AQUA.
               auto - Amazon Redshift determines whether to use AQUA.
        :param pulumi.Input[builtins.int] automated_snapshot_retention_period: The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Default value is 1
        :param pulumi.Input[builtins.str] availability_zone: The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint
        :param pulumi.Input[builtins.bool] availability_zone_relocation: The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.
        :param pulumi.Input[builtins.str] availability_zone_relocation_status: The availability zone relocation status of the cluster
        :param pulumi.Input[builtins.bool] classic: A boolean value indicating whether the resize operation is using the classic resize process. If you don't provide this parameter or set the value to false , the resize type is elastic.
        :param pulumi.Input[builtins.str] cluster_identifier: A unique identifier for the cluster. You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. All alphabetical characters must be lower case, no hypens at the end, no two consecutive hyphens. Cluster name should be unique for all clusters within an AWS account
        :param pulumi.Input[builtins.str] cluster_parameter_group_name: The name of the parameter group to be associated with this cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cluster_security_groups: A list of security groups to be associated with this cluster.
        :param pulumi.Input[builtins.str] cluster_subnet_group_name: The name of a cluster subnet group to be associated with this cluster.
        :param pulumi.Input[builtins.str] cluster_version: The version of the Amazon Redshift engine software that you want to deploy on the cluster.The version selected runs on all the nodes in the cluster.
        :param pulumi.Input[builtins.bool] defer_maintenance: A boolean indicating whether to enable the deferred maintenance window.
        :param pulumi.Input[builtins.int] defer_maintenance_duration: An integer indicating the duration of the maintenance window in days. If you specify a duration, you can't specify an end time. The duration must be 45 days or less.
        :param pulumi.Input[builtins.str] defer_maintenance_end_time: A timestamp indicating end time for the deferred maintenance window. If you specify an end time, you can't specify a duration.
        :param pulumi.Input[builtins.str] defer_maintenance_start_time: A timestamp indicating the start time for the deferred maintenance window.
        :param pulumi.Input[builtins.str] destination_region: The destination AWS Region that you want to copy snapshots to. Constraints: Must be the name of a valid AWS Region. For more information, see Regions and Endpoints in the Amazon Web Services [https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region] General Reference
        :param pulumi.Input[builtins.str] elastic_ip: The Elastic IP (EIP) address for the cluster.
        :param pulumi.Input[builtins.bool] encrypted: If true, the data in the cluster is encrypted at rest.
        :param pulumi.Input['ClusterEndpointArgs'] endpoint: The connection endpoint.
        :param pulumi.Input[builtins.bool] enhanced_vpc_routing: An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see Enhanced VPC Routing in the Amazon Redshift Cluster Management Guide.
               
               If this option is true , enhanced VPC routing is enabled.
               
               Default: false
        :param pulumi.Input[builtins.str] hsm_client_certificate_identifier: Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM
        :param pulumi.Input[builtins.str] hsm_configuration_identifier: Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] iam_roles: A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. You can supply up to 50 IAM roles in a single request
        :param pulumi.Input[builtins.str] kms_key_id: The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.
        :param pulumi.Input['ClusterLoggingPropertiesArgs'] logging_properties: Specifies logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
        :param pulumi.Input[builtins.str] maintenance_track_name: The name for the maintenance track that you want to assign for the cluster. This name change is asynchronous. The new track name stays in the PendingModifiedValues for the cluster until the next maintenance window. When the maintenance track changes, the cluster is switched to the latest cluster release available for the maintenance track. At this point, the maintenance track name is applied.
        :param pulumi.Input[builtins.bool] manage_master_password: A boolean indicating if the redshift cluster's admin user credentials is managed by Redshift or not. You can't use MasterUserPassword if ManageMasterPassword is true. If ManageMasterPassword is false or not set, Amazon Redshift uses MasterUserPassword for the admin user account's password.
        :param pulumi.Input[builtins.int] manual_snapshot_retention_period: The number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is -1, the manual snapshot is retained indefinitely.
               
               The value must be either -1 or an integer between 1 and 3,653.
        :param pulumi.Input[builtins.str] master_password_secret_kms_key_id: The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin user credentials secret.
        :param pulumi.Input[builtins.str] master_user_password: The password associated with the master user account for the cluster that is being created. You can't use MasterUserPassword if ManageMasterPassword is true. Password must be between 8 and 64 characters in length, should have at least one uppercase letter.Must contain at least one lowercase letter.Must contain one number.Can be any printable ASCII character.
        :param pulumi.Input[builtins.bool] multi_az: A boolean indicating if the redshift cluster is multi-az or not. If you don't provide this parameter or set the value to false, the redshift cluster will be single-az.
        :param Any namespace_resource_policy: The namespace resource policy document that will be attached to a Redshift cluster.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Redshift::Cluster` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.int] number_of_nodes: The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node.
        :param pulumi.Input[builtins.str] owner_account: The AWS account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
        :param pulumi.Input[builtins.int] port: The port number on which the cluster accepts incoming connections. The cluster is accessible only via the JDBC and ODBC connection strings
        :param pulumi.Input[builtins.str] preferred_maintenance_window: The weekly time range (in UTC) during which automated cluster maintenance can occur.
        :param pulumi.Input[builtins.bool] publicly_accessible: If true, the cluster can be accessed from a public network.
        :param pulumi.Input[builtins.str] resource_action: The Redshift operation to be performed. Resource Action supports pause-cluster, resume-cluster, failover-primary-compute APIs
        :param pulumi.Input[builtins.str] revision_target: The identifier of the database revision. You can retrieve this value from the response to the DescribeClusterDbRevisions request.
        :param pulumi.Input[builtins.bool] rotate_encryption_key: A boolean indicating if we want to rotate Encryption Keys.
        :param pulumi.Input[builtins.str] snapshot_cluster_identifier: The name of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
        :param pulumi.Input[builtins.str] snapshot_copy_grant_name: The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
        :param pulumi.Input[builtins.bool] snapshot_copy_manual: Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.
        :param pulumi.Input[builtins.int] snapshot_copy_retention_period: The number of days to retain automated snapshots in the destination region after they are copied from the source region. 
               
                Default is 7. 
               
                Constraints: Must be at least 1 and no more than 35.
        :param pulumi.Input[builtins.str] snapshot_identifier: The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The list of tags for the cluster parameter group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_security_group_ids: A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
        """
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "db_name", db_name)
        pulumi.set(__self__, "master_username", master_username)
        pulumi.set(__self__, "node_type", node_type)
        if allow_version_upgrade is not None:
            pulumi.set(__self__, "allow_version_upgrade", allow_version_upgrade)
        if aqua_configuration_status is not None:
            pulumi.set(__self__, "aqua_configuration_status", aqua_configuration_status)
        if automated_snapshot_retention_period is not None:
            pulumi.set(__self__, "automated_snapshot_retention_period", automated_snapshot_retention_period)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_relocation is not None:
            pulumi.set(__self__, "availability_zone_relocation", availability_zone_relocation)
        if availability_zone_relocation_status is not None:
            pulumi.set(__self__, "availability_zone_relocation_status", availability_zone_relocation_status)
        if classic is not None:
            pulumi.set(__self__, "classic", classic)
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if cluster_parameter_group_name is not None:
            pulumi.set(__self__, "cluster_parameter_group_name", cluster_parameter_group_name)
        if cluster_security_groups is not None:
            pulumi.set(__self__, "cluster_security_groups", cluster_security_groups)
        if cluster_subnet_group_name is not None:
            pulumi.set(__self__, "cluster_subnet_group_name", cluster_subnet_group_name)
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if defer_maintenance is not None:
            pulumi.set(__self__, "defer_maintenance", defer_maintenance)
        if defer_maintenance_duration is not None:
            pulumi.set(__self__, "defer_maintenance_duration", defer_maintenance_duration)
        if defer_maintenance_end_time is not None:
            pulumi.set(__self__, "defer_maintenance_end_time", defer_maintenance_end_time)
        if defer_maintenance_start_time is not None:
            pulumi.set(__self__, "defer_maintenance_start_time", defer_maintenance_start_time)
        if destination_region is not None:
            pulumi.set(__self__, "destination_region", destination_region)
        if elastic_ip is not None:
            pulumi.set(__self__, "elastic_ip", elastic_ip)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if enhanced_vpc_routing is not None:
            pulumi.set(__self__, "enhanced_vpc_routing", enhanced_vpc_routing)
        if hsm_client_certificate_identifier is not None:
            pulumi.set(__self__, "hsm_client_certificate_identifier", hsm_client_certificate_identifier)
        if hsm_configuration_identifier is not None:
            pulumi.set(__self__, "hsm_configuration_identifier", hsm_configuration_identifier)
        if iam_roles is not None:
            pulumi.set(__self__, "iam_roles", iam_roles)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if logging_properties is not None:
            pulumi.set(__self__, "logging_properties", logging_properties)
        if maintenance_track_name is not None:
            pulumi.set(__self__, "maintenance_track_name", maintenance_track_name)
        if manage_master_password is not None:
            pulumi.set(__self__, "manage_master_password", manage_master_password)
        if manual_snapshot_retention_period is not None:
            pulumi.set(__self__, "manual_snapshot_retention_period", manual_snapshot_retention_period)
        if master_password_secret_kms_key_id is not None:
            pulumi.set(__self__, "master_password_secret_kms_key_id", master_password_secret_kms_key_id)
        if master_user_password is not None:
            pulumi.set(__self__, "master_user_password", master_user_password)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if namespace_resource_policy is not None:
            pulumi.set(__self__, "namespace_resource_policy", namespace_resource_policy)
        if number_of_nodes is not None:
            pulumi.set(__self__, "number_of_nodes", number_of_nodes)
        if owner_account is not None:
            pulumi.set(__self__, "owner_account", owner_account)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if resource_action is not None:
            pulumi.set(__self__, "resource_action", resource_action)
        if revision_target is not None:
            pulumi.set(__self__, "revision_target", revision_target)
        if rotate_encryption_key is not None:
            pulumi.set(__self__, "rotate_encryption_key", rotate_encryption_key)
        if snapshot_cluster_identifier is not None:
            pulumi.set(__self__, "snapshot_cluster_identifier", snapshot_cluster_identifier)
        if snapshot_copy_grant_name is not None:
            pulumi.set(__self__, "snapshot_copy_grant_name", snapshot_copy_grant_name)
        if snapshot_copy_manual is not None:
            pulumi.set(__self__, "snapshot_copy_manual", snapshot_copy_manual)
        if snapshot_copy_retention_period is not None:
            pulumi.set(__self__, "snapshot_copy_retention_period", snapshot_copy_retention_period)
        if snapshot_identifier is not None:
            pulumi.set(__self__, "snapshot_identifier", snapshot_identifier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the cluster. When cluster type is specified as single-node, the NumberOfNodes parameter is not required and if multi-node, the NumberOfNodes parameter is required
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_type", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the first database to be created when the cluster is created. To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> pulumi.Input[builtins.str]:
        """
        The user name associated with the master user account for the cluster that is being created. The user name can't be PUBLIC and first character must be a letter.
        """
        return pulumi.get(self, "master_username")

    @master_username.setter
    def master_username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "master_username", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[builtins.str]:
        """
        The node type to be provisioned for the cluster.Valid Values: ds2.xlarge | ds2.8xlarge | dc1.large | dc1.8xlarge | dc2.large | dc2.8xlarge | ra3.large | ra3.4xlarge | ra3.16xlarge
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="allowVersionUpgrade")
    def allow_version_upgrade(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default value is True
        """
        return pulumi.get(self, "allow_version_upgrade")

    @allow_version_upgrade.setter
    def allow_version_upgrade(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_version_upgrade", value)

    @property
    @pulumi.getter(name="aquaConfigurationStatus")
    def aqua_configuration_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored. Possible values include the following.

        enabled - Use AQUA if it is available for the current Region and Amazon Redshift node type.
        disabled - Don't use AQUA.
        auto - Amazon Redshift determines whether to use AQUA.
        """
        return pulumi.get(self, "aqua_configuration_status")

    @aqua_configuration_status.setter
    def aqua_configuration_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aqua_configuration_status", value)

    @property
    @pulumi.getter(name="automatedSnapshotRetentionPeriod")
    def automated_snapshot_retention_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Default value is 1
        """
        return pulumi.get(self, "automated_snapshot_retention_period")

    @automated_snapshot_retention_period.setter
    def automated_snapshot_retention_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "automated_snapshot_retention_period", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="availabilityZoneRelocation")
    def availability_zone_relocation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.
        """
        return pulumi.get(self, "availability_zone_relocation")

    @availability_zone_relocation.setter
    def availability_zone_relocation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "availability_zone_relocation", value)

    @property
    @pulumi.getter(name="availabilityZoneRelocationStatus")
    def availability_zone_relocation_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability zone relocation status of the cluster
        """
        return pulumi.get(self, "availability_zone_relocation_status")

    @availability_zone_relocation_status.setter
    def availability_zone_relocation_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone_relocation_status", value)

    @property
    @pulumi.getter
    def classic(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A boolean value indicating whether the resize operation is using the classic resize process. If you don't provide this parameter or set the value to false , the resize type is elastic.
        """
        return pulumi.get(self, "classic")

    @classic.setter
    def classic(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "classic", value)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for the cluster. You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. All alphabetical characters must be lower case, no hypens at the end, no two consecutive hyphens. Cluster name should be unique for all clusters within an AWS account
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="clusterParameterGroupName")
    def cluster_parameter_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the parameter group to be associated with this cluster.
        """
        return pulumi.get(self, "cluster_parameter_group_name")

    @cluster_parameter_group_name.setter
    def cluster_parameter_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_parameter_group_name", value)

    @property
    @pulumi.getter(name="clusterSecurityGroups")
    def cluster_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of security groups to be associated with this cluster.
        """
        return pulumi.get(self, "cluster_security_groups")

    @cluster_security_groups.setter
    def cluster_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cluster_security_groups", value)

    @property
    @pulumi.getter(name="clusterSubnetGroupName")
    def cluster_subnet_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a cluster subnet group to be associated with this cluster.
        """
        return pulumi.get(self, "cluster_subnet_group_name")

    @cluster_subnet_group_name.setter
    def cluster_subnet_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_subnet_group_name", value)

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the Amazon Redshift engine software that you want to deploy on the cluster.The version selected runs on all the nodes in the cluster.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_version", value)

    @property
    @pulumi.getter(name="deferMaintenance")
    def defer_maintenance(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A boolean indicating whether to enable the deferred maintenance window.
        """
        return pulumi.get(self, "defer_maintenance")

    @defer_maintenance.setter
    def defer_maintenance(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "defer_maintenance", value)

    @property
    @pulumi.getter(name="deferMaintenanceDuration")
    def defer_maintenance_duration(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        An integer indicating the duration of the maintenance window in days. If you specify a duration, you can't specify an end time. The duration must be 45 days or less.
        """
        return pulumi.get(self, "defer_maintenance_duration")

    @defer_maintenance_duration.setter
    def defer_maintenance_duration(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "defer_maintenance_duration", value)

    @property
    @pulumi.getter(name="deferMaintenanceEndTime")
    def defer_maintenance_end_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A timestamp indicating end time for the deferred maintenance window. If you specify an end time, you can't specify a duration.
        """
        return pulumi.get(self, "defer_maintenance_end_time")

    @defer_maintenance_end_time.setter
    def defer_maintenance_end_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "defer_maintenance_end_time", value)

    @property
    @pulumi.getter(name="deferMaintenanceStartTime")
    def defer_maintenance_start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A timestamp indicating the start time for the deferred maintenance window.
        """
        return pulumi.get(self, "defer_maintenance_start_time")

    @defer_maintenance_start_time.setter
    def defer_maintenance_start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "defer_maintenance_start_time", value)

    @property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The destination AWS Region that you want to copy snapshots to. Constraints: Must be the name of a valid AWS Region. For more information, see Regions and Endpoints in the Amazon Web Services [https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region] General Reference
        """
        return pulumi.get(self, "destination_region")

    @destination_region.setter
    def destination_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_region", value)

    @property
    @pulumi.getter(name="elasticIp")
    def elastic_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Elastic IP (EIP) address for the cluster.
        """
        return pulumi.get(self, "elastic_ip")

    @elastic_ip.setter
    def elastic_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "elastic_ip", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the data in the cluster is encrypted at rest.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input['ClusterEndpointArgs']]:
        """
        The connection endpoint.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input['ClusterEndpointArgs']]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="enhancedVpcRouting")
    def enhanced_vpc_routing(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see Enhanced VPC Routing in the Amazon Redshift Cluster Management Guide.

        If this option is true , enhanced VPC routing is enabled.

        Default: false
        """
        return pulumi.get(self, "enhanced_vpc_routing")

    @enhanced_vpc_routing.setter
    def enhanced_vpc_routing(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enhanced_vpc_routing", value)

    @property
    @pulumi.getter(name="hsmClientCertificateIdentifier")
    def hsm_client_certificate_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM
        """
        return pulumi.get(self, "hsm_client_certificate_identifier")

    @hsm_client_certificate_identifier.setter
    def hsm_client_certificate_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hsm_client_certificate_identifier", value)

    @property
    @pulumi.getter(name="hsmConfigurationIdentifier")
    def hsm_configuration_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
        """
        return pulumi.get(self, "hsm_configuration_identifier")

    @hsm_configuration_identifier.setter
    def hsm_configuration_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hsm_configuration_identifier", value)

    @property
    @pulumi.getter(name="iamRoles")
    def iam_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. You can supply up to 50 IAM roles in a single request
        """
        return pulumi.get(self, "iam_roles")

    @iam_roles.setter
    def iam_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "iam_roles", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="loggingProperties")
    def logging_properties(self) -> Optional[pulumi.Input['ClusterLoggingPropertiesArgs']]:
        """
        Specifies logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
        """
        return pulumi.get(self, "logging_properties")

    @logging_properties.setter
    def logging_properties(self, value: Optional[pulumi.Input['ClusterLoggingPropertiesArgs']]):
        pulumi.set(self, "logging_properties", value)

    @property
    @pulumi.getter(name="maintenanceTrackName")
    def maintenance_track_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the maintenance track that you want to assign for the cluster. This name change is asynchronous. The new track name stays in the PendingModifiedValues for the cluster until the next maintenance window. When the maintenance track changes, the cluster is switched to the latest cluster release available for the maintenance track. At this point, the maintenance track name is applied.
        """
        return pulumi.get(self, "maintenance_track_name")

    @maintenance_track_name.setter
    def maintenance_track_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_track_name", value)

    @property
    @pulumi.getter(name="manageMasterPassword")
    def manage_master_password(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A boolean indicating if the redshift cluster's admin user credentials is managed by Redshift or not. You can't use MasterUserPassword if ManageMasterPassword is true. If ManageMasterPassword is false or not set, Amazon Redshift uses MasterUserPassword for the admin user account's password.
        """
        return pulumi.get(self, "manage_master_password")

    @manage_master_password.setter
    def manage_master_password(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "manage_master_password", value)

    @property
    @pulumi.getter(name="manualSnapshotRetentionPeriod")
    def manual_snapshot_retention_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is -1, the manual snapshot is retained indefinitely.

        The value must be either -1 or an integer between 1 and 3,653.
        """
        return pulumi.get(self, "manual_snapshot_retention_period")

    @manual_snapshot_retention_period.setter
    def manual_snapshot_retention_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "manual_snapshot_retention_period", value)

    @property
    @pulumi.getter(name="masterPasswordSecretKmsKeyId")
    def master_password_secret_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin user credentials secret.
        """
        return pulumi.get(self, "master_password_secret_kms_key_id")

    @master_password_secret_kms_key_id.setter
    def master_password_secret_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_password_secret_kms_key_id", value)

    @property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password associated with the master user account for the cluster that is being created. You can't use MasterUserPassword if ManageMasterPassword is true. Password must be between 8 and 64 characters in length, should have at least one uppercase letter.Must contain at least one lowercase letter.Must contain one number.Can be any printable ASCII character.
        """
        return pulumi.get(self, "master_user_password")

    @master_user_password.setter
    def master_user_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_user_password", value)

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A boolean indicating if the redshift cluster is multi-az or not. If you don't provide this parameter or set the value to false, the redshift cluster will be single-az.
        """
        return pulumi.get(self, "multi_az")

    @multi_az.setter
    def multi_az(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "multi_az", value)

    @property
    @pulumi.getter(name="namespaceResourcePolicy")
    def namespace_resource_policy(self) -> Optional[Any]:
        """
        The namespace resource policy document that will be attached to a Redshift cluster.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Redshift::Cluster` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "namespace_resource_policy")

    @namespace_resource_policy.setter
    def namespace_resource_policy(self, value: Optional[Any]):
        pulumi.set(self, "namespace_resource_policy", value)

    @property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node.
        """
        return pulumi.get(self, "number_of_nodes")

    @number_of_nodes.setter
    def number_of_nodes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_of_nodes", value)

    @property
    @pulumi.getter(name="ownerAccount")
    def owner_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
        """
        return pulumi.get(self, "owner_account")

    @owner_account.setter
    def owner_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner_account", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port number on which the cluster accepts incoming connections. The cluster is accessible only via the JDBC and ODBC connection strings
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The weekly time range (in UTC) during which automated cluster maintenance can occur.
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the cluster can be accessed from a public network.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="resourceAction")
    def resource_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Redshift operation to be performed. Resource Action supports pause-cluster, resume-cluster, failover-primary-compute APIs
        """
        return pulumi.get(self, "resource_action")

    @resource_action.setter
    def resource_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_action", value)

    @property
    @pulumi.getter(name="revisionTarget")
    def revision_target(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the database revision. You can retrieve this value from the response to the DescribeClusterDbRevisions request.
        """
        return pulumi.get(self, "revision_target")

    @revision_target.setter
    def revision_target(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "revision_target", value)

    @property
    @pulumi.getter(name="rotateEncryptionKey")
    def rotate_encryption_key(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A boolean indicating if we want to rotate Encryption Keys.
        """
        return pulumi.get(self, "rotate_encryption_key")

    @rotate_encryption_key.setter
    def rotate_encryption_key(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "rotate_encryption_key", value)

    @property
    @pulumi.getter(name="snapshotClusterIdentifier")
    def snapshot_cluster_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
        """
        return pulumi.get(self, "snapshot_cluster_identifier")

    @snapshot_cluster_identifier.setter
    def snapshot_cluster_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_cluster_identifier", value)

    @property
    @pulumi.getter(name="snapshotCopyGrantName")
    def snapshot_copy_grant_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
        """
        return pulumi.get(self, "snapshot_copy_grant_name")

    @snapshot_copy_grant_name.setter
    def snapshot_copy_grant_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_copy_grant_name", value)

    @property
    @pulumi.getter(name="snapshotCopyManual")
    def snapshot_copy_manual(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.
        """
        return pulumi.get(self, "snapshot_copy_manual")

    @snapshot_copy_manual.setter
    def snapshot_copy_manual(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "snapshot_copy_manual", value)

    @property
    @pulumi.getter(name="snapshotCopyRetentionPeriod")
    def snapshot_copy_retention_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days to retain automated snapshots in the destination region after they are copied from the source region. 

         Default is 7. 

         Constraints: Must be at least 1 and no more than 35.
        """
        return pulumi.get(self, "snapshot_copy_retention_period")

    @snapshot_copy_retention_period.setter
    def snapshot_copy_retention_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "snapshot_copy_retention_period", value)

    @property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive.
        """
        return pulumi.get(self, "snapshot_identifier")

    @snapshot_identifier.setter
    def snapshot_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_identifier", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The list of tags for the cluster parameter group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


@pulumi.type_token("aws-native:redshift:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 aqua_configuration_status: Optional[pulumi.Input[builtins.str]] = None,
                 automated_snapshot_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 availability_zone_relocation: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone_relocation_status: Optional[pulumi.Input[builtins.str]] = None,
                 classic: Optional[pulumi.Input[builtins.bool]] = None,
                 cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cluster_subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_version: Optional[pulumi.Input[builtins.str]] = None,
                 db_name: Optional[pulumi.Input[builtins.str]] = None,
                 defer_maintenance: Optional[pulumi.Input[builtins.bool]] = None,
                 defer_maintenance_duration: Optional[pulumi.Input[builtins.int]] = None,
                 defer_maintenance_end_time: Optional[pulumi.Input[builtins.str]] = None,
                 defer_maintenance_start_time: Optional[pulumi.Input[builtins.str]] = None,
                 destination_region: Optional[pulumi.Input[builtins.str]] = None,
                 elastic_ip: Optional[pulumi.Input[builtins.str]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint: Optional[pulumi.Input[Union['ClusterEndpointArgs', 'ClusterEndpointArgsDict']]] = None,
                 enhanced_vpc_routing: Optional[pulumi.Input[builtins.bool]] = None,
                 hsm_client_certificate_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 hsm_configuration_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 iam_roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 logging_properties: Optional[pulumi.Input[Union['ClusterLoggingPropertiesArgs', 'ClusterLoggingPropertiesArgsDict']]] = None,
                 maintenance_track_name: Optional[pulumi.Input[builtins.str]] = None,
                 manage_master_password: Optional[pulumi.Input[builtins.bool]] = None,
                 manual_snapshot_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 master_password_secret_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 master_user_password: Optional[pulumi.Input[builtins.str]] = None,
                 master_username: Optional[pulumi.Input[builtins.str]] = None,
                 multi_az: Optional[pulumi.Input[builtins.bool]] = None,
                 namespace_resource_policy: Optional[Any] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 number_of_nodes: Optional[pulumi.Input[builtins.int]] = None,
                 owner_account: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_action: Optional[pulumi.Input[builtins.str]] = None,
                 revision_target: Optional[pulumi.Input[builtins.str]] = None,
                 rotate_encryption_key: Optional[pulumi.Input[builtins.bool]] = None,
                 snapshot_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_copy_grant_name: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_copy_manual: Optional[pulumi.Input[builtins.bool]] = None,
                 snapshot_copy_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        An example resource schema demonstrating some basic constructs and validation rules.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_version_upgrade: Major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default value is True
        :param pulumi.Input[builtins.str] aqua_configuration_status: The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored. Possible values include the following.
               
               enabled - Use AQUA if it is available for the current Region and Amazon Redshift node type.
               disabled - Don't use AQUA.
               auto - Amazon Redshift determines whether to use AQUA.
        :param pulumi.Input[builtins.int] automated_snapshot_retention_period: The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Default value is 1
        :param pulumi.Input[builtins.str] availability_zone: The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint
        :param pulumi.Input[builtins.bool] availability_zone_relocation: The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.
        :param pulumi.Input[builtins.str] availability_zone_relocation_status: The availability zone relocation status of the cluster
        :param pulumi.Input[builtins.bool] classic: A boolean value indicating whether the resize operation is using the classic resize process. If you don't provide this parameter or set the value to false , the resize type is elastic.
        :param pulumi.Input[builtins.str] cluster_identifier: A unique identifier for the cluster. You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. All alphabetical characters must be lower case, no hypens at the end, no two consecutive hyphens. Cluster name should be unique for all clusters within an AWS account
        :param pulumi.Input[builtins.str] cluster_parameter_group_name: The name of the parameter group to be associated with this cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cluster_security_groups: A list of security groups to be associated with this cluster.
        :param pulumi.Input[builtins.str] cluster_subnet_group_name: The name of a cluster subnet group to be associated with this cluster.
        :param pulumi.Input[builtins.str] cluster_type: The type of the cluster. When cluster type is specified as single-node, the NumberOfNodes parameter is not required and if multi-node, the NumberOfNodes parameter is required
        :param pulumi.Input[builtins.str] cluster_version: The version of the Amazon Redshift engine software that you want to deploy on the cluster.The version selected runs on all the nodes in the cluster.
        :param pulumi.Input[builtins.str] db_name: The name of the first database to be created when the cluster is created. To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database.
        :param pulumi.Input[builtins.bool] defer_maintenance: A boolean indicating whether to enable the deferred maintenance window.
        :param pulumi.Input[builtins.int] defer_maintenance_duration: An integer indicating the duration of the maintenance window in days. If you specify a duration, you can't specify an end time. The duration must be 45 days or less.
        :param pulumi.Input[builtins.str] defer_maintenance_end_time: A timestamp indicating end time for the deferred maintenance window. If you specify an end time, you can't specify a duration.
        :param pulumi.Input[builtins.str] defer_maintenance_start_time: A timestamp indicating the start time for the deferred maintenance window.
        :param pulumi.Input[builtins.str] destination_region: The destination AWS Region that you want to copy snapshots to. Constraints: Must be the name of a valid AWS Region. For more information, see Regions and Endpoints in the Amazon Web Services [https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region] General Reference
        :param pulumi.Input[builtins.str] elastic_ip: The Elastic IP (EIP) address for the cluster.
        :param pulumi.Input[builtins.bool] encrypted: If true, the data in the cluster is encrypted at rest.
        :param pulumi.Input[Union['ClusterEndpointArgs', 'ClusterEndpointArgsDict']] endpoint: The connection endpoint.
        :param pulumi.Input[builtins.bool] enhanced_vpc_routing: An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see Enhanced VPC Routing in the Amazon Redshift Cluster Management Guide.
               
               If this option is true , enhanced VPC routing is enabled.
               
               Default: false
        :param pulumi.Input[builtins.str] hsm_client_certificate_identifier: Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM
        :param pulumi.Input[builtins.str] hsm_configuration_identifier: Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] iam_roles: A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. You can supply up to 50 IAM roles in a single request
        :param pulumi.Input[builtins.str] kms_key_id: The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.
        :param pulumi.Input[Union['ClusterLoggingPropertiesArgs', 'ClusterLoggingPropertiesArgsDict']] logging_properties: Specifies logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
        :param pulumi.Input[builtins.str] maintenance_track_name: The name for the maintenance track that you want to assign for the cluster. This name change is asynchronous. The new track name stays in the PendingModifiedValues for the cluster until the next maintenance window. When the maintenance track changes, the cluster is switched to the latest cluster release available for the maintenance track. At this point, the maintenance track name is applied.
        :param pulumi.Input[builtins.bool] manage_master_password: A boolean indicating if the redshift cluster's admin user credentials is managed by Redshift or not. You can't use MasterUserPassword if ManageMasterPassword is true. If ManageMasterPassword is false or not set, Amazon Redshift uses MasterUserPassword for the admin user account's password.
        :param pulumi.Input[builtins.int] manual_snapshot_retention_period: The number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is -1, the manual snapshot is retained indefinitely.
               
               The value must be either -1 or an integer between 1 and 3,653.
        :param pulumi.Input[builtins.str] master_password_secret_kms_key_id: The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin user credentials secret.
        :param pulumi.Input[builtins.str] master_user_password: The password associated with the master user account for the cluster that is being created. You can't use MasterUserPassword if ManageMasterPassword is true. Password must be between 8 and 64 characters in length, should have at least one uppercase letter.Must contain at least one lowercase letter.Must contain one number.Can be any printable ASCII character.
        :param pulumi.Input[builtins.str] master_username: The user name associated with the master user account for the cluster that is being created. The user name can't be PUBLIC and first character must be a letter.
        :param pulumi.Input[builtins.bool] multi_az: A boolean indicating if the redshift cluster is multi-az or not. If you don't provide this parameter or set the value to false, the redshift cluster will be single-az.
        :param Any namespace_resource_policy: The namespace resource policy document that will be attached to a Redshift cluster.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Redshift::Cluster` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] node_type: The node type to be provisioned for the cluster.Valid Values: ds2.xlarge | ds2.8xlarge | dc1.large | dc1.8xlarge | dc2.large | dc2.8xlarge | ra3.large | ra3.4xlarge | ra3.16xlarge
        :param pulumi.Input[builtins.int] number_of_nodes: The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node.
        :param pulumi.Input[builtins.str] owner_account: The AWS account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
        :param pulumi.Input[builtins.int] port: The port number on which the cluster accepts incoming connections. The cluster is accessible only via the JDBC and ODBC connection strings
        :param pulumi.Input[builtins.str] preferred_maintenance_window: The weekly time range (in UTC) during which automated cluster maintenance can occur.
        :param pulumi.Input[builtins.bool] publicly_accessible: If true, the cluster can be accessed from a public network.
        :param pulumi.Input[builtins.str] resource_action: The Redshift operation to be performed. Resource Action supports pause-cluster, resume-cluster, failover-primary-compute APIs
        :param pulumi.Input[builtins.str] revision_target: The identifier of the database revision. You can retrieve this value from the response to the DescribeClusterDbRevisions request.
        :param pulumi.Input[builtins.bool] rotate_encryption_key: A boolean indicating if we want to rotate Encryption Keys.
        :param pulumi.Input[builtins.str] snapshot_cluster_identifier: The name of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
        :param pulumi.Input[builtins.str] snapshot_copy_grant_name: The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
        :param pulumi.Input[builtins.bool] snapshot_copy_manual: Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.
        :param pulumi.Input[builtins.int] snapshot_copy_retention_period: The number of days to retain automated snapshots in the destination region after they are copied from the source region. 
               
                Default is 7. 
               
                Constraints: Must be at least 1 and no more than 35.
        :param pulumi.Input[builtins.str] snapshot_identifier: The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The list of tags for the cluster parameter group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_security_group_ids: A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An example resource schema demonstrating some basic constructs and validation rules.

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 aqua_configuration_status: Optional[pulumi.Input[builtins.str]] = None,
                 automated_snapshot_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 availability_zone_relocation: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone_relocation_status: Optional[pulumi.Input[builtins.str]] = None,
                 classic: Optional[pulumi.Input[builtins.bool]] = None,
                 cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cluster_subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_version: Optional[pulumi.Input[builtins.str]] = None,
                 db_name: Optional[pulumi.Input[builtins.str]] = None,
                 defer_maintenance: Optional[pulumi.Input[builtins.bool]] = None,
                 defer_maintenance_duration: Optional[pulumi.Input[builtins.int]] = None,
                 defer_maintenance_end_time: Optional[pulumi.Input[builtins.str]] = None,
                 defer_maintenance_start_time: Optional[pulumi.Input[builtins.str]] = None,
                 destination_region: Optional[pulumi.Input[builtins.str]] = None,
                 elastic_ip: Optional[pulumi.Input[builtins.str]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint: Optional[pulumi.Input[Union['ClusterEndpointArgs', 'ClusterEndpointArgsDict']]] = None,
                 enhanced_vpc_routing: Optional[pulumi.Input[builtins.bool]] = None,
                 hsm_client_certificate_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 hsm_configuration_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 iam_roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 logging_properties: Optional[pulumi.Input[Union['ClusterLoggingPropertiesArgs', 'ClusterLoggingPropertiesArgsDict']]] = None,
                 maintenance_track_name: Optional[pulumi.Input[builtins.str]] = None,
                 manage_master_password: Optional[pulumi.Input[builtins.bool]] = None,
                 manual_snapshot_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 master_password_secret_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 master_user_password: Optional[pulumi.Input[builtins.str]] = None,
                 master_username: Optional[pulumi.Input[builtins.str]] = None,
                 multi_az: Optional[pulumi.Input[builtins.bool]] = None,
                 namespace_resource_policy: Optional[Any] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 number_of_nodes: Optional[pulumi.Input[builtins.int]] = None,
                 owner_account: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_action: Optional[pulumi.Input[builtins.str]] = None,
                 revision_target: Optional[pulumi.Input[builtins.str]] = None,
                 rotate_encryption_key: Optional[pulumi.Input[builtins.bool]] = None,
                 snapshot_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_copy_grant_name: Optional[pulumi.Input[builtins.str]] = None,
                 snapshot_copy_manual: Optional[pulumi.Input[builtins.bool]] = None,
                 snapshot_copy_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["allow_version_upgrade"] = allow_version_upgrade
            __props__.__dict__["aqua_configuration_status"] = aqua_configuration_status
            __props__.__dict__["automated_snapshot_retention_period"] = automated_snapshot_retention_period
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["availability_zone_relocation"] = availability_zone_relocation
            __props__.__dict__["availability_zone_relocation_status"] = availability_zone_relocation_status
            __props__.__dict__["classic"] = classic
            __props__.__dict__["cluster_identifier"] = cluster_identifier
            __props__.__dict__["cluster_parameter_group_name"] = cluster_parameter_group_name
            __props__.__dict__["cluster_security_groups"] = cluster_security_groups
            __props__.__dict__["cluster_subnet_group_name"] = cluster_subnet_group_name
            if cluster_type is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_type'")
            __props__.__dict__["cluster_type"] = cluster_type
            __props__.__dict__["cluster_version"] = cluster_version
            if db_name is None and not opts.urn:
                raise TypeError("Missing required property 'db_name'")
            __props__.__dict__["db_name"] = db_name
            __props__.__dict__["defer_maintenance"] = defer_maintenance
            __props__.__dict__["defer_maintenance_duration"] = defer_maintenance_duration
            __props__.__dict__["defer_maintenance_end_time"] = defer_maintenance_end_time
            __props__.__dict__["defer_maintenance_start_time"] = defer_maintenance_start_time
            __props__.__dict__["destination_region"] = destination_region
            __props__.__dict__["elastic_ip"] = elastic_ip
            __props__.__dict__["encrypted"] = encrypted
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["enhanced_vpc_routing"] = enhanced_vpc_routing
            __props__.__dict__["hsm_client_certificate_identifier"] = hsm_client_certificate_identifier
            __props__.__dict__["hsm_configuration_identifier"] = hsm_configuration_identifier
            __props__.__dict__["iam_roles"] = iam_roles
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["logging_properties"] = logging_properties
            __props__.__dict__["maintenance_track_name"] = maintenance_track_name
            __props__.__dict__["manage_master_password"] = manage_master_password
            __props__.__dict__["manual_snapshot_retention_period"] = manual_snapshot_retention_period
            __props__.__dict__["master_password_secret_kms_key_id"] = master_password_secret_kms_key_id
            __props__.__dict__["master_user_password"] = master_user_password
            if master_username is None and not opts.urn:
                raise TypeError("Missing required property 'master_username'")
            __props__.__dict__["master_username"] = master_username
            __props__.__dict__["multi_az"] = multi_az
            __props__.__dict__["namespace_resource_policy"] = namespace_resource_policy
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["number_of_nodes"] = number_of_nodes
            __props__.__dict__["owner_account"] = owner_account
            __props__.__dict__["port"] = port
            __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            __props__.__dict__["resource_action"] = resource_action
            __props__.__dict__["revision_target"] = revision_target
            __props__.__dict__["rotate_encryption_key"] = rotate_encryption_key
            __props__.__dict__["snapshot_cluster_identifier"] = snapshot_cluster_identifier
            __props__.__dict__["snapshot_copy_grant_name"] = snapshot_copy_grant_name
            __props__.__dict__["snapshot_copy_manual"] = snapshot_copy_manual
            __props__.__dict__["snapshot_copy_retention_period"] = snapshot_copy_retention_period
            __props__.__dict__["snapshot_identifier"] = snapshot_identifier
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
            __props__.__dict__["cluster_namespace_arn"] = None
            __props__.__dict__["defer_maintenance_identifier"] = None
            __props__.__dict__["master_password_secret_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["clusterIdentifier", "clusterSubnetGroupName", "dbName", "masterUsername", "ownerAccount", "snapshotClusterIdentifier", "snapshotIdentifier"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Cluster, __self__).__init__(
            'aws-native:redshift:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ClusterArgs.__new__(ClusterArgs)

        __props__.__dict__["allow_version_upgrade"] = None
        __props__.__dict__["aqua_configuration_status"] = None
        __props__.__dict__["automated_snapshot_retention_period"] = None
        __props__.__dict__["availability_zone"] = None
        __props__.__dict__["availability_zone_relocation"] = None
        __props__.__dict__["availability_zone_relocation_status"] = None
        __props__.__dict__["classic"] = None
        __props__.__dict__["cluster_identifier"] = None
        __props__.__dict__["cluster_namespace_arn"] = None
        __props__.__dict__["cluster_parameter_group_name"] = None
        __props__.__dict__["cluster_security_groups"] = None
        __props__.__dict__["cluster_subnet_group_name"] = None
        __props__.__dict__["cluster_type"] = None
        __props__.__dict__["cluster_version"] = None
        __props__.__dict__["db_name"] = None
        __props__.__dict__["defer_maintenance"] = None
        __props__.__dict__["defer_maintenance_duration"] = None
        __props__.__dict__["defer_maintenance_end_time"] = None
        __props__.__dict__["defer_maintenance_identifier"] = None
        __props__.__dict__["defer_maintenance_start_time"] = None
        __props__.__dict__["destination_region"] = None
        __props__.__dict__["elastic_ip"] = None
        __props__.__dict__["encrypted"] = None
        __props__.__dict__["endpoint"] = None
        __props__.__dict__["enhanced_vpc_routing"] = None
        __props__.__dict__["hsm_client_certificate_identifier"] = None
        __props__.__dict__["hsm_configuration_identifier"] = None
        __props__.__dict__["iam_roles"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["logging_properties"] = None
        __props__.__dict__["maintenance_track_name"] = None
        __props__.__dict__["manage_master_password"] = None
        __props__.__dict__["manual_snapshot_retention_period"] = None
        __props__.__dict__["master_password_secret_arn"] = None
        __props__.__dict__["master_password_secret_kms_key_id"] = None
        __props__.__dict__["master_user_password"] = None
        __props__.__dict__["master_username"] = None
        __props__.__dict__["multi_az"] = None
        __props__.__dict__["namespace_resource_policy"] = None
        __props__.__dict__["node_type"] = None
        __props__.__dict__["number_of_nodes"] = None
        __props__.__dict__["owner_account"] = None
        __props__.__dict__["port"] = None
        __props__.__dict__["preferred_maintenance_window"] = None
        __props__.__dict__["publicly_accessible"] = None
        __props__.__dict__["resource_action"] = None
        __props__.__dict__["revision_target"] = None
        __props__.__dict__["rotate_encryption_key"] = None
        __props__.__dict__["snapshot_cluster_identifier"] = None
        __props__.__dict__["snapshot_copy_grant_name"] = None
        __props__.__dict__["snapshot_copy_manual"] = None
        __props__.__dict__["snapshot_copy_retention_period"] = None
        __props__.__dict__["snapshot_identifier"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["vpc_security_group_ids"] = None
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowVersionUpgrade")
    def allow_version_upgrade(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default value is True
        """
        return pulumi.get(self, "allow_version_upgrade")

    @property
    @pulumi.getter(name="aquaConfigurationStatus")
    def aqua_configuration_status(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored. Possible values include the following.

        enabled - Use AQUA if it is available for the current Region and Amazon Redshift node type.
        disabled - Don't use AQUA.
        auto - Amazon Redshift determines whether to use AQUA.
        """
        return pulumi.get(self, "aqua_configuration_status")

    @property
    @pulumi.getter(name="automatedSnapshotRetentionPeriod")
    def automated_snapshot_retention_period(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Default value is 1
        """
        return pulumi.get(self, "automated_snapshot_retention_period")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="availabilityZoneRelocation")
    def availability_zone_relocation(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.
        """
        return pulumi.get(self, "availability_zone_relocation")

    @property
    @pulumi.getter(name="availabilityZoneRelocationStatus")
    def availability_zone_relocation_status(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The availability zone relocation status of the cluster
        """
        return pulumi.get(self, "availability_zone_relocation_status")

    @property
    @pulumi.getter
    def classic(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A boolean value indicating whether the resize operation is using the classic resize process. If you don't provide this parameter or set the value to false , the resize type is elastic.
        """
        return pulumi.get(self, "classic")

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A unique identifier for the cluster. You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. All alphabetical characters must be lower case, no hypens at the end, no two consecutive hyphens. Cluster name should be unique for all clusters within an AWS account
        """
        return pulumi.get(self, "cluster_identifier")

    @property
    @pulumi.getter(name="clusterNamespaceArn")
    def cluster_namespace_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the cluster namespace.
        """
        return pulumi.get(self, "cluster_namespace_arn")

    @property
    @pulumi.getter(name="clusterParameterGroupName")
    def cluster_parameter_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the parameter group to be associated with this cluster.
        """
        return pulumi.get(self, "cluster_parameter_group_name")

    @property
    @pulumi.getter(name="clusterSecurityGroups")
    def cluster_security_groups(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of security groups to be associated with this cluster.
        """
        return pulumi.get(self, "cluster_security_groups")

    @property
    @pulumi.getter(name="clusterSubnetGroupName")
    def cluster_subnet_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of a cluster subnet group to be associated with this cluster.
        """
        return pulumi.get(self, "cluster_subnet_group_name")

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the cluster. When cluster type is specified as single-node, the NumberOfNodes parameter is not required and if multi-node, the NumberOfNodes parameter is required
        """
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version of the Amazon Redshift engine software that you want to deploy on the cluster.The version selected runs on all the nodes in the cluster.
        """
        return pulumi.get(self, "cluster_version")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the first database to be created when the cluster is created. To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="deferMaintenance")
    def defer_maintenance(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A boolean indicating whether to enable the deferred maintenance window.
        """
        return pulumi.get(self, "defer_maintenance")

    @property
    @pulumi.getter(name="deferMaintenanceDuration")
    def defer_maintenance_duration(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        An integer indicating the duration of the maintenance window in days. If you specify a duration, you can't specify an end time. The duration must be 45 days or less.
        """
        return pulumi.get(self, "defer_maintenance_duration")

    @property
    @pulumi.getter(name="deferMaintenanceEndTime")
    def defer_maintenance_end_time(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A timestamp indicating end time for the deferred maintenance window. If you specify an end time, you can't specify a duration.
        """
        return pulumi.get(self, "defer_maintenance_end_time")

    @property
    @pulumi.getter(name="deferMaintenanceIdentifier")
    def defer_maintenance_identifier(self) -> pulumi.Output[builtins.str]:
        """
        A unique identifier for the deferred maintenance window.
        """
        return pulumi.get(self, "defer_maintenance_identifier")

    @property
    @pulumi.getter(name="deferMaintenanceStartTime")
    def defer_maintenance_start_time(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A timestamp indicating the start time for the deferred maintenance window.
        """
        return pulumi.get(self, "defer_maintenance_start_time")

    @property
    @pulumi.getter(name="destinationRegion")
    def destination_region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The destination AWS Region that you want to copy snapshots to. Constraints: Must be the name of a valid AWS Region. For more information, see Regions and Endpoints in the Amazon Web Services [https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region] General Reference
        """
        return pulumi.get(self, "destination_region")

    @property
    @pulumi.getter(name="elasticIp")
    def elastic_ip(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Elastic IP (EIP) address for the cluster.
        """
        return pulumi.get(self, "elastic_ip")

    @property
    @pulumi.getter
    def encrypted(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, the data in the cluster is encrypted at rest.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional['outputs.ClusterEndpoint']]:
        """
        The connection endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="enhancedVpcRouting")
    def enhanced_vpc_routing(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see Enhanced VPC Routing in the Amazon Redshift Cluster Management Guide.

        If this option is true , enhanced VPC routing is enabled.

        Default: false
        """
        return pulumi.get(self, "enhanced_vpc_routing")

    @property
    @pulumi.getter(name="hsmClientCertificateIdentifier")
    def hsm_client_certificate_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM
        """
        return pulumi.get(self, "hsm_client_certificate_identifier")

    @property
    @pulumi.getter(name="hsmConfigurationIdentifier")
    def hsm_configuration_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
        """
        return pulumi.get(self, "hsm_configuration_identifier")

    @property
    @pulumi.getter(name="iamRoles")
    def iam_roles(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. You can supply up to 50 IAM roles in a single request
        """
        return pulumi.get(self, "iam_roles")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="loggingProperties")
    def logging_properties(self) -> pulumi.Output[Optional['outputs.ClusterLoggingProperties']]:
        """
        Specifies logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
        """
        return pulumi.get(self, "logging_properties")

    @property
    @pulumi.getter(name="maintenanceTrackName")
    def maintenance_track_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name for the maintenance track that you want to assign for the cluster. This name change is asynchronous. The new track name stays in the PendingModifiedValues for the cluster until the next maintenance window. When the maintenance track changes, the cluster is switched to the latest cluster release available for the maintenance track. At this point, the maintenance track name is applied.
        """
        return pulumi.get(self, "maintenance_track_name")

    @property
    @pulumi.getter(name="manageMasterPassword")
    def manage_master_password(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A boolean indicating if the redshift cluster's admin user credentials is managed by Redshift or not. You can't use MasterUserPassword if ManageMasterPassword is true. If ManageMasterPassword is false or not set, Amazon Redshift uses MasterUserPassword for the admin user account's password.
        """
        return pulumi.get(self, "manage_master_password")

    @property
    @pulumi.getter(name="manualSnapshotRetentionPeriod")
    def manual_snapshot_retention_period(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of days to retain newly copied snapshots in the destination AWS Region after they are copied from the source AWS Region. If the value is -1, the manual snapshot is retained indefinitely.

        The value must be either -1 or an integer between 1 and 3,653.
        """
        return pulumi.get(self, "manual_snapshot_retention_period")

    @property
    @pulumi.getter(name="masterPasswordSecretArn")
    def master_password_secret_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the cluster's admin user credentials secret.
        """
        return pulumi.get(self, "master_password_secret_arn")

    @property
    @pulumi.getter(name="masterPasswordSecretKmsKeyId")
    def master_password_secret_kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin user credentials secret.
        """
        return pulumi.get(self, "master_password_secret_kms_key_id")

    @property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The password associated with the master user account for the cluster that is being created. You can't use MasterUserPassword if ManageMasterPassword is true. Password must be between 8 and 64 characters in length, should have at least one uppercase letter.Must contain at least one lowercase letter.Must contain one number.Can be any printable ASCII character.
        """
        return pulumi.get(self, "master_user_password")

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> pulumi.Output[builtins.str]:
        """
        The user name associated with the master user account for the cluster that is being created. The user name can't be PUBLIC and first character must be a letter.
        """
        return pulumi.get(self, "master_username")

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A boolean indicating if the redshift cluster is multi-az or not. If you don't provide this parameter or set the value to false, the redshift cluster will be single-az.
        """
        return pulumi.get(self, "multi_az")

    @property
    @pulumi.getter(name="namespaceResourcePolicy")
    def namespace_resource_policy(self) -> pulumi.Output[Optional[Any]]:
        """
        The namespace resource policy document that will be attached to a Redshift cluster.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Redshift::Cluster` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "namespace_resource_policy")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[builtins.str]:
        """
        The node type to be provisioned for the cluster.Valid Values: ds2.xlarge | ds2.8xlarge | dc1.large | dc1.8xlarge | dc2.large | dc2.8xlarge | ra3.large | ra3.4xlarge | ra3.16xlarge
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node.
        """
        return pulumi.get(self, "number_of_nodes")

    @property
    @pulumi.getter(name="ownerAccount")
    def owner_account(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
        """
        return pulumi.get(self, "owner_account")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The port number on which the cluster accepts incoming connections. The cluster is accessible only via the JDBC and ODBC connection strings
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The weekly time range (in UTC) during which automated cluster maintenance can occur.
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, the cluster can be accessed from a public network.
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter(name="resourceAction")
    def resource_action(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Redshift operation to be performed. Resource Action supports pause-cluster, resume-cluster, failover-primary-compute APIs
        """
        return pulumi.get(self, "resource_action")

    @property
    @pulumi.getter(name="revisionTarget")
    def revision_target(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The identifier of the database revision. You can retrieve this value from the response to the DescribeClusterDbRevisions request.
        """
        return pulumi.get(self, "revision_target")

    @property
    @pulumi.getter(name="rotateEncryptionKey")
    def rotate_encryption_key(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A boolean indicating if we want to rotate Encryption Keys.
        """
        return pulumi.get(self, "rotate_encryption_key")

    @property
    @pulumi.getter(name="snapshotClusterIdentifier")
    def snapshot_cluster_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
        """
        return pulumi.get(self, "snapshot_cluster_identifier")

    @property
    @pulumi.getter(name="snapshotCopyGrantName")
    def snapshot_copy_grant_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
        """
        return pulumi.get(self, "snapshot_copy_grant_name")

    @property
    @pulumi.getter(name="snapshotCopyManual")
    def snapshot_copy_manual(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.
        """
        return pulumi.get(self, "snapshot_copy_manual")

    @property
    @pulumi.getter(name="snapshotCopyRetentionPeriod")
    def snapshot_copy_retention_period(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of days to retain automated snapshots in the destination region after they are copied from the source region. 

         Default is 7. 

         Constraints: Must be at least 1 and no more than 35.
        """
        return pulumi.get(self, "snapshot_copy_retention_period")

    @property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive.
        """
        return pulumi.get(self, "snapshot_identifier")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The list of tags for the cluster parameter group.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
        """
        return pulumi.get(self, "vpc_security_group_ids")

