# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DbClusterDbClusterRole',
    'DbClusterEndpoint',
    'DbClusterMasterUserSecret',
    'DbClusterReadEndpoint',
    'DbClusterScalingConfiguration',
    'DbClusterServerlessV2ScalingConfiguration',
    'DbInstanceCertificateDetails',
    'DbInstanceDbInstanceRole',
    'DbInstanceEndpoint',
    'DbInstanceMasterUserSecret',
    'DbInstanceProcessorFeature',
    'DbProxyAuthFormat',
    'DbProxyTargetGroupConnectionPoolConfigurationInfoFormat',
    'GlobalClusterGlobalEndpoint',
    'OptionGroupOptionConfiguration',
    'OptionGroupOptionSetting',
]

@pulumi.output_type
class DbClusterDbClusterRole(dict):
    """
    Describes an AWS Identity and Access Management (IAM) role that is associated with a DB cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "featureName":
            suggest = "feature_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbClusterDbClusterRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbClusterDbClusterRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbClusterDbClusterRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: builtins.str,
                 feature_name: Optional[builtins.str] = None):
        """
        Describes an AWS Identity and Access Management (IAM) role that is associated with a DB cluster.
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
        :param builtins.str feature_name: The name of the feature associated with the AWS Identity and Access Management (IAM) role. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf. For the list of supported feature names, see the ``SupportedFeatureNames`` description in [DBEngineVersion](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html) in the *Amazon RDS API Reference*.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if feature_name is not None:
            pulumi.set(__self__, "feature_name", feature_name)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="featureName")
    def feature_name(self) -> Optional[builtins.str]:
        """
        The name of the feature associated with the AWS Identity and Access Management (IAM) role. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf. For the list of supported feature names, see the ``SupportedFeatureNames`` description in [DBEngineVersion](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html) in the *Amazon RDS API Reference*.
        """
        return pulumi.get(self, "feature_name")


@pulumi.output_type
class DbClusterEndpoint(dict):
    """
    The ``Endpoint`` return value specifies the connection endpoint for the primary instance of the DB cluster.
    """
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 port: Optional[builtins.str] = None):
        """
        The ``Endpoint`` return value specifies the connection endpoint for the primary instance of the DB cluster.
        :param builtins.str address: Specifies the connection endpoint for the primary instance of the DB cluster.
        :param builtins.str port: Specifies the port that the database engine is listening on.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        Specifies the connection endpoint for the primary instance of the DB cluster.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.str]:
        """
        Specifies the port that the database engine is listening on.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DbClusterMasterUserSecret(dict):
    """
    The ``MasterUserSecret`` return value specifies the secret managed by RDS in AWS Secrets Manager for the master user password.
     For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbClusterMasterUserSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbClusterMasterUserSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbClusterMasterUserSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[builtins.str] = None,
                 secret_arn: Optional[builtins.str] = None):
        """
        The ``MasterUserSecret`` return value specifies the secret managed by RDS in AWS Secrets Manager for the master user password.
         For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
        :param builtins.str kms_key_id: The AWS KMS key identifier that is used to encrypt the secret.
        :param builtins.str secret_arn: The Amazon Resource Name (ARN) of the secret. This parameter is a return value that you can retrieve using the ``Fn::GetAtt`` intrinsic function. For more information, see [Return values](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#aws-resource-rds-dbcluster-return-values).
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        The AWS KMS key identifier that is used to encrypt the secret.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the secret. This parameter is a return value that you can retrieve using the ``Fn::GetAtt`` intrinsic function. For more information, see [Return values](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#aws-resource-rds-dbcluster-return-values).
        """
        return pulumi.get(self, "secret_arn")


@pulumi.output_type
class DbClusterReadEndpoint(dict):
    """
    The ``ReadEndpoint`` return value specifies the reader endpoint for the DB cluster.
     The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster.
     If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.
     For more information about Aurora endpoints, see [Amazon Aurora connection management](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.Endpoints.html) in the *Amazon Aurora User Guide*.
    """
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None):
        """
        The ``ReadEndpoint`` return value specifies the reader endpoint for the DB cluster.
         The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster.
         If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.
         For more information about Aurora endpoints, see [Amazon Aurora connection management](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.Endpoints.html) in the *Amazon Aurora User Guide*.
        :param builtins.str address: The host address of the reader endpoint.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The host address of the reader endpoint.
        """
        return pulumi.get(self, "address")


@pulumi.output_type
class DbClusterScalingConfiguration(dict):
    """
    The ``ScalingConfiguration`` property type specifies the scaling configuration of an Aurora Serverless v1 DB cluster. 
     For more information, see [Using Amazon Aurora Serverless](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html) in the *Amazon Aurora User Guide*.
     This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, Use the ``ServerlessV2ScalingConfiguration`` property.
     Valid for: Aurora Serverless v1 DB clusters only
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoPause":
            suggest = "auto_pause"
        elif key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"
        elif key == "secondsBeforeTimeout":
            suggest = "seconds_before_timeout"
        elif key == "secondsUntilAutoPause":
            suggest = "seconds_until_auto_pause"
        elif key == "timeoutAction":
            suggest = "timeout_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbClusterScalingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbClusterScalingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbClusterScalingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_pause: Optional[builtins.bool] = None,
                 max_capacity: Optional[builtins.int] = None,
                 min_capacity: Optional[builtins.int] = None,
                 seconds_before_timeout: Optional[builtins.int] = None,
                 seconds_until_auto_pause: Optional[builtins.int] = None,
                 timeout_action: Optional[builtins.str] = None):
        """
        The ``ScalingConfiguration`` property type specifies the scaling configuration of an Aurora Serverless v1 DB cluster. 
         For more information, see [Using Amazon Aurora Serverless](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html) in the *Amazon Aurora User Guide*.
         This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, Use the ``ServerlessV2ScalingConfiguration`` property.
         Valid for: Aurora Serverless v1 DB clusters only
        :param builtins.bool auto_pause: Indicates whether to allow or disallow automatic pause for an Aurora DB cluster in ``serverless`` DB engine mode. A DB cluster can be paused only when it's idle (it has no connections).
                 If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.
        :param builtins.int max_capacity: The maximum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.
                For Aurora MySQL, valid capacity values are ``1``, ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``128``, and ``256``.
                For Aurora PostgreSQL, valid capacity values are ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``192``, and ``384``.
                The maximum capacity must be greater than or equal to the minimum capacity.
        :param builtins.int min_capacity: The minimum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.
                For Aurora MySQL, valid capacity values are ``1``, ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``128``, and ``256``.
                For Aurora PostgreSQL, valid capacity values are ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``192``, and ``384``.
                The minimum capacity must be less than or equal to the maximum capacity.
        :param builtins.int seconds_before_timeout: The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.
                Specify a value between 60 and 600 seconds.
        :param builtins.int seconds_until_auto_pause: The time, in seconds, before an Aurora DB cluster in ``serverless`` mode is paused.
                Specify a value between 300 and 86,400 seconds.
        :param builtins.str timeout_action: The action to take when the timeout is reached, either ``ForceApplyCapacityChange`` or ``RollbackCapacityChange``.
                ``ForceApplyCapacityChange`` sets the capacity to the specified value as soon as possible.
                ``RollbackCapacityChange``, the default, ignores the capacity change if a scaling point isn't found in the timeout period.
                 If you specify ``ForceApplyCapacityChange``, connections that prevent Aurora Serverless v1 from finding a scaling point might be dropped.
                 For more information, see [Autoscaling for Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling) in the *Amazon Aurora User Guide*.
        """
        if auto_pause is not None:
            pulumi.set(__self__, "auto_pause", auto_pause)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if seconds_before_timeout is not None:
            pulumi.set(__self__, "seconds_before_timeout", seconds_before_timeout)
        if seconds_until_auto_pause is not None:
            pulumi.set(__self__, "seconds_until_auto_pause", seconds_until_auto_pause)
        if timeout_action is not None:
            pulumi.set(__self__, "timeout_action", timeout_action)

    @property
    @pulumi.getter(name="autoPause")
    def auto_pause(self) -> Optional[builtins.bool]:
        """
        Indicates whether to allow or disallow automatic pause for an Aurora DB cluster in ``serverless`` DB engine mode. A DB cluster can be paused only when it's idle (it has no connections).
          If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.
        """
        return pulumi.get(self, "auto_pause")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[builtins.int]:
        """
        The maximum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.
         For Aurora MySQL, valid capacity values are ``1``, ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``128``, and ``256``.
         For Aurora PostgreSQL, valid capacity values are ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``192``, and ``384``.
         The maximum capacity must be greater than or equal to the minimum capacity.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[builtins.int]:
        """
        The minimum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.
         For Aurora MySQL, valid capacity values are ``1``, ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``128``, and ``256``.
         For Aurora PostgreSQL, valid capacity values are ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``192``, and ``384``.
         The minimum capacity must be less than or equal to the maximum capacity.
        """
        return pulumi.get(self, "min_capacity")

    @property
    @pulumi.getter(name="secondsBeforeTimeout")
    def seconds_before_timeout(self) -> Optional[builtins.int]:
        """
        The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.
         Specify a value between 60 and 600 seconds.
        """
        return pulumi.get(self, "seconds_before_timeout")

    @property
    @pulumi.getter(name="secondsUntilAutoPause")
    def seconds_until_auto_pause(self) -> Optional[builtins.int]:
        """
        The time, in seconds, before an Aurora DB cluster in ``serverless`` mode is paused.
         Specify a value between 300 and 86,400 seconds.
        """
        return pulumi.get(self, "seconds_until_auto_pause")

    @property
    @pulumi.getter(name="timeoutAction")
    def timeout_action(self) -> Optional[builtins.str]:
        """
        The action to take when the timeout is reached, either ``ForceApplyCapacityChange`` or ``RollbackCapacityChange``.
         ``ForceApplyCapacityChange`` sets the capacity to the specified value as soon as possible.
         ``RollbackCapacityChange``, the default, ignores the capacity change if a scaling point isn't found in the timeout period.
          If you specify ``ForceApplyCapacityChange``, connections that prevent Aurora Serverless v1 from finding a scaling point might be dropped.
          For more information, see [Autoscaling for Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling) in the *Amazon Aurora User Guide*.
        """
        return pulumi.get(self, "timeout_action")


@pulumi.output_type
class DbClusterServerlessV2ScalingConfiguration(dict):
    """
    The ``ServerlessV2ScalingConfiguration`` property type specifies the scaling configuration of an Aurora Serverless V2 DB cluster. For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
     If you have an Aurora cluster, you must set this attribute before you add a DB instance that uses the ``db.serverless`` DB instance class. For more information, see [Clusters that use Aurora Serverless v2 must have a capacity range specified](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html#aurora-serverless-v2.requirements.capacity-range) in the *Amazon Aurora User Guide*.
     This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, use the ``ScalingConfiguration`` property.
     Valid for: Aurora Serverless v2 DB clusters
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"
        elif key == "secondsUntilAutoPause":
            suggest = "seconds_until_auto_pause"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbClusterServerlessV2ScalingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbClusterServerlessV2ScalingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbClusterServerlessV2ScalingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: Optional[builtins.float] = None,
                 min_capacity: Optional[builtins.float] = None,
                 seconds_until_auto_pause: Optional[builtins.int] = None):
        """
        The ``ServerlessV2ScalingConfiguration`` property type specifies the scaling configuration of an Aurora Serverless V2 DB cluster. For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
         If you have an Aurora cluster, you must set this attribute before you add a DB instance that uses the ``db.serverless`` DB instance class. For more information, see [Clusters that use Aurora Serverless v2 must have a capacity range specified](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html#aurora-serverless-v2.requirements.capacity-range) in the *Amazon Aurora User Guide*.
         This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, use the ``ScalingConfiguration`` property.
         Valid for: Aurora Serverless v2 DB clusters
        :param builtins.float max_capacity: The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 40, 40.5, 41, and so on. The largest value that you can use is 128.
                The maximum capacity must be higher than 0.5 ACUs. For more information, see [Choosing the maximum Aurora Serverless v2 capacity setting for a cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.setting-capacity.html#aurora-serverless-v2.max_capacity_considerations) in the *Amazon Aurora User Guide*.
                Aurora automatically sets certain parameters for Aurora Serverless V2 DB instances to values that depend on the maximum ACU value in the capacity range. When you update the maximum capacity value, the ``ParameterApplyStatus`` value for the DB instance changes to ``pending-reboot``. You can update the parameter values by rebooting the DB instance after changing the capacity range.
        :param builtins.float min_capacity: The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. For Aurora versions that support the Aurora Serverless v2 auto-pause feature, the smallest value that you can use is 0. For versions that don't support Aurora Serverless v2 auto-pause, the smallest value that you can use is 0.5.
        :param builtins.int seconds_until_auto_pause: Specifies the number of seconds an Aurora Serverless v2 DB instance must be idle before Aurora attempts to automatically pause it. 
                Specify a value between 300 seconds (five minutes) and 86,400 seconds (one day). The default is 300 seconds.
        """
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if seconds_until_auto_pause is not None:
            pulumi.set(__self__, "seconds_until_auto_pause", seconds_until_auto_pause)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[builtins.float]:
        """
        The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 40, 40.5, 41, and so on. The largest value that you can use is 128.
         The maximum capacity must be higher than 0.5 ACUs. For more information, see [Choosing the maximum Aurora Serverless v2 capacity setting for a cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.setting-capacity.html#aurora-serverless-v2.max_capacity_considerations) in the *Amazon Aurora User Guide*.
         Aurora automatically sets certain parameters for Aurora Serverless V2 DB instances to values that depend on the maximum ACU value in the capacity range. When you update the maximum capacity value, the ``ParameterApplyStatus`` value for the DB instance changes to ``pending-reboot``. You can update the parameter values by rebooting the DB instance after changing the capacity range.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[builtins.float]:
        """
        The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. For Aurora versions that support the Aurora Serverless v2 auto-pause feature, the smallest value that you can use is 0. For versions that don't support Aurora Serverless v2 auto-pause, the smallest value that you can use is 0.5.
        """
        return pulumi.get(self, "min_capacity")

    @property
    @pulumi.getter(name="secondsUntilAutoPause")
    def seconds_until_auto_pause(self) -> Optional[builtins.int]:
        """
        Specifies the number of seconds an Aurora Serverless v2 DB instance must be idle before Aurora attempts to automatically pause it. 
         Specify a value between 300 seconds (five minutes) and 86,400 seconds (one day). The default is 300 seconds.
        """
        return pulumi.get(self, "seconds_until_auto_pause")


@pulumi.output_type
class DbInstanceCertificateDetails(dict):
    """
    The details of the DB instance’s server certificate.
     For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caIdentifier":
            suggest = "ca_identifier"
        elif key == "validTill":
            suggest = "valid_till"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstanceCertificateDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstanceCertificateDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstanceCertificateDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_identifier: Optional[builtins.str] = None,
                 valid_till: Optional[builtins.str] = None):
        """
        The details of the DB instance’s server certificate.
         For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
        :param builtins.str ca_identifier: The CA identifier of the CA certificate used for the DB instance's server certificate.
        :param builtins.str valid_till: The expiration date of the DB instance’s server certificate.
        """
        if ca_identifier is not None:
            pulumi.set(__self__, "ca_identifier", ca_identifier)
        if valid_till is not None:
            pulumi.set(__self__, "valid_till", valid_till)

    @property
    @pulumi.getter(name="caIdentifier")
    def ca_identifier(self) -> Optional[builtins.str]:
        """
        The CA identifier of the CA certificate used for the DB instance's server certificate.
        """
        return pulumi.get(self, "ca_identifier")

    @property
    @pulumi.getter(name="validTill")
    def valid_till(self) -> Optional[builtins.str]:
        """
        The expiration date of the DB instance’s server certificate.
        """
        return pulumi.get(self, "valid_till")


@pulumi.output_type
class DbInstanceDbInstanceRole(dict):
    """
    Information about an AWS Identity and Access Management (IAM) role that is associated with a DB instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "featureName":
            suggest = "feature_name"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstanceDbInstanceRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstanceDbInstanceRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstanceDbInstanceRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feature_name: builtins.str,
                 role_arn: builtins.str):
        """
        Information about an AWS Identity and Access Management (IAM) role that is associated with a DB instance.
        :param builtins.str feature_name: The name of the feature associated with the AWS Identity and Access Management (IAM) role. IAM roles that are associated with a DB instance grant permission for the DB instance to access other AWS services on your behalf. For the list of supported feature names, see the ``SupportedFeatureNames`` description in [DBEngineVersion](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html) in the *Amazon RDS API Reference*.
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.
        """
        pulumi.set(__self__, "feature_name", feature_name)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="featureName")
    def feature_name(self) -> builtins.str:
        """
        The name of the feature associated with the AWS Identity and Access Management (IAM) role. IAM roles that are associated with a DB instance grant permission for the DB instance to access other AWS services on your behalf. For the list of supported feature names, see the ``SupportedFeatureNames`` description in [DBEngineVersion](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html) in the *Amazon RDS API Reference*.
        """
        return pulumi.get(self, "feature_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class DbInstanceEndpoint(dict):
    """
    This data type represents the information you need to connect to an Amazon RDS DB instance. This data type is used as a response element in the following actions:
      +   ``CreateDBInstance`` 
      +   ``DescribeDBInstances`` 
      +   ``DeleteDBInstance`` 
      
     For the data structure that represents Amazon Aurora DB cluster endpoints, see ``DBClusterEndpoint``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostedZoneId":
            suggest = "hosted_zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstanceEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstanceEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstanceEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 hosted_zone_id: Optional[builtins.str] = None,
                 port: Optional[builtins.str] = None):
        """
        This data type represents the information you need to connect to an Amazon RDS DB instance. This data type is used as a response element in the following actions:
          +   ``CreateDBInstance`` 
          +   ``DescribeDBInstances`` 
          +   ``DeleteDBInstance`` 
          
         For the data structure that represents Amazon Aurora DB cluster endpoints, see ``DBClusterEndpoint``.
        :param builtins.str address: Specifies the DNS address of the DB instance.
        :param builtins.str hosted_zone_id: Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
        :param builtins.str port: Specifies the port that the database engine is listening on.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        Specifies the DNS address of the DB instance.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[builtins.str]:
        """
        Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
        """
        return pulumi.get(self, "hosted_zone_id")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.str]:
        """
        Specifies the port that the database engine is listening on.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DbInstanceMasterUserSecret(dict):
    """
    The ``MasterUserSecret`` return value specifies the secret managed by RDS in AWS Secrets Manager for the master user password.
     For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbInstanceMasterUserSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbInstanceMasterUserSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbInstanceMasterUserSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[builtins.str] = None,
                 secret_arn: Optional[builtins.str] = None):
        """
        The ``MasterUserSecret`` return value specifies the secret managed by RDS in AWS Secrets Manager for the master user password.
         For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
        :param builtins.str kms_key_id: The AWS KMS key identifier that is used to encrypt the secret.
        :param builtins.str secret_arn: The Amazon Resource Name (ARN) of the secret. This parameter is a return value that you can retrieve using the ``Fn::GetAtt`` intrinsic function. For more information, see [Return values](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#aws-resource-rds-dbinstance-return-values).
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        The AWS KMS key identifier that is used to encrypt the secret.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the secret. This parameter is a return value that you can retrieve using the ``Fn::GetAtt`` intrinsic function. For more information, see [Return values](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#aws-resource-rds-dbinstance-return-values).
        """
        return pulumi.get(self, "secret_arn")


@pulumi.output_type
class DbInstanceProcessorFeature(dict):
    """
    The ``ProcessorFeature`` property type specifies the processor features of a DB instance class.
    """
    def __init__(__self__, *,
                 name: Optional['DbInstanceProcessorFeatureName'] = None,
                 value: Optional[builtins.str] = None):
        """
        The ``ProcessorFeature`` property type specifies the processor features of a DB instance class.
        :param 'DbInstanceProcessorFeatureName' name: The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore``.
        :param builtins.str value: The value of a processor feature.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional['DbInstanceProcessorFeatureName']:
        """
        The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore``.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value of a processor feature.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DbProxyAuthFormat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authScheme":
            suggest = "auth_scheme"
        elif key == "clientPasswordAuthType":
            suggest = "client_password_auth_type"
        elif key == "iamAuth":
            suggest = "iam_auth"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbProxyAuthFormat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbProxyAuthFormat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbProxyAuthFormat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_scheme: Optional['DbProxyAuthFormatAuthScheme'] = None,
                 client_password_auth_type: Optional['DbProxyAuthFormatClientPasswordAuthType'] = None,
                 description: Optional[builtins.str] = None,
                 iam_auth: Optional['DbProxyAuthFormatIamAuth'] = None,
                 secret_arn: Optional[builtins.str] = None):
        """
        :param 'DbProxyAuthFormatAuthScheme' auth_scheme: The type of authentication that the proxy uses for connections from the proxy to the underlying database. 
        :param 'DbProxyAuthFormatClientPasswordAuthType' client_password_auth_type: The type of authentication the proxy uses for connections from clients.
        :param builtins.str description: A user-specified description about the authentication used by a proxy to log in as a specific database user. 
        :param 'DbProxyAuthFormatIamAuth' iam_auth: Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy. The ENABLED value is valid only for proxies with RDS for Microsoft SQL Server.
        :param builtins.str secret_arn: The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager. 
        """
        if auth_scheme is not None:
            pulumi.set(__self__, "auth_scheme", auth_scheme)
        if client_password_auth_type is not None:
            pulumi.set(__self__, "client_password_auth_type", client_password_auth_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if iam_auth is not None:
            pulumi.set(__self__, "iam_auth", iam_auth)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)

    @property
    @pulumi.getter(name="authScheme")
    def auth_scheme(self) -> Optional['DbProxyAuthFormatAuthScheme']:
        """
        The type of authentication that the proxy uses for connections from the proxy to the underlying database. 
        """
        return pulumi.get(self, "auth_scheme")

    @property
    @pulumi.getter(name="clientPasswordAuthType")
    def client_password_auth_type(self) -> Optional['DbProxyAuthFormatClientPasswordAuthType']:
        """
        The type of authentication the proxy uses for connections from clients.
        """
        return pulumi.get(self, "client_password_auth_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A user-specified description about the authentication used by a proxy to log in as a specific database user. 
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="iamAuth")
    def iam_auth(self) -> Optional['DbProxyAuthFormatIamAuth']:
        """
        Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy. The ENABLED value is valid only for proxies with RDS for Microsoft SQL Server.
        """
        return pulumi.get(self, "iam_auth")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager. 
        """
        return pulumi.get(self, "secret_arn")


@pulumi.output_type
class DbProxyTargetGroupConnectionPoolConfigurationInfoFormat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionBorrowTimeout":
            suggest = "connection_borrow_timeout"
        elif key == "initQuery":
            suggest = "init_query"
        elif key == "maxConnectionsPercent":
            suggest = "max_connections_percent"
        elif key == "maxIdleConnectionsPercent":
            suggest = "max_idle_connections_percent"
        elif key == "sessionPinningFilters":
            suggest = "session_pinning_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DbProxyTargetGroupConnectionPoolConfigurationInfoFormat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DbProxyTargetGroupConnectionPoolConfigurationInfoFormat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DbProxyTargetGroupConnectionPoolConfigurationInfoFormat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_borrow_timeout: Optional[builtins.int] = None,
                 init_query: Optional[builtins.str] = None,
                 max_connections_percent: Optional[builtins.int] = None,
                 max_idle_connections_percent: Optional[builtins.int] = None,
                 session_pinning_filters: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int connection_borrow_timeout: The number of seconds for a proxy to wait for a connection to become available in the connection pool.
        :param builtins.str init_query: One or more SQL statements for the proxy to run when opening each new database connection.
        :param builtins.int max_connections_percent: The maximum size of the connection pool for each target in a target group.
        :param builtins.int max_idle_connections_percent: Controls how actively the proxy closes idle database connections in the connection pool.
        :param Sequence[builtins.str] session_pinning_filters: Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection.
        """
        if connection_borrow_timeout is not None:
            pulumi.set(__self__, "connection_borrow_timeout", connection_borrow_timeout)
        if init_query is not None:
            pulumi.set(__self__, "init_query", init_query)
        if max_connections_percent is not None:
            pulumi.set(__self__, "max_connections_percent", max_connections_percent)
        if max_idle_connections_percent is not None:
            pulumi.set(__self__, "max_idle_connections_percent", max_idle_connections_percent)
        if session_pinning_filters is not None:
            pulumi.set(__self__, "session_pinning_filters", session_pinning_filters)

    @property
    @pulumi.getter(name="connectionBorrowTimeout")
    def connection_borrow_timeout(self) -> Optional[builtins.int]:
        """
        The number of seconds for a proxy to wait for a connection to become available in the connection pool.
        """
        return pulumi.get(self, "connection_borrow_timeout")

    @property
    @pulumi.getter(name="initQuery")
    def init_query(self) -> Optional[builtins.str]:
        """
        One or more SQL statements for the proxy to run when opening each new database connection.
        """
        return pulumi.get(self, "init_query")

    @property
    @pulumi.getter(name="maxConnectionsPercent")
    def max_connections_percent(self) -> Optional[builtins.int]:
        """
        The maximum size of the connection pool for each target in a target group.
        """
        return pulumi.get(self, "max_connections_percent")

    @property
    @pulumi.getter(name="maxIdleConnectionsPercent")
    def max_idle_connections_percent(self) -> Optional[builtins.int]:
        """
        Controls how actively the proxy closes idle database connections in the connection pool.
        """
        return pulumi.get(self, "max_idle_connections_percent")

    @property
    @pulumi.getter(name="sessionPinningFilters")
    def session_pinning_filters(self) -> Optional[Sequence[builtins.str]]:
        """
        Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection.
        """
        return pulumi.get(self, "session_pinning_filters")


@pulumi.output_type
class GlobalClusterGlobalEndpoint(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None):
        """
        :param builtins.str address: The writer endpoint for the global database cluster. This endpoint always points to the writer DB instance in the current primary cluster.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The writer endpoint for the global database cluster. This endpoint always points to the writer DB instance in the current primary cluster.
        """
        return pulumi.get(self, "address")


@pulumi.output_type
class OptionGroupOptionConfiguration(dict):
    """
    The ``OptionConfiguration`` property type specifies an individual option, and its settings, within an ``AWS::RDS::OptionGroup`` resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "optionName":
            suggest = "option_name"
        elif key == "dbSecurityGroupMemberships":
            suggest = "db_security_group_memberships"
        elif key == "optionSettings":
            suggest = "option_settings"
        elif key == "optionVersion":
            suggest = "option_version"
        elif key == "vpcSecurityGroupMemberships":
            suggest = "vpc_security_group_memberships"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptionGroupOptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptionGroupOptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptionGroupOptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 option_name: builtins.str,
                 db_security_group_memberships: Optional[Sequence[builtins.str]] = None,
                 option_settings: Optional[Sequence['outputs.OptionGroupOptionSetting']] = None,
                 option_version: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 vpc_security_group_memberships: Optional[Sequence[builtins.str]] = None):
        """
        The ``OptionConfiguration`` property type specifies an individual option, and its settings, within an ``AWS::RDS::OptionGroup`` resource.
        :param builtins.str option_name: The configuration of options to include in a group.
        :param Sequence[builtins.str] db_security_group_memberships: A list of DB security groups used for this option.
        :param Sequence['OptionGroupOptionSetting'] option_settings: The option settings to include in an option group.
        :param builtins.str option_version: The version for the option.
        :param builtins.int port: The optional port for the option.
        :param Sequence[builtins.str] vpc_security_group_memberships: A list of VPC security group names used for this option.
        """
        pulumi.set(__self__, "option_name", option_name)
        if db_security_group_memberships is not None:
            pulumi.set(__self__, "db_security_group_memberships", db_security_group_memberships)
        if option_settings is not None:
            pulumi.set(__self__, "option_settings", option_settings)
        if option_version is not None:
            pulumi.set(__self__, "option_version", option_version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if vpc_security_group_memberships is not None:
            pulumi.set(__self__, "vpc_security_group_memberships", vpc_security_group_memberships)

    @property
    @pulumi.getter(name="optionName")
    def option_name(self) -> builtins.str:
        """
        The configuration of options to include in a group.
        """
        return pulumi.get(self, "option_name")

    @property
    @pulumi.getter(name="dbSecurityGroupMemberships")
    def db_security_group_memberships(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of DB security groups used for this option.
        """
        return pulumi.get(self, "db_security_group_memberships")

    @property
    @pulumi.getter(name="optionSettings")
    def option_settings(self) -> Optional[Sequence['outputs.OptionGroupOptionSetting']]:
        """
        The option settings to include in an option group.
        """
        return pulumi.get(self, "option_settings")

    @property
    @pulumi.getter(name="optionVersion")
    def option_version(self) -> Optional[builtins.str]:
        """
        The version for the option.
        """
        return pulumi.get(self, "option_version")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The optional port for the option.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="vpcSecurityGroupMemberships")
    def vpc_security_group_memberships(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of VPC security group names used for this option.
        """
        return pulumi.get(self, "vpc_security_group_memberships")


@pulumi.output_type
class OptionGroupOptionSetting(dict):
    """
    The ``OptionSetting`` property type specifies the value for an option within an ``OptionSetting`` property.
    """
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        The ``OptionSetting`` property type specifies the value for an option within an ``OptionSetting`` property.
        :param builtins.str name: The name of the option that has settings that you can set.
        :param builtins.str value: The current value of the option setting.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the option that has settings that you can set.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The current value of the option setting.
        """
        return pulumi.get(self, "value")


