# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetDbSubnetGroupResult',
    'AwaitableGetDbSubnetGroupResult',
    'get_db_subnet_group',
    'get_db_subnet_group_output',
]

@pulumi.output_type
class GetDbSubnetGroupResult:
    def __init__(__self__, db_subnet_group_description=None, subnet_ids=None, tags=None):
        if db_subnet_group_description and not isinstance(db_subnet_group_description, str):
            raise TypeError("Expected argument 'db_subnet_group_description' to be a str")
        pulumi.set(__self__, "db_subnet_group_description", db_subnet_group_description)
        if subnet_ids and not isinstance(subnet_ids, list):
            raise TypeError("Expected argument 'subnet_ids' to be a list")
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dbSubnetGroupDescription")
    def db_subnet_group_description(self) -> Optional[builtins.str]:
        """
        The description for the DB subnet group.
        """
        return pulumi.get(self, "db_subnet_group_description")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The EC2 Subnet IDs for the DB subnet group.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Tags to assign to the DB subnet group.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDbSubnetGroupResult(GetDbSubnetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbSubnetGroupResult(
            db_subnet_group_description=self.db_subnet_group_description,
            subnet_ids=self.subnet_ids,
            tags=self.tags)


def get_db_subnet_group(db_subnet_group_name: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbSubnetGroupResult:
    """
    The ``AWS::RDS::DBSubnetGroup`` resource creates a database subnet group. Subnet groups must contain at least two subnets in two different Availability Zones in the same region.
     For more information, see [Working with DB subnet groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Subnets) in the *Amazon RDS User Guide*.


    :param builtins.str db_subnet_group_name: The name for the DB subnet group. This value is stored as a lowercase string.
            Constraints:
             +  Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens.
             +  Must not be default.
             +  First character must be a letter.
             
            Example: ``mydbsubnetgroup``
    """
    __args__ = dict()
    __args__['dbSubnetGroupName'] = db_subnet_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:rds:getDbSubnetGroup', __args__, opts=opts, typ=GetDbSubnetGroupResult).value

    return AwaitableGetDbSubnetGroupResult(
        db_subnet_group_description=pulumi.get(__ret__, 'db_subnet_group_description'),
        subnet_ids=pulumi.get(__ret__, 'subnet_ids'),
        tags=pulumi.get(__ret__, 'tags'))
def get_db_subnet_group_output(db_subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbSubnetGroupResult]:
    """
    The ``AWS::RDS::DBSubnetGroup`` resource creates a database subnet group. Subnet groups must contain at least two subnets in two different Availability Zones in the same region.
     For more information, see [Working with DB subnet groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Subnets) in the *Amazon RDS User Guide*.


    :param builtins.str db_subnet_group_name: The name for the DB subnet group. This value is stored as a lowercase string.
            Constraints:
             +  Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens.
             +  Must not be default.
             +  First character must be a letter.
             
            Example: ``mydbsubnetgroup``
    """
    __args__ = dict()
    __args__['dbSubnetGroupName'] = db_subnet_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:rds:getDbSubnetGroup', __args__, opts=opts, typ=GetDbSubnetGroupResult)
    return __ret__.apply(lambda __response__: GetDbSubnetGroupResult(
        db_subnet_group_description=pulumi.get(__response__, 'db_subnet_group_description'),
        subnet_ids=pulumi.get(__response__, 'subnet_ids'),
        tags=pulumi.get(__response__, 'tags')))
