# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetDbShardGroupResult',
    'AwaitableGetDbShardGroupResult',
    'get_db_shard_group',
    'get_db_shard_group_output',
]

@pulumi.output_type
class GetDbShardGroupResult:
    def __init__(__self__, compute_redundancy=None, db_shard_group_resource_id=None, endpoint=None, max_acu=None, tags=None):
        if compute_redundancy and not isinstance(compute_redundancy, int):
            raise TypeError("Expected argument 'compute_redundancy' to be a int")
        pulumi.set(__self__, "compute_redundancy", compute_redundancy)
        if db_shard_group_resource_id and not isinstance(db_shard_group_resource_id, str):
            raise TypeError("Expected argument 'db_shard_group_resource_id' to be a str")
        pulumi.set(__self__, "db_shard_group_resource_id", db_shard_group_resource_id)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if max_acu and not isinstance(max_acu, float):
            raise TypeError("Expected argument 'max_acu' to be a float")
        pulumi.set(__self__, "max_acu", max_acu)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="computeRedundancy")
    def compute_redundancy(self) -> Optional[builtins.int]:
        """
        Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the following:
          +  0 - Creates a DB shard group without a standby DB shard group. This is the default value.
          +  1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).
          +  2 - Creates a DB shard group with two standby DB shard groups in two different AZs.
        """
        return pulumi.get(self, "compute_redundancy")

    @property
    @pulumi.getter(name="dbShardGroupResourceId")
    def db_shard_group_resource_id(self) -> Optional[builtins.str]:
        """
        The AWS Region -unique, immutable identifier for the DB shard group.
        """
        return pulumi.get(self, "db_shard_group_resource_id")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[builtins.str]:
        """
        This data type represents the information you need to connect to an Amazon RDS DB instance. This data type is used as a response element in the following actions:

        - `CreateDBInstance`
        - `DescribeDBInstances`
        - `DeleteDBInstance`

        For the data structure that represents Amazon Aurora DB cluster endpoints, see `DBClusterEndpoint` .
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="maxAcu")
    def max_acu(self) -> Optional[builtins.float]:
        """
        The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
        """
        return pulumi.get(self, "max_acu")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An optional set of key-value pairs to associate arbitrary data of your choosing with the DB shard group.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDbShardGroupResult(GetDbShardGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbShardGroupResult(
            compute_redundancy=self.compute_redundancy,
            db_shard_group_resource_id=self.db_shard_group_resource_id,
            endpoint=self.endpoint,
            max_acu=self.max_acu,
            tags=self.tags)


def get_db_shard_group(db_shard_group_identifier: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbShardGroupResult:
    """
    Creates a new DB shard group for Aurora Limitless Database. You must enable Aurora Limitless Database to create a DB shard group.
     Valid for: Aurora DB clusters only


    :param builtins.str db_shard_group_identifier: The name of the DB shard group.
    """
    __args__ = dict()
    __args__['dbShardGroupIdentifier'] = db_shard_group_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:rds:getDbShardGroup', __args__, opts=opts, typ=GetDbShardGroupResult).value

    return AwaitableGetDbShardGroupResult(
        compute_redundancy=pulumi.get(__ret__, 'compute_redundancy'),
        db_shard_group_resource_id=pulumi.get(__ret__, 'db_shard_group_resource_id'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        max_acu=pulumi.get(__ret__, 'max_acu'),
        tags=pulumi.get(__ret__, 'tags'))
def get_db_shard_group_output(db_shard_group_identifier: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbShardGroupResult]:
    """
    Creates a new DB shard group for Aurora Limitless Database. You must enable Aurora Limitless Database to create a DB shard group.
     Valid for: Aurora DB clusters only


    :param builtins.str db_shard_group_identifier: The name of the DB shard group.
    """
    __args__ = dict()
    __args__['dbShardGroupIdentifier'] = db_shard_group_identifier
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:rds:getDbShardGroup', __args__, opts=opts, typ=GetDbShardGroupResult)
    return __ret__.apply(lambda __response__: GetDbShardGroupResult(
        compute_redundancy=pulumi.get(__response__, 'compute_redundancy'),
        db_shard_group_resource_id=pulumi.get(__response__, 'db_shard_group_resource_id'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        max_acu=pulumi.get(__response__, 'max_acu'),
        tags=pulumi.get(__response__, 'tags')))
