# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbProxyTargetGroupResult',
    'AwaitableGetDbProxyTargetGroupResult',
    'get_db_proxy_target_group',
    'get_db_proxy_target_group_output',
]

@pulumi.output_type
class GetDbProxyTargetGroupResult:
    def __init__(__self__, connection_pool_configuration_info=None, db_cluster_identifiers=None, db_instance_identifiers=None, target_group_arn=None):
        if connection_pool_configuration_info and not isinstance(connection_pool_configuration_info, dict):
            raise TypeError("Expected argument 'connection_pool_configuration_info' to be a dict")
        pulumi.set(__self__, "connection_pool_configuration_info", connection_pool_configuration_info)
        if db_cluster_identifiers and not isinstance(db_cluster_identifiers, list):
            raise TypeError("Expected argument 'db_cluster_identifiers' to be a list")
        pulumi.set(__self__, "db_cluster_identifiers", db_cluster_identifiers)
        if db_instance_identifiers and not isinstance(db_instance_identifiers, list):
            raise TypeError("Expected argument 'db_instance_identifiers' to be a list")
        pulumi.set(__self__, "db_instance_identifiers", db_instance_identifiers)
        if target_group_arn and not isinstance(target_group_arn, str):
            raise TypeError("Expected argument 'target_group_arn' to be a str")
        pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter(name="connectionPoolConfigurationInfo")
    def connection_pool_configuration_info(self) -> Optional['outputs.DbProxyTargetGroupConnectionPoolConfigurationInfoFormat']:
        """
        Displays the settings that control the size and behavior of the connection pool associated with a `DBProxyTarget` .
        """
        return pulumi.get(self, "connection_pool_configuration_info")

    @property
    @pulumi.getter(name="dbClusterIdentifiers")
    def db_cluster_identifiers(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more DB cluster identifiers.
        """
        return pulumi.get(self, "db_cluster_identifiers")

    @property
    @pulumi.getter(name="dbInstanceIdentifiers")
    def db_instance_identifiers(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more DB instance identifiers.
        """
        return pulumi.get(self, "db_instance_identifiers")

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) representing the target group.
        """
        return pulumi.get(self, "target_group_arn")


class AwaitableGetDbProxyTargetGroupResult(GetDbProxyTargetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbProxyTargetGroupResult(
            connection_pool_configuration_info=self.connection_pool_configuration_info,
            db_cluster_identifiers=self.db_cluster_identifiers,
            db_instance_identifiers=self.db_instance_identifiers,
            target_group_arn=self.target_group_arn)


def get_db_proxy_target_group(target_group_arn: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbProxyTargetGroupResult:
    """
    Resource schema for AWS::RDS::DBProxyTargetGroup


    :param builtins.str target_group_arn: The Amazon Resource Name (ARN) representing the target group.
    """
    __args__ = dict()
    __args__['targetGroupArn'] = target_group_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:rds:getDbProxyTargetGroup', __args__, opts=opts, typ=GetDbProxyTargetGroupResult).value

    return AwaitableGetDbProxyTargetGroupResult(
        connection_pool_configuration_info=pulumi.get(__ret__, 'connection_pool_configuration_info'),
        db_cluster_identifiers=pulumi.get(__ret__, 'db_cluster_identifiers'),
        db_instance_identifiers=pulumi.get(__ret__, 'db_instance_identifiers'),
        target_group_arn=pulumi.get(__ret__, 'target_group_arn'))
def get_db_proxy_target_group_output(target_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbProxyTargetGroupResult]:
    """
    Resource schema for AWS::RDS::DBProxyTargetGroup


    :param builtins.str target_group_arn: The Amazon Resource Name (ARN) representing the target group.
    """
    __args__ = dict()
    __args__['targetGroupArn'] = target_group_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:rds:getDbProxyTargetGroup', __args__, opts=opts, typ=GetDbProxyTargetGroupResult)
    return __ret__.apply(lambda __response__: GetDbProxyTargetGroupResult(
        connection_pool_configuration_info=pulumi.get(__response__, 'connection_pool_configuration_info'),
        db_cluster_identifiers=pulumi.get(__response__, 'db_cluster_identifiers'),
        db_instance_identifiers=pulumi.get(__response__, 'db_instance_identifiers'),
        target_group_arn=pulumi.get(__response__, 'target_group_arn')))
