# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetDbClusterParameterGroupResult',
    'AwaitableGetDbClusterParameterGroupResult',
    'get_db_cluster_parameter_group',
    'get_db_cluster_parameter_group_output',
]

@pulumi.output_type
class GetDbClusterParameterGroupResult:
    def __init__(__self__, parameters=None, tags=None):
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        Provides a list of parameters for the DB cluster parameter group.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::RDS::DBClusterParameterGroup` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Tags to assign to the DB cluster parameter group.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDbClusterParameterGroupResult(GetDbClusterParameterGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbClusterParameterGroupResult(
            parameters=self.parameters,
            tags=self.tags)


def get_db_cluster_parameter_group(db_cluster_parameter_group_name: Optional[builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbClusterParameterGroupResult:
    """
    The ``AWS::RDS::DBClusterParameterGroup`` resource creates a new Amazon RDS DB cluster parameter group.
     For information about configuring parameters for Amazon Aurora DB clusters, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide*.
      If you apply a parameter group to a DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
     If you apply a change to parameter group associated with a stopped DB cluster, then the updated stack waits until the DB cluster is started.


    :param builtins.str db_cluster_parameter_group_name: The name of the DB cluster parameter group.
            Constraints:
             +  Must not match the name of an existing DB cluster parameter group.
             
             This value is stored as a lowercase string.
    """
    __args__ = dict()
    __args__['dbClusterParameterGroupName'] = db_cluster_parameter_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:rds:getDbClusterParameterGroup', __args__, opts=opts, typ=GetDbClusterParameterGroupResult).value

    return AwaitableGetDbClusterParameterGroupResult(
        parameters=pulumi.get(__ret__, 'parameters'),
        tags=pulumi.get(__ret__, 'tags'))
def get_db_cluster_parameter_group_output(db_cluster_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbClusterParameterGroupResult]:
    """
    The ``AWS::RDS::DBClusterParameterGroup`` resource creates a new Amazon RDS DB cluster parameter group.
     For information about configuring parameters for Amazon Aurora DB clusters, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide*.
      If you apply a parameter group to a DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
     If you apply a change to parameter group associated with a stopped DB cluster, then the updated stack waits until the DB cluster is started.


    :param builtins.str db_cluster_parameter_group_name: The name of the DB cluster parameter group.
            Constraints:
             +  Must not match the name of an existing DB cluster parameter group.
             
             This value is stored as a lowercase string.
    """
    __args__ = dict()
    __args__['dbClusterParameterGroupName'] = db_cluster_parameter_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:rds:getDbClusterParameterGroup', __args__, opts=opts, typ=GetDbClusterParameterGroupResult)
    return __ret__.apply(lambda __response__: GetDbClusterParameterGroupResult(
        parameters=pulumi.get(__response__, 'parameters'),
        tags=pulumi.get(__response__, 'tags')))
