# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetCustomDbEngineVersionResult',
    'AwaitableGetCustomDbEngineVersionResult',
    'get_custom_db_engine_version',
    'get_custom_db_engine_version_output',
]

@pulumi.output_type
class GetCustomDbEngineVersionResult:
    def __init__(__self__, db_engine_version_arn=None, description=None, status=None, tags=None):
        if db_engine_version_arn and not isinstance(db_engine_version_arn, str):
            raise TypeError("Expected argument 'db_engine_version_arn' to be a str")
        pulumi.set(__self__, "db_engine_version_arn", db_engine_version_arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dbEngineVersionArn")
    def db_engine_version_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the custom engine version.
        """
        return pulumi.get(self, "db_engine_version_arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        An optional description of your CEV.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional['CustomDbEngineVersionStatus']:
        """
        A value that indicates the status of a custom engine version (CEV).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
        """
        return pulumi.get(self, "tags")


class AwaitableGetCustomDbEngineVersionResult(GetCustomDbEngineVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomDbEngineVersionResult(
            db_engine_version_arn=self.db_engine_version_arn,
            description=self.description,
            status=self.status,
            tags=self.tags)


def get_custom_db_engine_version(engine: Optional[builtins.str] = None,
                                 engine_version: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomDbEngineVersionResult:
    """
    Creates a custom DB engine version (CEV).


    :param builtins.str engine: The database engine to use for your custom engine version (CEV).
            Valid values:
             +   ``custom-oracle-ee`` 
             +   ``custom-oracle-ee-cdb``
    :param builtins.str engine_version: The name of your CEV. The name format is ``major version.customized_string``. For example, a valid CEV name is ``19.my_cev1``. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of ``Engine`` and ``EngineVersion`` is unique per customer per Region.
             *Constraints:* Minimum length is 1. Maximum length is 60.
             *Pattern:* ``^[a-z0-9_.-]{1,60$``}
    """
    __args__ = dict()
    __args__['engine'] = engine
    __args__['engineVersion'] = engine_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:rds:getCustomDbEngineVersion', __args__, opts=opts, typ=GetCustomDbEngineVersionResult).value

    return AwaitableGetCustomDbEngineVersionResult(
        db_engine_version_arn=pulumi.get(__ret__, 'db_engine_version_arn'),
        description=pulumi.get(__ret__, 'description'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_custom_db_engine_version_output(engine: Optional[pulumi.Input[builtins.str]] = None,
                                        engine_version: Optional[pulumi.Input[builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomDbEngineVersionResult]:
    """
    Creates a custom DB engine version (CEV).


    :param builtins.str engine: The database engine to use for your custom engine version (CEV).
            Valid values:
             +   ``custom-oracle-ee`` 
             +   ``custom-oracle-ee-cdb``
    :param builtins.str engine_version: The name of your CEV. The name format is ``major version.customized_string``. For example, a valid CEV name is ``19.my_cev1``. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of ``Engine`` and ``EngineVersion`` is unique per customer per Region.
             *Constraints:* Minimum length is 1. Maximum length is 60.
             *Pattern:* ``^[a-z0-9_.-]{1,60$``}
    """
    __args__ = dict()
    __args__['engine'] = engine
    __args__['engineVersion'] = engine_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:rds:getCustomDbEngineVersion', __args__, opts=opts, typ=GetCustomDbEngineVersionResult)
    return __ret__.apply(lambda __response__: GetCustomDbEngineVersionResult(
        db_engine_version_arn=pulumi.get(__response__, 'db_engine_version_arn'),
        description=pulumi.get(__response__, 'description'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
