# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['DbShardGroupArgs', 'DbShardGroup']

@pulumi.input_type
class DbShardGroupArgs:
    def __init__(__self__, *,
                 db_cluster_identifier: pulumi.Input[builtins.str],
                 max_acu: pulumi.Input[builtins.float],
                 compute_redundancy: Optional[pulumi.Input[builtins.int]] = None,
                 db_shard_group_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 min_acu: Optional[pulumi.Input[builtins.float]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DbShardGroup resource.
        :param pulumi.Input[builtins.str] db_cluster_identifier: The name of the primary DB cluster for the DB shard group.
        :param pulumi.Input[builtins.float] max_acu: The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
        :param pulumi.Input[builtins.int] compute_redundancy: Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the following:
                 +  0 - Creates a DB shard group without a standby DB shard group. This is the default value.
                 +  1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).
                 +  2 - Creates a DB shard group with two standby DB shard groups in two different AZs.
        :param pulumi.Input[builtins.str] db_shard_group_identifier: The name of the DB shard group.
        :param pulumi.Input[builtins.float] min_acu: The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
        :param pulumi.Input[builtins.bool] publicly_accessible: Specifies whether the DB shard group is publicly accessible.
                When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB shard group doesn't permit it.
                When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.
                Default: The default behavior varies depending on whether ``DBSubnetGroupName`` is specified.
                If ``DBSubnetGroupName`` isn't specified, and ``PubliclyAccessible`` isn't specified, the following applies:
                 +  If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard group is private.
                 +  If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is public.
                 
                If ``DBSubnetGroupName`` is specified, and ``PubliclyAccessible`` isn't specified, the following applies:
                 +  If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard group is private.
                 +  If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is public.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An optional set of key-value pairs to associate arbitrary data of your choosing with the DB shard group.
        """
        pulumi.set(__self__, "db_cluster_identifier", db_cluster_identifier)
        pulumi.set(__self__, "max_acu", max_acu)
        if compute_redundancy is not None:
            pulumi.set(__self__, "compute_redundancy", compute_redundancy)
        if db_shard_group_identifier is not None:
            pulumi.set(__self__, "db_shard_group_identifier", db_shard_group_identifier)
        if min_acu is not None:
            pulumi.set(__self__, "min_acu", min_acu)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> pulumi.Input[builtins.str]:
        """
        The name of the primary DB cluster for the DB shard group.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @db_cluster_identifier.setter
    def db_cluster_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_cluster_identifier", value)

    @property
    @pulumi.getter(name="maxAcu")
    def max_acu(self) -> pulumi.Input[builtins.float]:
        """
        The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
        """
        return pulumi.get(self, "max_acu")

    @max_acu.setter
    def max_acu(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "max_acu", value)

    @property
    @pulumi.getter(name="computeRedundancy")
    def compute_redundancy(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the following:
          +  0 - Creates a DB shard group without a standby DB shard group. This is the default value.
          +  1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).
          +  2 - Creates a DB shard group with two standby DB shard groups in two different AZs.
        """
        return pulumi.get(self, "compute_redundancy")

    @compute_redundancy.setter
    def compute_redundancy(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "compute_redundancy", value)

    @property
    @pulumi.getter(name="dbShardGroupIdentifier")
    def db_shard_group_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the DB shard group.
        """
        return pulumi.get(self, "db_shard_group_identifier")

    @db_shard_group_identifier.setter
    def db_shard_group_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_shard_group_identifier", value)

    @property
    @pulumi.getter(name="minAcu")
    def min_acu(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
        """
        return pulumi.get(self, "min_acu")

    @min_acu.setter
    def min_acu(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "min_acu", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the DB shard group is publicly accessible.
         When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB shard group doesn't permit it.
         When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.
         Default: The default behavior varies depending on whether ``DBSubnetGroupName`` is specified.
         If ``DBSubnetGroupName`` isn't specified, and ``PubliclyAccessible`` isn't specified, the following applies:
          +  If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard group is private.
          +  If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is public.
          
         If ``DBSubnetGroupName`` is specified, and ``PubliclyAccessible`` isn't specified, the following applies:
          +  If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard group is private.
          +  If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is public.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An optional set of key-value pairs to associate arbitrary data of your choosing with the DB shard group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:rds:DbShardGroup")
class DbShardGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_redundancy: Optional[pulumi.Input[builtins.int]] = None,
                 db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_shard_group_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 max_acu: Optional[pulumi.Input[builtins.float]] = None,
                 min_acu: Optional[pulumi.Input[builtins.float]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Creates a new DB shard group for Aurora Limitless Database. You must enable Aurora Limitless Database to create a DB shard group.
         Valid for: Aurora DB clusters only

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] compute_redundancy: Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the following:
                 +  0 - Creates a DB shard group without a standby DB shard group. This is the default value.
                 +  1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).
                 +  2 - Creates a DB shard group with two standby DB shard groups in two different AZs.
        :param pulumi.Input[builtins.str] db_cluster_identifier: The name of the primary DB cluster for the DB shard group.
        :param pulumi.Input[builtins.str] db_shard_group_identifier: The name of the DB shard group.
        :param pulumi.Input[builtins.float] max_acu: The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
        :param pulumi.Input[builtins.float] min_acu: The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
        :param pulumi.Input[builtins.bool] publicly_accessible: Specifies whether the DB shard group is publicly accessible.
                When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB shard group doesn't permit it.
                When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.
                Default: The default behavior varies depending on whether ``DBSubnetGroupName`` is specified.
                If ``DBSubnetGroupName`` isn't specified, and ``PubliclyAccessible`` isn't specified, the following applies:
                 +  If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard group is private.
                 +  If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is public.
                 
                If ``DBSubnetGroupName`` is specified, and ``PubliclyAccessible`` isn't specified, the following applies:
                 +  If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard group is private.
                 +  If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is public.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An optional set of key-value pairs to associate arbitrary data of your choosing with the DB shard group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbShardGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new DB shard group for Aurora Limitless Database. You must enable Aurora Limitless Database to create a DB shard group.
         Valid for: Aurora DB clusters only

        :param str resource_name: The name of the resource.
        :param DbShardGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbShardGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_redundancy: Optional[pulumi.Input[builtins.int]] = None,
                 db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_shard_group_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 max_acu: Optional[pulumi.Input[builtins.float]] = None,
                 min_acu: Optional[pulumi.Input[builtins.float]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbShardGroupArgs.__new__(DbShardGroupArgs)

            __props__.__dict__["compute_redundancy"] = compute_redundancy
            if db_cluster_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'db_cluster_identifier'")
            __props__.__dict__["db_cluster_identifier"] = db_cluster_identifier
            __props__.__dict__["db_shard_group_identifier"] = db_shard_group_identifier
            if max_acu is None and not opts.urn:
                raise TypeError("Missing required property 'max_acu'")
            __props__.__dict__["max_acu"] = max_acu
            __props__.__dict__["min_acu"] = min_acu
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            __props__.__dict__["tags"] = tags
            __props__.__dict__["db_shard_group_resource_id"] = None
            __props__.__dict__["endpoint"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["dbClusterIdentifier", "dbShardGroupIdentifier", "publiclyAccessible"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DbShardGroup, __self__).__init__(
            'aws-native:rds:DbShardGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DbShardGroup':
        """
        Get an existing DbShardGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DbShardGroupArgs.__new__(DbShardGroupArgs)

        __props__.__dict__["compute_redundancy"] = None
        __props__.__dict__["db_cluster_identifier"] = None
        __props__.__dict__["db_shard_group_identifier"] = None
        __props__.__dict__["db_shard_group_resource_id"] = None
        __props__.__dict__["endpoint"] = None
        __props__.__dict__["max_acu"] = None
        __props__.__dict__["min_acu"] = None
        __props__.__dict__["publicly_accessible"] = None
        __props__.__dict__["tags"] = None
        return DbShardGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="computeRedundancy")
    def compute_redundancy(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the following:
          +  0 - Creates a DB shard group without a standby DB shard group. This is the default value.
          +  1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).
          +  2 - Creates a DB shard group with two standby DB shard groups in two different AZs.
        """
        return pulumi.get(self, "compute_redundancy")

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> pulumi.Output[builtins.str]:
        """
        The name of the primary DB cluster for the DB shard group.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @property
    @pulumi.getter(name="dbShardGroupIdentifier")
    def db_shard_group_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the DB shard group.
        """
        return pulumi.get(self, "db_shard_group_identifier")

    @property
    @pulumi.getter(name="dbShardGroupResourceId")
    def db_shard_group_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The AWS Region -unique, immutable identifier for the DB shard group.
        """
        return pulumi.get(self, "db_shard_group_resource_id")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[builtins.str]:
        """
        This data type represents the information you need to connect to an Amazon RDS DB instance. This data type is used as a response element in the following actions:

        - `CreateDBInstance`
        - `DescribeDBInstances`
        - `DeleteDBInstance`

        For the data structure that represents Amazon Aurora DB cluster endpoints, see `DBClusterEndpoint` .
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="maxAcu")
    def max_acu(self) -> pulumi.Output[builtins.float]:
        """
        The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
        """
        return pulumi.get(self, "max_acu")

    @property
    @pulumi.getter(name="minAcu")
    def min_acu(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
        """
        return pulumi.get(self, "min_acu")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the DB shard group is publicly accessible.
         When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB shard group doesn't permit it.
         When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.
         Default: The default behavior varies depending on whether ``DBSubnetGroupName`` is specified.
         If ``DBSubnetGroupName`` isn't specified, and ``PubliclyAccessible`` isn't specified, the following applies:
          +  If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB shard group is private.
          +  If the default VPC in the target Region has an internet gateway attached to it, the DB shard group is public.
          
         If ``DBSubnetGroupName`` is specified, and ``PubliclyAccessible`` isn't specified, the following applies:
          +  If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB shard group is private.
          +  If the subnets are part of a VPC that has an internet gateway attached to it, the DB shard group is public.
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An optional set of key-value pairs to associate arbitrary data of your choosing with the DB shard group.
        """
        return pulumi.get(self, "tags")

