# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['DbParameterGroupArgs', 'DbParameterGroup']

@pulumi.input_type
class DbParameterGroupArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 family: pulumi.Input[builtins.str],
                 db_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[Any] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DbParameterGroup resource.
        :param pulumi.Input[builtins.str] description: Provides the customer-specified description for this DB parameter group.
        :param pulumi.Input[builtins.str] family: The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.
                To list all of the available parameter group families for a DB engine, use the following command:
                 ``aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine <engine>`` 
                For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:
                 ``aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine mysql`` 
                 The output contains duplicates.
                 The following are the valid DB engine values:
                 +   ``aurora-mysql`` 
                 +   ``aurora-postgresql`` 
                 +   ``db2-ae`` 
                 +   ``db2-se`` 
                 +   ``mysql`` 
                 +   ``oracle-ee`` 
                 +   ``oracle-ee-cdb`` 
                 +   ``oracle-se2`` 
                 +   ``oracle-se2-cdb`` 
                 +   ``postgres`` 
                 +   ``sqlserver-ee`` 
                 +   ``sqlserver-se`` 
                 +   ``sqlserver-ex`` 
                 +   ``sqlserver-web``
        :param pulumi.Input[builtins.str] db_parameter_group_name: The name of the DB parameter group.
                Constraints:
                 +  Must be 1 to 255 letters, numbers, or hyphens.
                 +  First character must be a letter
                 +  Can't end with a hyphen or contain two consecutive hyphens
                 
                If you don't specify a value for ``DBParameterGroupName`` property, a name is automatically created for the DB parameter group.
                 This value is stored as a lowercase string.
        :param Any parameters: A mapping of parameter names and values for the parameter update. You must specify at least one parameter name and value.
                For more information about parameter groups, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide*, or [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide*.
                 AWS CloudFormation doesn't support specifying an apply method for each individual parameter. The default apply method for each parameter is used.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::RDS::DBParameterGroup` for more information about the expected schema for this property.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Tags to assign to the DB parameter group.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "family", family)
        if db_parameter_group_name is not None:
            pulumi.set(__self__, "db_parameter_group_name", db_parameter_group_name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        Provides the customer-specified description for this DB parameter group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def family(self) -> pulumi.Input[builtins.str]:
        """
        The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.
         To list all of the available parameter group families for a DB engine, use the following command:
          ``aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine <engine>`` 
         For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:
          ``aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine mysql`` 
          The output contains duplicates.
          The following are the valid DB engine values:
          +   ``aurora-mysql`` 
          +   ``aurora-postgresql`` 
          +   ``db2-ae`` 
          +   ``db2-se`` 
          +   ``mysql`` 
          +   ``oracle-ee`` 
          +   ``oracle-ee-cdb`` 
          +   ``oracle-se2`` 
          +   ``oracle-se2-cdb`` 
          +   ``postgres`` 
          +   ``sqlserver-ee`` 
          +   ``sqlserver-se`` 
          +   ``sqlserver-ex`` 
          +   ``sqlserver-web``
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter(name="dbParameterGroupName")
    def db_parameter_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the DB parameter group.
         Constraints:
          +  Must be 1 to 255 letters, numbers, or hyphens.
          +  First character must be a letter
          +  Can't end with a hyphen or contain two consecutive hyphens
          
         If you don't specify a value for ``DBParameterGroupName`` property, a name is automatically created for the DB parameter group.
          This value is stored as a lowercase string.
        """
        return pulumi.get(self, "db_parameter_group_name")

    @db_parameter_group_name.setter
    def db_parameter_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_parameter_group_name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        A mapping of parameter names and values for the parameter update. You must specify at least one parameter name and value.
         For more information about parameter groups, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide*, or [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide*.
          AWS CloudFormation doesn't support specifying an apply method for each individual parameter. The default apply method for each parameter is used.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::RDS::DBParameterGroup` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[Any]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Tags to assign to the DB parameter group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:rds:DbParameterGroup")
class DbParameterGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 family: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[Any] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        The ``AWS::RDS::DBParameterGroup`` resource creates a custom parameter group for an RDS database family.
         This type can be declared in a template and referenced in the ``DBParameterGroupName`` property of an ``AWS::RDS::DBInstance`` resource.
         For information about configuring parameters for Amazon RDS DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide*.
         For information about configuring parameters for Amazon Aurora DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide*.
          Applying a parameter group to a DB instance may require the DB instance to reboot, resulting in a database outage for the duration of the reboot.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] db_parameter_group_name: The name of the DB parameter group.
                Constraints:
                 +  Must be 1 to 255 letters, numbers, or hyphens.
                 +  First character must be a letter
                 +  Can't end with a hyphen or contain two consecutive hyphens
                 
                If you don't specify a value for ``DBParameterGroupName`` property, a name is automatically created for the DB parameter group.
                 This value is stored as a lowercase string.
        :param pulumi.Input[builtins.str] description: Provides the customer-specified description for this DB parameter group.
        :param pulumi.Input[builtins.str] family: The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.
                To list all of the available parameter group families for a DB engine, use the following command:
                 ``aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine <engine>`` 
                For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:
                 ``aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine mysql`` 
                 The output contains duplicates.
                 The following are the valid DB engine values:
                 +   ``aurora-mysql`` 
                 +   ``aurora-postgresql`` 
                 +   ``db2-ae`` 
                 +   ``db2-se`` 
                 +   ``mysql`` 
                 +   ``oracle-ee`` 
                 +   ``oracle-ee-cdb`` 
                 +   ``oracle-se2`` 
                 +   ``oracle-se2-cdb`` 
                 +   ``postgres`` 
                 +   ``sqlserver-ee`` 
                 +   ``sqlserver-se`` 
                 +   ``sqlserver-ex`` 
                 +   ``sqlserver-web``
        :param Any parameters: A mapping of parameter names and values for the parameter update. You must specify at least one parameter name and value.
                For more information about parameter groups, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide*, or [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide*.
                 AWS CloudFormation doesn't support specifying an apply method for each individual parameter. The default apply method for each parameter is used.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::RDS::DBParameterGroup` for more information about the expected schema for this property.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Tags to assign to the DB parameter group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbParameterGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::RDS::DBParameterGroup`` resource creates a custom parameter group for an RDS database family.
         This type can be declared in a template and referenced in the ``DBParameterGroupName`` property of an ``AWS::RDS::DBInstance`` resource.
         For information about configuring parameters for Amazon RDS DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide*.
         For information about configuring parameters for Amazon Aurora DB instances, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide*.
          Applying a parameter group to a DB instance may require the DB instance to reboot, resulting in a database outage for the duration of the reboot.

        :param str resource_name: The name of the resource.
        :param DbParameterGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbParameterGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 family: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[Any] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbParameterGroupArgs.__new__(DbParameterGroupArgs)

            __props__.__dict__["db_parameter_group_name"] = db_parameter_group_name
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if family is None and not opts.urn:
                raise TypeError("Missing required property 'family'")
            __props__.__dict__["family"] = family
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["tags"] = tags
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["dbParameterGroupName", "description", "family"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DbParameterGroup, __self__).__init__(
            'aws-native:rds:DbParameterGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DbParameterGroup':
        """
        Get an existing DbParameterGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DbParameterGroupArgs.__new__(DbParameterGroupArgs)

        __props__.__dict__["db_parameter_group_name"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["family"] = None
        __props__.__dict__["parameters"] = None
        __props__.__dict__["tags"] = None
        return DbParameterGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dbParameterGroupName")
    def db_parameter_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the DB parameter group.
         Constraints:
          +  Must be 1 to 255 letters, numbers, or hyphens.
          +  First character must be a letter
          +  Can't end with a hyphen or contain two consecutive hyphens
          
         If you don't specify a value for ``DBParameterGroupName`` property, a name is automatically created for the DB parameter group.
          This value is stored as a lowercase string.
        """
        return pulumi.get(self, "db_parameter_group_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Provides the customer-specified description for this DB parameter group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def family(self) -> pulumi.Output[builtins.str]:
        """
        The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.
         To list all of the available parameter group families for a DB engine, use the following command:
          ``aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine <engine>`` 
         For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:
          ``aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine mysql`` 
          The output contains duplicates.
          The following are the valid DB engine values:
          +   ``aurora-mysql`` 
          +   ``aurora-postgresql`` 
          +   ``db2-ae`` 
          +   ``db2-se`` 
          +   ``mysql`` 
          +   ``oracle-ee`` 
          +   ``oracle-ee-cdb`` 
          +   ``oracle-se2`` 
          +   ``oracle-se2-cdb`` 
          +   ``postgres`` 
          +   ``sqlserver-ee`` 
          +   ``sqlserver-se`` 
          +   ``sqlserver-ex`` 
          +   ``sqlserver-web``
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Any]]:
        """
        A mapping of parameter names and values for the parameter update. You must specify at least one parameter name and value.
         For more information about parameter groups, see [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide*, or [Working with parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide*.
          AWS CloudFormation doesn't support specifying an apply method for each individual parameter. The default apply method for each parameter is used.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::RDS::DBParameterGroup` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Tags to assign to the DB parameter group.
        """
        return pulumi.get(self, "tags")

