# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DbInstanceArgs', 'DbInstance']

@pulumi.input_type
class DbInstanceArgs:
    def __init__(__self__, *,
                 allocated_storage: Optional[pulumi.Input[builtins.str]] = None,
                 allow_major_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 apply_immediately: Optional[pulumi.Input[builtins.bool]] = None,
                 associated_roles: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceDbInstanceRoleArgs']]]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 automatic_backup_replication_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 automatic_backup_replication_region: Optional[pulumi.Input[builtins.str]] = None,
                 automatic_backup_replication_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 backup_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 ca_certificate_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_rotation_restart: Optional[pulumi.Input[builtins.bool]] = None,
                 character_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[builtins.bool]] = None,
                 custom_iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
                 database_insights_mode: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_instance_class: Optional[pulumi.Input[builtins.str]] = None,
                 db_instance_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 db_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 dedicated_log_volume: Optional[pulumi.Input[builtins.bool]] = None,
                 delete_automated_backups: Optional[pulumi.Input[builtins.bool]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 domain_auth_secret_arn: Optional[pulumi.Input[builtins.str]] = None,
                 domain_dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 domain_fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 domain_iam_role_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_ou: Optional[pulumi.Input[builtins.str]] = None,
                 enable_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enable_iam_database_authentication: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_performance_insights: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_lifecycle_support: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 iops: Optional[pulumi.Input[builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 license_model: Optional[pulumi.Input[builtins.str]] = None,
                 manage_master_user_password: Optional[pulumi.Input[builtins.bool]] = None,
                 master_user_password: Optional[pulumi.Input[builtins.str]] = None,
                 master_user_secret: Optional[pulumi.Input['DbInstanceMasterUserSecretArgs']] = None,
                 master_username: Optional[pulumi.Input[builtins.str]] = None,
                 max_allocated_storage: Optional[pulumi.Input[builtins.int]] = None,
                 monitoring_interval: Optional[pulumi.Input[builtins.int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 multi_az: Optional[pulumi.Input[builtins.bool]] = None,
                 nchar_character_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 network_type: Optional[pulumi.Input[builtins.str]] = None,
                 option_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 port: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_backup_window: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 processor_features: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceProcessorFeatureArgs']]]] = None,
                 promotion_tier: Optional[pulumi.Input[builtins.int]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 replica_mode: Optional[pulumi.Input[builtins.str]] = None,
                 restore_time: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_instance_automated_backups_arn: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_instance_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_dbi_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_region: Optional[pulumi.Input[builtins.str]] = None,
                 storage_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_throughput: Optional[pulumi.Input[builtins.int]] = None,
                 storage_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 tde_credential_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tde_credential_password: Optional[pulumi.Input[builtins.str]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None,
                 use_default_processor_features: Optional[pulumi.Input[builtins.bool]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[builtins.bool]] = None,
                 vpc_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a DbInstance resource.
        :param pulumi.Input[builtins.str] allocated_storage: The amount of storage in gibibytes (GiB) to be initially allocated for the database instance.
                 If any value is set in the ``Iops`` parameter, ``AllocatedStorage`` must be at least 100 GiB, which corresponds to the minimum Iops value of 1,000. If you increase the ``Iops`` value (in 1,000 IOPS increments), then you must also increase the ``AllocatedStorage`` value (in 100-GiB increments). 
                  *Amazon Aurora* 
                Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.
                 *Db2* 
                Constraints to the amount of storage for each storage type are the following:
                 +  General Purpose (SSD) storage (gp3): Must be an integer from 20 to 64000.
                 +  Provisioned IOPS storage (io1): Must be an integer from 100 to 64000.
                 
                 *MySQL* 
                Constraints to the amount of storage for each storage type are the following: 
                 +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
                 +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
                 +  Magnetic storage (standard): Must be an integer from 5 to 3072.
                 
                 *MariaDB* 
                Constraints to the amount of storage for each storage type are the following: 
                 +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
                 +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
                 +  Magnetic storage (standard): Must be an integer from 5 to 3072.
                 
                 *PostgreSQL* 
                Constraints to the amount of storage for each storage type are the following: 
                 +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
                 +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
                 +  Magnetic storage (standard): Must be an integer from 5 to 3072.
                 
                 *Oracle* 
                Constraints to the amount of storage for each storage type are the following: 
                 +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
                 +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
                 +  Magnetic storage (standard): Must be an integer from 10 to 3072.
                 
                 *SQL Server* 
                Constraints to the amount of storage for each storage type are the following: 
                 +  General Purpose (SSD) storage (gp2):
                 +  Enterprise and Standard editions: Must be an integer from 20 to 16384.
                 +  Web and Express editions: Must be an integer from 20 to 16384.
                 
                 +  Provisioned IOPS storage (io1):
                 +  Enterprise and Standard editions: Must be an integer from 20 to 16384.
                 +  Web and Express editions: Must be an integer from 20 to 16384.
                 
                 +  Magnetic storage (standard):
                 +  Enterprise and Standard editions: Must be an integer from 20 to 1024.
                 +  Web and Express editions: Must be an integer from 20 to 1024.
        :param pulumi.Input[builtins.bool] allow_major_version_upgrade: A value that indicates whether major version upgrades are allowed. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
                Constraints: Major version upgrades must be allowed when specifying a value for the ``EngineVersion`` parameter that is a different major version than the DB instance's current version.
        :param pulumi.Input[builtins.bool] apply_immediately: Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the ``PreferredMaintenanceWindow`` setting. If set to ``false``, changes are applied during the next maintenance window. Until RDS applies the changes, the DB instance remains in a drift state. As a result, the configuration doesn't fully reflect the requested modifications and temporarily diverges from the intended state.
                In addition to the settings described in [Modifying a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html), this property also determines whether the DB instance reboots when a static parameter is modified in the associated DB parameter group.
                Default: ``true``
        :param pulumi.Input[Sequence[pulumi.Input['DbInstanceDbInstanceRoleArgs']]] associated_roles: The IAMlong (IAM) roles associated with the DB instance. 
                 *Amazon Aurora* 
                Not applicable. The associated roles are managed by the DB cluster.
        :param pulumi.Input[builtins.bool] auto_minor_version_upgrade: A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are applied automatically.
        :param pulumi.Input[builtins.str] automatic_backup_replication_kms_key_id: The AWS KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination AWS-Region, for example, ``arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE``.
        :param pulumi.Input[builtins.str] automatic_backup_replication_region: The AWS-Region associated with the automated backup.
        :param pulumi.Input[builtins.int] automatic_backup_replication_retention_period: The retention period for automated backups in a different AWS Region. Use this parameter to set a unique retention period that only applies to cross-Region automated backups. To enable automated backups in a different Region, specify a positive value for the ``AutomaticBackupReplicationRegion`` parameter. 
                If not specified, this parameter defaults to the value of the ``BackupRetentionPeriod`` parameter. The maximum allowed value is 35.
        :param pulumi.Input[builtins.str] availability_zone: The Availability Zone (AZ) where the database will be created. For information on AWS-Regions and Availability Zones, see [Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
                For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.
                Default: A random, system-chosen Availability Zone in the endpoint's AWS-Region.
                Constraints:
                 +  The ``AvailabilityZone`` parameter can't be specified if the DB instance is a Multi-AZ deployment.
                 +  The specified Availability Zone must be in the same AWS-Region as the current endpoint.
                 
                Example: ``us-east-1d``
        :param pulumi.Input[builtins.int] backup_retention_period: The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
                 *Amazon Aurora* 
                Not applicable. The retention period for automated backups is managed by the DB cluster.
                Default: 1
                Constraints:
                 +  Must be a value from 0 to 35
                 +  Can't be set to 0 if the DB instance is a source to read replicas
        :param pulumi.Input[builtins.str] ca_certificate_identifier: The identifier of the CA certificate for this DB instance.
                For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
        :param pulumi.Input[builtins.bool] certificate_rotation_restart: Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
                By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.
                 Set this parameter only if you are *not* using SSL/TLS to connect to the DB instance.
                 If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB engine to rotate your SSL/TLS certificate:
                 +  For more information about rotating your SSL/TLS certificate for RDS DB engines, see [Rotating Your SSL/TLS Certificate.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html) in the *Amazon RDS User Guide.*
                 +  For more information about rotating your SSL/TLS certificate for Aurora DB engines, see [Rotating Your SSL/TLS Certificate](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html) in the *Amazon Aurora User Guide*.
                 
                This setting doesn't apply to RDS Custom DB instances.
        :param pulumi.Input[builtins.str] character_set_name: For supported engines, indicates that the DB instance should be associated with the specified character set.
                 *Amazon Aurora* 
                Not applicable. The character set is managed by the DB cluster. For more information, see [AWS::RDS::DBCluster](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html).
        :param pulumi.Input[builtins.bool] copy_tags_to_snapshot: Specifies whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.
                This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
        :param pulumi.Input[builtins.str] custom_iam_instance_profile: The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
                This setting is required for RDS Custom.
                Constraints:
                 +  The profile must exist in your account.
                 +  The profile must have an IAM role that Amazon EC2 has permissions to assume.
                 +  The instance profile name and the associated IAM role name must start with the prefix ``AWSRDSCustom``.
                 
                For the list of permissions required for the IAM role, see [Configure IAM and your VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc) in the *Amazon RDS User Guide*.
        :param pulumi.Input[builtins.str] database_insights_mode: The mode of Database Insights to enable for the DB instance.
                 Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
        :param pulumi.Input[builtins.str] db_cluster_identifier: The identifier of the DB cluster that this DB instance will belong to.
                This setting doesn't apply to RDS Custom DB instances.
        :param pulumi.Input[builtins.str] db_cluster_snapshot_identifier: The identifier for the Multi-AZ DB cluster snapshot to restore from.
                For more information on Multi-AZ DB clusters, see [Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
                Constraints:
                 +  Must match the identifier of an existing Multi-AZ DB cluster snapshot.
                 +  Can't be specified when ``DBSnapshotIdentifier`` is specified.
                 +  Must be specified when ``DBSnapshotIdentifier`` isn't specified.
                 +  If you are restoring from a shared manual Multi-AZ DB cluster snapshot, the ``DBClusterSnapshotIdentifier`` must be the ARN of the shared snapshot.
                 +  Can't be the identifier of an Aurora DB cluster snapshot.
        :param pulumi.Input[builtins.str] db_instance_class: The compute and memory capacity of the DB instance, for example ``db.m5.large``. Not all DB instance classes are available in all AWS-Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see [DB instance classes](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide* or [Aurora DB instance classes](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html) in the *Amazon Aurora User Guide*.
        :param pulumi.Input[builtins.str] db_instance_identifier: A name for the DB instance. If you specify a name, AWS CloudFormation converts it to lowercase. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the DB instance. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
                For information about constraints that apply to DB instance identifiers, see [Naming constraints in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints) in the *Amazon RDS User Guide*.
                 If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        :param pulumi.Input[builtins.str] db_name: The meaning of this parameter differs according to the database engine you use.
                 If you specify the ``DBSnapshotIdentifier`` property, this property only applies to RDS for Oracle.
                  *Amazon Aurora* 
                Not applicable. The database name is managed by the DB cluster.
                 *Db2* 
                The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.
                Constraints:
                 +  Must contain 1 to 64 letters or numbers.
                 +  Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
                 +  Can't be a word reserved by the specified database engine.
                 
                 *MySQL* 
                The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
                Constraints:
                 +  Must contain 1 to 64 letters or numbers.
                 +  Can't be a word reserved by the specified database engine
                 
                 *MariaDB* 
                The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
                Constraints:
                 +  Must contain 1 to 64 letters or numbers.
                 +  Can't be a word reserved by the specified database engine
                 
                 *PostgreSQL* 
                The name of the database to create when the DB instance is created. If this parameter is not specified, the default ``postgres`` database is created in the DB instance.
                Constraints:
                 +  Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
                 +  Must contain 1 to 63 characters.
                 +  Can't be a word reserved by the specified database engine
                 
                 *Oracle* 
                The Oracle System ID (SID) of the created DB instance. If you specify ``null``, the default value ``ORCL`` is used. You can't specify the string NULL, or any other reserved word, for ``DBName``. 
                Default: ``ORCL``
                Constraints:
                 +  Can't be longer than 8 characters
                 
                 *SQL Server* 
                Not applicable. Must be null.
        :param pulumi.Input[builtins.str] db_parameter_group_name: The name of an existing DB parameter group or a reference to an [AWS::RDS::DBParameterGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html) resource created in the template.
                To list all of the available DB parameter group names, use the following command:
                 ``aws rds describe-db-parameter-groups --query "DBParameterGroups[].DBParameterGroupName" --output text`` 
                 If any of the data members of the referenced parameter group are changed during an update, the DB instance might need to be restarted, which causes some interruption. If the parameter group contains static parameters, whether they were changed or not, an update triggers a reboot.
                 If you don't specify a value for ``DBParameterGroupName`` property, the default DB parameter group for the specified engine and engine version is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] db_security_groups: A list of the DB security groups to assign to the DB instance. The list can include both the name of existing DB security groups or references to AWS::RDS::DBSecurityGroup resources created in the template.
                 If you set DBSecurityGroups, you must not set VPCSecurityGroups, and vice versa. Also, note that the DBSecurityGroups property exists only for backwards compatibility with older regions and is no longer recommended for providing security information to an RDS DB instance. Instead, use VPCSecurityGroups.
                 If you specify this property, AWS CloudFormation sends only the following properties (if specified) to Amazon RDS during create operations:
                 +   ``AllocatedStorage`` 
                 +   ``AutoMinorVersionUpgrade`` 
                 +   ``AvailabilityZone`` 
                 +   ``BackupRetentionPeriod`` 
                 +   ``CharacterSetName`` 
                 +   ``DBInstanceClass`` 
                 +   ``DBName`` 
                 +   ``DBParameterGroupName`` 
                 +   ``DBSecurityGroups`` 
                 +   ``DBSubnetGroupName`` 
                 +   ``Engine`` 
                 +   ``EngineVersion`` 
                 +   ``Iops`` 
                 +   ``LicenseModel`` 
                 +   ``MasterUsername`` 
                 +   ``MasterUserPassword`` 
                 +   ``MultiAZ`` 
                 +   ``OptionGroupName`` 
                 +   ``PreferredBackupWindow`` 
                 +   ``PreferredMaintenanceWindow`` 
                 
                All other properties are ignored. Specify a virtual private cloud (VPC) security group if you want to submit other properties, such as ``StorageType``, ``StorageEncrypted``, or ``KmsKeyId``. If you're already using the ``DBSecurityGroups`` property, you can't use these other properties by updating your DB instance to use a VPC security group. You must recreate the DB instance.
        :param pulumi.Input[builtins.str] db_snapshot_identifier: The name or Amazon Resource Name (ARN) of the DB snapshot that's used to restore the DB instance. If you're restoring from a shared manual DB snapshot, you must specify the ARN of the snapshot.
                By specifying this property, you can create a DB instance from the specified DB snapshot. If the ``DBSnapshotIdentifier`` property is an empty string or the ``AWS::RDS::DBInstance`` declaration has no ``DBSnapshotIdentifier`` property, AWS CloudFormation creates a new database. If the property contains a value (other than an empty string), AWS CloudFormation creates a database from the specified snapshot. If a snapshot with the specified name doesn't exist, AWS CloudFormation can't create the database and it rolls back the stack.
                Some DB instance properties aren't valid when you restore from a snapshot, such as the ``MasterUsername`` and ``MasterUserPassword`` properties, and the point-in-time recovery properties ``RestoreTime`` and ``UseLatestRestorableTime``. For information about the properties that you can specify, see the [RestoreDBInstanceFromDBSnapshot](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBInstanceFromDBSnapshot.html) action in the *Amazon RDS API Reference*.
                After you restore a DB instance with a ``DBSnapshotIdentifier`` property, you must specify the same ``DBSnapshotIdentifier`` property for any future updates to the DB instance. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the ``DBSnapshotIdentifier`` property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified ``DBSnapshotIdentifier`` property, and the original DB instance is deleted.
                If you specify the ``DBSnapshotIdentifier`` property to restore a DB instance (as opposed to specifying it for DB instance updates), then don't specify the following properties:
                 +   ``CharacterSetName`` 
                 +   ``DBClusterIdentifier`` 
                 +   ``DBName`` 
                 +   ``KmsKeyId`` 
                 +   ``MasterUsername`` 
                 +   ``MasterUserPassword`` 
                 +   ``PromotionTier`` 
                 +   ``SourceDBInstanceIdentifier`` 
                 +   ``SourceRegion`` 
                 +  ``StorageEncrypted`` (for an unencrypted snapshot)
                 +   ``Timezone`` 
                 
                 *Amazon Aurora* 
                Not applicable. Snapshot restore is managed by the DB cluster.
        :param pulumi.Input[builtins.str] db_subnet_group_name: A DB subnet group to associate with the DB instance. If you update this value, the new subnet group must be a subnet group in a new VPC. 
                If you don't specify a DB subnet group, RDS uses the default DB subnet group if one exists. If a default DB subnet group does not exist, and you don't specify a ``DBSubnetGroupName``, the DB instance fails to launch. 
                For more information about using Amazon RDS in a VPC, see [Amazon VPC and Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html) in the *Amazon RDS User Guide*. 
                This setting doesn't apply to Amazon Aurora DB instances. The DB subnet group is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
        :param pulumi.Input[builtins.str] db_system_id: The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your database files. In this context, the term "Oracle database instance" refers exclusively to the system global area (SGA) and Oracle background processes. If you don't specify a SID, the value defaults to ``RDSCDB``. The Oracle SID is also the name of your CDB.
        :param pulumi.Input[builtins.bool] dedicated_log_volume: Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
        :param pulumi.Input[builtins.bool] delete_automated_backups: A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.
                 *Amazon Aurora* 
                Not applicable. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the DB cluster are not deleted.
        :param pulumi.Input[builtins.bool] deletion_protection: Specifies whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see [Deleting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
                This setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion protection for the DB cluster. For more information, see ``CreateDBCluster``. DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
        :param pulumi.Input[builtins.str] domain: The Active Directory directory ID to create the DB instance in. Currently, only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
                For more information, see [Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html) in the *Amazon RDS User Guide*.
        :param pulumi.Input[builtins.str] domain_auth_secret_arn: The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
                Example: ``arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456``
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] domain_dns_ips: The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
                Constraints:
                 +  Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.
                 
                Example: ``123.124.125.126,234.235.236.237``
        :param pulumi.Input[builtins.str] domain_fqdn: The fully qualified domain name (FQDN) of an Active Directory domain.
                Constraints:
                 +  Can't be longer than 64 characters.
                 
                Example: ``mymanagedADtest.mymanagedAD.mydomain``
        :param pulumi.Input[builtins.str] domain_iam_role_name: The name of the IAM role to use when making API calls to the Directory Service.
                This setting doesn't apply to the following DB instances:
                 +  Amazon Aurora (The domain is managed by the DB cluster.)
                 +  RDS Custom
        :param pulumi.Input[builtins.str] domain_ou: The Active Directory organizational unit for your DB instance to join.
                Constraints:
                 +  Must be in the distinguished name format.
                 +  Can't be longer than 64 characters.
                 
                Example: ``OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain``
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] enable_cloudwatch_logs_exports: The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Relational Database Service User Guide*.
                 *Amazon Aurora* 
                Not applicable. CloudWatch Logs exports are managed by the DB cluster. 
                 *Db2* 
                Valid values: ``diag.log``, ``notify.log``
                 *MariaDB* 
                Valid values: ``audit``, ``error``, ``general``, ``slowquery``
                 *Microsoft SQL Server* 
                Valid values: ``agent``, ``error``
                 *MySQL* 
                Valid values: ``audit``, ``error``, ``general``, ``slowquery``
                 *Oracle* 
                Valid values: ``alert``, ``audit``, ``listener``, ``trace``, ``oemagent``
                 *PostgreSQL* 
                Valid values: ``postgresql``, ``upgrade``
        :param pulumi.Input[builtins.bool] enable_iam_database_authentication: A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.
                This property is supported for RDS for MariaDB, RDS for MySQL, and RDS for PostgreSQL. For more information, see [IAM Database Authentication for MariaDB, MySQL, and PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon RDS User Guide.*
                 *Amazon Aurora* 
                Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.
        :param pulumi.Input[builtins.bool] enable_performance_insights: Specifies whether to enable Performance Insights for the DB instance. For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
                This setting doesn't apply to RDS Custom DB instances.
        :param pulumi.Input[builtins.str] engine: The name of the database engine to use for this DB instance. Not every database engine is available in every AWS Region.
                This property is required when creating a DB instance.
                 You can convert an Oracle database from the non-CDB architecture to the container database (CDB) architecture by updating the ``Engine`` value in your templates from ``oracle-ee`` to ``oracle-ee-cdb`` or from ``oracle-se2`` to ``oracle-se2-cdb``. Converting to the CDB architecture requires an interruption.
                 Valid Values:
                 +  ``aurora-mysql`` (for Aurora MySQL DB instances)
                 +  ``aurora-postgresql`` (for Aurora PostgreSQL DB instances)
                 +  ``custom-oracle-ee`` (for RDS Custom for Oracle DB instances)
                 +  ``custom-oracle-ee-cdb`` (for RDS Custom for Oracle DB instances)
                 +  ``custom-sqlserver-ee`` (for RDS Custom for SQL Server DB instances)
                 +  ``custom-sqlserver-se`` (for RDS Custom for SQL Server DB instances)
                 +  ``custom-sqlserver-web`` (for RDS Custom for SQL Server DB instances)
                 +   ``db2-ae`` 
                 +   ``db2-se`` 
                 +   ``mariadb`` 
                 +   ``mysql`` 
                 +   ``oracle-ee`` 
                 +   ``oracle-ee-cdb`` 
                 +   ``oracle-se2`` 
                 +   ``oracle-se2-cdb`` 
                 +   ``postgres`` 
                 +   ``sqlserver-ee`` 
                 +   ``sqlserver-se`` 
                 +   ``sqlserver-ex`` 
                 +   ``sqlserver-web``
        :param pulumi.Input[builtins.str] engine_lifecycle_support: The life cycle type for this DB instance.
                 By default, this value is set to ``open-source-rds-extended-support``, which enrolls your DB instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to ``open-source-rds-extended-support-disabled``. In this case, creating the DB instance will fail if the DB major version is past its end of standard support date.
                 This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by the DB cluster.
                You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB instance past the end of standard support for that engine version. For more information, see [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html) in the *Amazon RDS User Guide*.
                Valid Values: ``open-source-rds-extended-support | open-source-rds-extended-support-disabled``
                Default: ``open-source-rds-extended-support``
        :param pulumi.Input[builtins.str] engine_version: The version number of the database engine to use.
                For a list of valid engine versions, use the ``DescribeDBEngineVersions`` action.
                The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every AWS Region.
                 *Amazon Aurora* 
                Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.
                 *Db2* 
                See [Amazon RDS for Db2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Db2.html#Db2.Concepts.VersionMgmt) in the *Amazon RDS User Guide.*
                 *MariaDB* 
                See [MariaDB on Amazon RDS Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt) in the *Amazon RDS User Guide.*
                 *Microsoft SQL Server* 
                See [Microsoft SQL Server Versions on Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport) in the *Amazon RDS User Guide.*
                 *MySQL* 
                See [MySQL on Amazon RDS Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt) in the *Amazon RDS User Guide.*
                 *Oracle* 
                See [Oracle Database Engine Release Notes](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html) in the *Amazon RDS User Guide.*
                 *PostgreSQL* 
                See [Supported PostgreSQL Database Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts.General.DBVersions) in the *Amazon RDS User Guide.*
        :param pulumi.Input[builtins.int] iops: The number of I/O operations per second (IOPS) that the database provisions. The value must be equal to or greater than 1000. 
                If you specify this property, you must follow the range of allowed ratios of your requested IOPS rate to the amount of storage that you allocate (IOPS to allocated storage). For example, you can provision an Oracle database instance with 1000 IOPS and 200 GiB of storage (a ratio of 5:1), or specify 2000 IOPS with 200 GiB of storage (a ratio of 10:1). For more information, see [Amazon RDS Provisioned IOPS Storage to Improve Performance](https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
                 If you specify ``io1`` for the ``StorageType`` property, then you must also specify the ``Iops`` property.
                 Constraints:
                 +  For RDS for Db2, MariaDB, MySQL, Oracle, and PostgreSQL - Must be a multiple between .5 and 50 of the storage amount for the DB instance.
                 +  For RDS for SQL Server - Must be a multiple between 1 and 50 of the storage amount for the DB instance.
        :param pulumi.Input[builtins.str] kms_key_id: The ARN of the AWS KMS key that's used to encrypt the DB instance, such as ``arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef``. If you enable the StorageEncrypted property but don't specify this property, AWS CloudFormation uses the default KMS key. If you specify this property, you must set the StorageEncrypted property to true. 
                If you specify the ``SourceDBInstanceIdentifier`` or ``SourceDbiResourceId`` property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified ``KmsKeyId`` property is used. However, if the source DB instance is in a different AWS Region, you must specify a KMS key ID.
                If you specify the ``SourceDBInstanceAutomatedBackupsArn`` property, don't specify this property. The value is inherited from the source DB instance automated backup, and if the automated backup is encrypted, the specified ``KmsKeyId`` property is used.
                If you create an encrypted read replica in a different AWS Region, then you must specify a KMS key for the destination AWS Region. KMS encryption keys are specific to the region that they're created in, and you can't use encryption keys from one region in another region.
                If you specify the ``DBSnapshotIdentifier`` property, don't specify this property. The ``StorageEncrypted`` property value is inherited from the snapshot. If the DB instance is encrypted, the specified ``KmsKeyId`` property is also inherited from the snapshot.
                If you specify ``DBSecurityGroups``, AWS CloudFormation ignores this property. To specify both a security group and this property, you must use a VPC security group. For more information about Amazon RDS and VPC, see [Using Amazon RDS with Amazon VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html) in the *Amazon RDS User Guide*.
                 *Amazon Aurora* 
                Not applicable. The KMS key identifier is managed by the DB cluster.
        :param pulumi.Input[builtins.str] license_model: License model information for this DB instance.
                 Valid Values:
                 +  Aurora MySQL - ``general-public-license``
                 +  Aurora PostgreSQL - ``postgresql-license``
                 +  RDS for Db2 - ``bring-your-own-license``. For more information about RDS for Db2 licensing, see [](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html) in the *Amazon RDS User Guide.*
                 +  RDS for MariaDB - ``general-public-license``
                 +  RDS for Microsoft SQL Server - ``license-included``
                 +  RDS for MySQL - ``general-public-license``
                 +  RDS for Oracle - ``bring-your-own-license`` or ``license-included``
                 +  RDS for PostgreSQL - ``postgresql-license``
                 
                 If you've specified ``DBSecurityGroups`` and then you update the license model, AWS CloudFormation replaces the underlying DB instance. This will incur some interruptions to database availability.
        :param pulumi.Input[builtins.bool] manage_master_user_password: Specifies whether to manage the master user password with AWS Secrets Manager.
                For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide.*
                Constraints:
                 +  Can't manage the master user password with AWS Secrets Manager if ``MasterUserPassword`` is specified.
        :param pulumi.Input[builtins.str] master_user_password: The password for the master user. The password can include any printable ASCII character except "/", \"\"\", or "@".
                 *Amazon Aurora* 
                Not applicable. The password for the master user is managed by the DB cluster.
                 *RDS for Db2* 
                Must contain from 8 to 255 characters.
                 *RDS for MariaDB* 
                Constraints: Must contain from 8 to 41 characters.
                 *RDS for Microsoft SQL Server* 
                Constraints: Must contain from 8 to 128 characters.
                 *RDS for MySQL* 
                Constraints: Must contain from 8 to 41 characters.
                 *RDS for Oracle* 
                Constraints: Must contain from 8 to 30 characters.
                 *RDS for PostgreSQL* 
                Constraints: Must contain from 8 to 128 characters.
        :param pulumi.Input['DbInstanceMasterUserSecretArgs'] master_user_secret: The secret managed by RDS in AWS Secrets Manager for the master user password.
                For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide.*
        :param pulumi.Input[builtins.str] master_username: The master user name for the DB instance.
                 If you specify the ``SourceDBInstanceIdentifier`` or ``DBSnapshotIdentifier`` property, don't specify this property. The value is inherited from the source DB instance or snapshot.
                When migrating a self-managed Db2 database, we recommend that you use the same master username as your self-managed Db2 instance name.
                  *Amazon Aurora* 
                Not applicable. The name for the master user is managed by the DB cluster. 
                 *RDS for Db2* 
                Constraints:
                 +  Must be 1 to 16 letters or numbers.
                 +  First character must be a letter.
                 +  Can't be a reserved word for the chosen database engine.
                 
                 *RDS for MariaDB* 
                Constraints:
                 +  Must be 1 to 16 letters or numbers.
                 +  Can't be a reserved word for the chosen database engine.
                 
                 *RDS for Microsoft SQL Server* 
                Constraints:
                 +  Must be 1 to 128 letters or numbers.
                 +  First character must be a letter.
                 +  Can't be a reserved word for the chosen database engine.
                 
                 *RDS for MySQL* 
                Constraints:
                 +  Must be 1 to 16 letters or numbers.
                 +  First character must be a letter.
                 +  Can't be a reserved word for the chosen database engine.
                 
                 *RDS for Oracle* 
                Constraints:
                 +  Must be 1 to 30 letters or numbers.
                 +  First character must be a letter.
                 +  Can't be a reserved word for the chosen database engine.
                 
                 *RDS for PostgreSQL* 
                Constraints:
                 +  Must be 1 to 63 letters or numbers.
                 +  First character must be a letter.
                 +  Can't be a reserved word for the chosen database engine.
        :param pulumi.Input[builtins.int] max_allocated_storage: The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
                For more information about this setting, including limitations that apply to it, see [Managing capacity automatically with Amazon RDS storage autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling) in the *Amazon RDS User Guide*.
                This setting doesn't apply to the following DB instances:
                 +  Amazon Aurora (Storage is managed by the DB cluster.)
                 +  RDS Custom
        :param pulumi.Input[builtins.int] monitoring_interval: The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collection of Enhanced Monitoring metrics, specify ``0``.
                If ``MonitoringRoleArn`` is specified, then you must set ``MonitoringInterval`` to a value other than ``0``.
                This setting doesn't apply to RDS Custom DB instances.
                Valid Values: ``0 | 1 | 5 | 10 | 15 | 30 | 60``
                Default: ``0``
        :param pulumi.Input[builtins.str] monitoring_role_arn: The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, ``arn:aws:iam:123456789012:role/emaccess``. For information on creating a monitoring role, see [Setting Up and Enabling Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling) in the *Amazon RDS User Guide*.
                If ``MonitoringInterval`` is set to a value other than ``0``, then you must supply a ``MonitoringRoleArn`` value.
                This setting doesn't apply to RDS Custom DB instances.
        :param pulumi.Input[builtins.bool] multi_az: Specifies whether the DB instance is a Multi-AZ deployment. You can't set the ``AvailabilityZone`` parameter if the DB instance is a Multi-AZ deployment.
                This setting doesn't apply to the following DB instances:
                 +  Amazon Aurora (DB instance Availability Zones (AZs) are managed by the DB cluster.)
                 +  RDS Custom
        :param pulumi.Input[builtins.str] nchar_character_set_name: The name of the NCHAR character set for the Oracle DB instance.
                This setting doesn't apply to RDS Custom DB instances.
        :param pulumi.Input[builtins.str] network_type: The network type of the DB instance.
                Valid values:
                 +   ``IPV4`` 
                 +   ``DUAL`` 
                 
                The network type is determined by the ``DBSubnetGroup`` specified for the DB instance. A ``DBSubnetGroup`` can support only the IPv4 protocol or the IPv4 and IPv6 protocols (``DUAL``).
                For more information, see [Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
        :param pulumi.Input[builtins.str] option_group_name: Indicates that the DB instance should be associated with the specified option group.
                Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group. Also, that option group can't be removed from a DB instance once it is associated with a DB instance.
        :param pulumi.Input[builtins.str] performance_insights_kms_key_id: The AWS KMS key identifier for encryption of Performance Insights data.
                The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
                If you do not specify a value for ``PerformanceInsightsKMSKeyId``, then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account. Your AWS account has a different default KMS key for each AWS Region.
                For information about enabling Performance Insights, see [EnablePerformanceInsights](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights).
        :param pulumi.Input[builtins.int] performance_insights_retention_period: The number of days to retain Performance Insights data. When creating a DB instance without enabling Performance Insights, you can't specify the parameter ``PerformanceInsightsRetentionPeriod``.
                This setting doesn't apply to RDS Custom DB instances.
                Valid Values:
                 +   ``7`` 
                 +  *month* * 31, where *month* is a number of months from 1-23. Examples: ``93`` (3 months * 31), ``341`` (11 months * 31), ``589`` (19 months * 31)
                 +   ``731`` 
                 
                Default: ``7`` days
                If you specify a retention period that isn't valid, such as ``94``, Amazon RDS returns an error.
        :param pulumi.Input[builtins.str] port: The port number on which the database accepts connections.
                This setting doesn't apply to Aurora DB instances. The port number is managed by the cluster.
                Valid Values: ``1150-65535``
                Default:
                 +  RDS for Db2 - ``50000``
                 +  RDS for MariaDB - ``3306``
                 +  RDS for Microsoft SQL Server - ``1433``
                 +  RDS for MySQL - ``3306``
                 +  RDS for Oracle - ``1521``
                 +  RDS for PostgreSQL - ``5432``
                 
                Constraints:
                 +  For RDS for Microsoft SQL Server, the value can't be ``1234``, ``1434``, ``3260``, ``3343``, ``3389``, ``47001``, or ``49152-49156``.
        :param pulumi.Input[builtins.str] preferred_backup_window: The daily time range during which automated backups are created if automated backups are enabled, using the ``BackupRetentionPeriod`` parameter. For more information, see [Backup Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow) in the *Amazon RDS User Guide.*
                Constraints:
                 +  Must be in the format ``hh24:mi-hh24:mi``.
                 +  Must be in Universal Coordinated Time (UTC).
                 +  Must not conflict with the preferred maintenance window.
                 +  Must be at least 30 minutes.
                 
                 *Amazon Aurora* 
                Not applicable. The daily time range for creating automated backups is managed by the DB cluster.
        :param pulumi.Input[builtins.str] preferred_maintenance_window: The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
                Format: ``ddd:hh24:mi-ddd:hh24:mi``
                The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see [Maintaining a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow) in the *Amazon RDS User Guide.*
                 This property applies when AWS CloudFormation initially creates the DB instance. If you use AWS CloudFormation to update the DB instance, those updates are applied immediately.
                 Constraints: Minimum 30-minute window.
        :param pulumi.Input[Sequence[pulumi.Input['DbInstanceProcessorFeatureArgs']]] processor_features: The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
                This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
        :param pulumi.Input[builtins.int] promotion_tier: The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see [Fault Tolerance for an Aurora DB Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance) in the *Amazon Aurora User Guide*.
                This setting doesn't apply to RDS Custom DB instances.
                Default: ``1``
                Valid Values: ``0 - 15``
        :param pulumi.Input[builtins.bool] publicly_accessible: Indicates whether the DB instance is an internet-facing instance. If you specify true, AWS CloudFormation creates an instance with a publicly resolvable DNS name, which resolves to a public IP address. If you specify false, AWS CloudFormation creates an internal instance with a DNS name that resolves to a private IP address. 
                The default behavior value depends on your VPC setup and the database subnet group. For more information, see the ``PubliclyAccessible`` parameter in the [CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) in the *Amazon RDS API Reference*.
        :param pulumi.Input[builtins.str] replica_mode: The open mode of an Oracle read replica. For more information, see [Working with Oracle Read Replicas for Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) in the *Amazon RDS User Guide*.
                This setting is only supported in RDS for Oracle.
                Default: ``open-read-only``
                Valid Values: ``open-read-only`` or ``mounted``
        :param pulumi.Input[builtins.str] restore_time: The date and time to restore from. This parameter applies to point-in-time recovery. For more information, see [Restoring a DB instance to a specified time](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html) in the in the *Amazon RDS User Guide*.
                Constraints:
                 +  Must be a time in Universal Coordinated Time (UTC) format.
                 +  Must be before the latest restorable time for the DB instance.
                 +  Can't be specified if the ``UseLatestRestorableTime`` parameter is enabled.
                 
                Example: ``2009-09-07T23:45:00Z``
        :param pulumi.Input[builtins.str] source_db_cluster_identifier: The identifier of the Multi-AZ DB cluster that will act as the source for the read replica. Each DB cluster can have up to 15 read replicas.
                Constraints:
                 +  Must be the identifier of an existing Multi-AZ DB cluster.
                 +  Can't be specified if the ``SourceDBInstanceIdentifier`` parameter is also specified.
                 +  The specified DB cluster must have automatic backups enabled, that is, its backup retention period must be greater than 0.
                 +  The source DB cluster must be in the same AWS-Region as the read replica. Cross-Region replication isn't supported.
        :param pulumi.Input[builtins.str] source_db_instance_automated_backups_arn: The Amazon Resource Name (ARN) of the replicated automated backups from which to restore, for example, ``arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE``.
                This setting doesn't apply to RDS Custom.
        :param pulumi.Input[builtins.str] source_db_instance_identifier: If you want to create a read replica DB instance, specify the ID of the source DB instance. Each DB instance can have a limited number of read replicas. For more information, see [Working with Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/USER_ReadRepl.html) in the *Amazon RDS User Guide*.
                For information about constraints that apply to DB instance identifiers, see [Naming constraints in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints) in the *Amazon RDS User Guide*.
                The ``SourceDBInstanceIdentifier`` property determines whether a DB instance is a read replica. If you remove the ``SourceDBInstanceIdentifier`` property from your template and then update your stack, AWS CloudFormation promotes the read replica to a standalone DB instance.
                If you specify the ``UseLatestRestorableTime`` or ``RestoreTime`` properties in conjunction with the ``SourceDBInstanceIdentifier`` property, RDS restores the DB instance to the requested point in time, thereby creating a new DB instance.
                  +  If you specify a source DB instance that uses VPC security groups, we recommend that you specify the ``VPCSecurityGroups`` property. If you don't specify the property, the read replica inherits the value of the ``VPCSecurityGroups`` property from the source DB when you create the replica. However, if you update the stack, AWS CloudFormation reverts the replica's ``VPCSecurityGroups`` property to the default value because it's not defined in the stack's template. This change might cause unexpected issues.
                 +  Read replicas don't support deletion policies. AWS CloudFormation ignores any deletion policy that's associated with a read replica.
                 +  If you specify ``SourceDBInstanceIdentifier``, don't specify the ``DBSnapshotIdentifier`` property. You can't create a read replica from a snapshot.
                 +  Don't set the ``BackupRetentionPeriod``, ``DBName``, ``MasterUsername``, ``MasterUserPassword``, and ``PreferredBackupWindow`` properties. The database attributes are inherited from the source DB instance, and backups are disabled for read replicas.
                 +  If the source DB instance is in a different region than the read replica, specify the source region in ``SourceRegion``, and specify an ARN for a valid DB instance in ``SourceDBInstanceIdentifier``. For more information, see [Constructing a Amazon RDS Amazon Resource Name (ARN)](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN) in the *Amazon RDS User Guide*.
                 +  For DB instances in Amazon Aurora clusters, don't specify this property. Amazon RDS automatically assigns writer and reader DB instances.
        :param pulumi.Input[builtins.str] source_dbi_resource_id: The resource ID of the source DB instance from which to restore.
        :param pulumi.Input[builtins.str] source_region: The ID of the region that contains the source DB instance for the read replica.
        :param pulumi.Input[builtins.bool] storage_encrypted: A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
                If you specify the ``KmsKeyId`` property, then you must enable encryption.
                If you specify the ``SourceDBInstanceIdentifier`` or ``SourceDbiResourceId`` property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified ``KmsKeyId`` property is used.
                If you specify the ``SourceDBInstanceAutomatedBackupsArn`` property, don't specify this property. The value is inherited from the source DB instance automated backup. 
                If you specify ``DBSnapshotIdentifier`` property, don't specify this property. The value is inherited from the snapshot.
                 *Amazon Aurora* 
                Not applicable. The encryption for DB instances is managed by the DB cluster.
        :param pulumi.Input[builtins.int] storage_throughput: Specifies the storage throughput value, in mebibyte per second (MiBps), for the DB instance. This setting applies only to the ``gp3`` storage type. 
                This setting doesn't apply to RDS Custom or Amazon Aurora.
        :param pulumi.Input[builtins.str] storage_type: The storage type to associate with the DB instance.
                If you specify ``io1``, ``io2``, or ``gp3``, you must also include a value for the ``Iops`` parameter.
                This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
                Valid Values: ``gp2 | gp3 | io1 | io2 | standard``
                Default: ``io1``, if the ``Iops`` parameter is specified. Otherwise, ``gp3``.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Tags to assign to the DB instance.
        :param pulumi.Input[builtins.str] timezone: The time zone of the DB instance. The time zone parameter is currently supported only by [RDS for Db2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-time-zone) and [RDS for SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone).
        :param pulumi.Input[builtins.bool] use_default_processor_features: Specifies whether the DB instance class of the DB instance uses its default processor features.
                This setting doesn't apply to RDS Custom DB instances.
        :param pulumi.Input[builtins.bool] use_latest_restorable_time: Specifies whether the DB instance is restored from the latest backup time. By default, the DB instance isn't restored from the latest backup time. This parameter applies to point-in-time recovery. For more information, see [Restoring a DB instance to a specified time](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html) in the in the *Amazon RDS User Guide*.
                Constraints:
                 +  Can't be specified if the ``RestoreTime`` parameter is provided.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_security_groups: A list of the VPC security group IDs to assign to the DB instance. The list can include both the physical IDs of existing VPC security groups and references to [AWS::EC2::SecurityGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html) resources created in the template.
                If you plan to update the resource, don't specify VPC security groups in a shared VPC.
                 If you set ``VPCSecurityGroups``, you must not set [DBSecurityGroups](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups), and vice versa.
                 You can migrate a DB instance in your stack from an RDS DB security group to a VPC security group, but keep the following in mind:
                 +  You can't revert to using an RDS security group after you establish a VPC security group membership.
                 +  When you migrate your DB instance to VPC security groups, if your stack update rolls back because the DB instance update fails or because an update fails in another AWS CloudFormation resource, the rollback fails because it can't revert to an RDS security group.
                 +  To use the properties that are available when you use a VPC security group, you must recreate the DB instance. If you don't, AWS CloudFormation submits only the property values that are listed in the [DBSecurityGroups](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups) property.
                 
                 To avoid this situation, migrate your DB instance to using VPC security groups only when that is the only change in your stack template. 
                 *Amazon Aurora* 
                Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
        """
        if allocated_storage is not None:
            pulumi.set(__self__, "allocated_storage", allocated_storage)
        if allow_major_version_upgrade is not None:
            pulumi.set(__self__, "allow_major_version_upgrade", allow_major_version_upgrade)
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if associated_roles is not None:
            pulumi.set(__self__, "associated_roles", associated_roles)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if automatic_backup_replication_kms_key_id is not None:
            pulumi.set(__self__, "automatic_backup_replication_kms_key_id", automatic_backup_replication_kms_key_id)
        if automatic_backup_replication_region is not None:
            pulumi.set(__self__, "automatic_backup_replication_region", automatic_backup_replication_region)
        if automatic_backup_replication_retention_period is not None:
            pulumi.set(__self__, "automatic_backup_replication_retention_period", automatic_backup_replication_retention_period)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if ca_certificate_identifier is not None:
            pulumi.set(__self__, "ca_certificate_identifier", ca_certificate_identifier)
        if certificate_rotation_restart is not None:
            pulumi.set(__self__, "certificate_rotation_restart", certificate_rotation_restart)
        if character_set_name is not None:
            pulumi.set(__self__, "character_set_name", character_set_name)
        if copy_tags_to_snapshot is not None:
            pulumi.set(__self__, "copy_tags_to_snapshot", copy_tags_to_snapshot)
        if custom_iam_instance_profile is not None:
            pulumi.set(__self__, "custom_iam_instance_profile", custom_iam_instance_profile)
        if database_insights_mode is not None:
            pulumi.set(__self__, "database_insights_mode", database_insights_mode)
        if db_cluster_identifier is not None:
            pulumi.set(__self__, "db_cluster_identifier", db_cluster_identifier)
        if db_cluster_snapshot_identifier is not None:
            pulumi.set(__self__, "db_cluster_snapshot_identifier", db_cluster_snapshot_identifier)
        if db_instance_class is not None:
            pulumi.set(__self__, "db_instance_class", db_instance_class)
        if db_instance_identifier is not None:
            pulumi.set(__self__, "db_instance_identifier", db_instance_identifier)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_parameter_group_name is not None:
            pulumi.set(__self__, "db_parameter_group_name", db_parameter_group_name)
        if db_security_groups is not None:
            pulumi.set(__self__, "db_security_groups", db_security_groups)
        if db_snapshot_identifier is not None:
            pulumi.set(__self__, "db_snapshot_identifier", db_snapshot_identifier)
        if db_subnet_group_name is not None:
            pulumi.set(__self__, "db_subnet_group_name", db_subnet_group_name)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if dedicated_log_volume is not None:
            pulumi.set(__self__, "dedicated_log_volume", dedicated_log_volume)
        if delete_automated_backups is not None:
            pulumi.set(__self__, "delete_automated_backups", delete_automated_backups)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_auth_secret_arn is not None:
            pulumi.set(__self__, "domain_auth_secret_arn", domain_auth_secret_arn)
        if domain_dns_ips is not None:
            pulumi.set(__self__, "domain_dns_ips", domain_dns_ips)
        if domain_fqdn is not None:
            pulumi.set(__self__, "domain_fqdn", domain_fqdn)
        if domain_iam_role_name is not None:
            pulumi.set(__self__, "domain_iam_role_name", domain_iam_role_name)
        if domain_ou is not None:
            pulumi.set(__self__, "domain_ou", domain_ou)
        if enable_cloudwatch_logs_exports is not None:
            pulumi.set(__self__, "enable_cloudwatch_logs_exports", enable_cloudwatch_logs_exports)
        if enable_iam_database_authentication is not None:
            pulumi.set(__self__, "enable_iam_database_authentication", enable_iam_database_authentication)
        if enable_performance_insights is not None:
            pulumi.set(__self__, "enable_performance_insights", enable_performance_insights)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_lifecycle_support is not None:
            pulumi.set(__self__, "engine_lifecycle_support", engine_lifecycle_support)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if manage_master_user_password is not None:
            pulumi.set(__self__, "manage_master_user_password", manage_master_user_password)
        if master_user_password is not None:
            pulumi.set(__self__, "master_user_password", master_user_password)
        if master_user_secret is not None:
            pulumi.set(__self__, "master_user_secret", master_user_secret)
        if master_username is not None:
            pulumi.set(__self__, "master_username", master_username)
        if max_allocated_storage is not None:
            pulumi.set(__self__, "max_allocated_storage", max_allocated_storage)
        if monitoring_interval is not None:
            pulumi.set(__self__, "monitoring_interval", monitoring_interval)
        if monitoring_role_arn is not None:
            pulumi.set(__self__, "monitoring_role_arn", monitoring_role_arn)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if nchar_character_set_name is not None:
            pulumi.set(__self__, "nchar_character_set_name", nchar_character_set_name)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if option_group_name is not None:
            pulumi.set(__self__, "option_group_name", option_group_name)
        if performance_insights_kms_key_id is not None:
            pulumi.set(__self__, "performance_insights_kms_key_id", performance_insights_kms_key_id)
        if performance_insights_retention_period is not None:
            pulumi.set(__self__, "performance_insights_retention_period", performance_insights_retention_period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_backup_window is not None:
            pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if processor_features is not None:
            pulumi.set(__self__, "processor_features", processor_features)
        if promotion_tier is not None:
            pulumi.set(__self__, "promotion_tier", promotion_tier)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if replica_mode is not None:
            pulumi.set(__self__, "replica_mode", replica_mode)
        if restore_time is not None:
            pulumi.set(__self__, "restore_time", restore_time)
        if source_db_cluster_identifier is not None:
            pulumi.set(__self__, "source_db_cluster_identifier", source_db_cluster_identifier)
        if source_db_instance_automated_backups_arn is not None:
            pulumi.set(__self__, "source_db_instance_automated_backups_arn", source_db_instance_automated_backups_arn)
        if source_db_instance_identifier is not None:
            pulumi.set(__self__, "source_db_instance_identifier", source_db_instance_identifier)
        if source_dbi_resource_id is not None:
            pulumi.set(__self__, "source_dbi_resource_id", source_dbi_resource_id)
        if source_region is not None:
            pulumi.set(__self__, "source_region", source_region)
        if storage_encrypted is not None:
            pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if storage_throughput is not None:
            pulumi.set(__self__, "storage_throughput", storage_throughput)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tde_credential_arn is not None:
            pulumi.set(__self__, "tde_credential_arn", tde_credential_arn)
        if tde_credential_password is not None:
            pulumi.set(__self__, "tde_credential_password", tde_credential_password)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if use_default_processor_features is not None:
            pulumi.set(__self__, "use_default_processor_features", use_default_processor_features)
        if use_latest_restorable_time is not None:
            pulumi.set(__self__, "use_latest_restorable_time", use_latest_restorable_time)
        if vpc_security_groups is not None:
            pulumi.set(__self__, "vpc_security_groups", vpc_security_groups)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The amount of storage in gibibytes (GiB) to be initially allocated for the database instance.
          If any value is set in the ``Iops`` parameter, ``AllocatedStorage`` must be at least 100 GiB, which corresponds to the minimum Iops value of 1,000. If you increase the ``Iops`` value (in 1,000 IOPS increments), then you must also increase the ``AllocatedStorage`` value (in 100-GiB increments). 
           *Amazon Aurora* 
         Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.
          *Db2* 
         Constraints to the amount of storage for each storage type are the following:
          +  General Purpose (SSD) storage (gp3): Must be an integer from 20 to 64000.
          +  Provisioned IOPS storage (io1): Must be an integer from 100 to 64000.
          
          *MySQL* 
         Constraints to the amount of storage for each storage type are the following: 
          +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
          +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
          +  Magnetic storage (standard): Must be an integer from 5 to 3072.
          
          *MariaDB* 
         Constraints to the amount of storage for each storage type are the following: 
          +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
          +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
          +  Magnetic storage (standard): Must be an integer from 5 to 3072.
          
          *PostgreSQL* 
         Constraints to the amount of storage for each storage type are the following: 
          +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
          +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
          +  Magnetic storage (standard): Must be an integer from 5 to 3072.
          
          *Oracle* 
         Constraints to the amount of storage for each storage type are the following: 
          +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
          +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
          +  Magnetic storage (standard): Must be an integer from 10 to 3072.
          
          *SQL Server* 
         Constraints to the amount of storage for each storage type are the following: 
          +  General Purpose (SSD) storage (gp2):
          +  Enterprise and Standard editions: Must be an integer from 20 to 16384.
          +  Web and Express editions: Must be an integer from 20 to 16384.
          
          +  Provisioned IOPS storage (io1):
          +  Enterprise and Standard editions: Must be an integer from 20 to 16384.
          +  Web and Express editions: Must be an integer from 20 to 16384.
          
          +  Magnetic storage (standard):
          +  Enterprise and Standard editions: Must be an integer from 20 to 1024.
          +  Web and Express editions: Must be an integer from 20 to 1024.
        """
        return pulumi.get(self, "allocated_storage")

    @allocated_storage.setter
    def allocated_storage(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allocated_storage", value)

    @property
    @pulumi.getter(name="allowMajorVersionUpgrade")
    def allow_major_version_upgrade(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that indicates whether major version upgrades are allowed. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
         Constraints: Major version upgrades must be allowed when specifying a value for the ``EngineVersion`` parameter that is a different major version than the DB instance's current version.
        """
        return pulumi.get(self, "allow_major_version_upgrade")

    @allow_major_version_upgrade.setter
    def allow_major_version_upgrade(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_major_version_upgrade", value)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the ``PreferredMaintenanceWindow`` setting. If set to ``false``, changes are applied during the next maintenance window. Until RDS applies the changes, the DB instance remains in a drift state. As a result, the configuration doesn't fully reflect the requested modifications and temporarily diverges from the intended state.
         In addition to the settings described in [Modifying a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html), this property also determines whether the DB instance reboots when a static parameter is modified in the associated DB parameter group.
         Default: ``true``
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "apply_immediately", value)

    @property
    @pulumi.getter(name="associatedRoles")
    def associated_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceDbInstanceRoleArgs']]]]:
        """
        The IAMlong (IAM) roles associated with the DB instance. 
          *Amazon Aurora* 
         Not applicable. The associated roles are managed by the DB cluster.
        """
        return pulumi.get(self, "associated_roles")

    @associated_roles.setter
    def associated_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceDbInstanceRoleArgs']]]]):
        pulumi.set(self, "associated_roles", value)

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are applied automatically.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @property
    @pulumi.getter(name="automaticBackupReplicationKmsKeyId")
    def automatic_backup_replication_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination AWS-Region, for example, ``arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE``.
        """
        return pulumi.get(self, "automatic_backup_replication_kms_key_id")

    @automatic_backup_replication_kms_key_id.setter
    def automatic_backup_replication_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "automatic_backup_replication_kms_key_id", value)

    @property
    @pulumi.getter(name="automaticBackupReplicationRegion")
    def automatic_backup_replication_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS-Region associated with the automated backup.
        """
        return pulumi.get(self, "automatic_backup_replication_region")

    @automatic_backup_replication_region.setter
    def automatic_backup_replication_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "automatic_backup_replication_region", value)

    @property
    @pulumi.getter(name="automaticBackupReplicationRetentionPeriod")
    def automatic_backup_replication_retention_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The retention period for automated backups in a different AWS Region. Use this parameter to set a unique retention period that only applies to cross-Region automated backups. To enable automated backups in a different Region, specify a positive value for the ``AutomaticBackupReplicationRegion`` parameter. 
         If not specified, this parameter defaults to the value of the ``BackupRetentionPeriod`` parameter. The maximum allowed value is 35.
        """
        return pulumi.get(self, "automatic_backup_replication_retention_period")

    @automatic_backup_replication_retention_period.setter
    def automatic_backup_replication_retention_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "automatic_backup_replication_retention_period", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Availability Zone (AZ) where the database will be created. For information on AWS-Regions and Availability Zones, see [Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
         For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.
         Default: A random, system-chosen Availability Zone in the endpoint's AWS-Region.
         Constraints:
          +  The ``AvailabilityZone`` parameter can't be specified if the DB instance is a Multi-AZ deployment.
          +  The specified Availability Zone must be in the same AWS-Region as the current endpoint.
          
         Example: ``us-east-1d``
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
          *Amazon Aurora* 
         Not applicable. The retention period for automated backups is managed by the DB cluster.
         Default: 1
         Constraints:
          +  Must be a value from 0 to 35
          +  Can't be set to 0 if the DB instance is a source to read replicas
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backup_retention_period", value)

    @property
    @pulumi.getter(name="caCertificateIdentifier")
    def ca_certificate_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the CA certificate for this DB instance.
         For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
        """
        return pulumi.get(self, "ca_certificate_identifier")

    @ca_certificate_identifier.setter
    def ca_certificate_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_certificate_identifier", value)

    @property
    @pulumi.getter(name="certificateRotationRestart")
    def certificate_rotation_restart(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
         By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.
          Set this parameter only if you are *not* using SSL/TLS to connect to the DB instance.
          If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB engine to rotate your SSL/TLS certificate:
          +  For more information about rotating your SSL/TLS certificate for RDS DB engines, see [Rotating Your SSL/TLS Certificate.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html) in the *Amazon RDS User Guide.*
          +  For more information about rotating your SSL/TLS certificate for Aurora DB engines, see [Rotating Your SSL/TLS Certificate](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html) in the *Amazon Aurora User Guide*.
          
         This setting doesn't apply to RDS Custom DB instances.
        """
        return pulumi.get(self, "certificate_rotation_restart")

    @certificate_rotation_restart.setter
    def certificate_rotation_restart(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "certificate_rotation_restart", value)

    @property
    @pulumi.getter(name="characterSetName")
    def character_set_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For supported engines, indicates that the DB instance should be associated with the specified character set.
          *Amazon Aurora* 
         Not applicable. The character set is managed by the DB cluster. For more information, see [AWS::RDS::DBCluster](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html).
        """
        return pulumi.get(self, "character_set_name")

    @character_set_name.setter
    def character_set_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "character_set_name", value)

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.
         This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @copy_tags_to_snapshot.setter
    def copy_tags_to_snapshot(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "copy_tags_to_snapshot", value)

    @property
    @pulumi.getter(name="customIamInstanceProfile")
    def custom_iam_instance_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
         This setting is required for RDS Custom.
         Constraints:
          +  The profile must exist in your account.
          +  The profile must have an IAM role that Amazon EC2 has permissions to assume.
          +  The instance profile name and the associated IAM role name must start with the prefix ``AWSRDSCustom``.
          
         For the list of permissions required for the IAM role, see [Configure IAM and your VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc) in the *Amazon RDS User Guide*.
        """
        return pulumi.get(self, "custom_iam_instance_profile")

    @custom_iam_instance_profile.setter
    def custom_iam_instance_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_iam_instance_profile", value)

    @property
    @pulumi.getter(name="databaseInsightsMode")
    def database_insights_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mode of Database Insights to enable for the DB instance.
          Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
        """
        return pulumi.get(self, "database_insights_mode")

    @database_insights_mode.setter
    def database_insights_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_insights_mode", value)

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the DB cluster that this DB instance will belong to.
         This setting doesn't apply to RDS Custom DB instances.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @db_cluster_identifier.setter
    def db_cluster_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_cluster_identifier", value)

    @property
    @pulumi.getter(name="dbClusterSnapshotIdentifier")
    def db_cluster_snapshot_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier for the Multi-AZ DB cluster snapshot to restore from.
         For more information on Multi-AZ DB clusters, see [Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
         Constraints:
          +  Must match the identifier of an existing Multi-AZ DB cluster snapshot.
          +  Can't be specified when ``DBSnapshotIdentifier`` is specified.
          +  Must be specified when ``DBSnapshotIdentifier`` isn't specified.
          +  If you are restoring from a shared manual Multi-AZ DB cluster snapshot, the ``DBClusterSnapshotIdentifier`` must be the ARN of the shared snapshot.
          +  Can't be the identifier of an Aurora DB cluster snapshot.
        """
        return pulumi.get(self, "db_cluster_snapshot_identifier")

    @db_cluster_snapshot_identifier.setter
    def db_cluster_snapshot_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_cluster_snapshot_identifier", value)

    @property
    @pulumi.getter(name="dbInstanceClass")
    def db_instance_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The compute and memory capacity of the DB instance, for example ``db.m5.large``. Not all DB instance classes are available in all AWS-Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see [DB instance classes](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide* or [Aurora DB instance classes](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html) in the *Amazon Aurora User Guide*.
        """
        return pulumi.get(self, "db_instance_class")

    @db_instance_class.setter
    def db_instance_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_instance_class", value)

    @property
    @pulumi.getter(name="dbInstanceIdentifier")
    def db_instance_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for the DB instance. If you specify a name, AWS CloudFormation converts it to lowercase. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the DB instance. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
         For information about constraints that apply to DB instance identifiers, see [Naming constraints in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints) in the *Amazon RDS User Guide*.
          If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        """
        return pulumi.get(self, "db_instance_identifier")

    @db_instance_identifier.setter
    def db_instance_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_instance_identifier", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The meaning of this parameter differs according to the database engine you use.
          If you specify the ``DBSnapshotIdentifier`` property, this property only applies to RDS for Oracle.
           *Amazon Aurora* 
         Not applicable. The database name is managed by the DB cluster.
          *Db2* 
         The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.
         Constraints:
          +  Must contain 1 to 64 letters or numbers.
          +  Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
          +  Can't be a word reserved by the specified database engine.
          
          *MySQL* 
         The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
         Constraints:
          +  Must contain 1 to 64 letters or numbers.
          +  Can't be a word reserved by the specified database engine
          
          *MariaDB* 
         The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
         Constraints:
          +  Must contain 1 to 64 letters or numbers.
          +  Can't be a word reserved by the specified database engine
          
          *PostgreSQL* 
         The name of the database to create when the DB instance is created. If this parameter is not specified, the default ``postgres`` database is created in the DB instance.
         Constraints:
          +  Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
          +  Must contain 1 to 63 characters.
          +  Can't be a word reserved by the specified database engine
          
          *Oracle* 
         The Oracle System ID (SID) of the created DB instance. If you specify ``null``, the default value ``ORCL`` is used. You can't specify the string NULL, or any other reserved word, for ``DBName``. 
         Default: ``ORCL``
         Constraints:
          +  Can't be longer than 8 characters
          
          *SQL Server* 
         Not applicable. Must be null.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="dbParameterGroupName")
    def db_parameter_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of an existing DB parameter group or a reference to an [AWS::RDS::DBParameterGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html) resource created in the template.
         To list all of the available DB parameter group names, use the following command:
          ``aws rds describe-db-parameter-groups --query "DBParameterGroups[].DBParameterGroupName" --output text`` 
          If any of the data members of the referenced parameter group are changed during an update, the DB instance might need to be restarted, which causes some interruption. If the parameter group contains static parameters, whether they were changed or not, an update triggers a reboot.
          If you don't specify a value for ``DBParameterGroupName`` property, the default DB parameter group for the specified engine and engine version is used.
        """
        return pulumi.get(self, "db_parameter_group_name")

    @db_parameter_group_name.setter
    def db_parameter_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_parameter_group_name", value)

    @property
    @pulumi.getter(name="dbSecurityGroups")
    def db_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the DB security groups to assign to the DB instance. The list can include both the name of existing DB security groups or references to AWS::RDS::DBSecurityGroup resources created in the template.
          If you set DBSecurityGroups, you must not set VPCSecurityGroups, and vice versa. Also, note that the DBSecurityGroups property exists only for backwards compatibility with older regions and is no longer recommended for providing security information to an RDS DB instance. Instead, use VPCSecurityGroups.
          If you specify this property, AWS CloudFormation sends only the following properties (if specified) to Amazon RDS during create operations:
          +   ``AllocatedStorage`` 
          +   ``AutoMinorVersionUpgrade`` 
          +   ``AvailabilityZone`` 
          +   ``BackupRetentionPeriod`` 
          +   ``CharacterSetName`` 
          +   ``DBInstanceClass`` 
          +   ``DBName`` 
          +   ``DBParameterGroupName`` 
          +   ``DBSecurityGroups`` 
          +   ``DBSubnetGroupName`` 
          +   ``Engine`` 
          +   ``EngineVersion`` 
          +   ``Iops`` 
          +   ``LicenseModel`` 
          +   ``MasterUsername`` 
          +   ``MasterUserPassword`` 
          +   ``MultiAZ`` 
          +   ``OptionGroupName`` 
          +   ``PreferredBackupWindow`` 
          +   ``PreferredMaintenanceWindow`` 
          
         All other properties are ignored. Specify a virtual private cloud (VPC) security group if you want to submit other properties, such as ``StorageType``, ``StorageEncrypted``, or ``KmsKeyId``. If you're already using the ``DBSecurityGroups`` property, you can't use these other properties by updating your DB instance to use a VPC security group. You must recreate the DB instance.
        """
        return pulumi.get(self, "db_security_groups")

    @db_security_groups.setter
    def db_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "db_security_groups", value)

    @property
    @pulumi.getter(name="dbSnapshotIdentifier")
    def db_snapshot_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name or Amazon Resource Name (ARN) of the DB snapshot that's used to restore the DB instance. If you're restoring from a shared manual DB snapshot, you must specify the ARN of the snapshot.
         By specifying this property, you can create a DB instance from the specified DB snapshot. If the ``DBSnapshotIdentifier`` property is an empty string or the ``AWS::RDS::DBInstance`` declaration has no ``DBSnapshotIdentifier`` property, AWS CloudFormation creates a new database. If the property contains a value (other than an empty string), AWS CloudFormation creates a database from the specified snapshot. If a snapshot with the specified name doesn't exist, AWS CloudFormation can't create the database and it rolls back the stack.
         Some DB instance properties aren't valid when you restore from a snapshot, such as the ``MasterUsername`` and ``MasterUserPassword`` properties, and the point-in-time recovery properties ``RestoreTime`` and ``UseLatestRestorableTime``. For information about the properties that you can specify, see the [RestoreDBInstanceFromDBSnapshot](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBInstanceFromDBSnapshot.html) action in the *Amazon RDS API Reference*.
         After you restore a DB instance with a ``DBSnapshotIdentifier`` property, you must specify the same ``DBSnapshotIdentifier`` property for any future updates to the DB instance. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the ``DBSnapshotIdentifier`` property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified ``DBSnapshotIdentifier`` property, and the original DB instance is deleted.
         If you specify the ``DBSnapshotIdentifier`` property to restore a DB instance (as opposed to specifying it for DB instance updates), then don't specify the following properties:
          +   ``CharacterSetName`` 
          +   ``DBClusterIdentifier`` 
          +   ``DBName`` 
          +   ``KmsKeyId`` 
          +   ``MasterUsername`` 
          +   ``MasterUserPassword`` 
          +   ``PromotionTier`` 
          +   ``SourceDBInstanceIdentifier`` 
          +   ``SourceRegion`` 
          +  ``StorageEncrypted`` (for an unencrypted snapshot)
          +   ``Timezone`` 
          
          *Amazon Aurora* 
         Not applicable. Snapshot restore is managed by the DB cluster.
        """
        return pulumi.get(self, "db_snapshot_identifier")

    @db_snapshot_identifier.setter
    def db_snapshot_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_snapshot_identifier", value)

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A DB subnet group to associate with the DB instance. If you update this value, the new subnet group must be a subnet group in a new VPC. 
         If you don't specify a DB subnet group, RDS uses the default DB subnet group if one exists. If a default DB subnet group does not exist, and you don't specify a ``DBSubnetGroupName``, the DB instance fails to launch. 
         For more information about using Amazon RDS in a VPC, see [Amazon VPC and Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html) in the *Amazon RDS User Guide*. 
         This setting doesn't apply to Amazon Aurora DB instances. The DB subnet group is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @db_subnet_group_name.setter
    def db_subnet_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_subnet_group_name", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your database files. In this context, the term "Oracle database instance" refers exclusively to the system global area (SGA) and Oracle background processes. If you don't specify a SID, the value defaults to ``RDSCDB``. The Oracle SID is also the name of your CDB.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="dedicatedLogVolume")
    def dedicated_log_volume(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
        """
        return pulumi.get(self, "dedicated_log_volume")

    @dedicated_log_volume.setter
    def dedicated_log_volume(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dedicated_log_volume", value)

    @property
    @pulumi.getter(name="deleteAutomatedBackups")
    def delete_automated_backups(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.
          *Amazon Aurora* 
         Not applicable. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the DB cluster are not deleted.
        """
        return pulumi.get(self, "delete_automated_backups")

    @delete_automated_backups.setter
    def delete_automated_backups(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_automated_backups", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see [Deleting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
         This setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion protection for the DB cluster. For more information, see ``CreateDBCluster``. DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Active Directory directory ID to create the DB instance in. Currently, only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
         For more information, see [Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html) in the *Amazon RDS User Guide*.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="domainAuthSecretArn")
    def domain_auth_secret_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
         Example: ``arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456``
        """
        return pulumi.get(self, "domain_auth_secret_arn")

    @domain_auth_secret_arn.setter
    def domain_auth_secret_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_auth_secret_arn", value)

    @property
    @pulumi.getter(name="domainDnsIps")
    def domain_dns_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
         Constraints:
          +  Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.
          
         Example: ``123.124.125.126,234.235.236.237``
        """
        return pulumi.get(self, "domain_dns_ips")

    @domain_dns_ips.setter
    def domain_dns_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "domain_dns_ips", value)

    @property
    @pulumi.getter(name="domainFqdn")
    def domain_fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fully qualified domain name (FQDN) of an Active Directory domain.
         Constraints:
          +  Can't be longer than 64 characters.
          
         Example: ``mymanagedADtest.mymanagedAD.mydomain``
        """
        return pulumi.get(self, "domain_fqdn")

    @domain_fqdn.setter
    def domain_fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_fqdn", value)

    @property
    @pulumi.getter(name="domainIamRoleName")
    def domain_iam_role_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the IAM role to use when making API calls to the Directory Service.
         This setting doesn't apply to the following DB instances:
          +  Amazon Aurora (The domain is managed by the DB cluster.)
          +  RDS Custom
        """
        return pulumi.get(self, "domain_iam_role_name")

    @domain_iam_role_name.setter
    def domain_iam_role_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_iam_role_name", value)

    @property
    @pulumi.getter(name="domainOu")
    def domain_ou(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Active Directory organizational unit for your DB instance to join.
         Constraints:
          +  Must be in the distinguished name format.
          +  Can't be longer than 64 characters.
          
         Example: ``OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain``
        """
        return pulumi.get(self, "domain_ou")

    @domain_ou.setter
    def domain_ou(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_ou", value)

    @property
    @pulumi.getter(name="enableCloudwatchLogsExports")
    def enable_cloudwatch_logs_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Relational Database Service User Guide*.
          *Amazon Aurora* 
         Not applicable. CloudWatch Logs exports are managed by the DB cluster. 
          *Db2* 
         Valid values: ``diag.log``, ``notify.log``
          *MariaDB* 
         Valid values: ``audit``, ``error``, ``general``, ``slowquery``
          *Microsoft SQL Server* 
         Valid values: ``agent``, ``error``
          *MySQL* 
         Valid values: ``audit``, ``error``, ``general``, ``slowquery``
          *Oracle* 
         Valid values: ``alert``, ``audit``, ``listener``, ``trace``, ``oemagent``
          *PostgreSQL* 
         Valid values: ``postgresql``, ``upgrade``
        """
        return pulumi.get(self, "enable_cloudwatch_logs_exports")

    @enable_cloudwatch_logs_exports.setter
    def enable_cloudwatch_logs_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "enable_cloudwatch_logs_exports", value)

    @property
    @pulumi.getter(name="enableIamDatabaseAuthentication")
    def enable_iam_database_authentication(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.
         This property is supported for RDS for MariaDB, RDS for MySQL, and RDS for PostgreSQL. For more information, see [IAM Database Authentication for MariaDB, MySQL, and PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon RDS User Guide.*
          *Amazon Aurora* 
         Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.
        """
        return pulumi.get(self, "enable_iam_database_authentication")

    @enable_iam_database_authentication.setter
    def enable_iam_database_authentication(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_iam_database_authentication", value)

    @property
    @pulumi.getter(name="enablePerformanceInsights")
    def enable_performance_insights(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to enable Performance Insights for the DB instance. For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
         This setting doesn't apply to RDS Custom DB instances.
        """
        return pulumi.get(self, "enable_performance_insights")

    @enable_performance_insights.setter
    def enable_performance_insights(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_performance_insights", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the database engine to use for this DB instance. Not every database engine is available in every AWS Region.
         This property is required when creating a DB instance.
          You can convert an Oracle database from the non-CDB architecture to the container database (CDB) architecture by updating the ``Engine`` value in your templates from ``oracle-ee`` to ``oracle-ee-cdb`` or from ``oracle-se2`` to ``oracle-se2-cdb``. Converting to the CDB architecture requires an interruption.
          Valid Values:
          +  ``aurora-mysql`` (for Aurora MySQL DB instances)
          +  ``aurora-postgresql`` (for Aurora PostgreSQL DB instances)
          +  ``custom-oracle-ee`` (for RDS Custom for Oracle DB instances)
          +  ``custom-oracle-ee-cdb`` (for RDS Custom for Oracle DB instances)
          +  ``custom-sqlserver-ee`` (for RDS Custom for SQL Server DB instances)
          +  ``custom-sqlserver-se`` (for RDS Custom for SQL Server DB instances)
          +  ``custom-sqlserver-web`` (for RDS Custom for SQL Server DB instances)
          +   ``db2-ae`` 
          +   ``db2-se`` 
          +   ``mariadb`` 
          +   ``mysql`` 
          +   ``oracle-ee`` 
          +   ``oracle-ee-cdb`` 
          +   ``oracle-se2`` 
          +   ``oracle-se2-cdb`` 
          +   ``postgres`` 
          +   ``sqlserver-ee`` 
          +   ``sqlserver-se`` 
          +   ``sqlserver-ex`` 
          +   ``sqlserver-web``
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineLifecycleSupport")
    def engine_lifecycle_support(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The life cycle type for this DB instance.
          By default, this value is set to ``open-source-rds-extended-support``, which enrolls your DB instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to ``open-source-rds-extended-support-disabled``. In this case, creating the DB instance will fail if the DB major version is past its end of standard support date.
          This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by the DB cluster.
         You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB instance past the end of standard support for that engine version. For more information, see [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html) in the *Amazon RDS User Guide*.
         Valid Values: ``open-source-rds-extended-support | open-source-rds-extended-support-disabled``
         Default: ``open-source-rds-extended-support``
        """
        return pulumi.get(self, "engine_lifecycle_support")

    @engine_lifecycle_support.setter
    def engine_lifecycle_support(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine_lifecycle_support", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version number of the database engine to use.
         For a list of valid engine versions, use the ``DescribeDBEngineVersions`` action.
         The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every AWS Region.
          *Amazon Aurora* 
         Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.
          *Db2* 
         See [Amazon RDS for Db2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Db2.html#Db2.Concepts.VersionMgmt) in the *Amazon RDS User Guide.*
          *MariaDB* 
         See [MariaDB on Amazon RDS Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt) in the *Amazon RDS User Guide.*
          *Microsoft SQL Server* 
         See [Microsoft SQL Server Versions on Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport) in the *Amazon RDS User Guide.*
          *MySQL* 
         See [MySQL on Amazon RDS Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt) in the *Amazon RDS User Guide.*
          *Oracle* 
         See [Oracle Database Engine Release Notes](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html) in the *Amazon RDS User Guide.*
          *PostgreSQL* 
         See [Supported PostgreSQL Database Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts.General.DBVersions) in the *Amazon RDS User Guide.*
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of I/O operations per second (IOPS) that the database provisions. The value must be equal to or greater than 1000. 
         If you specify this property, you must follow the range of allowed ratios of your requested IOPS rate to the amount of storage that you allocate (IOPS to allocated storage). For example, you can provision an Oracle database instance with 1000 IOPS and 200 GiB of storage (a ratio of 5:1), or specify 2000 IOPS with 200 GiB of storage (a ratio of 10:1). For more information, see [Amazon RDS Provisioned IOPS Storage to Improve Performance](https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
          If you specify ``io1`` for the ``StorageType`` property, then you must also specify the ``Iops`` property.
          Constraints:
          +  For RDS for Db2, MariaDB, MySQL, Oracle, and PostgreSQL - Must be a multiple between .5 and 50 of the storage amount for the DB instance.
          +  For RDS for SQL Server - Must be a multiple between 1 and 50 of the storage amount for the DB instance.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the AWS KMS key that's used to encrypt the DB instance, such as ``arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef``. If you enable the StorageEncrypted property but don't specify this property, AWS CloudFormation uses the default KMS key. If you specify this property, you must set the StorageEncrypted property to true. 
         If you specify the ``SourceDBInstanceIdentifier`` or ``SourceDbiResourceId`` property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified ``KmsKeyId`` property is used. However, if the source DB instance is in a different AWS Region, you must specify a KMS key ID.
         If you specify the ``SourceDBInstanceAutomatedBackupsArn`` property, don't specify this property. The value is inherited from the source DB instance automated backup, and if the automated backup is encrypted, the specified ``KmsKeyId`` property is used.
         If you create an encrypted read replica in a different AWS Region, then you must specify a KMS key for the destination AWS Region. KMS encryption keys are specific to the region that they're created in, and you can't use encryption keys from one region in another region.
         If you specify the ``DBSnapshotIdentifier`` property, don't specify this property. The ``StorageEncrypted`` property value is inherited from the snapshot. If the DB instance is encrypted, the specified ``KmsKeyId`` property is also inherited from the snapshot.
         If you specify ``DBSecurityGroups``, AWS CloudFormation ignores this property. To specify both a security group and this property, you must use a VPC security group. For more information about Amazon RDS and VPC, see [Using Amazon RDS with Amazon VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html) in the *Amazon RDS User Guide*.
          *Amazon Aurora* 
         Not applicable. The KMS key identifier is managed by the DB cluster.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        License model information for this DB instance.
          Valid Values:
          +  Aurora MySQL - ``general-public-license``
          +  Aurora PostgreSQL - ``postgresql-license``
          +  RDS for Db2 - ``bring-your-own-license``. For more information about RDS for Db2 licensing, see [](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html) in the *Amazon RDS User Guide.*
          +  RDS for MariaDB - ``general-public-license``
          +  RDS for Microsoft SQL Server - ``license-included``
          +  RDS for MySQL - ``general-public-license``
          +  RDS for Oracle - ``bring-your-own-license`` or ``license-included``
          +  RDS for PostgreSQL - ``postgresql-license``
          
          If you've specified ``DBSecurityGroups`` and then you update the license model, AWS CloudFormation replaces the underlying DB instance. This will incur some interruptions to database availability.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="manageMasterUserPassword")
    def manage_master_user_password(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to manage the master user password with AWS Secrets Manager.
         For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide.*
         Constraints:
          +  Can't manage the master user password with AWS Secrets Manager if ``MasterUserPassword`` is specified.
        """
        return pulumi.get(self, "manage_master_user_password")

    @manage_master_user_password.setter
    def manage_master_user_password(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "manage_master_user_password", value)

    @property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password for the master user. The password can include any printable ASCII character except "/", \"\"\", or "@".
          *Amazon Aurora* 
         Not applicable. The password for the master user is managed by the DB cluster.
          *RDS for Db2* 
         Must contain from 8 to 255 characters.
          *RDS for MariaDB* 
         Constraints: Must contain from 8 to 41 characters.
          *RDS for Microsoft SQL Server* 
         Constraints: Must contain from 8 to 128 characters.
          *RDS for MySQL* 
         Constraints: Must contain from 8 to 41 characters.
          *RDS for Oracle* 
         Constraints: Must contain from 8 to 30 characters.
          *RDS for PostgreSQL* 
         Constraints: Must contain from 8 to 128 characters.
        """
        return pulumi.get(self, "master_user_password")

    @master_user_password.setter
    def master_user_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_user_password", value)

    @property
    @pulumi.getter(name="masterUserSecret")
    def master_user_secret(self) -> Optional[pulumi.Input['DbInstanceMasterUserSecretArgs']]:
        """
        The secret managed by RDS in AWS Secrets Manager for the master user password.
         For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide.*
        """
        return pulumi.get(self, "master_user_secret")

    @master_user_secret.setter
    def master_user_secret(self, value: Optional[pulumi.Input['DbInstanceMasterUserSecretArgs']]):
        pulumi.set(self, "master_user_secret", value)

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The master user name for the DB instance.
          If you specify the ``SourceDBInstanceIdentifier`` or ``DBSnapshotIdentifier`` property, don't specify this property. The value is inherited from the source DB instance or snapshot.
         When migrating a self-managed Db2 database, we recommend that you use the same master username as your self-managed Db2 instance name.
           *Amazon Aurora* 
         Not applicable. The name for the master user is managed by the DB cluster. 
          *RDS for Db2* 
         Constraints:
          +  Must be 1 to 16 letters or numbers.
          +  First character must be a letter.
          +  Can't be a reserved word for the chosen database engine.
          
          *RDS for MariaDB* 
         Constraints:
          +  Must be 1 to 16 letters or numbers.
          +  Can't be a reserved word for the chosen database engine.
          
          *RDS for Microsoft SQL Server* 
         Constraints:
          +  Must be 1 to 128 letters or numbers.
          +  First character must be a letter.
          +  Can't be a reserved word for the chosen database engine.
          
          *RDS for MySQL* 
         Constraints:
          +  Must be 1 to 16 letters or numbers.
          +  First character must be a letter.
          +  Can't be a reserved word for the chosen database engine.
          
          *RDS for Oracle* 
         Constraints:
          +  Must be 1 to 30 letters or numbers.
          +  First character must be a letter.
          +  Can't be a reserved word for the chosen database engine.
          
          *RDS for PostgreSQL* 
         Constraints:
          +  Must be 1 to 63 letters or numbers.
          +  First character must be a letter.
          +  Can't be a reserved word for the chosen database engine.
        """
        return pulumi.get(self, "master_username")

    @master_username.setter
    def master_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_username", value)

    @property
    @pulumi.getter(name="maxAllocatedStorage")
    def max_allocated_storage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
         For more information about this setting, including limitations that apply to it, see [Managing capacity automatically with Amazon RDS storage autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling) in the *Amazon RDS User Guide*.
         This setting doesn't apply to the following DB instances:
          +  Amazon Aurora (Storage is managed by the DB cluster.)
          +  RDS Custom
        """
        return pulumi.get(self, "max_allocated_storage")

    @max_allocated_storage.setter
    def max_allocated_storage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_allocated_storage", value)

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collection of Enhanced Monitoring metrics, specify ``0``.
         If ``MonitoringRoleArn`` is specified, then you must set ``MonitoringInterval`` to a value other than ``0``.
         This setting doesn't apply to RDS Custom DB instances.
         Valid Values: ``0 | 1 | 5 | 10 | 15 | 30 | 60``
         Default: ``0``
        """
        return pulumi.get(self, "monitoring_interval")

    @monitoring_interval.setter
    def monitoring_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "monitoring_interval", value)

    @property
    @pulumi.getter(name="monitoringRoleArn")
    def monitoring_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, ``arn:aws:iam:123456789012:role/emaccess``. For information on creating a monitoring role, see [Setting Up and Enabling Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling) in the *Amazon RDS User Guide*.
         If ``MonitoringInterval`` is set to a value other than ``0``, then you must supply a ``MonitoringRoleArn`` value.
         This setting doesn't apply to RDS Custom DB instances.
        """
        return pulumi.get(self, "monitoring_role_arn")

    @monitoring_role_arn.setter
    def monitoring_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "monitoring_role_arn", value)

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the DB instance is a Multi-AZ deployment. You can't set the ``AvailabilityZone`` parameter if the DB instance is a Multi-AZ deployment.
         This setting doesn't apply to the following DB instances:
          +  Amazon Aurora (DB instance Availability Zones (AZs) are managed by the DB cluster.)
          +  RDS Custom
        """
        return pulumi.get(self, "multi_az")

    @multi_az.setter
    def multi_az(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "multi_az", value)

    @property
    @pulumi.getter(name="ncharCharacterSetName")
    def nchar_character_set_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the NCHAR character set for the Oracle DB instance.
         This setting doesn't apply to RDS Custom DB instances.
        """
        return pulumi.get(self, "nchar_character_set_name")

    @nchar_character_set_name.setter
    def nchar_character_set_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "nchar_character_set_name", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network type of the DB instance.
         Valid values:
          +   ``IPV4`` 
          +   ``DUAL`` 
          
         The network type is determined by the ``DBSubnetGroup`` specified for the DB instance. A ``DBSubnetGroup`` can support only the IPv4 protocol or the IPv4 and IPv6 protocols (``DUAL``).
         For more information, see [Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="optionGroupName")
    def option_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates that the DB instance should be associated with the specified option group.
         Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group. Also, that option group can't be removed from a DB instance once it is associated with a DB instance.
        """
        return pulumi.get(self, "option_group_name")

    @option_group_name.setter
    def option_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "option_group_name", value)

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS KMS key identifier for encryption of Performance Insights data.
         The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         If you do not specify a value for ``PerformanceInsightsKMSKeyId``, then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account. Your AWS account has a different default KMS key for each AWS Region.
         For information about enabling Performance Insights, see [EnablePerformanceInsights](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights).
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @performance_insights_kms_key_id.setter
    def performance_insights_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "performance_insights_kms_key_id", value)

    @property
    @pulumi.getter(name="performanceInsightsRetentionPeriod")
    def performance_insights_retention_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days to retain Performance Insights data. When creating a DB instance without enabling Performance Insights, you can't specify the parameter ``PerformanceInsightsRetentionPeriod``.
         This setting doesn't apply to RDS Custom DB instances.
         Valid Values:
          +   ``7`` 
          +  *month* * 31, where *month* is a number of months from 1-23. Examples: ``93`` (3 months * 31), ``341`` (11 months * 31), ``589`` (19 months * 31)
          +   ``731`` 
          
         Default: ``7`` days
         If you specify a retention period that isn't valid, such as ``94``, Amazon RDS returns an error.
        """
        return pulumi.get(self, "performance_insights_retention_period")

    @performance_insights_retention_period.setter
    def performance_insights_retention_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "performance_insights_retention_period", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The port number on which the database accepts connections.
         This setting doesn't apply to Aurora DB instances. The port number is managed by the cluster.
         Valid Values: ``1150-65535``
         Default:
          +  RDS for Db2 - ``50000``
          +  RDS for MariaDB - ``3306``
          +  RDS for Microsoft SQL Server - ``1433``
          +  RDS for MySQL - ``3306``
          +  RDS for Oracle - ``1521``
          +  RDS for PostgreSQL - ``5432``
          
         Constraints:
          +  For RDS for Microsoft SQL Server, the value can't be ``1234``, ``1434``, ``3260``, ``3343``, ``3389``, ``47001``, or ``49152-49156``.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The daily time range during which automated backups are created if automated backups are enabled, using the ``BackupRetentionPeriod`` parameter. For more information, see [Backup Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow) in the *Amazon RDS User Guide.*
         Constraints:
          +  Must be in the format ``hh24:mi-hh24:mi``.
          +  Must be in Universal Coordinated Time (UTC).
          +  Must not conflict with the preferred maintenance window.
          +  Must be at least 30 minutes.
          
          *Amazon Aurora* 
         Not applicable. The daily time range for creating automated backups is managed by the DB cluster.
        """
        return pulumi.get(self, "preferred_backup_window")

    @preferred_backup_window.setter
    def preferred_backup_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_backup_window", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         Format: ``ddd:hh24:mi-ddd:hh24:mi``
         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see [Maintaining a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow) in the *Amazon RDS User Guide.*
          This property applies when AWS CloudFormation initially creates the DB instance. If you use AWS CloudFormation to update the DB instance, those updates are applied immediately.
          Constraints: Minimum 30-minute window.
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="processorFeatures")
    def processor_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceProcessorFeatureArgs']]]]:
        """
        The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
        """
        return pulumi.get(self, "processor_features")

    @processor_features.setter
    def processor_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceProcessorFeatureArgs']]]]):
        pulumi.set(self, "processor_features", value)

    @property
    @pulumi.getter(name="promotionTier")
    def promotion_tier(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see [Fault Tolerance for an Aurora DB Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance) in the *Amazon Aurora User Guide*.
         This setting doesn't apply to RDS Custom DB instances.
         Default: ``1``
         Valid Values: ``0 - 15``
        """
        return pulumi.get(self, "promotion_tier")

    @promotion_tier.setter
    def promotion_tier(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "promotion_tier", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the DB instance is an internet-facing instance. If you specify true, AWS CloudFormation creates an instance with a publicly resolvable DNS name, which resolves to a public IP address. If you specify false, AWS CloudFormation creates an internal instance with a DNS name that resolves to a private IP address. 
         The default behavior value depends on your VPC setup and the database subnet group. For more information, see the ``PubliclyAccessible`` parameter in the [CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) in the *Amazon RDS API Reference*.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="replicaMode")
    def replica_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The open mode of an Oracle read replica. For more information, see [Working with Oracle Read Replicas for Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) in the *Amazon RDS User Guide*.
         This setting is only supported in RDS for Oracle.
         Default: ``open-read-only``
         Valid Values: ``open-read-only`` or ``mounted``
        """
        return pulumi.get(self, "replica_mode")

    @replica_mode.setter
    def replica_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replica_mode", value)

    @property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time to restore from. This parameter applies to point-in-time recovery. For more information, see [Restoring a DB instance to a specified time](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html) in the in the *Amazon RDS User Guide*.
         Constraints:
          +  Must be a time in Universal Coordinated Time (UTC) format.
          +  Must be before the latest restorable time for the DB instance.
          +  Can't be specified if the ``UseLatestRestorableTime`` parameter is enabled.
          
         Example: ``2009-09-07T23:45:00Z``
        """
        return pulumi.get(self, "restore_time")

    @restore_time.setter
    def restore_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "restore_time", value)

    @property
    @pulumi.getter(name="sourceDbClusterIdentifier")
    def source_db_cluster_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the Multi-AZ DB cluster that will act as the source for the read replica. Each DB cluster can have up to 15 read replicas.
         Constraints:
          +  Must be the identifier of an existing Multi-AZ DB cluster.
          +  Can't be specified if the ``SourceDBInstanceIdentifier`` parameter is also specified.
          +  The specified DB cluster must have automatic backups enabled, that is, its backup retention period must be greater than 0.
          +  The source DB cluster must be in the same AWS-Region as the read replica. Cross-Region replication isn't supported.
        """
        return pulumi.get(self, "source_db_cluster_identifier")

    @source_db_cluster_identifier.setter
    def source_db_cluster_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_db_cluster_identifier", value)

    @property
    @pulumi.getter(name="sourceDbInstanceAutomatedBackupsArn")
    def source_db_instance_automated_backups_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the replicated automated backups from which to restore, for example, ``arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE``.
         This setting doesn't apply to RDS Custom.
        """
        return pulumi.get(self, "source_db_instance_automated_backups_arn")

    @source_db_instance_automated_backups_arn.setter
    def source_db_instance_automated_backups_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_db_instance_automated_backups_arn", value)

    @property
    @pulumi.getter(name="sourceDbInstanceIdentifier")
    def source_db_instance_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If you want to create a read replica DB instance, specify the ID of the source DB instance. Each DB instance can have a limited number of read replicas. For more information, see [Working with Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/USER_ReadRepl.html) in the *Amazon RDS User Guide*.
         For information about constraints that apply to DB instance identifiers, see [Naming constraints in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints) in the *Amazon RDS User Guide*.
         The ``SourceDBInstanceIdentifier`` property determines whether a DB instance is a read replica. If you remove the ``SourceDBInstanceIdentifier`` property from your template and then update your stack, AWS CloudFormation promotes the read replica to a standalone DB instance.
         If you specify the ``UseLatestRestorableTime`` or ``RestoreTime`` properties in conjunction with the ``SourceDBInstanceIdentifier`` property, RDS restores the DB instance to the requested point in time, thereby creating a new DB instance.
           +  If you specify a source DB instance that uses VPC security groups, we recommend that you specify the ``VPCSecurityGroups`` property. If you don't specify the property, the read replica inherits the value of the ``VPCSecurityGroups`` property from the source DB when you create the replica. However, if you update the stack, AWS CloudFormation reverts the replica's ``VPCSecurityGroups`` property to the default value because it's not defined in the stack's template. This change might cause unexpected issues.
          +  Read replicas don't support deletion policies. AWS CloudFormation ignores any deletion policy that's associated with a read replica.
          +  If you specify ``SourceDBInstanceIdentifier``, don't specify the ``DBSnapshotIdentifier`` property. You can't create a read replica from a snapshot.
          +  Don't set the ``BackupRetentionPeriod``, ``DBName``, ``MasterUsername``, ``MasterUserPassword``, and ``PreferredBackupWindow`` properties. The database attributes are inherited from the source DB instance, and backups are disabled for read replicas.
          +  If the source DB instance is in a different region than the read replica, specify the source region in ``SourceRegion``, and specify an ARN for a valid DB instance in ``SourceDBInstanceIdentifier``. For more information, see [Constructing a Amazon RDS Amazon Resource Name (ARN)](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN) in the *Amazon RDS User Guide*.
          +  For DB instances in Amazon Aurora clusters, don't specify this property. Amazon RDS automatically assigns writer and reader DB instances.
        """
        return pulumi.get(self, "source_db_instance_identifier")

    @source_db_instance_identifier.setter
    def source_db_instance_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_db_instance_identifier", value)

    @property
    @pulumi.getter(name="sourceDbiResourceId")
    def source_dbi_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource ID of the source DB instance from which to restore.
        """
        return pulumi.get(self, "source_dbi_resource_id")

    @source_dbi_resource_id.setter
    def source_dbi_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_dbi_resource_id", value)

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the region that contains the source DB instance for the read replica.
        """
        return pulumi.get(self, "source_region")

    @source_region.setter
    def source_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_region", value)

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
         If you specify the ``KmsKeyId`` property, then you must enable encryption.
         If you specify the ``SourceDBInstanceIdentifier`` or ``SourceDbiResourceId`` property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified ``KmsKeyId`` property is used.
         If you specify the ``SourceDBInstanceAutomatedBackupsArn`` property, don't specify this property. The value is inherited from the source DB instance automated backup. 
         If you specify ``DBSnapshotIdentifier`` property, don't specify this property. The value is inherited from the snapshot.
          *Amazon Aurora* 
         Not applicable. The encryption for DB instances is managed by the DB cluster.
        """
        return pulumi.get(self, "storage_encrypted")

    @storage_encrypted.setter
    def storage_encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "storage_encrypted", value)

    @property
    @pulumi.getter(name="storageThroughput")
    def storage_throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the storage throughput value, in mebibyte per second (MiBps), for the DB instance. This setting applies only to the ``gp3`` storage type. 
         This setting doesn't apply to RDS Custom or Amazon Aurora.
        """
        return pulumi.get(self, "storage_throughput")

    @storage_throughput.setter
    def storage_throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "storage_throughput", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The storage type to associate with the DB instance.
         If you specify ``io1``, ``io2``, or ``gp3``, you must also include a value for the ``Iops`` parameter.
         This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
         Valid Values: ``gp2 | gp3 | io1 | io2 | standard``
         Default: ``io1``, if the ``Iops`` parameter is specified. Otherwise, ``gp3``.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Tags to assign to the DB instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tdeCredentialArn")
    def tde_credential_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "tde_credential_arn")

    @tde_credential_arn.setter
    def tde_credential_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tde_credential_arn", value)

    @property
    @pulumi.getter(name="tdeCredentialPassword")
    def tde_credential_password(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "tde_credential_password")

    @tde_credential_password.setter
    def tde_credential_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tde_credential_password", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time zone of the DB instance. The time zone parameter is currently supported only by [RDS for Db2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-time-zone) and [RDS for SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone).
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="useDefaultProcessorFeatures")
    def use_default_processor_features(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the DB instance class of the DB instance uses its default processor features.
         This setting doesn't apply to RDS Custom DB instances.
        """
        return pulumi.get(self, "use_default_processor_features")

    @use_default_processor_features.setter
    def use_default_processor_features(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_default_processor_features", value)

    @property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the DB instance is restored from the latest backup time. By default, the DB instance isn't restored from the latest backup time. This parameter applies to point-in-time recovery. For more information, see [Restoring a DB instance to a specified time](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html) in the in the *Amazon RDS User Guide*.
         Constraints:
          +  Can't be specified if the ``RestoreTime`` parameter is provided.
        """
        return pulumi.get(self, "use_latest_restorable_time")

    @use_latest_restorable_time.setter
    def use_latest_restorable_time(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_latest_restorable_time", value)

    @property
    @pulumi.getter(name="vpcSecurityGroups")
    def vpc_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the VPC security group IDs to assign to the DB instance. The list can include both the physical IDs of existing VPC security groups and references to [AWS::EC2::SecurityGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html) resources created in the template.
         If you plan to update the resource, don't specify VPC security groups in a shared VPC.
          If you set ``VPCSecurityGroups``, you must not set [DBSecurityGroups](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups), and vice versa.
          You can migrate a DB instance in your stack from an RDS DB security group to a VPC security group, but keep the following in mind:
          +  You can't revert to using an RDS security group after you establish a VPC security group membership.
          +  When you migrate your DB instance to VPC security groups, if your stack update rolls back because the DB instance update fails or because an update fails in another AWS CloudFormation resource, the rollback fails because it can't revert to an RDS security group.
          +  To use the properties that are available when you use a VPC security group, you must recreate the DB instance. If you don't, AWS CloudFormation submits only the property values that are listed in the [DBSecurityGroups](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups) property.
          
          To avoid this situation, migrate your DB instance to using VPC security groups only when that is the only change in your stack template. 
          *Amazon Aurora* 
         Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
        """
        return pulumi.get(self, "vpc_security_groups")

    @vpc_security_groups.setter
    def vpc_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vpc_security_groups", value)


@pulumi.type_token("aws-native:rds:DbInstance")
class DbInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_storage: Optional[pulumi.Input[builtins.str]] = None,
                 allow_major_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 apply_immediately: Optional[pulumi.Input[builtins.bool]] = None,
                 associated_roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceDbInstanceRoleArgs', 'DbInstanceDbInstanceRoleArgsDict']]]]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 automatic_backup_replication_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 automatic_backup_replication_region: Optional[pulumi.Input[builtins.str]] = None,
                 automatic_backup_replication_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 backup_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 ca_certificate_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_rotation_restart: Optional[pulumi.Input[builtins.bool]] = None,
                 character_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[builtins.bool]] = None,
                 custom_iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
                 database_insights_mode: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_instance_class: Optional[pulumi.Input[builtins.str]] = None,
                 db_instance_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 db_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 dedicated_log_volume: Optional[pulumi.Input[builtins.bool]] = None,
                 delete_automated_backups: Optional[pulumi.Input[builtins.bool]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 domain_auth_secret_arn: Optional[pulumi.Input[builtins.str]] = None,
                 domain_dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 domain_fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 domain_iam_role_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_ou: Optional[pulumi.Input[builtins.str]] = None,
                 enable_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enable_iam_database_authentication: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_performance_insights: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_lifecycle_support: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 iops: Optional[pulumi.Input[builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 license_model: Optional[pulumi.Input[builtins.str]] = None,
                 manage_master_user_password: Optional[pulumi.Input[builtins.bool]] = None,
                 master_user_password: Optional[pulumi.Input[builtins.str]] = None,
                 master_user_secret: Optional[pulumi.Input[Union['DbInstanceMasterUserSecretArgs', 'DbInstanceMasterUserSecretArgsDict']]] = None,
                 master_username: Optional[pulumi.Input[builtins.str]] = None,
                 max_allocated_storage: Optional[pulumi.Input[builtins.int]] = None,
                 monitoring_interval: Optional[pulumi.Input[builtins.int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 multi_az: Optional[pulumi.Input[builtins.bool]] = None,
                 nchar_character_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 network_type: Optional[pulumi.Input[builtins.str]] = None,
                 option_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 port: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_backup_window: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 processor_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceProcessorFeatureArgs', 'DbInstanceProcessorFeatureArgsDict']]]]] = None,
                 promotion_tier: Optional[pulumi.Input[builtins.int]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 replica_mode: Optional[pulumi.Input[builtins.str]] = None,
                 restore_time: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_instance_automated_backups_arn: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_instance_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_dbi_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_region: Optional[pulumi.Input[builtins.str]] = None,
                 storage_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_throughput: Optional[pulumi.Input[builtins.int]] = None,
                 storage_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tde_credential_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tde_credential_password: Optional[pulumi.Input[builtins.str]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None,
                 use_default_processor_features: Optional[pulumi.Input[builtins.bool]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[builtins.bool]] = None,
                 vpc_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        The ``AWS::RDS::DBInstance`` resource creates an Amazon DB instance. The new DB instance can be an RDS DB instance, or it can be a DB instance in an Aurora DB cluster.
         For more information about creating an RDS DB instance, see [Creating an Amazon RDS DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html) in the *Amazon RDS User Guide*.
         For more information about creating a DB instance in an Aurora DB cluster, see [Creating an Amazon Aurora DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html) in the *Amazon Aurora User Guide*.
         If you import an existing DB instance, and the template configuration doesn't match the actual configuration of the DB instance, AWS CloudFormation applies the changes in the template during the import operation.
          If a DB instance is deleted or replaced during an update, AWS CloudFormation deletes all automated snapshots. However, it retains manual DB snapshots. During an update that requires replacement, you can apply a stack policy to prevent DB instances from being replaced. For more information, see [Prevent Updates to Stack Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html).
           *Updating DB instances*
         When properties labeled "*Update requires:*[Replacement](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement)" are updated, AWS CloudFormation first creates a replacement DB instance, then changes references from other dependent resources to point to the replacement DB instance, and finally deletes the old DB instance.
          We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB instance. To preserve your data, perform the following procedure:
          1.  Deactivate any applications that are using the DB instance so that there's no activity on the DB instance.
          2.  Create a snapshot of the DB instance. For more information, see [Creating a DB Snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateSnapshot.html).
          3.  If you want to restore your instance using a DB snapshot, modify the updated template with your DB instance changes and add the ``DBSnapshotIdentifier`` property with the ID of the DB snapshot that you want to use.
               After you restore a DB instance with a ``DBSnapshotIdentifier`` property, you can delete the ``DBSnapshotIdentifier`` property. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the ``DBSnapshotIdentifier`` property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified ``DBSnapshotIdentifier`` property, and the original DB instance is deleted.
          4.  Update the stack.

          For more information about updating other properties of this resource, see ``ModifyDBInstance``. For more information about updating stacks, see [CloudFormation Stacks Updates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
          *Deleting DB instances*
         For DB instances that are part of an Aurora DB cluster, you can set a deletion policy for your DB instance to control how AWS CloudFormation handles the DB instance when the stack is deleted. For Amazon RDS DB instances, you can choose to *retain* the DB instance, to *delete* the DB instance, or to *create a snapshot* of the DB instance. The default AWS CloudFormation behavior depends on the ``DBClusterIdentifier`` property:
          1.  For ``AWS::RDS::DBInstance`` resources that don't specify the ``DBClusterIdentifier`` property, AWS CloudFormation saves a snapshot of the DB instance.
          2.   For ``AWS::RDS::DBInstance`` resources that do specify the ``DBClusterIdentifier`` property, AWS CloudFormation deletes the DB instance.

          For more information, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] allocated_storage: The amount of storage in gibibytes (GiB) to be initially allocated for the database instance.
                 If any value is set in the ``Iops`` parameter, ``AllocatedStorage`` must be at least 100 GiB, which corresponds to the minimum Iops value of 1,000. If you increase the ``Iops`` value (in 1,000 IOPS increments), then you must also increase the ``AllocatedStorage`` value (in 100-GiB increments). 
                  *Amazon Aurora* 
                Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.
                 *Db2* 
                Constraints to the amount of storage for each storage type are the following:
                 +  General Purpose (SSD) storage (gp3): Must be an integer from 20 to 64000.
                 +  Provisioned IOPS storage (io1): Must be an integer from 100 to 64000.
                 
                 *MySQL* 
                Constraints to the amount of storage for each storage type are the following: 
                 +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
                 +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
                 +  Magnetic storage (standard): Must be an integer from 5 to 3072.
                 
                 *MariaDB* 
                Constraints to the amount of storage for each storage type are the following: 
                 +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
                 +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
                 +  Magnetic storage (standard): Must be an integer from 5 to 3072.
                 
                 *PostgreSQL* 
                Constraints to the amount of storage for each storage type are the following: 
                 +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
                 +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
                 +  Magnetic storage (standard): Must be an integer from 5 to 3072.
                 
                 *Oracle* 
                Constraints to the amount of storage for each storage type are the following: 
                 +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
                 +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
                 +  Magnetic storage (standard): Must be an integer from 10 to 3072.
                 
                 *SQL Server* 
                Constraints to the amount of storage for each storage type are the following: 
                 +  General Purpose (SSD) storage (gp2):
                 +  Enterprise and Standard editions: Must be an integer from 20 to 16384.
                 +  Web and Express editions: Must be an integer from 20 to 16384.
                 
                 +  Provisioned IOPS storage (io1):
                 +  Enterprise and Standard editions: Must be an integer from 20 to 16384.
                 +  Web and Express editions: Must be an integer from 20 to 16384.
                 
                 +  Magnetic storage (standard):
                 +  Enterprise and Standard editions: Must be an integer from 20 to 1024.
                 +  Web and Express editions: Must be an integer from 20 to 1024.
        :param pulumi.Input[builtins.bool] allow_major_version_upgrade: A value that indicates whether major version upgrades are allowed. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
                Constraints: Major version upgrades must be allowed when specifying a value for the ``EngineVersion`` parameter that is a different major version than the DB instance's current version.
        :param pulumi.Input[builtins.bool] apply_immediately: Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the ``PreferredMaintenanceWindow`` setting. If set to ``false``, changes are applied during the next maintenance window. Until RDS applies the changes, the DB instance remains in a drift state. As a result, the configuration doesn't fully reflect the requested modifications and temporarily diverges from the intended state.
                In addition to the settings described in [Modifying a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html), this property also determines whether the DB instance reboots when a static parameter is modified in the associated DB parameter group.
                Default: ``true``
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceDbInstanceRoleArgs', 'DbInstanceDbInstanceRoleArgsDict']]]] associated_roles: The IAMlong (IAM) roles associated with the DB instance. 
                 *Amazon Aurora* 
                Not applicable. The associated roles are managed by the DB cluster.
        :param pulumi.Input[builtins.bool] auto_minor_version_upgrade: A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are applied automatically.
        :param pulumi.Input[builtins.str] automatic_backup_replication_kms_key_id: The AWS KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination AWS-Region, for example, ``arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE``.
        :param pulumi.Input[builtins.str] automatic_backup_replication_region: The AWS-Region associated with the automated backup.
        :param pulumi.Input[builtins.int] automatic_backup_replication_retention_period: The retention period for automated backups in a different AWS Region. Use this parameter to set a unique retention period that only applies to cross-Region automated backups. To enable automated backups in a different Region, specify a positive value for the ``AutomaticBackupReplicationRegion`` parameter. 
                If not specified, this parameter defaults to the value of the ``BackupRetentionPeriod`` parameter. The maximum allowed value is 35.
        :param pulumi.Input[builtins.str] availability_zone: The Availability Zone (AZ) where the database will be created. For information on AWS-Regions and Availability Zones, see [Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
                For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.
                Default: A random, system-chosen Availability Zone in the endpoint's AWS-Region.
                Constraints:
                 +  The ``AvailabilityZone`` parameter can't be specified if the DB instance is a Multi-AZ deployment.
                 +  The specified Availability Zone must be in the same AWS-Region as the current endpoint.
                 
                Example: ``us-east-1d``
        :param pulumi.Input[builtins.int] backup_retention_period: The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
                 *Amazon Aurora* 
                Not applicable. The retention period for automated backups is managed by the DB cluster.
                Default: 1
                Constraints:
                 +  Must be a value from 0 to 35
                 +  Can't be set to 0 if the DB instance is a source to read replicas
        :param pulumi.Input[builtins.str] ca_certificate_identifier: The identifier of the CA certificate for this DB instance.
                For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
        :param pulumi.Input[builtins.bool] certificate_rotation_restart: Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
                By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.
                 Set this parameter only if you are *not* using SSL/TLS to connect to the DB instance.
                 If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB engine to rotate your SSL/TLS certificate:
                 +  For more information about rotating your SSL/TLS certificate for RDS DB engines, see [Rotating Your SSL/TLS Certificate.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html) in the *Amazon RDS User Guide.*
                 +  For more information about rotating your SSL/TLS certificate for Aurora DB engines, see [Rotating Your SSL/TLS Certificate](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html) in the *Amazon Aurora User Guide*.
                 
                This setting doesn't apply to RDS Custom DB instances.
        :param pulumi.Input[builtins.str] character_set_name: For supported engines, indicates that the DB instance should be associated with the specified character set.
                 *Amazon Aurora* 
                Not applicable. The character set is managed by the DB cluster. For more information, see [AWS::RDS::DBCluster](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html).
        :param pulumi.Input[builtins.bool] copy_tags_to_snapshot: Specifies whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.
                This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
        :param pulumi.Input[builtins.str] custom_iam_instance_profile: The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
                This setting is required for RDS Custom.
                Constraints:
                 +  The profile must exist in your account.
                 +  The profile must have an IAM role that Amazon EC2 has permissions to assume.
                 +  The instance profile name and the associated IAM role name must start with the prefix ``AWSRDSCustom``.
                 
                For the list of permissions required for the IAM role, see [Configure IAM and your VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc) in the *Amazon RDS User Guide*.
        :param pulumi.Input[builtins.str] database_insights_mode: The mode of Database Insights to enable for the DB instance.
                 Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
        :param pulumi.Input[builtins.str] db_cluster_identifier: The identifier of the DB cluster that this DB instance will belong to.
                This setting doesn't apply to RDS Custom DB instances.
        :param pulumi.Input[builtins.str] db_cluster_snapshot_identifier: The identifier for the Multi-AZ DB cluster snapshot to restore from.
                For more information on Multi-AZ DB clusters, see [Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
                Constraints:
                 +  Must match the identifier of an existing Multi-AZ DB cluster snapshot.
                 +  Can't be specified when ``DBSnapshotIdentifier`` is specified.
                 +  Must be specified when ``DBSnapshotIdentifier`` isn't specified.
                 +  If you are restoring from a shared manual Multi-AZ DB cluster snapshot, the ``DBClusterSnapshotIdentifier`` must be the ARN of the shared snapshot.
                 +  Can't be the identifier of an Aurora DB cluster snapshot.
        :param pulumi.Input[builtins.str] db_instance_class: The compute and memory capacity of the DB instance, for example ``db.m5.large``. Not all DB instance classes are available in all AWS-Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see [DB instance classes](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide* or [Aurora DB instance classes](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html) in the *Amazon Aurora User Guide*.
        :param pulumi.Input[builtins.str] db_instance_identifier: A name for the DB instance. If you specify a name, AWS CloudFormation converts it to lowercase. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the DB instance. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
                For information about constraints that apply to DB instance identifiers, see [Naming constraints in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints) in the *Amazon RDS User Guide*.
                 If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        :param pulumi.Input[builtins.str] db_name: The meaning of this parameter differs according to the database engine you use.
                 If you specify the ``DBSnapshotIdentifier`` property, this property only applies to RDS for Oracle.
                  *Amazon Aurora* 
                Not applicable. The database name is managed by the DB cluster.
                 *Db2* 
                The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.
                Constraints:
                 +  Must contain 1 to 64 letters or numbers.
                 +  Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
                 +  Can't be a word reserved by the specified database engine.
                 
                 *MySQL* 
                The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
                Constraints:
                 +  Must contain 1 to 64 letters or numbers.
                 +  Can't be a word reserved by the specified database engine
                 
                 *MariaDB* 
                The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
                Constraints:
                 +  Must contain 1 to 64 letters or numbers.
                 +  Can't be a word reserved by the specified database engine
                 
                 *PostgreSQL* 
                The name of the database to create when the DB instance is created. If this parameter is not specified, the default ``postgres`` database is created in the DB instance.
                Constraints:
                 +  Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
                 +  Must contain 1 to 63 characters.
                 +  Can't be a word reserved by the specified database engine
                 
                 *Oracle* 
                The Oracle System ID (SID) of the created DB instance. If you specify ``null``, the default value ``ORCL`` is used. You can't specify the string NULL, or any other reserved word, for ``DBName``. 
                Default: ``ORCL``
                Constraints:
                 +  Can't be longer than 8 characters
                 
                 *SQL Server* 
                Not applicable. Must be null.
        :param pulumi.Input[builtins.str] db_parameter_group_name: The name of an existing DB parameter group or a reference to an [AWS::RDS::DBParameterGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html) resource created in the template.
                To list all of the available DB parameter group names, use the following command:
                 ``aws rds describe-db-parameter-groups --query "DBParameterGroups[].DBParameterGroupName" --output text`` 
                 If any of the data members of the referenced parameter group are changed during an update, the DB instance might need to be restarted, which causes some interruption. If the parameter group contains static parameters, whether they were changed or not, an update triggers a reboot.
                 If you don't specify a value for ``DBParameterGroupName`` property, the default DB parameter group for the specified engine and engine version is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] db_security_groups: A list of the DB security groups to assign to the DB instance. The list can include both the name of existing DB security groups or references to AWS::RDS::DBSecurityGroup resources created in the template.
                 If you set DBSecurityGroups, you must not set VPCSecurityGroups, and vice versa. Also, note that the DBSecurityGroups property exists only for backwards compatibility with older regions and is no longer recommended for providing security information to an RDS DB instance. Instead, use VPCSecurityGroups.
                 If you specify this property, AWS CloudFormation sends only the following properties (if specified) to Amazon RDS during create operations:
                 +   ``AllocatedStorage`` 
                 +   ``AutoMinorVersionUpgrade`` 
                 +   ``AvailabilityZone`` 
                 +   ``BackupRetentionPeriod`` 
                 +   ``CharacterSetName`` 
                 +   ``DBInstanceClass`` 
                 +   ``DBName`` 
                 +   ``DBParameterGroupName`` 
                 +   ``DBSecurityGroups`` 
                 +   ``DBSubnetGroupName`` 
                 +   ``Engine`` 
                 +   ``EngineVersion`` 
                 +   ``Iops`` 
                 +   ``LicenseModel`` 
                 +   ``MasterUsername`` 
                 +   ``MasterUserPassword`` 
                 +   ``MultiAZ`` 
                 +   ``OptionGroupName`` 
                 +   ``PreferredBackupWindow`` 
                 +   ``PreferredMaintenanceWindow`` 
                 
                All other properties are ignored. Specify a virtual private cloud (VPC) security group if you want to submit other properties, such as ``StorageType``, ``StorageEncrypted``, or ``KmsKeyId``. If you're already using the ``DBSecurityGroups`` property, you can't use these other properties by updating your DB instance to use a VPC security group. You must recreate the DB instance.
        :param pulumi.Input[builtins.str] db_snapshot_identifier: The name or Amazon Resource Name (ARN) of the DB snapshot that's used to restore the DB instance. If you're restoring from a shared manual DB snapshot, you must specify the ARN of the snapshot.
                By specifying this property, you can create a DB instance from the specified DB snapshot. If the ``DBSnapshotIdentifier`` property is an empty string or the ``AWS::RDS::DBInstance`` declaration has no ``DBSnapshotIdentifier`` property, AWS CloudFormation creates a new database. If the property contains a value (other than an empty string), AWS CloudFormation creates a database from the specified snapshot. If a snapshot with the specified name doesn't exist, AWS CloudFormation can't create the database and it rolls back the stack.
                Some DB instance properties aren't valid when you restore from a snapshot, such as the ``MasterUsername`` and ``MasterUserPassword`` properties, and the point-in-time recovery properties ``RestoreTime`` and ``UseLatestRestorableTime``. For information about the properties that you can specify, see the [RestoreDBInstanceFromDBSnapshot](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBInstanceFromDBSnapshot.html) action in the *Amazon RDS API Reference*.
                After you restore a DB instance with a ``DBSnapshotIdentifier`` property, you must specify the same ``DBSnapshotIdentifier`` property for any future updates to the DB instance. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the ``DBSnapshotIdentifier`` property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified ``DBSnapshotIdentifier`` property, and the original DB instance is deleted.
                If you specify the ``DBSnapshotIdentifier`` property to restore a DB instance (as opposed to specifying it for DB instance updates), then don't specify the following properties:
                 +   ``CharacterSetName`` 
                 +   ``DBClusterIdentifier`` 
                 +   ``DBName`` 
                 +   ``KmsKeyId`` 
                 +   ``MasterUsername`` 
                 +   ``MasterUserPassword`` 
                 +   ``PromotionTier`` 
                 +   ``SourceDBInstanceIdentifier`` 
                 +   ``SourceRegion`` 
                 +  ``StorageEncrypted`` (for an unencrypted snapshot)
                 +   ``Timezone`` 
                 
                 *Amazon Aurora* 
                Not applicable. Snapshot restore is managed by the DB cluster.
        :param pulumi.Input[builtins.str] db_subnet_group_name: A DB subnet group to associate with the DB instance. If you update this value, the new subnet group must be a subnet group in a new VPC. 
                If you don't specify a DB subnet group, RDS uses the default DB subnet group if one exists. If a default DB subnet group does not exist, and you don't specify a ``DBSubnetGroupName``, the DB instance fails to launch. 
                For more information about using Amazon RDS in a VPC, see [Amazon VPC and Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html) in the *Amazon RDS User Guide*. 
                This setting doesn't apply to Amazon Aurora DB instances. The DB subnet group is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
        :param pulumi.Input[builtins.str] db_system_id: The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your database files. In this context, the term "Oracle database instance" refers exclusively to the system global area (SGA) and Oracle background processes. If you don't specify a SID, the value defaults to ``RDSCDB``. The Oracle SID is also the name of your CDB.
        :param pulumi.Input[builtins.bool] dedicated_log_volume: Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
        :param pulumi.Input[builtins.bool] delete_automated_backups: A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.
                 *Amazon Aurora* 
                Not applicable. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the DB cluster are not deleted.
        :param pulumi.Input[builtins.bool] deletion_protection: Specifies whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see [Deleting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
                This setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion protection for the DB cluster. For more information, see ``CreateDBCluster``. DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
        :param pulumi.Input[builtins.str] domain: The Active Directory directory ID to create the DB instance in. Currently, only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
                For more information, see [Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html) in the *Amazon RDS User Guide*.
        :param pulumi.Input[builtins.str] domain_auth_secret_arn: The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
                Example: ``arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456``
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] domain_dns_ips: The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
                Constraints:
                 +  Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.
                 
                Example: ``123.124.125.126,234.235.236.237``
        :param pulumi.Input[builtins.str] domain_fqdn: The fully qualified domain name (FQDN) of an Active Directory domain.
                Constraints:
                 +  Can't be longer than 64 characters.
                 
                Example: ``mymanagedADtest.mymanagedAD.mydomain``
        :param pulumi.Input[builtins.str] domain_iam_role_name: The name of the IAM role to use when making API calls to the Directory Service.
                This setting doesn't apply to the following DB instances:
                 +  Amazon Aurora (The domain is managed by the DB cluster.)
                 +  RDS Custom
        :param pulumi.Input[builtins.str] domain_ou: The Active Directory organizational unit for your DB instance to join.
                Constraints:
                 +  Must be in the distinguished name format.
                 +  Can't be longer than 64 characters.
                 
                Example: ``OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain``
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] enable_cloudwatch_logs_exports: The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Relational Database Service User Guide*.
                 *Amazon Aurora* 
                Not applicable. CloudWatch Logs exports are managed by the DB cluster. 
                 *Db2* 
                Valid values: ``diag.log``, ``notify.log``
                 *MariaDB* 
                Valid values: ``audit``, ``error``, ``general``, ``slowquery``
                 *Microsoft SQL Server* 
                Valid values: ``agent``, ``error``
                 *MySQL* 
                Valid values: ``audit``, ``error``, ``general``, ``slowquery``
                 *Oracle* 
                Valid values: ``alert``, ``audit``, ``listener``, ``trace``, ``oemagent``
                 *PostgreSQL* 
                Valid values: ``postgresql``, ``upgrade``
        :param pulumi.Input[builtins.bool] enable_iam_database_authentication: A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.
                This property is supported for RDS for MariaDB, RDS for MySQL, and RDS for PostgreSQL. For more information, see [IAM Database Authentication for MariaDB, MySQL, and PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon RDS User Guide.*
                 *Amazon Aurora* 
                Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.
        :param pulumi.Input[builtins.bool] enable_performance_insights: Specifies whether to enable Performance Insights for the DB instance. For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
                This setting doesn't apply to RDS Custom DB instances.
        :param pulumi.Input[builtins.str] engine: The name of the database engine to use for this DB instance. Not every database engine is available in every AWS Region.
                This property is required when creating a DB instance.
                 You can convert an Oracle database from the non-CDB architecture to the container database (CDB) architecture by updating the ``Engine`` value in your templates from ``oracle-ee`` to ``oracle-ee-cdb`` or from ``oracle-se2`` to ``oracle-se2-cdb``. Converting to the CDB architecture requires an interruption.
                 Valid Values:
                 +  ``aurora-mysql`` (for Aurora MySQL DB instances)
                 +  ``aurora-postgresql`` (for Aurora PostgreSQL DB instances)
                 +  ``custom-oracle-ee`` (for RDS Custom for Oracle DB instances)
                 +  ``custom-oracle-ee-cdb`` (for RDS Custom for Oracle DB instances)
                 +  ``custom-sqlserver-ee`` (for RDS Custom for SQL Server DB instances)
                 +  ``custom-sqlserver-se`` (for RDS Custom for SQL Server DB instances)
                 +  ``custom-sqlserver-web`` (for RDS Custom for SQL Server DB instances)
                 +   ``db2-ae`` 
                 +   ``db2-se`` 
                 +   ``mariadb`` 
                 +   ``mysql`` 
                 +   ``oracle-ee`` 
                 +   ``oracle-ee-cdb`` 
                 +   ``oracle-se2`` 
                 +   ``oracle-se2-cdb`` 
                 +   ``postgres`` 
                 +   ``sqlserver-ee`` 
                 +   ``sqlserver-se`` 
                 +   ``sqlserver-ex`` 
                 +   ``sqlserver-web``
        :param pulumi.Input[builtins.str] engine_lifecycle_support: The life cycle type for this DB instance.
                 By default, this value is set to ``open-source-rds-extended-support``, which enrolls your DB instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to ``open-source-rds-extended-support-disabled``. In this case, creating the DB instance will fail if the DB major version is past its end of standard support date.
                 This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by the DB cluster.
                You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB instance past the end of standard support for that engine version. For more information, see [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html) in the *Amazon RDS User Guide*.
                Valid Values: ``open-source-rds-extended-support | open-source-rds-extended-support-disabled``
                Default: ``open-source-rds-extended-support``
        :param pulumi.Input[builtins.str] engine_version: The version number of the database engine to use.
                For a list of valid engine versions, use the ``DescribeDBEngineVersions`` action.
                The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every AWS Region.
                 *Amazon Aurora* 
                Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.
                 *Db2* 
                See [Amazon RDS for Db2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Db2.html#Db2.Concepts.VersionMgmt) in the *Amazon RDS User Guide.*
                 *MariaDB* 
                See [MariaDB on Amazon RDS Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt) in the *Amazon RDS User Guide.*
                 *Microsoft SQL Server* 
                See [Microsoft SQL Server Versions on Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport) in the *Amazon RDS User Guide.*
                 *MySQL* 
                See [MySQL on Amazon RDS Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt) in the *Amazon RDS User Guide.*
                 *Oracle* 
                See [Oracle Database Engine Release Notes](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html) in the *Amazon RDS User Guide.*
                 *PostgreSQL* 
                See [Supported PostgreSQL Database Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts.General.DBVersions) in the *Amazon RDS User Guide.*
        :param pulumi.Input[builtins.int] iops: The number of I/O operations per second (IOPS) that the database provisions. The value must be equal to or greater than 1000. 
                If you specify this property, you must follow the range of allowed ratios of your requested IOPS rate to the amount of storage that you allocate (IOPS to allocated storage). For example, you can provision an Oracle database instance with 1000 IOPS and 200 GiB of storage (a ratio of 5:1), or specify 2000 IOPS with 200 GiB of storage (a ratio of 10:1). For more information, see [Amazon RDS Provisioned IOPS Storage to Improve Performance](https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
                 If you specify ``io1`` for the ``StorageType`` property, then you must also specify the ``Iops`` property.
                 Constraints:
                 +  For RDS for Db2, MariaDB, MySQL, Oracle, and PostgreSQL - Must be a multiple between .5 and 50 of the storage amount for the DB instance.
                 +  For RDS for SQL Server - Must be a multiple between 1 and 50 of the storage amount for the DB instance.
        :param pulumi.Input[builtins.str] kms_key_id: The ARN of the AWS KMS key that's used to encrypt the DB instance, such as ``arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef``. If you enable the StorageEncrypted property but don't specify this property, AWS CloudFormation uses the default KMS key. If you specify this property, you must set the StorageEncrypted property to true. 
                If you specify the ``SourceDBInstanceIdentifier`` or ``SourceDbiResourceId`` property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified ``KmsKeyId`` property is used. However, if the source DB instance is in a different AWS Region, you must specify a KMS key ID.
                If you specify the ``SourceDBInstanceAutomatedBackupsArn`` property, don't specify this property. The value is inherited from the source DB instance automated backup, and if the automated backup is encrypted, the specified ``KmsKeyId`` property is used.
                If you create an encrypted read replica in a different AWS Region, then you must specify a KMS key for the destination AWS Region. KMS encryption keys are specific to the region that they're created in, and you can't use encryption keys from one region in another region.
                If you specify the ``DBSnapshotIdentifier`` property, don't specify this property. The ``StorageEncrypted`` property value is inherited from the snapshot. If the DB instance is encrypted, the specified ``KmsKeyId`` property is also inherited from the snapshot.
                If you specify ``DBSecurityGroups``, AWS CloudFormation ignores this property. To specify both a security group and this property, you must use a VPC security group. For more information about Amazon RDS and VPC, see [Using Amazon RDS with Amazon VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html) in the *Amazon RDS User Guide*.
                 *Amazon Aurora* 
                Not applicable. The KMS key identifier is managed by the DB cluster.
        :param pulumi.Input[builtins.str] license_model: License model information for this DB instance.
                 Valid Values:
                 +  Aurora MySQL - ``general-public-license``
                 +  Aurora PostgreSQL - ``postgresql-license``
                 +  RDS for Db2 - ``bring-your-own-license``. For more information about RDS for Db2 licensing, see [](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html) in the *Amazon RDS User Guide.*
                 +  RDS for MariaDB - ``general-public-license``
                 +  RDS for Microsoft SQL Server - ``license-included``
                 +  RDS for MySQL - ``general-public-license``
                 +  RDS for Oracle - ``bring-your-own-license`` or ``license-included``
                 +  RDS for PostgreSQL - ``postgresql-license``
                 
                 If you've specified ``DBSecurityGroups`` and then you update the license model, AWS CloudFormation replaces the underlying DB instance. This will incur some interruptions to database availability.
        :param pulumi.Input[builtins.bool] manage_master_user_password: Specifies whether to manage the master user password with AWS Secrets Manager.
                For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide.*
                Constraints:
                 +  Can't manage the master user password with AWS Secrets Manager if ``MasterUserPassword`` is specified.
        :param pulumi.Input[builtins.str] master_user_password: The password for the master user. The password can include any printable ASCII character except "/", \"\"\", or "@".
                 *Amazon Aurora* 
                Not applicable. The password for the master user is managed by the DB cluster.
                 *RDS for Db2* 
                Must contain from 8 to 255 characters.
                 *RDS for MariaDB* 
                Constraints: Must contain from 8 to 41 characters.
                 *RDS for Microsoft SQL Server* 
                Constraints: Must contain from 8 to 128 characters.
                 *RDS for MySQL* 
                Constraints: Must contain from 8 to 41 characters.
                 *RDS for Oracle* 
                Constraints: Must contain from 8 to 30 characters.
                 *RDS for PostgreSQL* 
                Constraints: Must contain from 8 to 128 characters.
        :param pulumi.Input[Union['DbInstanceMasterUserSecretArgs', 'DbInstanceMasterUserSecretArgsDict']] master_user_secret: The secret managed by RDS in AWS Secrets Manager for the master user password.
                For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide.*
        :param pulumi.Input[builtins.str] master_username: The master user name for the DB instance.
                 If you specify the ``SourceDBInstanceIdentifier`` or ``DBSnapshotIdentifier`` property, don't specify this property. The value is inherited from the source DB instance or snapshot.
                When migrating a self-managed Db2 database, we recommend that you use the same master username as your self-managed Db2 instance name.
                  *Amazon Aurora* 
                Not applicable. The name for the master user is managed by the DB cluster. 
                 *RDS for Db2* 
                Constraints:
                 +  Must be 1 to 16 letters or numbers.
                 +  First character must be a letter.
                 +  Can't be a reserved word for the chosen database engine.
                 
                 *RDS for MariaDB* 
                Constraints:
                 +  Must be 1 to 16 letters or numbers.
                 +  Can't be a reserved word for the chosen database engine.
                 
                 *RDS for Microsoft SQL Server* 
                Constraints:
                 +  Must be 1 to 128 letters or numbers.
                 +  First character must be a letter.
                 +  Can't be a reserved word for the chosen database engine.
                 
                 *RDS for MySQL* 
                Constraints:
                 +  Must be 1 to 16 letters or numbers.
                 +  First character must be a letter.
                 +  Can't be a reserved word for the chosen database engine.
                 
                 *RDS for Oracle* 
                Constraints:
                 +  Must be 1 to 30 letters or numbers.
                 +  First character must be a letter.
                 +  Can't be a reserved word for the chosen database engine.
                 
                 *RDS for PostgreSQL* 
                Constraints:
                 +  Must be 1 to 63 letters or numbers.
                 +  First character must be a letter.
                 +  Can't be a reserved word for the chosen database engine.
        :param pulumi.Input[builtins.int] max_allocated_storage: The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
                For more information about this setting, including limitations that apply to it, see [Managing capacity automatically with Amazon RDS storage autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling) in the *Amazon RDS User Guide*.
                This setting doesn't apply to the following DB instances:
                 +  Amazon Aurora (Storage is managed by the DB cluster.)
                 +  RDS Custom
        :param pulumi.Input[builtins.int] monitoring_interval: The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collection of Enhanced Monitoring metrics, specify ``0``.
                If ``MonitoringRoleArn`` is specified, then you must set ``MonitoringInterval`` to a value other than ``0``.
                This setting doesn't apply to RDS Custom DB instances.
                Valid Values: ``0 | 1 | 5 | 10 | 15 | 30 | 60``
                Default: ``0``
        :param pulumi.Input[builtins.str] monitoring_role_arn: The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, ``arn:aws:iam:123456789012:role/emaccess``. For information on creating a monitoring role, see [Setting Up and Enabling Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling) in the *Amazon RDS User Guide*.
                If ``MonitoringInterval`` is set to a value other than ``0``, then you must supply a ``MonitoringRoleArn`` value.
                This setting doesn't apply to RDS Custom DB instances.
        :param pulumi.Input[builtins.bool] multi_az: Specifies whether the DB instance is a Multi-AZ deployment. You can't set the ``AvailabilityZone`` parameter if the DB instance is a Multi-AZ deployment.
                This setting doesn't apply to the following DB instances:
                 +  Amazon Aurora (DB instance Availability Zones (AZs) are managed by the DB cluster.)
                 +  RDS Custom
        :param pulumi.Input[builtins.str] nchar_character_set_name: The name of the NCHAR character set for the Oracle DB instance.
                This setting doesn't apply to RDS Custom DB instances.
        :param pulumi.Input[builtins.str] network_type: The network type of the DB instance.
                Valid values:
                 +   ``IPV4`` 
                 +   ``DUAL`` 
                 
                The network type is determined by the ``DBSubnetGroup`` specified for the DB instance. A ``DBSubnetGroup`` can support only the IPv4 protocol or the IPv4 and IPv6 protocols (``DUAL``).
                For more information, see [Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
        :param pulumi.Input[builtins.str] option_group_name: Indicates that the DB instance should be associated with the specified option group.
                Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group. Also, that option group can't be removed from a DB instance once it is associated with a DB instance.
        :param pulumi.Input[builtins.str] performance_insights_kms_key_id: The AWS KMS key identifier for encryption of Performance Insights data.
                The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
                If you do not specify a value for ``PerformanceInsightsKMSKeyId``, then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account. Your AWS account has a different default KMS key for each AWS Region.
                For information about enabling Performance Insights, see [EnablePerformanceInsights](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights).
        :param pulumi.Input[builtins.int] performance_insights_retention_period: The number of days to retain Performance Insights data. When creating a DB instance without enabling Performance Insights, you can't specify the parameter ``PerformanceInsightsRetentionPeriod``.
                This setting doesn't apply to RDS Custom DB instances.
                Valid Values:
                 +   ``7`` 
                 +  *month* * 31, where *month* is a number of months from 1-23. Examples: ``93`` (3 months * 31), ``341`` (11 months * 31), ``589`` (19 months * 31)
                 +   ``731`` 
                 
                Default: ``7`` days
                If you specify a retention period that isn't valid, such as ``94``, Amazon RDS returns an error.
        :param pulumi.Input[builtins.str] port: The port number on which the database accepts connections.
                This setting doesn't apply to Aurora DB instances. The port number is managed by the cluster.
                Valid Values: ``1150-65535``
                Default:
                 +  RDS for Db2 - ``50000``
                 +  RDS for MariaDB - ``3306``
                 +  RDS for Microsoft SQL Server - ``1433``
                 +  RDS for MySQL - ``3306``
                 +  RDS for Oracle - ``1521``
                 +  RDS for PostgreSQL - ``5432``
                 
                Constraints:
                 +  For RDS for Microsoft SQL Server, the value can't be ``1234``, ``1434``, ``3260``, ``3343``, ``3389``, ``47001``, or ``49152-49156``.
        :param pulumi.Input[builtins.str] preferred_backup_window: The daily time range during which automated backups are created if automated backups are enabled, using the ``BackupRetentionPeriod`` parameter. For more information, see [Backup Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow) in the *Amazon RDS User Guide.*
                Constraints:
                 +  Must be in the format ``hh24:mi-hh24:mi``.
                 +  Must be in Universal Coordinated Time (UTC).
                 +  Must not conflict with the preferred maintenance window.
                 +  Must be at least 30 minutes.
                 
                 *Amazon Aurora* 
                Not applicable. The daily time range for creating automated backups is managed by the DB cluster.
        :param pulumi.Input[builtins.str] preferred_maintenance_window: The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
                Format: ``ddd:hh24:mi-ddd:hh24:mi``
                The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see [Maintaining a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow) in the *Amazon RDS User Guide.*
                 This property applies when AWS CloudFormation initially creates the DB instance. If you use AWS CloudFormation to update the DB instance, those updates are applied immediately.
                 Constraints: Minimum 30-minute window.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceProcessorFeatureArgs', 'DbInstanceProcessorFeatureArgsDict']]]] processor_features: The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
                This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
        :param pulumi.Input[builtins.int] promotion_tier: The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see [Fault Tolerance for an Aurora DB Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance) in the *Amazon Aurora User Guide*.
                This setting doesn't apply to RDS Custom DB instances.
                Default: ``1``
                Valid Values: ``0 - 15``
        :param pulumi.Input[builtins.bool] publicly_accessible: Indicates whether the DB instance is an internet-facing instance. If you specify true, AWS CloudFormation creates an instance with a publicly resolvable DNS name, which resolves to a public IP address. If you specify false, AWS CloudFormation creates an internal instance with a DNS name that resolves to a private IP address. 
                The default behavior value depends on your VPC setup and the database subnet group. For more information, see the ``PubliclyAccessible`` parameter in the [CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) in the *Amazon RDS API Reference*.
        :param pulumi.Input[builtins.str] replica_mode: The open mode of an Oracle read replica. For more information, see [Working with Oracle Read Replicas for Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) in the *Amazon RDS User Guide*.
                This setting is only supported in RDS for Oracle.
                Default: ``open-read-only``
                Valid Values: ``open-read-only`` or ``mounted``
        :param pulumi.Input[builtins.str] restore_time: The date and time to restore from. This parameter applies to point-in-time recovery. For more information, see [Restoring a DB instance to a specified time](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html) in the in the *Amazon RDS User Guide*.
                Constraints:
                 +  Must be a time in Universal Coordinated Time (UTC) format.
                 +  Must be before the latest restorable time for the DB instance.
                 +  Can't be specified if the ``UseLatestRestorableTime`` parameter is enabled.
                 
                Example: ``2009-09-07T23:45:00Z``
        :param pulumi.Input[builtins.str] source_db_cluster_identifier: The identifier of the Multi-AZ DB cluster that will act as the source for the read replica. Each DB cluster can have up to 15 read replicas.
                Constraints:
                 +  Must be the identifier of an existing Multi-AZ DB cluster.
                 +  Can't be specified if the ``SourceDBInstanceIdentifier`` parameter is also specified.
                 +  The specified DB cluster must have automatic backups enabled, that is, its backup retention period must be greater than 0.
                 +  The source DB cluster must be in the same AWS-Region as the read replica. Cross-Region replication isn't supported.
        :param pulumi.Input[builtins.str] source_db_instance_automated_backups_arn: The Amazon Resource Name (ARN) of the replicated automated backups from which to restore, for example, ``arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE``.
                This setting doesn't apply to RDS Custom.
        :param pulumi.Input[builtins.str] source_db_instance_identifier: If you want to create a read replica DB instance, specify the ID of the source DB instance. Each DB instance can have a limited number of read replicas. For more information, see [Working with Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/USER_ReadRepl.html) in the *Amazon RDS User Guide*.
                For information about constraints that apply to DB instance identifiers, see [Naming constraints in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints) in the *Amazon RDS User Guide*.
                The ``SourceDBInstanceIdentifier`` property determines whether a DB instance is a read replica. If you remove the ``SourceDBInstanceIdentifier`` property from your template and then update your stack, AWS CloudFormation promotes the read replica to a standalone DB instance.
                If you specify the ``UseLatestRestorableTime`` or ``RestoreTime`` properties in conjunction with the ``SourceDBInstanceIdentifier`` property, RDS restores the DB instance to the requested point in time, thereby creating a new DB instance.
                  +  If you specify a source DB instance that uses VPC security groups, we recommend that you specify the ``VPCSecurityGroups`` property. If you don't specify the property, the read replica inherits the value of the ``VPCSecurityGroups`` property from the source DB when you create the replica. However, if you update the stack, AWS CloudFormation reverts the replica's ``VPCSecurityGroups`` property to the default value because it's not defined in the stack's template. This change might cause unexpected issues.
                 +  Read replicas don't support deletion policies. AWS CloudFormation ignores any deletion policy that's associated with a read replica.
                 +  If you specify ``SourceDBInstanceIdentifier``, don't specify the ``DBSnapshotIdentifier`` property. You can't create a read replica from a snapshot.
                 +  Don't set the ``BackupRetentionPeriod``, ``DBName``, ``MasterUsername``, ``MasterUserPassword``, and ``PreferredBackupWindow`` properties. The database attributes are inherited from the source DB instance, and backups are disabled for read replicas.
                 +  If the source DB instance is in a different region than the read replica, specify the source region in ``SourceRegion``, and specify an ARN for a valid DB instance in ``SourceDBInstanceIdentifier``. For more information, see [Constructing a Amazon RDS Amazon Resource Name (ARN)](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN) in the *Amazon RDS User Guide*.
                 +  For DB instances in Amazon Aurora clusters, don't specify this property. Amazon RDS automatically assigns writer and reader DB instances.
        :param pulumi.Input[builtins.str] source_dbi_resource_id: The resource ID of the source DB instance from which to restore.
        :param pulumi.Input[builtins.str] source_region: The ID of the region that contains the source DB instance for the read replica.
        :param pulumi.Input[builtins.bool] storage_encrypted: A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
                If you specify the ``KmsKeyId`` property, then you must enable encryption.
                If you specify the ``SourceDBInstanceIdentifier`` or ``SourceDbiResourceId`` property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified ``KmsKeyId`` property is used.
                If you specify the ``SourceDBInstanceAutomatedBackupsArn`` property, don't specify this property. The value is inherited from the source DB instance automated backup. 
                If you specify ``DBSnapshotIdentifier`` property, don't specify this property. The value is inherited from the snapshot.
                 *Amazon Aurora* 
                Not applicable. The encryption for DB instances is managed by the DB cluster.
        :param pulumi.Input[builtins.int] storage_throughput: Specifies the storage throughput value, in mebibyte per second (MiBps), for the DB instance. This setting applies only to the ``gp3`` storage type. 
                This setting doesn't apply to RDS Custom or Amazon Aurora.
        :param pulumi.Input[builtins.str] storage_type: The storage type to associate with the DB instance.
                If you specify ``io1``, ``io2``, or ``gp3``, you must also include a value for the ``Iops`` parameter.
                This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
                Valid Values: ``gp2 | gp3 | io1 | io2 | standard``
                Default: ``io1``, if the ``Iops`` parameter is specified. Otherwise, ``gp3``.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Tags to assign to the DB instance.
        :param pulumi.Input[builtins.str] timezone: The time zone of the DB instance. The time zone parameter is currently supported only by [RDS for Db2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-time-zone) and [RDS for SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone).
        :param pulumi.Input[builtins.bool] use_default_processor_features: Specifies whether the DB instance class of the DB instance uses its default processor features.
                This setting doesn't apply to RDS Custom DB instances.
        :param pulumi.Input[builtins.bool] use_latest_restorable_time: Specifies whether the DB instance is restored from the latest backup time. By default, the DB instance isn't restored from the latest backup time. This parameter applies to point-in-time recovery. For more information, see [Restoring a DB instance to a specified time](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html) in the in the *Amazon RDS User Guide*.
                Constraints:
                 +  Can't be specified if the ``RestoreTime`` parameter is provided.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_security_groups: A list of the VPC security group IDs to assign to the DB instance. The list can include both the physical IDs of existing VPC security groups and references to [AWS::EC2::SecurityGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html) resources created in the template.
                If you plan to update the resource, don't specify VPC security groups in a shared VPC.
                 If you set ``VPCSecurityGroups``, you must not set [DBSecurityGroups](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups), and vice versa.
                 You can migrate a DB instance in your stack from an RDS DB security group to a VPC security group, but keep the following in mind:
                 +  You can't revert to using an RDS security group after you establish a VPC security group membership.
                 +  When you migrate your DB instance to VPC security groups, if your stack update rolls back because the DB instance update fails or because an update fails in another AWS CloudFormation resource, the rollback fails because it can't revert to an RDS security group.
                 +  To use the properties that are available when you use a VPC security group, you must recreate the DB instance. If you don't, AWS CloudFormation submits only the property values that are listed in the [DBSecurityGroups](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups) property.
                 
                 To avoid this situation, migrate your DB instance to using VPC security groups only when that is the only change in your stack template. 
                 *Amazon Aurora* 
                Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DbInstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::RDS::DBInstance`` resource creates an Amazon DB instance. The new DB instance can be an RDS DB instance, or it can be a DB instance in an Aurora DB cluster.
         For more information about creating an RDS DB instance, see [Creating an Amazon RDS DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html) in the *Amazon RDS User Guide*.
         For more information about creating a DB instance in an Aurora DB cluster, see [Creating an Amazon Aurora DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html) in the *Amazon Aurora User Guide*.
         If you import an existing DB instance, and the template configuration doesn't match the actual configuration of the DB instance, AWS CloudFormation applies the changes in the template during the import operation.
          If a DB instance is deleted or replaced during an update, AWS CloudFormation deletes all automated snapshots. However, it retains manual DB snapshots. During an update that requires replacement, you can apply a stack policy to prevent DB instances from being replaced. For more information, see [Prevent Updates to Stack Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html).
           *Updating DB instances*
         When properties labeled "*Update requires:*[Replacement](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement)" are updated, AWS CloudFormation first creates a replacement DB instance, then changes references from other dependent resources to point to the replacement DB instance, and finally deletes the old DB instance.
          We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB instance. To preserve your data, perform the following procedure:
          1.  Deactivate any applications that are using the DB instance so that there's no activity on the DB instance.
          2.  Create a snapshot of the DB instance. For more information, see [Creating a DB Snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateSnapshot.html).
          3.  If you want to restore your instance using a DB snapshot, modify the updated template with your DB instance changes and add the ``DBSnapshotIdentifier`` property with the ID of the DB snapshot that you want to use.
               After you restore a DB instance with a ``DBSnapshotIdentifier`` property, you can delete the ``DBSnapshotIdentifier`` property. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the ``DBSnapshotIdentifier`` property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified ``DBSnapshotIdentifier`` property, and the original DB instance is deleted.
          4.  Update the stack.

          For more information about updating other properties of this resource, see ``ModifyDBInstance``. For more information about updating stacks, see [CloudFormation Stacks Updates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
          *Deleting DB instances*
         For DB instances that are part of an Aurora DB cluster, you can set a deletion policy for your DB instance to control how AWS CloudFormation handles the DB instance when the stack is deleted. For Amazon RDS DB instances, you can choose to *retain* the DB instance, to *delete* the DB instance, or to *create a snapshot* of the DB instance. The default AWS CloudFormation behavior depends on the ``DBClusterIdentifier`` property:
          1.  For ``AWS::RDS::DBInstance`` resources that don't specify the ``DBClusterIdentifier`` property, AWS CloudFormation saves a snapshot of the DB instance.
          2.   For ``AWS::RDS::DBInstance`` resources that do specify the ``DBClusterIdentifier`` property, AWS CloudFormation deletes the DB instance.

          For more information, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html).

        :param str resource_name: The name of the resource.
        :param DbInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_storage: Optional[pulumi.Input[builtins.str]] = None,
                 allow_major_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 apply_immediately: Optional[pulumi.Input[builtins.bool]] = None,
                 associated_roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceDbInstanceRoleArgs', 'DbInstanceDbInstanceRoleArgsDict']]]]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 automatic_backup_replication_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 automatic_backup_replication_region: Optional[pulumi.Input[builtins.str]] = None,
                 automatic_backup_replication_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 backup_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 ca_certificate_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_rotation_restart: Optional[pulumi.Input[builtins.bool]] = None,
                 character_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[builtins.bool]] = None,
                 custom_iam_instance_profile: Optional[pulumi.Input[builtins.str]] = None,
                 database_insights_mode: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_instance_class: Optional[pulumi.Input[builtins.str]] = None,
                 db_instance_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 db_snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 dedicated_log_volume: Optional[pulumi.Input[builtins.bool]] = None,
                 delete_automated_backups: Optional[pulumi.Input[builtins.bool]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 domain_auth_secret_arn: Optional[pulumi.Input[builtins.str]] = None,
                 domain_dns_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 domain_fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 domain_iam_role_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_ou: Optional[pulumi.Input[builtins.str]] = None,
                 enable_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enable_iam_database_authentication: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_performance_insights: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_lifecycle_support: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 iops: Optional[pulumi.Input[builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 license_model: Optional[pulumi.Input[builtins.str]] = None,
                 manage_master_user_password: Optional[pulumi.Input[builtins.bool]] = None,
                 master_user_password: Optional[pulumi.Input[builtins.str]] = None,
                 master_user_secret: Optional[pulumi.Input[Union['DbInstanceMasterUserSecretArgs', 'DbInstanceMasterUserSecretArgsDict']]] = None,
                 master_username: Optional[pulumi.Input[builtins.str]] = None,
                 max_allocated_storage: Optional[pulumi.Input[builtins.int]] = None,
                 monitoring_interval: Optional[pulumi.Input[builtins.int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 multi_az: Optional[pulumi.Input[builtins.bool]] = None,
                 nchar_character_set_name: Optional[pulumi.Input[builtins.str]] = None,
                 network_type: Optional[pulumi.Input[builtins.str]] = None,
                 option_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 port: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_backup_window: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 processor_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceProcessorFeatureArgs', 'DbInstanceProcessorFeatureArgsDict']]]]] = None,
                 promotion_tier: Optional[pulumi.Input[builtins.int]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 replica_mode: Optional[pulumi.Input[builtins.str]] = None,
                 restore_time: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_instance_automated_backups_arn: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_instance_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_dbi_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_region: Optional[pulumi.Input[builtins.str]] = None,
                 storage_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_throughput: Optional[pulumi.Input[builtins.int]] = None,
                 storage_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tde_credential_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tde_credential_password: Optional[pulumi.Input[builtins.str]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None,
                 use_default_processor_features: Optional[pulumi.Input[builtins.bool]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[builtins.bool]] = None,
                 vpc_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbInstanceArgs.__new__(DbInstanceArgs)

            __props__.__dict__["allocated_storage"] = allocated_storage
            __props__.__dict__["allow_major_version_upgrade"] = allow_major_version_upgrade
            __props__.__dict__["apply_immediately"] = apply_immediately
            __props__.__dict__["associated_roles"] = associated_roles
            __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
            __props__.__dict__["automatic_backup_replication_kms_key_id"] = automatic_backup_replication_kms_key_id
            __props__.__dict__["automatic_backup_replication_region"] = automatic_backup_replication_region
            __props__.__dict__["automatic_backup_replication_retention_period"] = automatic_backup_replication_retention_period
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["backup_retention_period"] = backup_retention_period
            __props__.__dict__["ca_certificate_identifier"] = ca_certificate_identifier
            __props__.__dict__["certificate_rotation_restart"] = certificate_rotation_restart
            __props__.__dict__["character_set_name"] = character_set_name
            __props__.__dict__["copy_tags_to_snapshot"] = copy_tags_to_snapshot
            __props__.__dict__["custom_iam_instance_profile"] = custom_iam_instance_profile
            __props__.__dict__["database_insights_mode"] = database_insights_mode
            __props__.__dict__["db_cluster_identifier"] = db_cluster_identifier
            __props__.__dict__["db_cluster_snapshot_identifier"] = db_cluster_snapshot_identifier
            __props__.__dict__["db_instance_class"] = db_instance_class
            __props__.__dict__["db_instance_identifier"] = db_instance_identifier
            __props__.__dict__["db_name"] = db_name
            __props__.__dict__["db_parameter_group_name"] = db_parameter_group_name
            __props__.__dict__["db_security_groups"] = db_security_groups
            __props__.__dict__["db_snapshot_identifier"] = db_snapshot_identifier
            __props__.__dict__["db_subnet_group_name"] = db_subnet_group_name
            __props__.__dict__["db_system_id"] = db_system_id
            __props__.__dict__["dedicated_log_volume"] = dedicated_log_volume
            __props__.__dict__["delete_automated_backups"] = delete_automated_backups
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["domain"] = domain
            __props__.__dict__["domain_auth_secret_arn"] = domain_auth_secret_arn
            __props__.__dict__["domain_dns_ips"] = domain_dns_ips
            __props__.__dict__["domain_fqdn"] = domain_fqdn
            __props__.__dict__["domain_iam_role_name"] = domain_iam_role_name
            __props__.__dict__["domain_ou"] = domain_ou
            __props__.__dict__["enable_cloudwatch_logs_exports"] = enable_cloudwatch_logs_exports
            __props__.__dict__["enable_iam_database_authentication"] = enable_iam_database_authentication
            __props__.__dict__["enable_performance_insights"] = enable_performance_insights
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_lifecycle_support"] = engine_lifecycle_support
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["iops"] = iops
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["manage_master_user_password"] = manage_master_user_password
            __props__.__dict__["master_user_password"] = master_user_password
            __props__.__dict__["master_user_secret"] = master_user_secret
            __props__.__dict__["master_username"] = master_username
            __props__.__dict__["max_allocated_storage"] = max_allocated_storage
            __props__.__dict__["monitoring_interval"] = monitoring_interval
            __props__.__dict__["monitoring_role_arn"] = monitoring_role_arn
            __props__.__dict__["multi_az"] = multi_az
            __props__.__dict__["nchar_character_set_name"] = nchar_character_set_name
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["option_group_name"] = option_group_name
            __props__.__dict__["performance_insights_kms_key_id"] = performance_insights_kms_key_id
            __props__.__dict__["performance_insights_retention_period"] = performance_insights_retention_period
            __props__.__dict__["port"] = port
            __props__.__dict__["preferred_backup_window"] = preferred_backup_window
            __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
            __props__.__dict__["processor_features"] = processor_features
            __props__.__dict__["promotion_tier"] = promotion_tier
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            __props__.__dict__["replica_mode"] = replica_mode
            __props__.__dict__["restore_time"] = restore_time
            __props__.__dict__["source_db_cluster_identifier"] = source_db_cluster_identifier
            __props__.__dict__["source_db_instance_automated_backups_arn"] = source_db_instance_automated_backups_arn
            __props__.__dict__["source_db_instance_identifier"] = source_db_instance_identifier
            __props__.__dict__["source_dbi_resource_id"] = source_dbi_resource_id
            __props__.__dict__["source_region"] = source_region
            __props__.__dict__["storage_encrypted"] = storage_encrypted
            __props__.__dict__["storage_throughput"] = storage_throughput
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tde_credential_arn"] = tde_credential_arn
            __props__.__dict__["tde_credential_password"] = tde_credential_password
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["use_default_processor_features"] = use_default_processor_features
            __props__.__dict__["use_latest_restorable_time"] = use_latest_restorable_time
            __props__.__dict__["vpc_security_groups"] = vpc_security_groups
            __props__.__dict__["certificate_details"] = None
            __props__.__dict__["db_instance_arn"] = None
            __props__.__dict__["dbi_resource_id"] = None
            __props__.__dict__["endpoint"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["characterSetName", "customIamInstanceProfile", "dbClusterIdentifier", "dbInstanceIdentifier", "dbName", "dbSubnetGroupName", "dbSystemId", "kmsKeyId", "masterUsername", "ncharCharacterSetName", "sourceRegion", "storageEncrypted", "timezone"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DbInstance, __self__).__init__(
            'aws-native:rds:DbInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DbInstance':
        """
        Get an existing DbInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DbInstanceArgs.__new__(DbInstanceArgs)

        __props__.__dict__["allocated_storage"] = None
        __props__.__dict__["allow_major_version_upgrade"] = None
        __props__.__dict__["apply_immediately"] = None
        __props__.__dict__["associated_roles"] = None
        __props__.__dict__["auto_minor_version_upgrade"] = None
        __props__.__dict__["automatic_backup_replication_kms_key_id"] = None
        __props__.__dict__["automatic_backup_replication_region"] = None
        __props__.__dict__["automatic_backup_replication_retention_period"] = None
        __props__.__dict__["availability_zone"] = None
        __props__.__dict__["backup_retention_period"] = None
        __props__.__dict__["ca_certificate_identifier"] = None
        __props__.__dict__["certificate_details"] = None
        __props__.__dict__["certificate_rotation_restart"] = None
        __props__.__dict__["character_set_name"] = None
        __props__.__dict__["copy_tags_to_snapshot"] = None
        __props__.__dict__["custom_iam_instance_profile"] = None
        __props__.__dict__["database_insights_mode"] = None
        __props__.__dict__["db_cluster_identifier"] = None
        __props__.__dict__["db_cluster_snapshot_identifier"] = None
        __props__.__dict__["db_instance_arn"] = None
        __props__.__dict__["db_instance_class"] = None
        __props__.__dict__["db_instance_identifier"] = None
        __props__.__dict__["db_name"] = None
        __props__.__dict__["db_parameter_group_name"] = None
        __props__.__dict__["db_security_groups"] = None
        __props__.__dict__["db_snapshot_identifier"] = None
        __props__.__dict__["db_subnet_group_name"] = None
        __props__.__dict__["db_system_id"] = None
        __props__.__dict__["dbi_resource_id"] = None
        __props__.__dict__["dedicated_log_volume"] = None
        __props__.__dict__["delete_automated_backups"] = None
        __props__.__dict__["deletion_protection"] = None
        __props__.__dict__["domain"] = None
        __props__.__dict__["domain_auth_secret_arn"] = None
        __props__.__dict__["domain_dns_ips"] = None
        __props__.__dict__["domain_fqdn"] = None
        __props__.__dict__["domain_iam_role_name"] = None
        __props__.__dict__["domain_ou"] = None
        __props__.__dict__["enable_cloudwatch_logs_exports"] = None
        __props__.__dict__["enable_iam_database_authentication"] = None
        __props__.__dict__["enable_performance_insights"] = None
        __props__.__dict__["endpoint"] = None
        __props__.__dict__["engine"] = None
        __props__.__dict__["engine_lifecycle_support"] = None
        __props__.__dict__["engine_version"] = None
        __props__.__dict__["iops"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["license_model"] = None
        __props__.__dict__["manage_master_user_password"] = None
        __props__.__dict__["master_user_password"] = None
        __props__.__dict__["master_user_secret"] = None
        __props__.__dict__["master_username"] = None
        __props__.__dict__["max_allocated_storage"] = None
        __props__.__dict__["monitoring_interval"] = None
        __props__.__dict__["monitoring_role_arn"] = None
        __props__.__dict__["multi_az"] = None
        __props__.__dict__["nchar_character_set_name"] = None
        __props__.__dict__["network_type"] = None
        __props__.__dict__["option_group_name"] = None
        __props__.__dict__["performance_insights_kms_key_id"] = None
        __props__.__dict__["performance_insights_retention_period"] = None
        __props__.__dict__["port"] = None
        __props__.__dict__["preferred_backup_window"] = None
        __props__.__dict__["preferred_maintenance_window"] = None
        __props__.__dict__["processor_features"] = None
        __props__.__dict__["promotion_tier"] = None
        __props__.__dict__["publicly_accessible"] = None
        __props__.__dict__["replica_mode"] = None
        __props__.__dict__["restore_time"] = None
        __props__.__dict__["source_db_cluster_identifier"] = None
        __props__.__dict__["source_db_instance_automated_backups_arn"] = None
        __props__.__dict__["source_db_instance_identifier"] = None
        __props__.__dict__["source_dbi_resource_id"] = None
        __props__.__dict__["source_region"] = None
        __props__.__dict__["storage_encrypted"] = None
        __props__.__dict__["storage_throughput"] = None
        __props__.__dict__["storage_type"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["tde_credential_arn"] = None
        __props__.__dict__["tde_credential_password"] = None
        __props__.__dict__["timezone"] = None
        __props__.__dict__["use_default_processor_features"] = None
        __props__.__dict__["use_latest_restorable_time"] = None
        __props__.__dict__["vpc_security_groups"] = None
        return DbInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The amount of storage in gibibytes (GiB) to be initially allocated for the database instance.
          If any value is set in the ``Iops`` parameter, ``AllocatedStorage`` must be at least 100 GiB, which corresponds to the minimum Iops value of 1,000. If you increase the ``Iops`` value (in 1,000 IOPS increments), then you must also increase the ``AllocatedStorage`` value (in 100-GiB increments). 
           *Amazon Aurora* 
         Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.
          *Db2* 
         Constraints to the amount of storage for each storage type are the following:
          +  General Purpose (SSD) storage (gp3): Must be an integer from 20 to 64000.
          +  Provisioned IOPS storage (io1): Must be an integer from 100 to 64000.
          
          *MySQL* 
         Constraints to the amount of storage for each storage type are the following: 
          +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
          +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
          +  Magnetic storage (standard): Must be an integer from 5 to 3072.
          
          *MariaDB* 
         Constraints to the amount of storage for each storage type are the following: 
          +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
          +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
          +  Magnetic storage (standard): Must be an integer from 5 to 3072.
          
          *PostgreSQL* 
         Constraints to the amount of storage for each storage type are the following: 
          +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
          +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
          +  Magnetic storage (standard): Must be an integer from 5 to 3072.
          
          *Oracle* 
         Constraints to the amount of storage for each storage type are the following: 
          +  General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.
          +  Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.
          +  Magnetic storage (standard): Must be an integer from 10 to 3072.
          
          *SQL Server* 
         Constraints to the amount of storage for each storage type are the following: 
          +  General Purpose (SSD) storage (gp2):
          +  Enterprise and Standard editions: Must be an integer from 20 to 16384.
          +  Web and Express editions: Must be an integer from 20 to 16384.
          
          +  Provisioned IOPS storage (io1):
          +  Enterprise and Standard editions: Must be an integer from 20 to 16384.
          +  Web and Express editions: Must be an integer from 20 to 16384.
          
          +  Magnetic storage (standard):
          +  Enterprise and Standard editions: Must be an integer from 20 to 1024.
          +  Web and Express editions: Must be an integer from 20 to 1024.
        """
        return pulumi.get(self, "allocated_storage")

    @property
    @pulumi.getter(name="allowMajorVersionUpgrade")
    def allow_major_version_upgrade(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A value that indicates whether major version upgrades are allowed. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
         Constraints: Major version upgrades must be allowed when specifying a value for the ``EngineVersion`` parameter that is a different major version than the DB instance's current version.
        """
        return pulumi.get(self, "allow_major_version_upgrade")

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether changes to the DB instance and any pending modifications are applied immediately, regardless of the ``PreferredMaintenanceWindow`` setting. If set to ``false``, changes are applied during the next maintenance window. Until RDS applies the changes, the DB instance remains in a drift state. As a result, the configuration doesn't fully reflect the requested modifications and temporarily diverges from the intended state.
         In addition to the settings described in [Modifying a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html), this property also determines whether the DB instance reboots when a static parameter is modified in the associated DB parameter group.
         Default: ``true``
        """
        return pulumi.get(self, "apply_immediately")

    @property
    @pulumi.getter(name="associatedRoles")
    def associated_roles(self) -> pulumi.Output[Optional[Sequence['outputs.DbInstanceDbInstanceRole']]]:
        """
        The IAMlong (IAM) roles associated with the DB instance. 
          *Amazon Aurora* 
         Not applicable. The associated roles are managed by the DB cluster.
        """
        return pulumi.get(self, "associated_roles")

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are applied automatically.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @property
    @pulumi.getter(name="automaticBackupReplicationKmsKeyId")
    def automatic_backup_replication_kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination AWS-Region, for example, ``arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE``.
        """
        return pulumi.get(self, "automatic_backup_replication_kms_key_id")

    @property
    @pulumi.getter(name="automaticBackupReplicationRegion")
    def automatic_backup_replication_region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS-Region associated with the automated backup.
        """
        return pulumi.get(self, "automatic_backup_replication_region")

    @property
    @pulumi.getter(name="automaticBackupReplicationRetentionPeriod")
    def automatic_backup_replication_retention_period(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The retention period for automated backups in a different AWS Region. Use this parameter to set a unique retention period that only applies to cross-Region automated backups. To enable automated backups in a different Region, specify a positive value for the ``AutomaticBackupReplicationRegion`` parameter. 
         If not specified, this parameter defaults to the value of the ``BackupRetentionPeriod`` parameter. The maximum allowed value is 35.
        """
        return pulumi.get(self, "automatic_backup_replication_retention_period")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Availability Zone (AZ) where the database will be created. For information on AWS-Regions and Availability Zones, see [Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
         For Amazon Aurora, each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.
         Default: A random, system-chosen Availability Zone in the endpoint's AWS-Region.
         Constraints:
          +  The ``AvailabilityZone`` parameter can't be specified if the DB instance is a Multi-AZ deployment.
          +  The specified Availability Zone must be in the same AWS-Region as the current endpoint.
          
         Example: ``us-east-1d``
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
          *Amazon Aurora* 
         Not applicable. The retention period for automated backups is managed by the DB cluster.
         Default: 1
         Constraints:
          +  Must be a value from 0 to 35
          +  Can't be set to 0 if the DB instance is a source to read replicas
        """
        return pulumi.get(self, "backup_retention_period")

    @property
    @pulumi.getter(name="caCertificateIdentifier")
    def ca_certificate_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The identifier of the CA certificate for this DB instance.
         For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
        """
        return pulumi.get(self, "ca_certificate_identifier")

    @property
    @pulumi.getter(name="certificateDetails")
    def certificate_details(self) -> pulumi.Output['outputs.DbInstanceCertificateDetails']:
        return pulumi.get(self, "certificate_details")

    @property
    @pulumi.getter(name="certificateRotationRestart")
    def certificate_rotation_restart(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
         By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.
          Set this parameter only if you are *not* using SSL/TLS to connect to the DB instance.
          If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB engine to rotate your SSL/TLS certificate:
          +  For more information about rotating your SSL/TLS certificate for RDS DB engines, see [Rotating Your SSL/TLS Certificate.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html) in the *Amazon RDS User Guide.*
          +  For more information about rotating your SSL/TLS certificate for Aurora DB engines, see [Rotating Your SSL/TLS Certificate](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html) in the *Amazon Aurora User Guide*.
          
         This setting doesn't apply to RDS Custom DB instances.
        """
        return pulumi.get(self, "certificate_rotation_restart")

    @property
    @pulumi.getter(name="characterSetName")
    def character_set_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        For supported engines, indicates that the DB instance should be associated with the specified character set.
          *Amazon Aurora* 
         Not applicable. The character set is managed by the DB cluster. For more information, see [AWS::RDS::DBCluster](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html).
        """
        return pulumi.get(self, "character_set_name")

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.
         This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @property
    @pulumi.getter(name="customIamInstanceProfile")
    def custom_iam_instance_profile(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
         This setting is required for RDS Custom.
         Constraints:
          +  The profile must exist in your account.
          +  The profile must have an IAM role that Amazon EC2 has permissions to assume.
          +  The instance profile name and the associated IAM role name must start with the prefix ``AWSRDSCustom``.
          
         For the list of permissions required for the IAM role, see [Configure IAM and your VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc) in the *Amazon RDS User Guide*.
        """
        return pulumi.get(self, "custom_iam_instance_profile")

    @property
    @pulumi.getter(name="databaseInsightsMode")
    def database_insights_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The mode of Database Insights to enable for the DB instance.
          Aurora DB instances inherit this value from the DB cluster, so you can't change this value.
        """
        return pulumi.get(self, "database_insights_mode")

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The identifier of the DB cluster that this DB instance will belong to.
         This setting doesn't apply to RDS Custom DB instances.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @property
    @pulumi.getter(name="dbClusterSnapshotIdentifier")
    def db_cluster_snapshot_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The identifier for the Multi-AZ DB cluster snapshot to restore from.
         For more information on Multi-AZ DB clusters, see [Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
         Constraints:
          +  Must match the identifier of an existing Multi-AZ DB cluster snapshot.
          +  Can't be specified when ``DBSnapshotIdentifier`` is specified.
          +  Must be specified when ``DBSnapshotIdentifier`` isn't specified.
          +  If you are restoring from a shared manual Multi-AZ DB cluster snapshot, the ``DBClusterSnapshotIdentifier`` must be the ARN of the shared snapshot.
          +  Can't be the identifier of an Aurora DB cluster snapshot.
        """
        return pulumi.get(self, "db_cluster_snapshot_identifier")

    @property
    @pulumi.getter(name="dbInstanceArn")
    def db_instance_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the DB instance.
        """
        return pulumi.get(self, "db_instance_arn")

    @property
    @pulumi.getter(name="dbInstanceClass")
    def db_instance_class(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The compute and memory capacity of the DB instance, for example ``db.m5.large``. Not all DB instance classes are available in all AWS-Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see [DB instance classes](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide* or [Aurora DB instance classes](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html) in the *Amazon Aurora User Guide*.
        """
        return pulumi.get(self, "db_instance_class")

    @property
    @pulumi.getter(name="dbInstanceIdentifier")
    def db_instance_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A name for the DB instance. If you specify a name, AWS CloudFormation converts it to lowercase. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the DB instance. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
         For information about constraints that apply to DB instance identifiers, see [Naming constraints in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints) in the *Amazon RDS User Guide*.
          If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        """
        return pulumi.get(self, "db_instance_identifier")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The meaning of this parameter differs according to the database engine you use.
          If you specify the ``DBSnapshotIdentifier`` property, this property only applies to RDS for Oracle.
           *Amazon Aurora* 
         Not applicable. The database name is managed by the DB cluster.
          *Db2* 
         The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.
         Constraints:
          +  Must contain 1 to 64 letters or numbers.
          +  Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
          +  Can't be a word reserved by the specified database engine.
          
          *MySQL* 
         The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
         Constraints:
          +  Must contain 1 to 64 letters or numbers.
          +  Can't be a word reserved by the specified database engine
          
          *MariaDB* 
         The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
         Constraints:
          +  Must contain 1 to 64 letters or numbers.
          +  Can't be a word reserved by the specified database engine
          
          *PostgreSQL* 
         The name of the database to create when the DB instance is created. If this parameter is not specified, the default ``postgres`` database is created in the DB instance.
         Constraints:
          +  Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).
          +  Must contain 1 to 63 characters.
          +  Can't be a word reserved by the specified database engine
          
          *Oracle* 
         The Oracle System ID (SID) of the created DB instance. If you specify ``null``, the default value ``ORCL`` is used. You can't specify the string NULL, or any other reserved word, for ``DBName``. 
         Default: ``ORCL``
         Constraints:
          +  Can't be longer than 8 characters
          
          *SQL Server* 
         Not applicable. Must be null.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbParameterGroupName")
    def db_parameter_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of an existing DB parameter group or a reference to an [AWS::RDS::DBParameterGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html) resource created in the template.
         To list all of the available DB parameter group names, use the following command:
          ``aws rds describe-db-parameter-groups --query "DBParameterGroups[].DBParameterGroupName" --output text`` 
          If any of the data members of the referenced parameter group are changed during an update, the DB instance might need to be restarted, which causes some interruption. If the parameter group contains static parameters, whether they were changed or not, an update triggers a reboot.
          If you don't specify a value for ``DBParameterGroupName`` property, the default DB parameter group for the specified engine and engine version is used.
        """
        return pulumi.get(self, "db_parameter_group_name")

    @property
    @pulumi.getter(name="dbSecurityGroups")
    def db_security_groups(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of the DB security groups to assign to the DB instance. The list can include both the name of existing DB security groups or references to AWS::RDS::DBSecurityGroup resources created in the template.
          If you set DBSecurityGroups, you must not set VPCSecurityGroups, and vice versa. Also, note that the DBSecurityGroups property exists only for backwards compatibility with older regions and is no longer recommended for providing security information to an RDS DB instance. Instead, use VPCSecurityGroups.
          If you specify this property, AWS CloudFormation sends only the following properties (if specified) to Amazon RDS during create operations:
          +   ``AllocatedStorage`` 
          +   ``AutoMinorVersionUpgrade`` 
          +   ``AvailabilityZone`` 
          +   ``BackupRetentionPeriod`` 
          +   ``CharacterSetName`` 
          +   ``DBInstanceClass`` 
          +   ``DBName`` 
          +   ``DBParameterGroupName`` 
          +   ``DBSecurityGroups`` 
          +   ``DBSubnetGroupName`` 
          +   ``Engine`` 
          +   ``EngineVersion`` 
          +   ``Iops`` 
          +   ``LicenseModel`` 
          +   ``MasterUsername`` 
          +   ``MasterUserPassword`` 
          +   ``MultiAZ`` 
          +   ``OptionGroupName`` 
          +   ``PreferredBackupWindow`` 
          +   ``PreferredMaintenanceWindow`` 
          
         All other properties are ignored. Specify a virtual private cloud (VPC) security group if you want to submit other properties, such as ``StorageType``, ``StorageEncrypted``, or ``KmsKeyId``. If you're already using the ``DBSecurityGroups`` property, you can't use these other properties by updating your DB instance to use a VPC security group. You must recreate the DB instance.
        """
        return pulumi.get(self, "db_security_groups")

    @property
    @pulumi.getter(name="dbSnapshotIdentifier")
    def db_snapshot_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name or Amazon Resource Name (ARN) of the DB snapshot that's used to restore the DB instance. If you're restoring from a shared manual DB snapshot, you must specify the ARN of the snapshot.
         By specifying this property, you can create a DB instance from the specified DB snapshot. If the ``DBSnapshotIdentifier`` property is an empty string or the ``AWS::RDS::DBInstance`` declaration has no ``DBSnapshotIdentifier`` property, AWS CloudFormation creates a new database. If the property contains a value (other than an empty string), AWS CloudFormation creates a database from the specified snapshot. If a snapshot with the specified name doesn't exist, AWS CloudFormation can't create the database and it rolls back the stack.
         Some DB instance properties aren't valid when you restore from a snapshot, such as the ``MasterUsername`` and ``MasterUserPassword`` properties, and the point-in-time recovery properties ``RestoreTime`` and ``UseLatestRestorableTime``. For information about the properties that you can specify, see the [RestoreDBInstanceFromDBSnapshot](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_RestoreDBInstanceFromDBSnapshot.html) action in the *Amazon RDS API Reference*.
         After you restore a DB instance with a ``DBSnapshotIdentifier`` property, you must specify the same ``DBSnapshotIdentifier`` property for any future updates to the DB instance. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the ``DBSnapshotIdentifier`` property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified ``DBSnapshotIdentifier`` property, and the original DB instance is deleted.
         If you specify the ``DBSnapshotIdentifier`` property to restore a DB instance (as opposed to specifying it for DB instance updates), then don't specify the following properties:
          +   ``CharacterSetName`` 
          +   ``DBClusterIdentifier`` 
          +   ``DBName`` 
          +   ``KmsKeyId`` 
          +   ``MasterUsername`` 
          +   ``MasterUserPassword`` 
          +   ``PromotionTier`` 
          +   ``SourceDBInstanceIdentifier`` 
          +   ``SourceRegion`` 
          +  ``StorageEncrypted`` (for an unencrypted snapshot)
          +   ``Timezone`` 
          
          *Amazon Aurora* 
         Not applicable. Snapshot restore is managed by the DB cluster.
        """
        return pulumi.get(self, "db_snapshot_identifier")

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A DB subnet group to associate with the DB instance. If you update this value, the new subnet group must be a subnet group in a new VPC. 
         If you don't specify a DB subnet group, RDS uses the default DB subnet group if one exists. If a default DB subnet group does not exist, and you don't specify a ``DBSubnetGroupName``, the DB instance fails to launch. 
         For more information about using Amazon RDS in a VPC, see [Amazon VPC and Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html) in the *Amazon RDS User Guide*. 
         This setting doesn't apply to Amazon Aurora DB instances. The DB subnet group is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Oracle system identifier (SID), which is the name of the Oracle database instance that manages your database files. In this context, the term "Oracle database instance" refers exclusively to the system global area (SGA) and Oracle background processes. If you don't specify a SID, the value defaults to ``RDSCDB``. The Oracle SID is also the name of your CDB.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="dbiResourceId")
    def dbi_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The AWS Region-unique, immutable identifier for the DB instance. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB instance is accessed.
        """
        return pulumi.get(self, "dbi_resource_id")

    @property
    @pulumi.getter(name="dedicatedLogVolume")
    def dedicated_log_volume(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
        """
        return pulumi.get(self, "dedicated_log_volume")

    @property
    @pulumi.getter(name="deleteAutomatedBackups")
    def delete_automated_backups(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.
          *Amazon Aurora* 
         Not applicable. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the DB cluster are not deleted.
        """
        return pulumi.get(self, "delete_automated_backups")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see [Deleting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
         This setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion protection for the DB cluster. For more information, see ``CreateDBCluster``. DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Active Directory directory ID to create the DB instance in. Currently, only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
         For more information, see [Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html) in the *Amazon RDS User Guide*.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainAuthSecretArn")
    def domain_auth_secret_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
         Example: ``arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456``
        """
        return pulumi.get(self, "domain_auth_secret_arn")

    @property
    @pulumi.getter(name="domainDnsIps")
    def domain_dns_ips(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
         Constraints:
          +  Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.
          
         Example: ``123.124.125.126,234.235.236.237``
        """
        return pulumi.get(self, "domain_dns_ips")

    @property
    @pulumi.getter(name="domainFqdn")
    def domain_fqdn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The fully qualified domain name (FQDN) of an Active Directory domain.
         Constraints:
          +  Can't be longer than 64 characters.
          
         Example: ``mymanagedADtest.mymanagedAD.mydomain``
        """
        return pulumi.get(self, "domain_fqdn")

    @property
    @pulumi.getter(name="domainIamRoleName")
    def domain_iam_role_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the IAM role to use when making API calls to the Directory Service.
         This setting doesn't apply to the following DB instances:
          +  Amazon Aurora (The domain is managed by the DB cluster.)
          +  RDS Custom
        """
        return pulumi.get(self, "domain_iam_role_name")

    @property
    @pulumi.getter(name="domainOu")
    def domain_ou(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Active Directory organizational unit for your DB instance to join.
         Constraints:
          +  Must be in the distinguished name format.
          +  Can't be longer than 64 characters.
          
         Example: ``OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain``
        """
        return pulumi.get(self, "domain_ou")

    @property
    @pulumi.getter(name="enableCloudwatchLogsExports")
    def enable_cloudwatch_logs_exports(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Relational Database Service User Guide*.
          *Amazon Aurora* 
         Not applicable. CloudWatch Logs exports are managed by the DB cluster. 
          *Db2* 
         Valid values: ``diag.log``, ``notify.log``
          *MariaDB* 
         Valid values: ``audit``, ``error``, ``general``, ``slowquery``
          *Microsoft SQL Server* 
         Valid values: ``agent``, ``error``
          *MySQL* 
         Valid values: ``audit``, ``error``, ``general``, ``slowquery``
          *Oracle* 
         Valid values: ``alert``, ``audit``, ``listener``, ``trace``, ``oemagent``
          *PostgreSQL* 
         Valid values: ``postgresql``, ``upgrade``
        """
        return pulumi.get(self, "enable_cloudwatch_logs_exports")

    @property
    @pulumi.getter(name="enableIamDatabaseAuthentication")
    def enable_iam_database_authentication(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.
         This property is supported for RDS for MariaDB, RDS for MySQL, and RDS for PostgreSQL. For more information, see [IAM Database Authentication for MariaDB, MySQL, and PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon RDS User Guide.*
          *Amazon Aurora* 
         Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.
        """
        return pulumi.get(self, "enable_iam_database_authentication")

    @property
    @pulumi.getter(name="enablePerformanceInsights")
    def enable_performance_insights(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether to enable Performance Insights for the DB instance. For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
         This setting doesn't apply to RDS Custom DB instances.
        """
        return pulumi.get(self, "enable_performance_insights")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output['outputs.DbInstanceEndpoint']:
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the database engine to use for this DB instance. Not every database engine is available in every AWS Region.
         This property is required when creating a DB instance.
          You can convert an Oracle database from the non-CDB architecture to the container database (CDB) architecture by updating the ``Engine`` value in your templates from ``oracle-ee`` to ``oracle-ee-cdb`` or from ``oracle-se2`` to ``oracle-se2-cdb``. Converting to the CDB architecture requires an interruption.
          Valid Values:
          +  ``aurora-mysql`` (for Aurora MySQL DB instances)
          +  ``aurora-postgresql`` (for Aurora PostgreSQL DB instances)
          +  ``custom-oracle-ee`` (for RDS Custom for Oracle DB instances)
          +  ``custom-oracle-ee-cdb`` (for RDS Custom for Oracle DB instances)
          +  ``custom-sqlserver-ee`` (for RDS Custom for SQL Server DB instances)
          +  ``custom-sqlserver-se`` (for RDS Custom for SQL Server DB instances)
          +  ``custom-sqlserver-web`` (for RDS Custom for SQL Server DB instances)
          +   ``db2-ae`` 
          +   ``db2-se`` 
          +   ``mariadb`` 
          +   ``mysql`` 
          +   ``oracle-ee`` 
          +   ``oracle-ee-cdb`` 
          +   ``oracle-se2`` 
          +   ``oracle-se2-cdb`` 
          +   ``postgres`` 
          +   ``sqlserver-ee`` 
          +   ``sqlserver-se`` 
          +   ``sqlserver-ex`` 
          +   ``sqlserver-web``
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineLifecycleSupport")
    def engine_lifecycle_support(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The life cycle type for this DB instance.
          By default, this value is set to ``open-source-rds-extended-support``, which enrolls your DB instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to ``open-source-rds-extended-support-disabled``. In this case, creating the DB instance will fail if the DB major version is past its end of standard support date.
          This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by the DB cluster.
         You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB instance past the end of standard support for that engine version. For more information, see [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html) in the *Amazon RDS User Guide*.
         Valid Values: ``open-source-rds-extended-support | open-source-rds-extended-support-disabled``
         Default: ``open-source-rds-extended-support``
        """
        return pulumi.get(self, "engine_lifecycle_support")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version number of the database engine to use.
         For a list of valid engine versions, use the ``DescribeDBEngineVersions`` action.
         The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every AWS Region.
          *Amazon Aurora* 
         Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.
          *Db2* 
         See [Amazon RDS for Db2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Db2.html#Db2.Concepts.VersionMgmt) in the *Amazon RDS User Guide.*
          *MariaDB* 
         See [MariaDB on Amazon RDS Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt) in the *Amazon RDS User Guide.*
          *Microsoft SQL Server* 
         See [Microsoft SQL Server Versions on Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport) in the *Amazon RDS User Guide.*
          *MySQL* 
         See [MySQL on Amazon RDS Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt) in the *Amazon RDS User Guide.*
          *Oracle* 
         See [Oracle Database Engine Release Notes](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html) in the *Amazon RDS User Guide.*
          *PostgreSQL* 
         See [Supported PostgreSQL Database Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts.General.DBVersions) in the *Amazon RDS User Guide.*
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter
    def iops(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of I/O operations per second (IOPS) that the database provisions. The value must be equal to or greater than 1000. 
         If you specify this property, you must follow the range of allowed ratios of your requested IOPS rate to the amount of storage that you allocate (IOPS to allocated storage). For example, you can provision an Oracle database instance with 1000 IOPS and 200 GiB of storage (a ratio of 5:1), or specify 2000 IOPS with 200 GiB of storage (a ratio of 10:1). For more information, see [Amazon RDS Provisioned IOPS Storage to Improve Performance](https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
          If you specify ``io1`` for the ``StorageType`` property, then you must also specify the ``Iops`` property.
          Constraints:
          +  For RDS for Db2, MariaDB, MySQL, Oracle, and PostgreSQL - Must be a multiple between .5 and 50 of the storage amount for the DB instance.
          +  For RDS for SQL Server - Must be a multiple between 1 and 50 of the storage amount for the DB instance.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARN of the AWS KMS key that's used to encrypt the DB instance, such as ``arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef``. If you enable the StorageEncrypted property but don't specify this property, AWS CloudFormation uses the default KMS key. If you specify this property, you must set the StorageEncrypted property to true. 
         If you specify the ``SourceDBInstanceIdentifier`` or ``SourceDbiResourceId`` property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified ``KmsKeyId`` property is used. However, if the source DB instance is in a different AWS Region, you must specify a KMS key ID.
         If you specify the ``SourceDBInstanceAutomatedBackupsArn`` property, don't specify this property. The value is inherited from the source DB instance automated backup, and if the automated backup is encrypted, the specified ``KmsKeyId`` property is used.
         If you create an encrypted read replica in a different AWS Region, then you must specify a KMS key for the destination AWS Region. KMS encryption keys are specific to the region that they're created in, and you can't use encryption keys from one region in another region.
         If you specify the ``DBSnapshotIdentifier`` property, don't specify this property. The ``StorageEncrypted`` property value is inherited from the snapshot. If the DB instance is encrypted, the specified ``KmsKeyId`` property is also inherited from the snapshot.
         If you specify ``DBSecurityGroups``, AWS CloudFormation ignores this property. To specify both a security group and this property, you must use a VPC security group. For more information about Amazon RDS and VPC, see [Using Amazon RDS with Amazon VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html) in the *Amazon RDS User Guide*.
          *Amazon Aurora* 
         Not applicable. The KMS key identifier is managed by the DB cluster.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        License model information for this DB instance.
          Valid Values:
          +  Aurora MySQL - ``general-public-license``
          +  Aurora PostgreSQL - ``postgresql-license``
          +  RDS for Db2 - ``bring-your-own-license``. For more information about RDS for Db2 licensing, see [](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html) in the *Amazon RDS User Guide.*
          +  RDS for MariaDB - ``general-public-license``
          +  RDS for Microsoft SQL Server - ``license-included``
          +  RDS for MySQL - ``general-public-license``
          +  RDS for Oracle - ``bring-your-own-license`` or ``license-included``
          +  RDS for PostgreSQL - ``postgresql-license``
          
          If you've specified ``DBSecurityGroups`` and then you update the license model, AWS CloudFormation replaces the underlying DB instance. This will incur some interruptions to database availability.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="manageMasterUserPassword")
    def manage_master_user_password(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether to manage the master user password with AWS Secrets Manager.
         For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide.*
         Constraints:
          +  Can't manage the master user password with AWS Secrets Manager if ``MasterUserPassword`` is specified.
        """
        return pulumi.get(self, "manage_master_user_password")

    @property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The password for the master user. The password can include any printable ASCII character except "/", \"\"\", or "@".
          *Amazon Aurora* 
         Not applicable. The password for the master user is managed by the DB cluster.
          *RDS for Db2* 
         Must contain from 8 to 255 characters.
          *RDS for MariaDB* 
         Constraints: Must contain from 8 to 41 characters.
          *RDS for Microsoft SQL Server* 
         Constraints: Must contain from 8 to 128 characters.
          *RDS for MySQL* 
         Constraints: Must contain from 8 to 41 characters.
          *RDS for Oracle* 
         Constraints: Must contain from 8 to 30 characters.
          *RDS for PostgreSQL* 
         Constraints: Must contain from 8 to 128 characters.
        """
        return pulumi.get(self, "master_user_password")

    @property
    @pulumi.getter(name="masterUserSecret")
    def master_user_secret(self) -> pulumi.Output[Optional['outputs.DbInstanceMasterUserSecret']]:
        """
        The secret managed by RDS in AWS Secrets Manager for the master user password.
         For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide.*
        """
        return pulumi.get(self, "master_user_secret")

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The master user name for the DB instance.
          If you specify the ``SourceDBInstanceIdentifier`` or ``DBSnapshotIdentifier`` property, don't specify this property. The value is inherited from the source DB instance or snapshot.
         When migrating a self-managed Db2 database, we recommend that you use the same master username as your self-managed Db2 instance name.
           *Amazon Aurora* 
         Not applicable. The name for the master user is managed by the DB cluster. 
          *RDS for Db2* 
         Constraints:
          +  Must be 1 to 16 letters or numbers.
          +  First character must be a letter.
          +  Can't be a reserved word for the chosen database engine.
          
          *RDS for MariaDB* 
         Constraints:
          +  Must be 1 to 16 letters or numbers.
          +  Can't be a reserved word for the chosen database engine.
          
          *RDS for Microsoft SQL Server* 
         Constraints:
          +  Must be 1 to 128 letters or numbers.
          +  First character must be a letter.
          +  Can't be a reserved word for the chosen database engine.
          
          *RDS for MySQL* 
         Constraints:
          +  Must be 1 to 16 letters or numbers.
          +  First character must be a letter.
          +  Can't be a reserved word for the chosen database engine.
          
          *RDS for Oracle* 
         Constraints:
          +  Must be 1 to 30 letters or numbers.
          +  First character must be a letter.
          +  Can't be a reserved word for the chosen database engine.
          
          *RDS for PostgreSQL* 
         Constraints:
          +  Must be 1 to 63 letters or numbers.
          +  First character must be a letter.
          +  Can't be a reserved word for the chosen database engine.
        """
        return pulumi.get(self, "master_username")

    @property
    @pulumi.getter(name="maxAllocatedStorage")
    def max_allocated_storage(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
         For more information about this setting, including limitations that apply to it, see [Managing capacity automatically with Amazon RDS storage autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling) in the *Amazon RDS User Guide*.
         This setting doesn't apply to the following DB instances:
          +  Amazon Aurora (Storage is managed by the DB cluster.)
          +  RDS Custom
        """
        return pulumi.get(self, "max_allocated_storage")

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collection of Enhanced Monitoring metrics, specify ``0``.
         If ``MonitoringRoleArn`` is specified, then you must set ``MonitoringInterval`` to a value other than ``0``.
         This setting doesn't apply to RDS Custom DB instances.
         Valid Values: ``0 | 1 | 5 | 10 | 15 | 30 | 60``
         Default: ``0``
        """
        return pulumi.get(self, "monitoring_interval")

    @property
    @pulumi.getter(name="monitoringRoleArn")
    def monitoring_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, ``arn:aws:iam:123456789012:role/emaccess``. For information on creating a monitoring role, see [Setting Up and Enabling Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling) in the *Amazon RDS User Guide*.
         If ``MonitoringInterval`` is set to a value other than ``0``, then you must supply a ``MonitoringRoleArn`` value.
         This setting doesn't apply to RDS Custom DB instances.
        """
        return pulumi.get(self, "monitoring_role_arn")

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the DB instance is a Multi-AZ deployment. You can't set the ``AvailabilityZone`` parameter if the DB instance is a Multi-AZ deployment.
         This setting doesn't apply to the following DB instances:
          +  Amazon Aurora (DB instance Availability Zones (AZs) are managed by the DB cluster.)
          +  RDS Custom
        """
        return pulumi.get(self, "multi_az")

    @property
    @pulumi.getter(name="ncharCharacterSetName")
    def nchar_character_set_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the NCHAR character set for the Oracle DB instance.
         This setting doesn't apply to RDS Custom DB instances.
        """
        return pulumi.get(self, "nchar_character_set_name")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The network type of the DB instance.
         Valid values:
          +   ``IPV4`` 
          +   ``DUAL`` 
          
         The network type is determined by the ``DBSubnetGroup`` specified for the DB instance. A ``DBSubnetGroup`` can support only the IPv4 protocol or the IPv4 and IPv6 protocols (``DUAL``).
         For more information, see [Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="optionGroupName")
    def option_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Indicates that the DB instance should be associated with the specified option group.
         Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group. Also, that option group can't be removed from a DB instance once it is associated with a DB instance.
        """
        return pulumi.get(self, "option_group_name")

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS KMS key identifier for encryption of Performance Insights data.
         The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         If you do not specify a value for ``PerformanceInsightsKMSKeyId``, then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account. Your AWS account has a different default KMS key for each AWS Region.
         For information about enabling Performance Insights, see [EnablePerformanceInsights](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights).
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @property
    @pulumi.getter(name="performanceInsightsRetentionPeriod")
    def performance_insights_retention_period(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of days to retain Performance Insights data. When creating a DB instance without enabling Performance Insights, you can't specify the parameter ``PerformanceInsightsRetentionPeriod``.
         This setting doesn't apply to RDS Custom DB instances.
         Valid Values:
          +   ``7`` 
          +  *month* * 31, where *month* is a number of months from 1-23. Examples: ``93`` (3 months * 31), ``341`` (11 months * 31), ``589`` (19 months * 31)
          +   ``731`` 
          
         Default: ``7`` days
         If you specify a retention period that isn't valid, such as ``94``, Amazon RDS returns an error.
        """
        return pulumi.get(self, "performance_insights_retention_period")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The port number on which the database accepts connections.
         This setting doesn't apply to Aurora DB instances. The port number is managed by the cluster.
         Valid Values: ``1150-65535``
         Default:
          +  RDS for Db2 - ``50000``
          +  RDS for MariaDB - ``3306``
          +  RDS for Microsoft SQL Server - ``1433``
          +  RDS for MySQL - ``3306``
          +  RDS for Oracle - ``1521``
          +  RDS for PostgreSQL - ``5432``
          
         Constraints:
          +  For RDS for Microsoft SQL Server, the value can't be ``1234``, ``1434``, ``3260``, ``3343``, ``3389``, ``47001``, or ``49152-49156``.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The daily time range during which automated backups are created if automated backups are enabled, using the ``BackupRetentionPeriod`` parameter. For more information, see [Backup Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow) in the *Amazon RDS User Guide.*
         Constraints:
          +  Must be in the format ``hh24:mi-hh24:mi``.
          +  Must be in Universal Coordinated Time (UTC).
          +  Must not conflict with the preferred maintenance window.
          +  Must be at least 30 minutes.
          
          *Amazon Aurora* 
         Not applicable. The daily time range for creating automated backups is managed by the DB cluster.
        """
        return pulumi.get(self, "preferred_backup_window")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         Format: ``ddd:hh24:mi-ddd:hh24:mi``
         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see [Maintaining a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow) in the *Amazon RDS User Guide.*
          This property applies when AWS CloudFormation initially creates the DB instance. If you use AWS CloudFormation to update the DB instance, those updates are applied immediately.
          Constraints: Minimum 30-minute window.
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="processorFeatures")
    def processor_features(self) -> pulumi.Output[Optional[Sequence['outputs.DbInstanceProcessorFeature']]]:
        """
        The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
        """
        return pulumi.get(self, "processor_features")

    @property
    @pulumi.getter(name="promotionTier")
    def promotion_tier(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see [Fault Tolerance for an Aurora DB Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance) in the *Amazon Aurora User Guide*.
         This setting doesn't apply to RDS Custom DB instances.
         Default: ``1``
         Valid Values: ``0 - 15``
        """
        return pulumi.get(self, "promotion_tier")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether the DB instance is an internet-facing instance. If you specify true, AWS CloudFormation creates an instance with a publicly resolvable DNS name, which resolves to a public IP address. If you specify false, AWS CloudFormation creates an internal instance with a DNS name that resolves to a private IP address. 
         The default behavior value depends on your VPC setup and the database subnet group. For more information, see the ``PubliclyAccessible`` parameter in the [CreateDBInstance](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) in the *Amazon RDS API Reference*.
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter(name="replicaMode")
    def replica_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The open mode of an Oracle read replica. For more information, see [Working with Oracle Read Replicas for Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) in the *Amazon RDS User Guide*.
         This setting is only supported in RDS for Oracle.
         Default: ``open-read-only``
         Valid Values: ``open-read-only`` or ``mounted``
        """
        return pulumi.get(self, "replica_mode")

    @property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The date and time to restore from. This parameter applies to point-in-time recovery. For more information, see [Restoring a DB instance to a specified time](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html) in the in the *Amazon RDS User Guide*.
         Constraints:
          +  Must be a time in Universal Coordinated Time (UTC) format.
          +  Must be before the latest restorable time for the DB instance.
          +  Can't be specified if the ``UseLatestRestorableTime`` parameter is enabled.
          
         Example: ``2009-09-07T23:45:00Z``
        """
        return pulumi.get(self, "restore_time")

    @property
    @pulumi.getter(name="sourceDbClusterIdentifier")
    def source_db_cluster_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The identifier of the Multi-AZ DB cluster that will act as the source for the read replica. Each DB cluster can have up to 15 read replicas.
         Constraints:
          +  Must be the identifier of an existing Multi-AZ DB cluster.
          +  Can't be specified if the ``SourceDBInstanceIdentifier`` parameter is also specified.
          +  The specified DB cluster must have automatic backups enabled, that is, its backup retention period must be greater than 0.
          +  The source DB cluster must be in the same AWS-Region as the read replica. Cross-Region replication isn't supported.
        """
        return pulumi.get(self, "source_db_cluster_identifier")

    @property
    @pulumi.getter(name="sourceDbInstanceAutomatedBackupsArn")
    def source_db_instance_automated_backups_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the replicated automated backups from which to restore, for example, ``arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE``.
         This setting doesn't apply to RDS Custom.
        """
        return pulumi.get(self, "source_db_instance_automated_backups_arn")

    @property
    @pulumi.getter(name="sourceDbInstanceIdentifier")
    def source_db_instance_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If you want to create a read replica DB instance, specify the ID of the source DB instance. Each DB instance can have a limited number of read replicas. For more information, see [Working with Read Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/USER_ReadRepl.html) in the *Amazon RDS User Guide*.
         For information about constraints that apply to DB instance identifiers, see [Naming constraints in Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints) in the *Amazon RDS User Guide*.
         The ``SourceDBInstanceIdentifier`` property determines whether a DB instance is a read replica. If you remove the ``SourceDBInstanceIdentifier`` property from your template and then update your stack, AWS CloudFormation promotes the read replica to a standalone DB instance.
         If you specify the ``UseLatestRestorableTime`` or ``RestoreTime`` properties in conjunction with the ``SourceDBInstanceIdentifier`` property, RDS restores the DB instance to the requested point in time, thereby creating a new DB instance.
           +  If you specify a source DB instance that uses VPC security groups, we recommend that you specify the ``VPCSecurityGroups`` property. If you don't specify the property, the read replica inherits the value of the ``VPCSecurityGroups`` property from the source DB when you create the replica. However, if you update the stack, AWS CloudFormation reverts the replica's ``VPCSecurityGroups`` property to the default value because it's not defined in the stack's template. This change might cause unexpected issues.
          +  Read replicas don't support deletion policies. AWS CloudFormation ignores any deletion policy that's associated with a read replica.
          +  If you specify ``SourceDBInstanceIdentifier``, don't specify the ``DBSnapshotIdentifier`` property. You can't create a read replica from a snapshot.
          +  Don't set the ``BackupRetentionPeriod``, ``DBName``, ``MasterUsername``, ``MasterUserPassword``, and ``PreferredBackupWindow`` properties. The database attributes are inherited from the source DB instance, and backups are disabled for read replicas.
          +  If the source DB instance is in a different region than the read replica, specify the source region in ``SourceRegion``, and specify an ARN for a valid DB instance in ``SourceDBInstanceIdentifier``. For more information, see [Constructing a Amazon RDS Amazon Resource Name (ARN)](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN) in the *Amazon RDS User Guide*.
          +  For DB instances in Amazon Aurora clusters, don't specify this property. Amazon RDS automatically assigns writer and reader DB instances.
        """
        return pulumi.get(self, "source_db_instance_identifier")

    @property
    @pulumi.getter(name="sourceDbiResourceId")
    def source_dbi_resource_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The resource ID of the source DB instance from which to restore.
        """
        return pulumi.get(self, "source_dbi_resource_id")

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the region that contains the source DB instance for the read replica.
        """
        return pulumi.get(self, "source_region")

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
         If you specify the ``KmsKeyId`` property, then you must enable encryption.
         If you specify the ``SourceDBInstanceIdentifier`` or ``SourceDbiResourceId`` property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified ``KmsKeyId`` property is used.
         If you specify the ``SourceDBInstanceAutomatedBackupsArn`` property, don't specify this property. The value is inherited from the source DB instance automated backup. 
         If you specify ``DBSnapshotIdentifier`` property, don't specify this property. The value is inherited from the snapshot.
          *Amazon Aurora* 
         Not applicable. The encryption for DB instances is managed by the DB cluster.
        """
        return pulumi.get(self, "storage_encrypted")

    @property
    @pulumi.getter(name="storageThroughput")
    def storage_throughput(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the storage throughput value, in mebibyte per second (MiBps), for the DB instance. This setting applies only to the ``gp3`` storage type. 
         This setting doesn't apply to RDS Custom or Amazon Aurora.
        """
        return pulumi.get(self, "storage_throughput")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The storage type to associate with the DB instance.
         If you specify ``io1``, ``io2``, or ``gp3``, you must also include a value for the ``Iops`` parameter.
         This setting doesn't apply to Amazon Aurora DB instances. Storage is managed by the DB cluster.
         Valid Values: ``gp2 | gp3 | io1 | io2 | standard``
         Default: ``io1``, if the ``Iops`` parameter is specified. Otherwise, ``gp3``.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Tags to assign to the DB instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tdeCredentialArn")
    def tde_credential_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "tde_credential_arn")

    @property
    @pulumi.getter(name="tdeCredentialPassword")
    def tde_credential_password(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "tde_credential_password")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The time zone of the DB instance. The time zone parameter is currently supported only by [RDS for Db2](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-time-zone) and [RDS for SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone).
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter(name="useDefaultProcessorFeatures")
    def use_default_processor_features(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the DB instance class of the DB instance uses its default processor features.
         This setting doesn't apply to RDS Custom DB instances.
        """
        return pulumi.get(self, "use_default_processor_features")

    @property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the DB instance is restored from the latest backup time. By default, the DB instance isn't restored from the latest backup time. This parameter applies to point-in-time recovery. For more information, see [Restoring a DB instance to a specified time](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIT.html) in the in the *Amazon RDS User Guide*.
         Constraints:
          +  Can't be specified if the ``RestoreTime`` parameter is provided.
        """
        return pulumi.get(self, "use_latest_restorable_time")

    @property
    @pulumi.getter(name="vpcSecurityGroups")
    def vpc_security_groups(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of the VPC security group IDs to assign to the DB instance. The list can include both the physical IDs of existing VPC security groups and references to [AWS::EC2::SecurityGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html) resources created in the template.
         If you plan to update the resource, don't specify VPC security groups in a shared VPC.
          If you set ``VPCSecurityGroups``, you must not set [DBSecurityGroups](https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups), and vice versa.
          You can migrate a DB instance in your stack from an RDS DB security group to a VPC security group, but keep the following in mind:
          +  You can't revert to using an RDS security group after you establish a VPC security group membership.
          +  When you migrate your DB instance to VPC security groups, if your stack update rolls back because the DB instance update fails or because an update fails in another AWS CloudFormation resource, the rollback fails because it can't revert to an RDS security group.
          +  To use the properties that are available when you use a VPC security group, you must recreate the DB instance. If you don't, AWS CloudFormation submits only the property values that are listed in the [DBSecurityGroups](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups) property.
          
          To avoid this situation, migrate your DB instance to using VPC security groups only when that is the only change in your stack template. 
          *Amazon Aurora* 
         Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
        """
        return pulumi.get(self, "vpc_security_groups")

