# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['DbClusterArgs', 'DbCluster']

@pulumi.input_type
class DbClusterArgs:
    def __init__(__self__, *,
                 allocated_storage: Optional[pulumi.Input[builtins.int]] = None,
                 associated_roles: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterRoleArgs']]]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 backtrack_window: Optional[pulumi.Input[builtins.int]] = None,
                 backup_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 cluster_scalability_type: Optional[pulumi.Input[builtins.str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[builtins.bool]] = None,
                 database_insights_mode: Optional[pulumi.Input[builtins.str]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_instance_class: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_instance_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 domain_iam_role_name: Optional[pulumi.Input[builtins.str]] = None,
                 enable_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enable_global_write_forwarding: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_http_endpoint: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_iam_database_authentication: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_local_write_forwarding: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_lifecycle_support: Optional[pulumi.Input[builtins.str]] = None,
                 engine_mode: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 global_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 iops: Optional[pulumi.Input[builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 manage_master_user_password: Optional[pulumi.Input[builtins.bool]] = None,
                 master_user_password: Optional[pulumi.Input[builtins.str]] = None,
                 master_user_secret: Optional[pulumi.Input['DbClusterMasterUserSecretArgs']] = None,
                 master_username: Optional[pulumi.Input[builtins.str]] = None,
                 monitoring_interval: Optional[pulumi.Input[builtins.int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 network_type: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 replication_source_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 restore_to_time: Optional[pulumi.Input[builtins.str]] = None,
                 restore_type: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_configuration: Optional[pulumi.Input['DbClusterScalingConfigurationArgs']] = None,
                 serverless_v2_scaling_configuration: Optional[pulumi.Input['DbClusterServerlessV2ScalingConfigurationArgs']] = None,
                 snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_region: Optional[pulumi.Input[builtins.str]] = None,
                 storage_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[builtins.bool]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a DbCluster resource.
        :param pulumi.Input[builtins.int] allocated_storage: The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
                Valid for Cluster Type: Multi-AZ DB clusters only
                This setting is required to create a Multi-AZ DB cluster.
        :param pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterRoleArgs']]] associated_roles: Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.bool] auto_minor_version_upgrade: Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB cluster.
                For more information about automatic minor version upgrades, see [Automatically upgrading the minor engine version](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] availability_zones: A list of Availability Zones (AZs) where instances in the DB cluster can be created. For information on AWS Regions and Availability Zones, see [Choosing the Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html) in the *Amazon Aurora User Guide*. 
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.int] backtrack_window: The target backtrack window, in seconds. To disable backtracking, set this value to ``0``.
                Valid for Cluster Type: Aurora MySQL DB clusters only
                Default: ``0``
                Constraints:
                 +  If specified, this value must be set to a number from 0 to 259,200 (72 hours).
        :param pulumi.Input[builtins.int] backup_retention_period: The number of days for which automated backups are retained.
                Default: 1
                Constraints:
                 +  Must be a value from 1 to 35
                 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] cluster_scalability_type: Specifies the scalability mode of the Aurora DB cluster. When set to ``limitless``, the cluster operates as an Aurora Limitless Database, allowing you to create a DB shard group for horizontal scaling (sharding) capabilities. When set to ``standard`` (the default), the cluster uses normal DB instance creation.
        :param pulumi.Input[builtins.bool] copy_tags_to_snapshot: A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] database_insights_mode: The mode of Database Insights to enable for the DB cluster.
                If you set this value to ``advanced``, you must also set the ``PerformanceInsightsEnabled`` parameter to ``true`` and the ``PerformanceInsightsRetentionPeriod`` parameter to 465.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] database_name: The name of your database. If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see [Naming Constraints](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html#RDS_Limits.Constraints) in the *Amazon Aurora User Guide*. 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] db_cluster_identifier: The DB cluster identifier. This parameter is stored as a lowercase string.
                Constraints:
                 +  Must contain from 1 to 63 letters, numbers, or hyphens.
                 +  First character must be a letter.
                 +  Can't end with a hyphen or contain two consecutive hyphens.
                 
                Example: ``my-cluster1``
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] db_cluster_instance_class: The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example ``db.m6gd.xlarge``. Not all DB instance classes are available in all AWS-Regions, or for all database engines.
                For the full list of DB instance classes and availability for your engine, see [DB instance class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide*.
                This setting is required to create a Multi-AZ DB cluster.
                Valid for Cluster Type: Multi-AZ DB clusters only
        :param pulumi.Input[builtins.str] db_cluster_parameter_group_name: The name of the DB cluster parameter group to associate with this DB cluster.
                 If you apply a parameter group to an existing DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
                If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
                 To list all of the available DB cluster parameter group names, use the following command:
                 ``aws rds describe-db-cluster-parameter-groups --query "DBClusterParameterGroups[].DBClusterParameterGroupName" --output text`` 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] db_instance_parameter_group_name: The name of the DB parameter group to apply to all instances of the DB cluster.
                 When you apply a parameter group using the ``DBInstanceParameterGroupName`` parameter, the DB cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the next maintenance window.
                 Valid for Cluster Type: Aurora DB clusters only
                Default: The existing name setting
                Constraints:
                 +  The DB parameter group must be in the same DB parameter group family as this DB cluster.
                 +  The ``DBInstanceParameterGroupName`` parameter is valid in combination with the ``AllowMajorVersionUpgrade`` parameter for a major version upgrade only.
        :param pulumi.Input[builtins.str] db_subnet_group_name: A DB subnet group that you want to associate with this DB cluster. 
                If you are restoring a DB cluster to a point in time with ``RestoreType`` set to ``copy-on-write``, and don't specify a DB subnet group name, then the DB cluster is restored with a default DB subnet group.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] db_system_id: Reserved for future use.
        :param pulumi.Input[builtins.bool] deletion_protection: A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] domain: Indicates the directory ID of the Active Directory to create the DB cluster.
                For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.
                For more information, see [Kerberos authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html) in the *Amazon Aurora User Guide*.
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.str] domain_iam_role_name: Specifies the name of the IAM role to use when making API calls to the Directory Service.
                Valid for: Aurora DB clusters only
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] enable_cloudwatch_logs_exports: The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Aurora User Guide*.
                 *Aurora MySQL* 
                Valid values: ``audit``, ``error``, ``general``, ``slowquery``
                 *Aurora PostgreSQL* 
                Valid values: ``postgresql``
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.bool] enable_global_write_forwarding: Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global cluster (Aurora global database). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.
                You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by a global cluster API operation, but it does nothing until then.
                Valid for Cluster Type: Aurora DB clusters only
        :param pulumi.Input[builtins.bool] enable_http_endpoint: Specifies whether to enable the HTTP endpoint for the DB cluster. By default, the HTTP endpoint isn't enabled.
                When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the DB cluster. You can also query your database from inside the RDS console with the RDS query editor.
                For more information, see [Using RDS Data API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
                Valid for Cluster Type: Aurora DB clusters only
        :param pulumi.Input[builtins.bool] enable_iam_database_authentication: A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.
                For more information, see [IAM Database Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon Aurora User Guide.*
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.bool] enable_local_write_forwarding: Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster. By default, write operations aren't allowed on reader DB instances.
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.str] engine: The name of the database engine to be used for this DB cluster.
                Valid Values:
                 +   ``aurora-mysql`` 
                 +   ``aurora-postgresql`` 
                 +   ``mysql`` 
                 +   ``postgres`` 
                 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] engine_lifecycle_support: The life cycle type for this DB cluster.
                 By default, this value is set to ``open-source-rds-extended-support``, which enrolls your DB cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to ``open-source-rds-extended-support-disabled``. In this case, creating the DB cluster will fail if the DB major version is past its end of standard support date.
                 You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB cluster past the end of standard support for that engine version. For more information, see the following sections:
                 +  Amazon Aurora - [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html) in the *Amazon Aurora User Guide*
                 +  Amazon RDS - [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html) in the *Amazon RDS User Guide*
                 
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
                Valid Values: ``open-source-rds-extended-support | open-source-rds-extended-support-disabled``
                Default: ``open-source-rds-extended-support``
        :param pulumi.Input[builtins.str] engine_mode: The DB engine mode of the DB cluster, either ``provisioned`` or ``serverless``.
                The ``serverless`` engine mode only applies for Aurora Serverless v1 DB clusters. Aurora Serverless v2 DB clusters use the ``provisioned`` engine mode.
                For information about limitations and requirements for Serverless DB clusters, see the following sections in the *Amazon Aurora User Guide*:
                 +   [Limitations of Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations) 
                 +   [Requirements for Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html) 
                 
                Valid for Cluster Type: Aurora DB clusters only
        :param pulumi.Input[builtins.str] engine_version: The version number of the database engine to use.
                To list all of the available engine versions for Aurora MySQL version 2 (5.7-compatible) and version 3 (8.0-compatible), use the following command:
                 ``aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`` 
                You can supply either ``5.7`` or ``8.0`` to use the default engine version for Aurora MySQL version 2 or version 3, respectively.
                To list all of the available engine versions for Aurora PostgreSQL, use the following command:
                 ``aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"`` 
                To list all of the available engine versions for RDS for MySQL, use the following command:
                 ``aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"`` 
                To list all of the available engine versions for RDS for PostgreSQL, use the following command:
                 ``aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"`` 
                 *Aurora MySQL* 
                For information, see [Database engine updates for Amazon Aurora MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html) in the *Amazon Aurora User Guide*.
                 *Aurora PostgreSQL* 
                For information, see [Amazon Aurora PostgreSQL releases and engine versions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html) in the *Amazon Aurora User Guide*.
                 *MySQL* 
                For information, see [Amazon RDS for MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt) in the *Amazon RDS User Guide*.
                 *PostgreSQL* 
                For information, see [Amazon RDS for PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts) in the *Amazon RDS User Guide*.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] global_cluster_identifier: If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster. To define the primary database cluster of the global cluster, use the [AWS::RDS::GlobalCluster](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html) resource. 
                 If you aren't configuring a global database cluster, don't specify this property. 
                 To remove the DB cluster from a global database cluster, specify an empty value for the ``GlobalClusterIdentifier`` property.
                 For information about Aurora global databases, see [Working with Amazon Aurora Global Databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) in the *Amazon Aurora User Guide*.
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.int] iops: The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
                For information about valid IOPS values, see [Provisioned IOPS storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
                This setting is required to create a Multi-AZ DB cluster.
                Valid for Cluster Type: Multi-AZ DB clusters only
                Constraints:
                 +  Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
        :param pulumi.Input[builtins.str] kms_key_id: The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as ``arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef``. If you enable the ``StorageEncrypted`` property but don't specify this property, the default KMS key is used. If you specify this property, you must set the ``StorageEncrypted`` property to ``true``.
                If you specify the ``SnapshotIdentifier`` property, the ``StorageEncrypted`` property value is inherited from the snapshot, and if the DB cluster is encrypted, the specified ``KmsKeyId`` property is used.
                If you create a read replica of an encrypted DB cluster in another AWS Region, make sure to set ``KmsKeyId`` to a KMS key identifier that is valid in the destination AWS Region. This KMS key is used to encrypt the read replica in that AWS Region.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.bool] manage_master_user_password: Specifies whether to manage the master user password with AWS Secrets Manager.
                For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
                Constraints:
                 +  Can't manage the master user password with AWS Secrets Manager if ``MasterUserPassword`` is specified.
        :param pulumi.Input[builtins.str] master_user_password: The master password for the DB instance.
                 If you specify the ``SourceDBClusterIdentifier``, ``SnapshotIdentifier``, or ``GlobalClusterIdentifier`` property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
                 Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input['DbClusterMasterUserSecretArgs'] master_user_secret: The secret managed by RDS in AWS Secrets Manager for the master user password.
                 When you restore a DB cluster from a snapshot, Amazon RDS generates a new secret instead of reusing the secret specified in the ``SecretArn`` property. This ensures that the restored DB cluster is securely managed with a dedicated secret. To maintain consistent integration with your application, you might need to update resource configurations to reference the newly created secret.
                 For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
        :param pulumi.Input[builtins.str] master_username: The name of the master user for the DB cluster.
                 If you specify the ``SourceDBClusterIdentifier``, ``SnapshotIdentifier``, or ``GlobalClusterIdentifier`` property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
                 Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.int] monitoring_interval: The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify ``0``.
                If ``MonitoringRoleArn`` is specified, also set ``MonitoringInterval`` to a value other than ``0``.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
                Valid Values: ``0 | 1 | 5 | 10 | 15 | 30 | 60``
                Default: ``0``
        :param pulumi.Input[builtins.str] monitoring_role_arn: The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is ``arn:aws:iam:123456789012:role/emaccess``. For information on creating a monitoring role, see [Setting up and enabling Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling) in the *Amazon RDS User Guide*.
                If ``MonitoringInterval`` is set to a value other than ``0``, supply a ``MonitoringRoleArn`` value.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] network_type: The network type of the DB cluster.
                Valid values:
                 +   ``IPV4`` 
                 +   ``DUAL`` 
                 
                The network type is determined by the ``DBSubnetGroup`` specified for the DB cluster. A ``DBSubnetGroup`` can support only the IPv4 protocol or the IPv4 and IPv6 protocols (``DUAL``).
                For more information, see [Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon Aurora User Guide.*
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.bool] performance_insights_enabled: Specifies whether to turn on Performance Insights for the DB cluster.
                For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] performance_insights_kms_key_id: The AWS KMS key identifier for encryption of Performance Insights data.
                The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
                If you don't specify a value for ``PerformanceInsightsKMSKeyId``, then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS-account. Your AWS-account has a different default KMS key for each AWS-Region.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.int] performance_insights_retention_period: The number of days to retain Performance Insights data. When creating a DB cluster without enabling Performance Insights, you can't specify the parameter ``PerformanceInsightsRetentionPeriod``.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
                Valid Values:
                 +   ``7`` 
                 +  *month* * 31, where *month* is a number of months from 1-23. Examples: ``93`` (3 months * 31), ``341`` (11 months * 31), ``589`` (19 months * 31)
                 +   ``731`` 
                 
                Default: ``7`` days
                If you specify a retention period that isn't valid, such as ``94``, Amazon RDS issues an error.
        :param pulumi.Input[builtins.int] port: The port number on which the DB instances in the DB cluster accept connections.
                Default:
                 +  When ``EngineMode`` is ``provisioned``, ``3306`` (for both Aurora MySQL and Aurora PostgreSQL)
                 +  When ``EngineMode`` is ``serverless``:
                 +  ``3306`` when ``Engine`` is ``aurora`` or ``aurora-mysql``
                 +  ``5432`` when ``Engine`` is ``aurora-postgresql``
                 
                 
                 The ``No interruption`` on update behavior only applies to DB clusters. If you are updating a DB instance, see [Port](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port) for the AWS::RDS::DBInstance resource.
                 Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] preferred_backup_window: The daily time range during which automated backups are created. For more information, see [Backup Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow) in the *Amazon Aurora User Guide.*
                Constraints:
                 +  Must be in the format ``hh24:mi-hh24:mi``.
                 +  Must be in Universal Coordinated Time (UTC).
                 +  Must not conflict with the preferred maintenance window.
                 +  Must be at least 30 minutes.
                 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] preferred_maintenance_window: The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
                Format: ``ddd:hh24:mi-ddd:hh24:mi``
                The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see [Maintaining an Amazon Aurora DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora) in the *Amazon Aurora User Guide.*
                Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
                Constraints: Minimum 30-minute window.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.bool] publicly_accessible: Specifies whether the DB cluster is publicly accessible.
                When the DB cluster is publicly accessible and you connect from outside of the DB cluster's virtual private cloud (VPC), its Domain Name System (DNS) endpoint resolves to the public IP address. When you connect from within the same VPC as the DB cluster, the endpoint resolves to the private IP address. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
                When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
                Valid for Cluster Type: Multi-AZ DB clusters only
                Default: The default behavior varies depending on whether ``DBSubnetGroupName`` is specified.
                If ``DBSubnetGroupName`` isn't specified, and ``PubliclyAccessible`` isn't specified, the following applies:
                 +  If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
                 +  If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
                 
                If ``DBSubnetGroupName`` is specified, and ``PubliclyAccessible`` isn't specified, the following applies:
                 +  If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
                 +  If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
        :param pulumi.Input[builtins.str] replication_source_identifier: The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.str] restore_to_time: The date and time to restore the DB cluster to.
                Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
                Constraints:
                 +  Must be before the latest restorable time for the DB instance
                 +  Must be specified if ``UseLatestRestorableTime`` parameter isn't provided
                 +  Can't be specified if the ``UseLatestRestorableTime`` parameter is enabled
                 +  Can't be specified if the ``RestoreType`` parameter is ``copy-on-write``
                 
                This property must be used with ``SourceDBClusterIdentifier`` property. The resulting cluster will have the identifier that matches the value of the ``DBclusterIdentifier`` property.
                Example: ``2015-03-07T23:45:00Z``
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] restore_type: The type of restore to be performed. You can specify one of the following values:
                 +  ``full-copy`` - The new DB cluster is restored as a full copy of the source DB cluster.
                 +  ``copy-on-write`` - The new DB cluster is restored as a clone of the source DB cluster.
                 
                If you don't specify a ``RestoreType`` value, then the new DB cluster is restored as a full copy of the source DB cluster.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input['DbClusterScalingConfigurationArgs'] scaling_configuration: The scaling configuration of an Aurora Serverless v1 DB cluster.
                This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, Use the ``ServerlessV2ScalingConfiguration`` property.
                Valid for: Aurora Serverless v1 DB clusters only
        :param pulumi.Input['DbClusterServerlessV2ScalingConfigurationArgs'] serverless_v2_scaling_configuration: The scaling configuration of an Aurora Serverless V2 DB cluster. 
                This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, Use the ``ScalingConfiguration`` property.
                Valid for: Aurora Serverless v2 DB clusters only
        :param pulumi.Input[builtins.str] snapshot_identifier: The identifier for the DB snapshot or DB cluster snapshot to restore from.
                You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
                After you restore a DB cluster with a ``SnapshotIdentifier`` property, you must specify the same ``SnapshotIdentifier`` property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the ``SnapshotIdentifier`` property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified ``SnapshotIdentifier`` property, and the original DB cluster is deleted.
                If you specify the ``SnapshotIdentifier`` property to restore a DB cluster (as opposed to specifying it for DB cluster updates), then don't specify the following properties:
                 +   ``GlobalClusterIdentifier`` 
                 +   ``MasterUsername`` 
                 +   ``MasterUserPassword`` 
                 +   ``ReplicationSourceIdentifier`` 
                 +   ``RestoreType`` 
                 +   ``SourceDBClusterIdentifier`` 
                 +   ``SourceRegion`` 
                 +  ``StorageEncrypted`` (for an encrypted snapshot)
                 +   ``UseLatestRestorableTime`` 
                 
                Constraints:
                 +  Must match the identifier of an existing Snapshot.
                 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] source_db_cluster_identifier: When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore.
                Constraints:
                 +  Must match the identifier of an existing DBCluster.
                 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] source_region: The AWS Region which contains the source DB cluster when replicating a DB cluster. For example, ``us-east-1``. 
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.bool] storage_encrypted: Indicates whether the DB cluster is encrypted.
                If you specify the ``KmsKeyId`` property, then you must enable encryption.
                If you specify the ``SourceDBClusterIdentifier`` property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified ``KmsKeyId`` property is used.
                If you specify the ``SnapshotIdentifier`` and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified ``KmsKeyId`` property is used.
                If you specify the ``SnapshotIdentifier`` and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the ``KmsKeyId`` property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to ``false``.
                 If you specify both the ``StorageEncrypted`` and ``SnapshotIdentifier`` properties without specifying the ``KmsKeyId`` property, then the restored DB cluster inherits the encryption settings from the DB snapshot that provide.
                 Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] storage_type: The storage type to associate with the DB cluster.
                For information on storage types for Aurora DB clusters, see [Storage configurations for Amazon Aurora DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type). For information on storage types for Multi-AZ DB clusters, see [Settings for creating Multi-AZ DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings).
                This setting is required to create a Multi-AZ DB cluster.
                When specified for a Multi-AZ DB cluster, a value for the ``Iops`` parameter is required.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
                Valid Values:
                 +  Aurora DB clusters - ``aurora | aurora-iopt1``
                 +  Multi-AZ DB clusters - ``io1 | io2 | gp3``
                 
                Default:
                 +  Aurora DB clusters - ``aurora``
                 +  Multi-AZ DB clusters - ``io1``
                 
                 When you create an Aurora DB cluster with the storage type set to ``aurora-iopt1``, the storage type is returned in the response. The storage type isn't returned when you set it to ``aurora``.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Tags to assign to the DB cluster.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.bool] use_latest_restorable_time: A value that indicates whether to restore the DB cluster to the latest restorable backup time. By default, the DB cluster is not restored to the latest restorable backup time. 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_security_group_ids: A list of EC2 VPC security groups to associate with this DB cluster.
                If you plan to update the resource, don't specify VPC security groups in a shared VPC.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        if allocated_storage is not None:
            pulumi.set(__self__, "allocated_storage", allocated_storage)
        if associated_roles is not None:
            pulumi.set(__self__, "associated_roles", associated_roles)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if backtrack_window is not None:
            pulumi.set(__self__, "backtrack_window", backtrack_window)
        if backup_retention_period is not None:
            pulumi.set(__self__, "backup_retention_period", backup_retention_period)
        if cluster_scalability_type is not None:
            pulumi.set(__self__, "cluster_scalability_type", cluster_scalability_type)
        if copy_tags_to_snapshot is not None:
            pulumi.set(__self__, "copy_tags_to_snapshot", copy_tags_to_snapshot)
        if database_insights_mode is not None:
            pulumi.set(__self__, "database_insights_mode", database_insights_mode)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if db_cluster_identifier is not None:
            pulumi.set(__self__, "db_cluster_identifier", db_cluster_identifier)
        if db_cluster_instance_class is not None:
            pulumi.set(__self__, "db_cluster_instance_class", db_cluster_instance_class)
        if db_cluster_parameter_group_name is not None:
            pulumi.set(__self__, "db_cluster_parameter_group_name", db_cluster_parameter_group_name)
        if db_instance_parameter_group_name is not None:
            pulumi.set(__self__, "db_instance_parameter_group_name", db_instance_parameter_group_name)
        if db_subnet_group_name is not None:
            pulumi.set(__self__, "db_subnet_group_name", db_subnet_group_name)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_iam_role_name is not None:
            pulumi.set(__self__, "domain_iam_role_name", domain_iam_role_name)
        if enable_cloudwatch_logs_exports is not None:
            pulumi.set(__self__, "enable_cloudwatch_logs_exports", enable_cloudwatch_logs_exports)
        if enable_global_write_forwarding is not None:
            pulumi.set(__self__, "enable_global_write_forwarding", enable_global_write_forwarding)
        if enable_http_endpoint is not None:
            pulumi.set(__self__, "enable_http_endpoint", enable_http_endpoint)
        if enable_iam_database_authentication is not None:
            pulumi.set(__self__, "enable_iam_database_authentication", enable_iam_database_authentication)
        if enable_local_write_forwarding is not None:
            pulumi.set(__self__, "enable_local_write_forwarding", enable_local_write_forwarding)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_lifecycle_support is not None:
            pulumi.set(__self__, "engine_lifecycle_support", engine_lifecycle_support)
        if engine_mode is not None:
            pulumi.set(__self__, "engine_mode", engine_mode)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if global_cluster_identifier is not None:
            pulumi.set(__self__, "global_cluster_identifier", global_cluster_identifier)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if manage_master_user_password is not None:
            pulumi.set(__self__, "manage_master_user_password", manage_master_user_password)
        if master_user_password is not None:
            pulumi.set(__self__, "master_user_password", master_user_password)
        if master_user_secret is not None:
            pulumi.set(__self__, "master_user_secret", master_user_secret)
        if master_username is not None:
            pulumi.set(__self__, "master_username", master_username)
        if monitoring_interval is not None:
            pulumi.set(__self__, "monitoring_interval", monitoring_interval)
        if monitoring_role_arn is not None:
            pulumi.set(__self__, "monitoring_role_arn", monitoring_role_arn)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if performance_insights_enabled is not None:
            pulumi.set(__self__, "performance_insights_enabled", performance_insights_enabled)
        if performance_insights_kms_key_id is not None:
            pulumi.set(__self__, "performance_insights_kms_key_id", performance_insights_kms_key_id)
        if performance_insights_retention_period is not None:
            pulumi.set(__self__, "performance_insights_retention_period", performance_insights_retention_period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_backup_window is not None:
            pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if replication_source_identifier is not None:
            pulumi.set(__self__, "replication_source_identifier", replication_source_identifier)
        if restore_to_time is not None:
            pulumi.set(__self__, "restore_to_time", restore_to_time)
        if restore_type is not None:
            pulumi.set(__self__, "restore_type", restore_type)
        if scaling_configuration is not None:
            pulumi.set(__self__, "scaling_configuration", scaling_configuration)
        if serverless_v2_scaling_configuration is not None:
            pulumi.set(__self__, "serverless_v2_scaling_configuration", serverless_v2_scaling_configuration)
        if snapshot_identifier is not None:
            pulumi.set(__self__, "snapshot_identifier", snapshot_identifier)
        if source_db_cluster_identifier is not None:
            pulumi.set(__self__, "source_db_cluster_identifier", source_db_cluster_identifier)
        if source_region is not None:
            pulumi.set(__self__, "source_region", source_region)
        if storage_encrypted is not None:
            pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_latest_restorable_time is not None:
            pulumi.set(__self__, "use_latest_restorable_time", use_latest_restorable_time)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
         Valid for Cluster Type: Multi-AZ DB clusters only
         This setting is required to create a Multi-AZ DB cluster.
        """
        return pulumi.get(self, "allocated_storage")

    @allocated_storage.setter
    def allocated_storage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "allocated_storage", value)

    @property
    @pulumi.getter(name="associatedRoles")
    def associated_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterRoleArgs']]]]:
        """
        Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "associated_roles")

    @associated_roles.setter
    def associated_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbClusterDbClusterRoleArgs']]]]):
        pulumi.set(self, "associated_roles", value)

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB cluster.
         For more information about automatic minor version upgrades, see [Automatically upgrading the minor engine version](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades).
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of Availability Zones (AZs) where instances in the DB cluster can be created. For information on AWS Regions and Availability Zones, see [Choosing the Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html) in the *Amazon Aurora User Guide*. 
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="backtrackWindow")
    def backtrack_window(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The target backtrack window, in seconds. To disable backtracking, set this value to ``0``.
         Valid for Cluster Type: Aurora MySQL DB clusters only
         Default: ``0``
         Constraints:
          +  If specified, this value must be set to a number from 0 to 259,200 (72 hours).
        """
        return pulumi.get(self, "backtrack_window")

    @backtrack_window.setter
    def backtrack_window(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backtrack_window", value)

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days for which automated backups are retained.
         Default: 1
         Constraints:
          +  Must be a value from 1 to 35
          
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "backup_retention_period")

    @backup_retention_period.setter
    def backup_retention_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backup_retention_period", value)

    @property
    @pulumi.getter(name="clusterScalabilityType")
    def cluster_scalability_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the scalability mode of the Aurora DB cluster. When set to ``limitless``, the cluster operates as an Aurora Limitless Database, allowing you to create a DB shard group for horizontal scaling (sharding) capabilities. When set to ``standard`` (the default), the cluster uses normal DB instance creation.
        """
        return pulumi.get(self, "cluster_scalability_type")

    @cluster_scalability_type.setter
    def cluster_scalability_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_scalability_type", value)

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @copy_tags_to_snapshot.setter
    def copy_tags_to_snapshot(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "copy_tags_to_snapshot", value)

    @property
    @pulumi.getter(name="databaseInsightsMode")
    def database_insights_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mode of Database Insights to enable for the DB cluster.
         If you set this value to ``advanced``, you must also set the ``PerformanceInsightsEnabled`` parameter to ``true`` and the ``PerformanceInsightsRetentionPeriod`` parameter to 465.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "database_insights_mode")

    @database_insights_mode.setter
    def database_insights_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_insights_mode", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of your database. If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see [Naming Constraints](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html#RDS_Limits.Constraints) in the *Amazon Aurora User Guide*. 
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DB cluster identifier. This parameter is stored as a lowercase string.
         Constraints:
          +  Must contain from 1 to 63 letters, numbers, or hyphens.
          +  First character must be a letter.
          +  Can't end with a hyphen or contain two consecutive hyphens.
          
         Example: ``my-cluster1``
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "db_cluster_identifier")

    @db_cluster_identifier.setter
    def db_cluster_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_cluster_identifier", value)

    @property
    @pulumi.getter(name="dbClusterInstanceClass")
    def db_cluster_instance_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example ``db.m6gd.xlarge``. Not all DB instance classes are available in all AWS-Regions, or for all database engines.
         For the full list of DB instance classes and availability for your engine, see [DB instance class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide*.
         This setting is required to create a Multi-AZ DB cluster.
         Valid for Cluster Type: Multi-AZ DB clusters only
        """
        return pulumi.get(self, "db_cluster_instance_class")

    @db_cluster_instance_class.setter
    def db_cluster_instance_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_cluster_instance_class", value)

    @property
    @pulumi.getter(name="dbClusterParameterGroupName")
    def db_cluster_parameter_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the DB cluster parameter group to associate with this DB cluster.
          If you apply a parameter group to an existing DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
         If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
          To list all of the available DB cluster parameter group names, use the following command:
          ``aws rds describe-db-cluster-parameter-groups --query "DBClusterParameterGroups[].DBClusterParameterGroupName" --output text`` 
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "db_cluster_parameter_group_name")

    @db_cluster_parameter_group_name.setter
    def db_cluster_parameter_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_cluster_parameter_group_name", value)

    @property
    @pulumi.getter(name="dbInstanceParameterGroupName")
    def db_instance_parameter_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the DB parameter group to apply to all instances of the DB cluster.
          When you apply a parameter group using the ``DBInstanceParameterGroupName`` parameter, the DB cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the next maintenance window.
          Valid for Cluster Type: Aurora DB clusters only
         Default: The existing name setting
         Constraints:
          +  The DB parameter group must be in the same DB parameter group family as this DB cluster.
          +  The ``DBInstanceParameterGroupName`` parameter is valid in combination with the ``AllowMajorVersionUpgrade`` parameter for a major version upgrade only.
        """
        return pulumi.get(self, "db_instance_parameter_group_name")

    @db_instance_parameter_group_name.setter
    def db_instance_parameter_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_instance_parameter_group_name", value)

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A DB subnet group that you want to associate with this DB cluster. 
         If you are restoring a DB cluster to a point in time with ``RestoreType`` set to ``copy-on-write``, and don't specify a DB subnet group name, then the DB cluster is restored with a default DB subnet group.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "db_subnet_group_name")

    @db_subnet_group_name.setter
    def db_subnet_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_subnet_group_name", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates the directory ID of the Active Directory to create the DB cluster.
         For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.
         For more information, see [Kerberos authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html) in the *Amazon Aurora User Guide*.
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="domainIamRoleName")
    def domain_iam_role_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the IAM role to use when making API calls to the Directory Service.
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "domain_iam_role_name")

    @domain_iam_role_name.setter
    def domain_iam_role_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_iam_role_name", value)

    @property
    @pulumi.getter(name="enableCloudwatchLogsExports")
    def enable_cloudwatch_logs_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Aurora User Guide*.
          *Aurora MySQL* 
         Valid values: ``audit``, ``error``, ``general``, ``slowquery``
          *Aurora PostgreSQL* 
         Valid values: ``postgresql``
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "enable_cloudwatch_logs_exports")

    @enable_cloudwatch_logs_exports.setter
    def enable_cloudwatch_logs_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "enable_cloudwatch_logs_exports", value)

    @property
    @pulumi.getter(name="enableGlobalWriteForwarding")
    def enable_global_write_forwarding(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global cluster (Aurora global database). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.
         You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by a global cluster API operation, but it does nothing until then.
         Valid for Cluster Type: Aurora DB clusters only
        """
        return pulumi.get(self, "enable_global_write_forwarding")

    @enable_global_write_forwarding.setter
    def enable_global_write_forwarding(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_global_write_forwarding", value)

    @property
    @pulumi.getter(name="enableHttpEndpoint")
    def enable_http_endpoint(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to enable the HTTP endpoint for the DB cluster. By default, the HTTP endpoint isn't enabled.
         When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the DB cluster. You can also query your database from inside the RDS console with the RDS query editor.
         For more information, see [Using RDS Data API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
         Valid for Cluster Type: Aurora DB clusters only
        """
        return pulumi.get(self, "enable_http_endpoint")

    @enable_http_endpoint.setter
    def enable_http_endpoint(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_http_endpoint", value)

    @property
    @pulumi.getter(name="enableIamDatabaseAuthentication")
    def enable_iam_database_authentication(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.
         For more information, see [IAM Database Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon Aurora User Guide.*
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "enable_iam_database_authentication")

    @enable_iam_database_authentication.setter
    def enable_iam_database_authentication(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_iam_database_authentication", value)

    @property
    @pulumi.getter(name="enableLocalWriteForwarding")
    def enable_local_write_forwarding(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster. By default, write operations aren't allowed on reader DB instances.
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "enable_local_write_forwarding")

    @enable_local_write_forwarding.setter
    def enable_local_write_forwarding(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_local_write_forwarding", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the database engine to be used for this DB cluster.
         Valid Values:
          +   ``aurora-mysql`` 
          +   ``aurora-postgresql`` 
          +   ``mysql`` 
          +   ``postgres`` 
          
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineLifecycleSupport")
    def engine_lifecycle_support(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The life cycle type for this DB cluster.
          By default, this value is set to ``open-source-rds-extended-support``, which enrolls your DB cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to ``open-source-rds-extended-support-disabled``. In this case, creating the DB cluster will fail if the DB major version is past its end of standard support date.
          You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB cluster past the end of standard support for that engine version. For more information, see the following sections:
          +  Amazon Aurora - [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html) in the *Amazon Aurora User Guide*
          +  Amazon RDS - [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html) in the *Amazon RDS User Guide*
          
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         Valid Values: ``open-source-rds-extended-support | open-source-rds-extended-support-disabled``
         Default: ``open-source-rds-extended-support``
        """
        return pulumi.get(self, "engine_lifecycle_support")

    @engine_lifecycle_support.setter
    def engine_lifecycle_support(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine_lifecycle_support", value)

    @property
    @pulumi.getter(name="engineMode")
    def engine_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DB engine mode of the DB cluster, either ``provisioned`` or ``serverless``.
         The ``serverless`` engine mode only applies for Aurora Serverless v1 DB clusters. Aurora Serverless v2 DB clusters use the ``provisioned`` engine mode.
         For information about limitations and requirements for Serverless DB clusters, see the following sections in the *Amazon Aurora User Guide*:
          +   [Limitations of Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations) 
          +   [Requirements for Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html) 
          
         Valid for Cluster Type: Aurora DB clusters only
        """
        return pulumi.get(self, "engine_mode")

    @engine_mode.setter
    def engine_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine_mode", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version number of the database engine to use.
         To list all of the available engine versions for Aurora MySQL version 2 (5.7-compatible) and version 3 (8.0-compatible), use the following command:
          ``aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`` 
         You can supply either ``5.7`` or ``8.0`` to use the default engine version for Aurora MySQL version 2 or version 3, respectively.
         To list all of the available engine versions for Aurora PostgreSQL, use the following command:
          ``aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"`` 
         To list all of the available engine versions for RDS for MySQL, use the following command:
          ``aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"`` 
         To list all of the available engine versions for RDS for PostgreSQL, use the following command:
          ``aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"`` 
          *Aurora MySQL* 
         For information, see [Database engine updates for Amazon Aurora MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html) in the *Amazon Aurora User Guide*.
          *Aurora PostgreSQL* 
         For information, see [Amazon Aurora PostgreSQL releases and engine versions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html) in the *Amazon Aurora User Guide*.
          *MySQL* 
         For information, see [Amazon RDS for MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt) in the *Amazon RDS User Guide*.
          *PostgreSQL* 
         For information, see [Amazon RDS for PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts) in the *Amazon RDS User Guide*.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="globalClusterIdentifier")
    def global_cluster_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster. To define the primary database cluster of the global cluster, use the [AWS::RDS::GlobalCluster](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html) resource. 
          If you aren't configuring a global database cluster, don't specify this property. 
          To remove the DB cluster from a global database cluster, specify an empty value for the ``GlobalClusterIdentifier`` property.
          For information about Aurora global databases, see [Working with Amazon Aurora Global Databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) in the *Amazon Aurora User Guide*.
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "global_cluster_identifier")

    @global_cluster_identifier.setter
    def global_cluster_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "global_cluster_identifier", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
         For information about valid IOPS values, see [Provisioned IOPS storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
         This setting is required to create a Multi-AZ DB cluster.
         Valid for Cluster Type: Multi-AZ DB clusters only
         Constraints:
          +  Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as ``arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef``. If you enable the ``StorageEncrypted`` property but don't specify this property, the default KMS key is used. If you specify this property, you must set the ``StorageEncrypted`` property to ``true``.
         If you specify the ``SnapshotIdentifier`` property, the ``StorageEncrypted`` property value is inherited from the snapshot, and if the DB cluster is encrypted, the specified ``KmsKeyId`` property is used.
         If you create a read replica of an encrypted DB cluster in another AWS Region, make sure to set ``KmsKeyId`` to a KMS key identifier that is valid in the destination AWS Region. This KMS key is used to encrypt the read replica in that AWS Region.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="manageMasterUserPassword")
    def manage_master_user_password(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to manage the master user password with AWS Secrets Manager.
         For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         Constraints:
          +  Can't manage the master user password with AWS Secrets Manager if ``MasterUserPassword`` is specified.
        """
        return pulumi.get(self, "manage_master_user_password")

    @manage_master_user_password.setter
    def manage_master_user_password(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "manage_master_user_password", value)

    @property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The master password for the DB instance.
          If you specify the ``SourceDBClusterIdentifier``, ``SnapshotIdentifier``, or ``GlobalClusterIdentifier`` property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
          Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "master_user_password")

    @master_user_password.setter
    def master_user_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_user_password", value)

    @property
    @pulumi.getter(name="masterUserSecret")
    def master_user_secret(self) -> Optional[pulumi.Input['DbClusterMasterUserSecretArgs']]:
        """
        The secret managed by RDS in AWS Secrets Manager for the master user password.
          When you restore a DB cluster from a snapshot, Amazon RDS generates a new secret instead of reusing the secret specified in the ``SecretArn`` property. This ensures that the restored DB cluster is securely managed with a dedicated secret. To maintain consistent integration with your application, you might need to update resource configurations to reference the newly created secret.
          For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
        """
        return pulumi.get(self, "master_user_secret")

    @master_user_secret.setter
    def master_user_secret(self, value: Optional[pulumi.Input['DbClusterMasterUserSecretArgs']]):
        pulumi.set(self, "master_user_secret", value)

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the master user for the DB cluster.
          If you specify the ``SourceDBClusterIdentifier``, ``SnapshotIdentifier``, or ``GlobalClusterIdentifier`` property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
          Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "master_username")

    @master_username.setter
    def master_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_username", value)

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify ``0``.
         If ``MonitoringRoleArn`` is specified, also set ``MonitoringInterval`` to a value other than ``0``.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         Valid Values: ``0 | 1 | 5 | 10 | 15 | 30 | 60``
         Default: ``0``
        """
        return pulumi.get(self, "monitoring_interval")

    @monitoring_interval.setter
    def monitoring_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "monitoring_interval", value)

    @property
    @pulumi.getter(name="monitoringRoleArn")
    def monitoring_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is ``arn:aws:iam:123456789012:role/emaccess``. For information on creating a monitoring role, see [Setting up and enabling Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling) in the *Amazon RDS User Guide*.
         If ``MonitoringInterval`` is set to a value other than ``0``, supply a ``MonitoringRoleArn`` value.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "monitoring_role_arn")

    @monitoring_role_arn.setter
    def monitoring_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "monitoring_role_arn", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network type of the DB cluster.
         Valid values:
          +   ``IPV4`` 
          +   ``DUAL`` 
          
         The network type is determined by the ``DBSubnetGroup`` specified for the DB cluster. A ``DBSubnetGroup`` can support only the IPv4 protocol or the IPv4 and IPv6 protocols (``DUAL``).
         For more information, see [Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon Aurora User Guide.*
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="performanceInsightsEnabled")
    def performance_insights_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to turn on Performance Insights for the DB cluster.
         For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "performance_insights_enabled")

    @performance_insights_enabled.setter
    def performance_insights_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "performance_insights_enabled", value)

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS KMS key identifier for encryption of Performance Insights data.
         The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         If you don't specify a value for ``PerformanceInsightsKMSKeyId``, then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS-account. Your AWS-account has a different default KMS key for each AWS-Region.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @performance_insights_kms_key_id.setter
    def performance_insights_kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "performance_insights_kms_key_id", value)

    @property
    @pulumi.getter(name="performanceInsightsRetentionPeriod")
    def performance_insights_retention_period(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days to retain Performance Insights data. When creating a DB cluster without enabling Performance Insights, you can't specify the parameter ``PerformanceInsightsRetentionPeriod``.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         Valid Values:
          +   ``7`` 
          +  *month* * 31, where *month* is a number of months from 1-23. Examples: ``93`` (3 months * 31), ``341`` (11 months * 31), ``589`` (19 months * 31)
          +   ``731`` 
          
         Default: ``7`` days
         If you specify a retention period that isn't valid, such as ``94``, Amazon RDS issues an error.
        """
        return pulumi.get(self, "performance_insights_retention_period")

    @performance_insights_retention_period.setter
    def performance_insights_retention_period(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "performance_insights_retention_period", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port number on which the DB instances in the DB cluster accept connections.
         Default:
          +  When ``EngineMode`` is ``provisioned``, ``3306`` (for both Aurora MySQL and Aurora PostgreSQL)
          +  When ``EngineMode`` is ``serverless``:
          +  ``3306`` when ``Engine`` is ``aurora`` or ``aurora-mysql``
          +  ``5432`` when ``Engine`` is ``aurora-postgresql``
          
          
          The ``No interruption`` on update behavior only applies to DB clusters. If you are updating a DB instance, see [Port](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port) for the AWS::RDS::DBInstance resource.
          Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The daily time range during which automated backups are created. For more information, see [Backup Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow) in the *Amazon Aurora User Guide.*
         Constraints:
          +  Must be in the format ``hh24:mi-hh24:mi``.
          +  Must be in Universal Coordinated Time (UTC).
          +  Must not conflict with the preferred maintenance window.
          +  Must be at least 30 minutes.
          
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "preferred_backup_window")

    @preferred_backup_window.setter
    def preferred_backup_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_backup_window", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         Format: ``ddd:hh24:mi-ddd:hh24:mi``
         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see [Maintaining an Amazon Aurora DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora) in the *Amazon Aurora User Guide.*
         Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         Constraints: Minimum 30-minute window.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the DB cluster is publicly accessible.
         When the DB cluster is publicly accessible and you connect from outside of the DB cluster's virtual private cloud (VPC), its Domain Name System (DNS) endpoint resolves to the public IP address. When you connect from within the same VPC as the DB cluster, the endpoint resolves to the private IP address. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
         When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
         Valid for Cluster Type: Multi-AZ DB clusters only
         Default: The default behavior varies depending on whether ``DBSubnetGroupName`` is specified.
         If ``DBSubnetGroupName`` isn't specified, and ``PubliclyAccessible`` isn't specified, the following applies:
          +  If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
          +  If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
          
         If ``DBSubnetGroupName`` is specified, and ``PubliclyAccessible`` isn't specified, the following applies:
          +  If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
          +  If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="replicationSourceIdentifier")
    def replication_source_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "replication_source_identifier")

    @replication_source_identifier.setter
    def replication_source_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_source_identifier", value)

    @property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time to restore the DB cluster to.
         Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
         Constraints:
          +  Must be before the latest restorable time for the DB instance
          +  Must be specified if ``UseLatestRestorableTime`` parameter isn't provided
          +  Can't be specified if the ``UseLatestRestorableTime`` parameter is enabled
          +  Can't be specified if the ``RestoreType`` parameter is ``copy-on-write``
          
         This property must be used with ``SourceDBClusterIdentifier`` property. The resulting cluster will have the identifier that matches the value of the ``DBclusterIdentifier`` property.
         Example: ``2015-03-07T23:45:00Z``
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "restore_to_time")

    @restore_to_time.setter
    def restore_to_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "restore_to_time", value)

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of restore to be performed. You can specify one of the following values:
          +  ``full-copy`` - The new DB cluster is restored as a full copy of the source DB cluster.
          +  ``copy-on-write`` - The new DB cluster is restored as a clone of the source DB cluster.
          
         If you don't specify a ``RestoreType`` value, then the new DB cluster is restored as a full copy of the source DB cluster.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "restore_type")

    @restore_type.setter
    def restore_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "restore_type", value)

    @property
    @pulumi.getter(name="scalingConfiguration")
    def scaling_configuration(self) -> Optional[pulumi.Input['DbClusterScalingConfigurationArgs']]:
        """
        The scaling configuration of an Aurora Serverless v1 DB cluster.
         This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, Use the ``ServerlessV2ScalingConfiguration`` property.
         Valid for: Aurora Serverless v1 DB clusters only
        """
        return pulumi.get(self, "scaling_configuration")

    @scaling_configuration.setter
    def scaling_configuration(self, value: Optional[pulumi.Input['DbClusterScalingConfigurationArgs']]):
        pulumi.set(self, "scaling_configuration", value)

    @property
    @pulumi.getter(name="serverlessV2ScalingConfiguration")
    def serverless_v2_scaling_configuration(self) -> Optional[pulumi.Input['DbClusterServerlessV2ScalingConfigurationArgs']]:
        """
        The scaling configuration of an Aurora Serverless V2 DB cluster. 
         This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, Use the ``ScalingConfiguration`` property.
         Valid for: Aurora Serverless v2 DB clusters only
        """
        return pulumi.get(self, "serverless_v2_scaling_configuration")

    @serverless_v2_scaling_configuration.setter
    def serverless_v2_scaling_configuration(self, value: Optional[pulumi.Input['DbClusterServerlessV2ScalingConfigurationArgs']]):
        pulumi.set(self, "serverless_v2_scaling_configuration", value)

    @property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier for the DB snapshot or DB cluster snapshot to restore from.
         You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
         After you restore a DB cluster with a ``SnapshotIdentifier`` property, you must specify the same ``SnapshotIdentifier`` property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the ``SnapshotIdentifier`` property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified ``SnapshotIdentifier`` property, and the original DB cluster is deleted.
         If you specify the ``SnapshotIdentifier`` property to restore a DB cluster (as opposed to specifying it for DB cluster updates), then don't specify the following properties:
          +   ``GlobalClusterIdentifier`` 
          +   ``MasterUsername`` 
          +   ``MasterUserPassword`` 
          +   ``ReplicationSourceIdentifier`` 
          +   ``RestoreType`` 
          +   ``SourceDBClusterIdentifier`` 
          +   ``SourceRegion`` 
          +  ``StorageEncrypted`` (for an encrypted snapshot)
          +   ``UseLatestRestorableTime`` 
          
         Constraints:
          +  Must match the identifier of an existing Snapshot.
          
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "snapshot_identifier")

    @snapshot_identifier.setter
    def snapshot_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_identifier", value)

    @property
    @pulumi.getter(name="sourceDbClusterIdentifier")
    def source_db_cluster_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore.
         Constraints:
          +  Must match the identifier of an existing DBCluster.
          
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "source_db_cluster_identifier")

    @source_db_cluster_identifier.setter
    def source_db_cluster_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_db_cluster_identifier", value)

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS Region which contains the source DB cluster when replicating a DB cluster. For example, ``us-east-1``. 
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "source_region")

    @source_region.setter
    def source_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_region", value)

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the DB cluster is encrypted.
         If you specify the ``KmsKeyId`` property, then you must enable encryption.
         If you specify the ``SourceDBClusterIdentifier`` property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified ``KmsKeyId`` property is used.
         If you specify the ``SnapshotIdentifier`` and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified ``KmsKeyId`` property is used.
         If you specify the ``SnapshotIdentifier`` and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the ``KmsKeyId`` property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to ``false``.
          If you specify both the ``StorageEncrypted`` and ``SnapshotIdentifier`` properties without specifying the ``KmsKeyId`` property, then the restored DB cluster inherits the encryption settings from the DB snapshot that provide.
          Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "storage_encrypted")

    @storage_encrypted.setter
    def storage_encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "storage_encrypted", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The storage type to associate with the DB cluster.
         For information on storage types for Aurora DB clusters, see [Storage configurations for Amazon Aurora DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type). For information on storage types for Multi-AZ DB clusters, see [Settings for creating Multi-AZ DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings).
         This setting is required to create a Multi-AZ DB cluster.
         When specified for a Multi-AZ DB cluster, a value for the ``Iops`` parameter is required.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         Valid Values:
          +  Aurora DB clusters - ``aurora | aurora-iopt1``
          +  Multi-AZ DB clusters - ``io1 | io2 | gp3``
          
         Default:
          +  Aurora DB clusters - ``aurora``
          +  Multi-AZ DB clusters - ``io1``
          
          When you create an Aurora DB cluster with the storage type set to ``aurora-iopt1``, the storage type is returned in the response. The storage type isn't returned when you set it to ``aurora``.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Tags to assign to the DB cluster.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A value that indicates whether to restore the DB cluster to the latest restorable backup time. By default, the DB cluster is not restored to the latest restorable backup time. 
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "use_latest_restorable_time")

    @use_latest_restorable_time.setter
    def use_latest_restorable_time(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_latest_restorable_time", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of EC2 VPC security groups to associate with this DB cluster.
         If you plan to update the resource, don't specify VPC security groups in a shared VPC.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


@pulumi.type_token("aws-native:rds:DbCluster")
class DbCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_storage: Optional[pulumi.Input[builtins.int]] = None,
                 associated_roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDbClusterRoleArgs', 'DbClusterDbClusterRoleArgsDict']]]]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 backtrack_window: Optional[pulumi.Input[builtins.int]] = None,
                 backup_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 cluster_scalability_type: Optional[pulumi.Input[builtins.str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[builtins.bool]] = None,
                 database_insights_mode: Optional[pulumi.Input[builtins.str]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_instance_class: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_instance_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 domain_iam_role_name: Optional[pulumi.Input[builtins.str]] = None,
                 enable_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enable_global_write_forwarding: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_http_endpoint: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_iam_database_authentication: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_local_write_forwarding: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_lifecycle_support: Optional[pulumi.Input[builtins.str]] = None,
                 engine_mode: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 global_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 iops: Optional[pulumi.Input[builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 manage_master_user_password: Optional[pulumi.Input[builtins.bool]] = None,
                 master_user_password: Optional[pulumi.Input[builtins.str]] = None,
                 master_user_secret: Optional[pulumi.Input[Union['DbClusterMasterUserSecretArgs', 'DbClusterMasterUserSecretArgsDict']]] = None,
                 master_username: Optional[pulumi.Input[builtins.str]] = None,
                 monitoring_interval: Optional[pulumi.Input[builtins.int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 network_type: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 replication_source_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 restore_to_time: Optional[pulumi.Input[builtins.str]] = None,
                 restore_type: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_configuration: Optional[pulumi.Input[Union['DbClusterScalingConfigurationArgs', 'DbClusterScalingConfigurationArgsDict']]] = None,
                 serverless_v2_scaling_configuration: Optional[pulumi.Input[Union['DbClusterServerlessV2ScalingConfigurationArgs', 'DbClusterServerlessV2ScalingConfigurationArgsDict']]] = None,
                 snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_region: Optional[pulumi.Input[builtins.str]] = None,
                 storage_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[builtins.bool]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        The ``AWS::RDS::DBCluster`` resource creates an Amazon Aurora DB cluster or Multi-AZ DB cluster.
         For more information about creating an Aurora DB cluster, see [Creating an Amazon Aurora DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html) in the *Amazon Aurora User Guide*.
         For more information about creating a Multi-AZ DB cluster, see [Creating a Multi-AZ DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html) in the *Amazon RDS User Guide*.
          You can only create this resource in AWS Regions where Amazon Aurora or Multi-AZ DB clusters are supported.
           *Updating DB clusters*
         When properties labeled "*Update requires:*[Replacement](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement)" are updated, AWS CloudFormation first creates a replacement DB cluster, then changes references from other dependent resources to point to the replacement DB cluster, and finally deletes the old DB cluster.
          We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB cluster. To preserve your data, perform the following procedure:
          1.  Deactivate any applications that are using the DB cluster so that there's no activity on the DB instance.
          2.  Create a snapshot of the DB cluster. For more information, see [Creating a DB cluster snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CreateSnapshotCluster.html).
          3.  If you want to restore your DB cluster using a DB cluster snapshot, modify the updated template with your DB cluster changes and add the ``SnapshotIdentifier`` property with the ID of the DB cluster snapshot that you want to use.
               After you restore a DB cluster with a ``SnapshotIdentifier`` property, you must specify the same ``SnapshotIdentifier`` property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the DB cluster snapshot again, and the data in the database is not changed. However, if you don't specify the ``SnapshotIdentifier`` property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified ``SnapshotIdentifier`` property, and the original DB cluster is deleted.
          4.  Update the stack.

          Currently, when you are updating the stack for an Aurora Serverless DB cluster, you can't include changes to any other properties when you specify one of the following properties: ``PreferredBackupWindow``, ``PreferredMaintenanceWindow``, and ``Port``. This limitation doesn't apply to provisioned DB clusters.
         For more information about updating other properties of this resource, see ``ModifyDBCluster``. For more information about updating stacks, see [CloudFormation Stacks Updates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
          *Deleting DB clusters*
         The default ``DeletionPolicy`` for ``AWS::RDS::DBCluster`` resources is ``Snapshot``. For more information about how AWS CloudFormation deletes resources, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] allocated_storage: The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
                Valid for Cluster Type: Multi-AZ DB clusters only
                This setting is required to create a Multi-AZ DB cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDbClusterRoleArgs', 'DbClusterDbClusterRoleArgsDict']]]] associated_roles: Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.bool] auto_minor_version_upgrade: Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB cluster.
                For more information about automatic minor version upgrades, see [Automatically upgrading the minor engine version](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] availability_zones: A list of Availability Zones (AZs) where instances in the DB cluster can be created. For information on AWS Regions and Availability Zones, see [Choosing the Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html) in the *Amazon Aurora User Guide*. 
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.int] backtrack_window: The target backtrack window, in seconds. To disable backtracking, set this value to ``0``.
                Valid for Cluster Type: Aurora MySQL DB clusters only
                Default: ``0``
                Constraints:
                 +  If specified, this value must be set to a number from 0 to 259,200 (72 hours).
        :param pulumi.Input[builtins.int] backup_retention_period: The number of days for which automated backups are retained.
                Default: 1
                Constraints:
                 +  Must be a value from 1 to 35
                 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] cluster_scalability_type: Specifies the scalability mode of the Aurora DB cluster. When set to ``limitless``, the cluster operates as an Aurora Limitless Database, allowing you to create a DB shard group for horizontal scaling (sharding) capabilities. When set to ``standard`` (the default), the cluster uses normal DB instance creation.
        :param pulumi.Input[builtins.bool] copy_tags_to_snapshot: A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] database_insights_mode: The mode of Database Insights to enable for the DB cluster.
                If you set this value to ``advanced``, you must also set the ``PerformanceInsightsEnabled`` parameter to ``true`` and the ``PerformanceInsightsRetentionPeriod`` parameter to 465.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] database_name: The name of your database. If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see [Naming Constraints](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html#RDS_Limits.Constraints) in the *Amazon Aurora User Guide*. 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] db_cluster_identifier: The DB cluster identifier. This parameter is stored as a lowercase string.
                Constraints:
                 +  Must contain from 1 to 63 letters, numbers, or hyphens.
                 +  First character must be a letter.
                 +  Can't end with a hyphen or contain two consecutive hyphens.
                 
                Example: ``my-cluster1``
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] db_cluster_instance_class: The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example ``db.m6gd.xlarge``. Not all DB instance classes are available in all AWS-Regions, or for all database engines.
                For the full list of DB instance classes and availability for your engine, see [DB instance class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide*.
                This setting is required to create a Multi-AZ DB cluster.
                Valid for Cluster Type: Multi-AZ DB clusters only
        :param pulumi.Input[builtins.str] db_cluster_parameter_group_name: The name of the DB cluster parameter group to associate with this DB cluster.
                 If you apply a parameter group to an existing DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
                If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
                 To list all of the available DB cluster parameter group names, use the following command:
                 ``aws rds describe-db-cluster-parameter-groups --query "DBClusterParameterGroups[].DBClusterParameterGroupName" --output text`` 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] db_instance_parameter_group_name: The name of the DB parameter group to apply to all instances of the DB cluster.
                 When you apply a parameter group using the ``DBInstanceParameterGroupName`` parameter, the DB cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the next maintenance window.
                 Valid for Cluster Type: Aurora DB clusters only
                Default: The existing name setting
                Constraints:
                 +  The DB parameter group must be in the same DB parameter group family as this DB cluster.
                 +  The ``DBInstanceParameterGroupName`` parameter is valid in combination with the ``AllowMajorVersionUpgrade`` parameter for a major version upgrade only.
        :param pulumi.Input[builtins.str] db_subnet_group_name: A DB subnet group that you want to associate with this DB cluster. 
                If you are restoring a DB cluster to a point in time with ``RestoreType`` set to ``copy-on-write``, and don't specify a DB subnet group name, then the DB cluster is restored with a default DB subnet group.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] db_system_id: Reserved for future use.
        :param pulumi.Input[builtins.bool] deletion_protection: A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] domain: Indicates the directory ID of the Active Directory to create the DB cluster.
                For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.
                For more information, see [Kerberos authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html) in the *Amazon Aurora User Guide*.
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.str] domain_iam_role_name: Specifies the name of the IAM role to use when making API calls to the Directory Service.
                Valid for: Aurora DB clusters only
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] enable_cloudwatch_logs_exports: The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Aurora User Guide*.
                 *Aurora MySQL* 
                Valid values: ``audit``, ``error``, ``general``, ``slowquery``
                 *Aurora PostgreSQL* 
                Valid values: ``postgresql``
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.bool] enable_global_write_forwarding: Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global cluster (Aurora global database). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.
                You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by a global cluster API operation, but it does nothing until then.
                Valid for Cluster Type: Aurora DB clusters only
        :param pulumi.Input[builtins.bool] enable_http_endpoint: Specifies whether to enable the HTTP endpoint for the DB cluster. By default, the HTTP endpoint isn't enabled.
                When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the DB cluster. You can also query your database from inside the RDS console with the RDS query editor.
                For more information, see [Using RDS Data API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
                Valid for Cluster Type: Aurora DB clusters only
        :param pulumi.Input[builtins.bool] enable_iam_database_authentication: A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.
                For more information, see [IAM Database Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon Aurora User Guide.*
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.bool] enable_local_write_forwarding: Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster. By default, write operations aren't allowed on reader DB instances.
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.str] engine: The name of the database engine to be used for this DB cluster.
                Valid Values:
                 +   ``aurora-mysql`` 
                 +   ``aurora-postgresql`` 
                 +   ``mysql`` 
                 +   ``postgres`` 
                 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] engine_lifecycle_support: The life cycle type for this DB cluster.
                 By default, this value is set to ``open-source-rds-extended-support``, which enrolls your DB cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to ``open-source-rds-extended-support-disabled``. In this case, creating the DB cluster will fail if the DB major version is past its end of standard support date.
                 You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB cluster past the end of standard support for that engine version. For more information, see the following sections:
                 +  Amazon Aurora - [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html) in the *Amazon Aurora User Guide*
                 +  Amazon RDS - [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html) in the *Amazon RDS User Guide*
                 
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
                Valid Values: ``open-source-rds-extended-support | open-source-rds-extended-support-disabled``
                Default: ``open-source-rds-extended-support``
        :param pulumi.Input[builtins.str] engine_mode: The DB engine mode of the DB cluster, either ``provisioned`` or ``serverless``.
                The ``serverless`` engine mode only applies for Aurora Serverless v1 DB clusters. Aurora Serverless v2 DB clusters use the ``provisioned`` engine mode.
                For information about limitations and requirements for Serverless DB clusters, see the following sections in the *Amazon Aurora User Guide*:
                 +   [Limitations of Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations) 
                 +   [Requirements for Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html) 
                 
                Valid for Cluster Type: Aurora DB clusters only
        :param pulumi.Input[builtins.str] engine_version: The version number of the database engine to use.
                To list all of the available engine versions for Aurora MySQL version 2 (5.7-compatible) and version 3 (8.0-compatible), use the following command:
                 ``aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`` 
                You can supply either ``5.7`` or ``8.0`` to use the default engine version for Aurora MySQL version 2 or version 3, respectively.
                To list all of the available engine versions for Aurora PostgreSQL, use the following command:
                 ``aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"`` 
                To list all of the available engine versions for RDS for MySQL, use the following command:
                 ``aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"`` 
                To list all of the available engine versions for RDS for PostgreSQL, use the following command:
                 ``aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"`` 
                 *Aurora MySQL* 
                For information, see [Database engine updates for Amazon Aurora MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html) in the *Amazon Aurora User Guide*.
                 *Aurora PostgreSQL* 
                For information, see [Amazon Aurora PostgreSQL releases and engine versions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html) in the *Amazon Aurora User Guide*.
                 *MySQL* 
                For information, see [Amazon RDS for MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt) in the *Amazon RDS User Guide*.
                 *PostgreSQL* 
                For information, see [Amazon RDS for PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts) in the *Amazon RDS User Guide*.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] global_cluster_identifier: If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster. To define the primary database cluster of the global cluster, use the [AWS::RDS::GlobalCluster](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html) resource. 
                 If you aren't configuring a global database cluster, don't specify this property. 
                 To remove the DB cluster from a global database cluster, specify an empty value for the ``GlobalClusterIdentifier`` property.
                 For information about Aurora global databases, see [Working with Amazon Aurora Global Databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) in the *Amazon Aurora User Guide*.
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.int] iops: The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
                For information about valid IOPS values, see [Provisioned IOPS storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
                This setting is required to create a Multi-AZ DB cluster.
                Valid for Cluster Type: Multi-AZ DB clusters only
                Constraints:
                 +  Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
        :param pulumi.Input[builtins.str] kms_key_id: The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as ``arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef``. If you enable the ``StorageEncrypted`` property but don't specify this property, the default KMS key is used. If you specify this property, you must set the ``StorageEncrypted`` property to ``true``.
                If you specify the ``SnapshotIdentifier`` property, the ``StorageEncrypted`` property value is inherited from the snapshot, and if the DB cluster is encrypted, the specified ``KmsKeyId`` property is used.
                If you create a read replica of an encrypted DB cluster in another AWS Region, make sure to set ``KmsKeyId`` to a KMS key identifier that is valid in the destination AWS Region. This KMS key is used to encrypt the read replica in that AWS Region.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.bool] manage_master_user_password: Specifies whether to manage the master user password with AWS Secrets Manager.
                For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
                Constraints:
                 +  Can't manage the master user password with AWS Secrets Manager if ``MasterUserPassword`` is specified.
        :param pulumi.Input[builtins.str] master_user_password: The master password for the DB instance.
                 If you specify the ``SourceDBClusterIdentifier``, ``SnapshotIdentifier``, or ``GlobalClusterIdentifier`` property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
                 Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[Union['DbClusterMasterUserSecretArgs', 'DbClusterMasterUserSecretArgsDict']] master_user_secret: The secret managed by RDS in AWS Secrets Manager for the master user password.
                 When you restore a DB cluster from a snapshot, Amazon RDS generates a new secret instead of reusing the secret specified in the ``SecretArn`` property. This ensures that the restored DB cluster is securely managed with a dedicated secret. To maintain consistent integration with your application, you might need to update resource configurations to reference the newly created secret.
                 For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
        :param pulumi.Input[builtins.str] master_username: The name of the master user for the DB cluster.
                 If you specify the ``SourceDBClusterIdentifier``, ``SnapshotIdentifier``, or ``GlobalClusterIdentifier`` property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
                 Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.int] monitoring_interval: The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify ``0``.
                If ``MonitoringRoleArn`` is specified, also set ``MonitoringInterval`` to a value other than ``0``.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
                Valid Values: ``0 | 1 | 5 | 10 | 15 | 30 | 60``
                Default: ``0``
        :param pulumi.Input[builtins.str] monitoring_role_arn: The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is ``arn:aws:iam:123456789012:role/emaccess``. For information on creating a monitoring role, see [Setting up and enabling Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling) in the *Amazon RDS User Guide*.
                If ``MonitoringInterval`` is set to a value other than ``0``, supply a ``MonitoringRoleArn`` value.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] network_type: The network type of the DB cluster.
                Valid values:
                 +   ``IPV4`` 
                 +   ``DUAL`` 
                 
                The network type is determined by the ``DBSubnetGroup`` specified for the DB cluster. A ``DBSubnetGroup`` can support only the IPv4 protocol or the IPv4 and IPv6 protocols (``DUAL``).
                For more information, see [Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon Aurora User Guide.*
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.bool] performance_insights_enabled: Specifies whether to turn on Performance Insights for the DB cluster.
                For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] performance_insights_kms_key_id: The AWS KMS key identifier for encryption of Performance Insights data.
                The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
                If you don't specify a value for ``PerformanceInsightsKMSKeyId``, then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS-account. Your AWS-account has a different default KMS key for each AWS-Region.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.int] performance_insights_retention_period: The number of days to retain Performance Insights data. When creating a DB cluster without enabling Performance Insights, you can't specify the parameter ``PerformanceInsightsRetentionPeriod``.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
                Valid Values:
                 +   ``7`` 
                 +  *month* * 31, where *month* is a number of months from 1-23. Examples: ``93`` (3 months * 31), ``341`` (11 months * 31), ``589`` (19 months * 31)
                 +   ``731`` 
                 
                Default: ``7`` days
                If you specify a retention period that isn't valid, such as ``94``, Amazon RDS issues an error.
        :param pulumi.Input[builtins.int] port: The port number on which the DB instances in the DB cluster accept connections.
                Default:
                 +  When ``EngineMode`` is ``provisioned``, ``3306`` (for both Aurora MySQL and Aurora PostgreSQL)
                 +  When ``EngineMode`` is ``serverless``:
                 +  ``3306`` when ``Engine`` is ``aurora`` or ``aurora-mysql``
                 +  ``5432`` when ``Engine`` is ``aurora-postgresql``
                 
                 
                 The ``No interruption`` on update behavior only applies to DB clusters. If you are updating a DB instance, see [Port](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port) for the AWS::RDS::DBInstance resource.
                 Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] preferred_backup_window: The daily time range during which automated backups are created. For more information, see [Backup Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow) in the *Amazon Aurora User Guide.*
                Constraints:
                 +  Must be in the format ``hh24:mi-hh24:mi``.
                 +  Must be in Universal Coordinated Time (UTC).
                 +  Must not conflict with the preferred maintenance window.
                 +  Must be at least 30 minutes.
                 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] preferred_maintenance_window: The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
                Format: ``ddd:hh24:mi-ddd:hh24:mi``
                The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see [Maintaining an Amazon Aurora DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora) in the *Amazon Aurora User Guide.*
                Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
                Constraints: Minimum 30-minute window.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.bool] publicly_accessible: Specifies whether the DB cluster is publicly accessible.
                When the DB cluster is publicly accessible and you connect from outside of the DB cluster's virtual private cloud (VPC), its Domain Name System (DNS) endpoint resolves to the public IP address. When you connect from within the same VPC as the DB cluster, the endpoint resolves to the private IP address. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
                When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
                Valid for Cluster Type: Multi-AZ DB clusters only
                Default: The default behavior varies depending on whether ``DBSubnetGroupName`` is specified.
                If ``DBSubnetGroupName`` isn't specified, and ``PubliclyAccessible`` isn't specified, the following applies:
                 +  If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
                 +  If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
                 
                If ``DBSubnetGroupName`` is specified, and ``PubliclyAccessible`` isn't specified, the following applies:
                 +  If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
                 +  If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
        :param pulumi.Input[builtins.str] replication_source_identifier: The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.str] restore_to_time: The date and time to restore the DB cluster to.
                Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
                Constraints:
                 +  Must be before the latest restorable time for the DB instance
                 +  Must be specified if ``UseLatestRestorableTime`` parameter isn't provided
                 +  Can't be specified if the ``UseLatestRestorableTime`` parameter is enabled
                 +  Can't be specified if the ``RestoreType`` parameter is ``copy-on-write``
                 
                This property must be used with ``SourceDBClusterIdentifier`` property. The resulting cluster will have the identifier that matches the value of the ``DBclusterIdentifier`` property.
                Example: ``2015-03-07T23:45:00Z``
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] restore_type: The type of restore to be performed. You can specify one of the following values:
                 +  ``full-copy`` - The new DB cluster is restored as a full copy of the source DB cluster.
                 +  ``copy-on-write`` - The new DB cluster is restored as a clone of the source DB cluster.
                 
                If you don't specify a ``RestoreType`` value, then the new DB cluster is restored as a full copy of the source DB cluster.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[Union['DbClusterScalingConfigurationArgs', 'DbClusterScalingConfigurationArgsDict']] scaling_configuration: The scaling configuration of an Aurora Serverless v1 DB cluster.
                This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, Use the ``ServerlessV2ScalingConfiguration`` property.
                Valid for: Aurora Serverless v1 DB clusters only
        :param pulumi.Input[Union['DbClusterServerlessV2ScalingConfigurationArgs', 'DbClusterServerlessV2ScalingConfigurationArgsDict']] serverless_v2_scaling_configuration: The scaling configuration of an Aurora Serverless V2 DB cluster. 
                This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, Use the ``ScalingConfiguration`` property.
                Valid for: Aurora Serverless v2 DB clusters only
        :param pulumi.Input[builtins.str] snapshot_identifier: The identifier for the DB snapshot or DB cluster snapshot to restore from.
                You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
                After you restore a DB cluster with a ``SnapshotIdentifier`` property, you must specify the same ``SnapshotIdentifier`` property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the ``SnapshotIdentifier`` property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified ``SnapshotIdentifier`` property, and the original DB cluster is deleted.
                If you specify the ``SnapshotIdentifier`` property to restore a DB cluster (as opposed to specifying it for DB cluster updates), then don't specify the following properties:
                 +   ``GlobalClusterIdentifier`` 
                 +   ``MasterUsername`` 
                 +   ``MasterUserPassword`` 
                 +   ``ReplicationSourceIdentifier`` 
                 +   ``RestoreType`` 
                 +   ``SourceDBClusterIdentifier`` 
                 +   ``SourceRegion`` 
                 +  ``StorageEncrypted`` (for an encrypted snapshot)
                 +   ``UseLatestRestorableTime`` 
                 
                Constraints:
                 +  Must match the identifier of an existing Snapshot.
                 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] source_db_cluster_identifier: When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore.
                Constraints:
                 +  Must match the identifier of an existing DBCluster.
                 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] source_region: The AWS Region which contains the source DB cluster when replicating a DB cluster. For example, ``us-east-1``. 
                Valid for: Aurora DB clusters only
        :param pulumi.Input[builtins.bool] storage_encrypted: Indicates whether the DB cluster is encrypted.
                If you specify the ``KmsKeyId`` property, then you must enable encryption.
                If you specify the ``SourceDBClusterIdentifier`` property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified ``KmsKeyId`` property is used.
                If you specify the ``SnapshotIdentifier`` and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified ``KmsKeyId`` property is used.
                If you specify the ``SnapshotIdentifier`` and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the ``KmsKeyId`` property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to ``false``.
                 If you specify both the ``StorageEncrypted`` and ``SnapshotIdentifier`` properties without specifying the ``KmsKeyId`` property, then the restored DB cluster inherits the encryption settings from the DB snapshot that provide.
                 Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.str] storage_type: The storage type to associate with the DB cluster.
                For information on storage types for Aurora DB clusters, see [Storage configurations for Amazon Aurora DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type). For information on storage types for Multi-AZ DB clusters, see [Settings for creating Multi-AZ DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings).
                This setting is required to create a Multi-AZ DB cluster.
                When specified for a Multi-AZ DB cluster, a value for the ``Iops`` parameter is required.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
                Valid Values:
                 +  Aurora DB clusters - ``aurora | aurora-iopt1``
                 +  Multi-AZ DB clusters - ``io1 | io2 | gp3``
                 
                Default:
                 +  Aurora DB clusters - ``aurora``
                 +  Multi-AZ DB clusters - ``io1``
                 
                 When you create an Aurora DB cluster with the storage type set to ``aurora-iopt1``, the storage type is returned in the response. The storage type isn't returned when you set it to ``aurora``.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Tags to assign to the DB cluster.
                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[builtins.bool] use_latest_restorable_time: A value that indicates whether to restore the DB cluster to the latest restorable backup time. By default, the DB cluster is not restored to the latest restorable backup time. 
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_security_group_ids: A list of EC2 VPC security groups to associate with this DB cluster.
                If you plan to update the resource, don't specify VPC security groups in a shared VPC.
                Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DbClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::RDS::DBCluster`` resource creates an Amazon Aurora DB cluster or Multi-AZ DB cluster.
         For more information about creating an Aurora DB cluster, see [Creating an Amazon Aurora DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html) in the *Amazon Aurora User Guide*.
         For more information about creating a Multi-AZ DB cluster, see [Creating a Multi-AZ DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html) in the *Amazon RDS User Guide*.
          You can only create this resource in AWS Regions where Amazon Aurora or Multi-AZ DB clusters are supported.
           *Updating DB clusters*
         When properties labeled "*Update requires:*[Replacement](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement)" are updated, AWS CloudFormation first creates a replacement DB cluster, then changes references from other dependent resources to point to the replacement DB cluster, and finally deletes the old DB cluster.
          We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB cluster. To preserve your data, perform the following procedure:
          1.  Deactivate any applications that are using the DB cluster so that there's no activity on the DB instance.
          2.  Create a snapshot of the DB cluster. For more information, see [Creating a DB cluster snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CreateSnapshotCluster.html).
          3.  If you want to restore your DB cluster using a DB cluster snapshot, modify the updated template with your DB cluster changes and add the ``SnapshotIdentifier`` property with the ID of the DB cluster snapshot that you want to use.
               After you restore a DB cluster with a ``SnapshotIdentifier`` property, you must specify the same ``SnapshotIdentifier`` property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the DB cluster snapshot again, and the data in the database is not changed. However, if you don't specify the ``SnapshotIdentifier`` property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified ``SnapshotIdentifier`` property, and the original DB cluster is deleted.
          4.  Update the stack.

          Currently, when you are updating the stack for an Aurora Serverless DB cluster, you can't include changes to any other properties when you specify one of the following properties: ``PreferredBackupWindow``, ``PreferredMaintenanceWindow``, and ``Port``. This limitation doesn't apply to provisioned DB clusters.
         For more information about updating other properties of this resource, see ``ModifyDBCluster``. For more information about updating stacks, see [CloudFormation Stacks Updates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
          *Deleting DB clusters*
         The default ``DeletionPolicy`` for ``AWS::RDS::DBCluster`` resources is ``Snapshot``. For more information about how AWS CloudFormation deletes resources, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html).

        :param str resource_name: The name of the resource.
        :param DbClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_storage: Optional[pulumi.Input[builtins.int]] = None,
                 associated_roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbClusterDbClusterRoleArgs', 'DbClusterDbClusterRoleArgsDict']]]]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 backtrack_window: Optional[pulumi.Input[builtins.int]] = None,
                 backup_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 cluster_scalability_type: Optional[pulumi.Input[builtins.str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[builtins.bool]] = None,
                 database_insights_mode: Optional[pulumi.Input[builtins.str]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_instance_class: Optional[pulumi.Input[builtins.str]] = None,
                 db_cluster_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_instance_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 domain_iam_role_name: Optional[pulumi.Input[builtins.str]] = None,
                 enable_cloudwatch_logs_exports: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enable_global_write_forwarding: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_http_endpoint: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_iam_database_authentication: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_local_write_forwarding: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_lifecycle_support: Optional[pulumi.Input[builtins.str]] = None,
                 engine_mode: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 global_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 iops: Optional[pulumi.Input[builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 manage_master_user_password: Optional[pulumi.Input[builtins.bool]] = None,
                 master_user_password: Optional[pulumi.Input[builtins.str]] = None,
                 master_user_secret: Optional[pulumi.Input[Union['DbClusterMasterUserSecretArgs', 'DbClusterMasterUserSecretArgsDict']]] = None,
                 master_username: Optional[pulumi.Input[builtins.str]] = None,
                 monitoring_interval: Optional[pulumi.Input[builtins.int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 network_type: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[builtins.int]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[builtins.str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[builtins.str]] = None,
                 publicly_accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 replication_source_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 restore_to_time: Optional[pulumi.Input[builtins.str]] = None,
                 restore_type: Optional[pulumi.Input[builtins.str]] = None,
                 scaling_configuration: Optional[pulumi.Input[Union['DbClusterScalingConfigurationArgs', 'DbClusterScalingConfigurationArgsDict']]] = None,
                 serverless_v2_scaling_configuration: Optional[pulumi.Input[Union['DbClusterServerlessV2ScalingConfigurationArgs', 'DbClusterServerlessV2ScalingConfigurationArgsDict']]] = None,
                 snapshot_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_db_cluster_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 source_region: Optional[pulumi.Input[builtins.str]] = None,
                 storage_encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 use_latest_restorable_time: Optional[pulumi.Input[builtins.bool]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbClusterArgs.__new__(DbClusterArgs)

            __props__.__dict__["allocated_storage"] = allocated_storage
            __props__.__dict__["associated_roles"] = associated_roles
            __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["backtrack_window"] = backtrack_window
            __props__.__dict__["backup_retention_period"] = backup_retention_period
            __props__.__dict__["cluster_scalability_type"] = cluster_scalability_type
            __props__.__dict__["copy_tags_to_snapshot"] = copy_tags_to_snapshot
            __props__.__dict__["database_insights_mode"] = database_insights_mode
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["db_cluster_identifier"] = db_cluster_identifier
            __props__.__dict__["db_cluster_instance_class"] = db_cluster_instance_class
            __props__.__dict__["db_cluster_parameter_group_name"] = db_cluster_parameter_group_name
            __props__.__dict__["db_instance_parameter_group_name"] = db_instance_parameter_group_name
            __props__.__dict__["db_subnet_group_name"] = db_subnet_group_name
            __props__.__dict__["db_system_id"] = db_system_id
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["domain"] = domain
            __props__.__dict__["domain_iam_role_name"] = domain_iam_role_name
            __props__.__dict__["enable_cloudwatch_logs_exports"] = enable_cloudwatch_logs_exports
            __props__.__dict__["enable_global_write_forwarding"] = enable_global_write_forwarding
            __props__.__dict__["enable_http_endpoint"] = enable_http_endpoint
            __props__.__dict__["enable_iam_database_authentication"] = enable_iam_database_authentication
            __props__.__dict__["enable_local_write_forwarding"] = enable_local_write_forwarding
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_lifecycle_support"] = engine_lifecycle_support
            __props__.__dict__["engine_mode"] = engine_mode
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["global_cluster_identifier"] = global_cluster_identifier
            __props__.__dict__["iops"] = iops
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["manage_master_user_password"] = manage_master_user_password
            __props__.__dict__["master_user_password"] = master_user_password
            __props__.__dict__["master_user_secret"] = master_user_secret
            __props__.__dict__["master_username"] = master_username
            __props__.__dict__["monitoring_interval"] = monitoring_interval
            __props__.__dict__["monitoring_role_arn"] = monitoring_role_arn
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["performance_insights_enabled"] = performance_insights_enabled
            __props__.__dict__["performance_insights_kms_key_id"] = performance_insights_kms_key_id
            __props__.__dict__["performance_insights_retention_period"] = performance_insights_retention_period
            __props__.__dict__["port"] = port
            __props__.__dict__["preferred_backup_window"] = preferred_backup_window
            __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            __props__.__dict__["replication_source_identifier"] = replication_source_identifier
            __props__.__dict__["restore_to_time"] = restore_to_time
            __props__.__dict__["restore_type"] = restore_type
            __props__.__dict__["scaling_configuration"] = scaling_configuration
            __props__.__dict__["serverless_v2_scaling_configuration"] = serverless_v2_scaling_configuration
            __props__.__dict__["snapshot_identifier"] = snapshot_identifier
            __props__.__dict__["source_db_cluster_identifier"] = source_db_cluster_identifier
            __props__.__dict__["source_region"] = source_region
            __props__.__dict__["storage_encrypted"] = storage_encrypted
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_latest_restorable_time"] = use_latest_restorable_time
            __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
            __props__.__dict__["db_cluster_arn"] = None
            __props__.__dict__["db_cluster_resource_id"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["read_endpoint"] = None
            __props__.__dict__["storage_throughput"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["availabilityZones[*]", "clusterScalabilityType", "databaseName", "dbClusterIdentifier", "dbSubnetGroupName", "dbSystemId", "engineMode", "kmsKeyId", "publiclyAccessible", "restoreToTime", "restoreType", "snapshotIdentifier", "sourceDbClusterIdentifier", "sourceRegion", "storageEncrypted", "useLatestRestorableTime"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DbCluster, __self__).__init__(
            'aws-native:rds:DbCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DbCluster':
        """
        Get an existing DbCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DbClusterArgs.__new__(DbClusterArgs)

        __props__.__dict__["allocated_storage"] = None
        __props__.__dict__["associated_roles"] = None
        __props__.__dict__["auto_minor_version_upgrade"] = None
        __props__.__dict__["availability_zones"] = None
        __props__.__dict__["backtrack_window"] = None
        __props__.__dict__["backup_retention_period"] = None
        __props__.__dict__["cluster_scalability_type"] = None
        __props__.__dict__["copy_tags_to_snapshot"] = None
        __props__.__dict__["database_insights_mode"] = None
        __props__.__dict__["database_name"] = None
        __props__.__dict__["db_cluster_arn"] = None
        __props__.__dict__["db_cluster_identifier"] = None
        __props__.__dict__["db_cluster_instance_class"] = None
        __props__.__dict__["db_cluster_parameter_group_name"] = None
        __props__.__dict__["db_cluster_resource_id"] = None
        __props__.__dict__["db_instance_parameter_group_name"] = None
        __props__.__dict__["db_subnet_group_name"] = None
        __props__.__dict__["db_system_id"] = None
        __props__.__dict__["deletion_protection"] = None
        __props__.__dict__["domain"] = None
        __props__.__dict__["domain_iam_role_name"] = None
        __props__.__dict__["enable_cloudwatch_logs_exports"] = None
        __props__.__dict__["enable_global_write_forwarding"] = None
        __props__.__dict__["enable_http_endpoint"] = None
        __props__.__dict__["enable_iam_database_authentication"] = None
        __props__.__dict__["enable_local_write_forwarding"] = None
        __props__.__dict__["endpoint"] = None
        __props__.__dict__["engine"] = None
        __props__.__dict__["engine_lifecycle_support"] = None
        __props__.__dict__["engine_mode"] = None
        __props__.__dict__["engine_version"] = None
        __props__.__dict__["global_cluster_identifier"] = None
        __props__.__dict__["iops"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["manage_master_user_password"] = None
        __props__.__dict__["master_user_password"] = None
        __props__.__dict__["master_user_secret"] = None
        __props__.__dict__["master_username"] = None
        __props__.__dict__["monitoring_interval"] = None
        __props__.__dict__["monitoring_role_arn"] = None
        __props__.__dict__["network_type"] = None
        __props__.__dict__["performance_insights_enabled"] = None
        __props__.__dict__["performance_insights_kms_key_id"] = None
        __props__.__dict__["performance_insights_retention_period"] = None
        __props__.__dict__["port"] = None
        __props__.__dict__["preferred_backup_window"] = None
        __props__.__dict__["preferred_maintenance_window"] = None
        __props__.__dict__["publicly_accessible"] = None
        __props__.__dict__["read_endpoint"] = None
        __props__.__dict__["replication_source_identifier"] = None
        __props__.__dict__["restore_to_time"] = None
        __props__.__dict__["restore_type"] = None
        __props__.__dict__["scaling_configuration"] = None
        __props__.__dict__["serverless_v2_scaling_configuration"] = None
        __props__.__dict__["snapshot_identifier"] = None
        __props__.__dict__["source_db_cluster_identifier"] = None
        __props__.__dict__["source_region"] = None
        __props__.__dict__["storage_encrypted"] = None
        __props__.__dict__["storage_throughput"] = None
        __props__.__dict__["storage_type"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["use_latest_restorable_time"] = None
        __props__.__dict__["vpc_security_group_ids"] = None
        return DbCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
         Valid for Cluster Type: Multi-AZ DB clusters only
         This setting is required to create a Multi-AZ DB cluster.
        """
        return pulumi.get(self, "allocated_storage")

    @property
    @pulumi.getter(name="associatedRoles")
    def associated_roles(self) -> pulumi.Output[Optional[Sequence['outputs.DbClusterDbClusterRole']]]:
        """
        Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "associated_roles")

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB cluster.
         For more information about automatic minor version upgrades, see [Automatically upgrading the minor engine version](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades).
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of Availability Zones (AZs) where instances in the DB cluster can be created. For information on AWS Regions and Availability Zones, see [Choosing the Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html) in the *Amazon Aurora User Guide*. 
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="backtrackWindow")
    def backtrack_window(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The target backtrack window, in seconds. To disable backtracking, set this value to ``0``.
         Valid for Cluster Type: Aurora MySQL DB clusters only
         Default: ``0``
         Constraints:
          +  If specified, this value must be set to a number from 0 to 259,200 (72 hours).
        """
        return pulumi.get(self, "backtrack_window")

    @property
    @pulumi.getter(name="backupRetentionPeriod")
    def backup_retention_period(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of days for which automated backups are retained.
         Default: 1
         Constraints:
          +  Must be a value from 1 to 35
          
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "backup_retention_period")

    @property
    @pulumi.getter(name="clusterScalabilityType")
    def cluster_scalability_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the scalability mode of the Aurora DB cluster. When set to ``limitless``, the cluster operates as an Aurora Limitless Database, allowing you to create a DB shard group for horizontal scaling (sharding) capabilities. When set to ``standard`` (the default), the cluster uses normal DB instance creation.
        """
        return pulumi.get(self, "cluster_scalability_type")

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @property
    @pulumi.getter(name="databaseInsightsMode")
    def database_insights_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The mode of Database Insights to enable for the DB cluster.
         If you set this value to ``advanced``, you must also set the ``PerformanceInsightsEnabled`` parameter to ``true`` and the ``PerformanceInsightsRetentionPeriod`` parameter to 465.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "database_insights_mode")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of your database. If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see [Naming Constraints](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html#RDS_Limits.Constraints) in the *Amazon Aurora User Guide*. 
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="dbClusterArn")
    def db_cluster_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the DB cluster.
        """
        return pulumi.get(self, "db_cluster_arn")

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The DB cluster identifier. This parameter is stored as a lowercase string.
         Constraints:
          +  Must contain from 1 to 63 letters, numbers, or hyphens.
          +  First character must be a letter.
          +  Can't end with a hyphen or contain two consecutive hyphens.
          
         Example: ``my-cluster1``
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "db_cluster_identifier")

    @property
    @pulumi.getter(name="dbClusterInstanceClass")
    def db_cluster_instance_class(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example ``db.m6gd.xlarge``. Not all DB instance classes are available in all AWS-Regions, or for all database engines.
         For the full list of DB instance classes and availability for your engine, see [DB instance class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide*.
         This setting is required to create a Multi-AZ DB cluster.
         Valid for Cluster Type: Multi-AZ DB clusters only
        """
        return pulumi.get(self, "db_cluster_instance_class")

    @property
    @pulumi.getter(name="dbClusterParameterGroupName")
    def db_cluster_parameter_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the DB cluster parameter group to associate with this DB cluster.
          If you apply a parameter group to an existing DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
         If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
          To list all of the available DB cluster parameter group names, use the following command:
          ``aws rds describe-db-cluster-parameter-groups --query "DBClusterParameterGroups[].DBClusterParameterGroupName" --output text`` 
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "db_cluster_parameter_group_name")

    @property
    @pulumi.getter(name="dbClusterResourceId")
    def db_cluster_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The AWS Region -unique, immutable identifier for the DB cluster. This identifier is found in AWS CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
        """
        return pulumi.get(self, "db_cluster_resource_id")

    @property
    @pulumi.getter(name="dbInstanceParameterGroupName")
    def db_instance_parameter_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the DB parameter group to apply to all instances of the DB cluster.
          When you apply a parameter group using the ``DBInstanceParameterGroupName`` parameter, the DB cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the next maintenance window.
          Valid for Cluster Type: Aurora DB clusters only
         Default: The existing name setting
         Constraints:
          +  The DB parameter group must be in the same DB parameter group family as this DB cluster.
          +  The ``DBInstanceParameterGroupName`` parameter is valid in combination with the ``AllowMajorVersionUpgrade`` parameter for a major version upgrade only.
        """
        return pulumi.get(self, "db_instance_parameter_group_name")

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A DB subnet group that you want to associate with this DB cluster. 
         If you are restoring a DB cluster to a point in time with ``RestoreType`` set to ``copy-on-write``, and don't specify a DB subnet group name, then the DB cluster is restored with a default DB subnet group.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "db_subnet_group_name")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Indicates the directory ID of the Active Directory to create the DB cluster.
         For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.
         For more information, see [Kerberos authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html) in the *Amazon Aurora User Guide*.
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainIamRoleName")
    def domain_iam_role_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the name of the IAM role to use when making API calls to the Directory Service.
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "domain_iam_role_name")

    @property
    @pulumi.getter(name="enableCloudwatchLogsExports")
    def enable_cloudwatch_logs_exports(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Aurora User Guide*.
          *Aurora MySQL* 
         Valid values: ``audit``, ``error``, ``general``, ``slowquery``
          *Aurora PostgreSQL* 
         Valid values: ``postgresql``
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "enable_cloudwatch_logs_exports")

    @property
    @pulumi.getter(name="enableGlobalWriteForwarding")
    def enable_global_write_forwarding(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global cluster (Aurora global database). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.
         You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by a global cluster API operation, but it does nothing until then.
         Valid for Cluster Type: Aurora DB clusters only
        """
        return pulumi.get(self, "enable_global_write_forwarding")

    @property
    @pulumi.getter(name="enableHttpEndpoint")
    def enable_http_endpoint(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether to enable the HTTP endpoint for the DB cluster. By default, the HTTP endpoint isn't enabled.
         When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the DB cluster. You can also query your database from inside the RDS console with the RDS query editor.
         For more information, see [Using RDS Data API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
         Valid for Cluster Type: Aurora DB clusters only
        """
        return pulumi.get(self, "enable_http_endpoint")

    @property
    @pulumi.getter(name="enableIamDatabaseAuthentication")
    def enable_iam_database_authentication(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.
         For more information, see [IAM Database Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon Aurora User Guide.*
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "enable_iam_database_authentication")

    @property
    @pulumi.getter(name="enableLocalWriteForwarding")
    def enable_local_write_forwarding(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster. By default, write operations aren't allowed on reader DB instances.
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "enable_local_write_forwarding")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output['outputs.DbClusterEndpoint']:
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the database engine to be used for this DB cluster.
         Valid Values:
          +   ``aurora-mysql`` 
          +   ``aurora-postgresql`` 
          +   ``mysql`` 
          +   ``postgres`` 
          
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineLifecycleSupport")
    def engine_lifecycle_support(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The life cycle type for this DB cluster.
          By default, this value is set to ``open-source-rds-extended-support``, which enrolls your DB cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to ``open-source-rds-extended-support-disabled``. In this case, creating the DB cluster will fail if the DB major version is past its end of standard support date.
          You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB cluster past the end of standard support for that engine version. For more information, see the following sections:
          +  Amazon Aurora - [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html) in the *Amazon Aurora User Guide*
          +  Amazon RDS - [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html) in the *Amazon RDS User Guide*
          
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         Valid Values: ``open-source-rds-extended-support | open-source-rds-extended-support-disabled``
         Default: ``open-source-rds-extended-support``
        """
        return pulumi.get(self, "engine_lifecycle_support")

    @property
    @pulumi.getter(name="engineMode")
    def engine_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The DB engine mode of the DB cluster, either ``provisioned`` or ``serverless``.
         The ``serverless`` engine mode only applies for Aurora Serverless v1 DB clusters. Aurora Serverless v2 DB clusters use the ``provisioned`` engine mode.
         For information about limitations and requirements for Serverless DB clusters, see the following sections in the *Amazon Aurora User Guide*:
          +   [Limitations of Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations) 
          +   [Requirements for Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html) 
          
         Valid for Cluster Type: Aurora DB clusters only
        """
        return pulumi.get(self, "engine_mode")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version number of the database engine to use.
         To list all of the available engine versions for Aurora MySQL version 2 (5.7-compatible) and version 3 (8.0-compatible), use the following command:
          ``aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`` 
         You can supply either ``5.7`` or ``8.0`` to use the default engine version for Aurora MySQL version 2 or version 3, respectively.
         To list all of the available engine versions for Aurora PostgreSQL, use the following command:
          ``aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"`` 
         To list all of the available engine versions for RDS for MySQL, use the following command:
          ``aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"`` 
         To list all of the available engine versions for RDS for PostgreSQL, use the following command:
          ``aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"`` 
          *Aurora MySQL* 
         For information, see [Database engine updates for Amazon Aurora MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html) in the *Amazon Aurora User Guide*.
          *Aurora PostgreSQL* 
         For information, see [Amazon Aurora PostgreSQL releases and engine versions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html) in the *Amazon Aurora User Guide*.
          *MySQL* 
         For information, see [Amazon RDS for MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt) in the *Amazon RDS User Guide*.
          *PostgreSQL* 
         For information, see [Amazon RDS for PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts) in the *Amazon RDS User Guide*.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="globalClusterIdentifier")
    def global_cluster_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster. To define the primary database cluster of the global cluster, use the [AWS::RDS::GlobalCluster](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html) resource. 
          If you aren't configuring a global database cluster, don't specify this property. 
          To remove the DB cluster from a global database cluster, specify an empty value for the ``GlobalClusterIdentifier`` property.
          For information about Aurora global databases, see [Working with Amazon Aurora Global Databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) in the *Amazon Aurora User Guide*.
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "global_cluster_identifier")

    @property
    @pulumi.getter
    def iops(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
         For information about valid IOPS values, see [Provisioned IOPS storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
         This setting is required to create a Multi-AZ DB cluster.
         Valid for Cluster Type: Multi-AZ DB clusters only
         Constraints:
          +  Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as ``arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef``. If you enable the ``StorageEncrypted`` property but don't specify this property, the default KMS key is used. If you specify this property, you must set the ``StorageEncrypted`` property to ``true``.
         If you specify the ``SnapshotIdentifier`` property, the ``StorageEncrypted`` property value is inherited from the snapshot, and if the DB cluster is encrypted, the specified ``KmsKeyId`` property is used.
         If you create a read replica of an encrypted DB cluster in another AWS Region, make sure to set ``KmsKeyId`` to a KMS key identifier that is valid in the destination AWS Region. This KMS key is used to encrypt the read replica in that AWS Region.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="manageMasterUserPassword")
    def manage_master_user_password(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether to manage the master user password with AWS Secrets Manager.
         For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         Constraints:
          +  Can't manage the master user password with AWS Secrets Manager if ``MasterUserPassword`` is specified.
        """
        return pulumi.get(self, "manage_master_user_password")

    @property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The master password for the DB instance.
          If you specify the ``SourceDBClusterIdentifier``, ``SnapshotIdentifier``, or ``GlobalClusterIdentifier`` property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
          Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "master_user_password")

    @property
    @pulumi.getter(name="masterUserSecret")
    def master_user_secret(self) -> pulumi.Output[Optional['outputs.DbClusterMasterUserSecret']]:
        """
        The secret managed by RDS in AWS Secrets Manager for the master user password.
          When you restore a DB cluster from a snapshot, Amazon RDS generates a new secret instead of reusing the secret specified in the ``SecretArn`` property. This ensures that the restored DB cluster is securely managed with a dedicated secret. To maintain consistent integration with your application, you might need to update resource configurations to reference the newly created secret.
          For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
        """
        return pulumi.get(self, "master_user_secret")

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the master user for the DB cluster.
          If you specify the ``SourceDBClusterIdentifier``, ``SnapshotIdentifier``, or ``GlobalClusterIdentifier`` property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
          Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "master_username")

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify ``0``.
         If ``MonitoringRoleArn`` is specified, also set ``MonitoringInterval`` to a value other than ``0``.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         Valid Values: ``0 | 1 | 5 | 10 | 15 | 30 | 60``
         Default: ``0``
        """
        return pulumi.get(self, "monitoring_interval")

    @property
    @pulumi.getter(name="monitoringRoleArn")
    def monitoring_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is ``arn:aws:iam:123456789012:role/emaccess``. For information on creating a monitoring role, see [Setting up and enabling Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling) in the *Amazon RDS User Guide*.
         If ``MonitoringInterval`` is set to a value other than ``0``, supply a ``MonitoringRoleArn`` value.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "monitoring_role_arn")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The network type of the DB cluster.
         Valid values:
          +   ``IPV4`` 
          +   ``DUAL`` 
          
         The network type is determined by the ``DBSubnetGroup`` specified for the DB cluster. A ``DBSubnetGroup`` can support only the IPv4 protocol or the IPv4 and IPv6 protocols (``DUAL``).
         For more information, see [Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon Aurora User Guide.*
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="performanceInsightsEnabled")
    def performance_insights_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether to turn on Performance Insights for the DB cluster.
         For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "performance_insights_enabled")

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS KMS key identifier for encryption of Performance Insights data.
         The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         If you don't specify a value for ``PerformanceInsightsKMSKeyId``, then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS-account. Your AWS-account has a different default KMS key for each AWS-Region.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @property
    @pulumi.getter(name="performanceInsightsRetentionPeriod")
    def performance_insights_retention_period(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of days to retain Performance Insights data. When creating a DB cluster without enabling Performance Insights, you can't specify the parameter ``PerformanceInsightsRetentionPeriod``.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         Valid Values:
          +   ``7`` 
          +  *month* * 31, where *month* is a number of months from 1-23. Examples: ``93`` (3 months * 31), ``341`` (11 months * 31), ``589`` (19 months * 31)
          +   ``731`` 
          
         Default: ``7`` days
         If you specify a retention period that isn't valid, such as ``94``, Amazon RDS issues an error.
        """
        return pulumi.get(self, "performance_insights_retention_period")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The port number on which the DB instances in the DB cluster accept connections.
         Default:
          +  When ``EngineMode`` is ``provisioned``, ``3306`` (for both Aurora MySQL and Aurora PostgreSQL)
          +  When ``EngineMode`` is ``serverless``:
          +  ``3306`` when ``Engine`` is ``aurora`` or ``aurora-mysql``
          +  ``5432`` when ``Engine`` is ``aurora-postgresql``
          
          
          The ``No interruption`` on update behavior only applies to DB clusters. If you are updating a DB instance, see [Port](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port) for the AWS::RDS::DBInstance resource.
          Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The daily time range during which automated backups are created. For more information, see [Backup Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow) in the *Amazon Aurora User Guide.*
         Constraints:
          +  Must be in the format ``hh24:mi-hh24:mi``.
          +  Must be in Universal Coordinated Time (UTC).
          +  Must not conflict with the preferred maintenance window.
          +  Must be at least 30 minutes.
          
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "preferred_backup_window")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         Format: ``ddd:hh24:mi-ddd:hh24:mi``
         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see [Maintaining an Amazon Aurora DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora) in the *Amazon Aurora User Guide.*
         Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         Constraints: Minimum 30-minute window.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the DB cluster is publicly accessible.
         When the DB cluster is publicly accessible and you connect from outside of the DB cluster's virtual private cloud (VPC), its Domain Name System (DNS) endpoint resolves to the public IP address. When you connect from within the same VPC as the DB cluster, the endpoint resolves to the private IP address. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
         When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
         Valid for Cluster Type: Multi-AZ DB clusters only
         Default: The default behavior varies depending on whether ``DBSubnetGroupName`` is specified.
         If ``DBSubnetGroupName`` isn't specified, and ``PubliclyAccessible`` isn't specified, the following applies:
          +  If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
          +  If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
          
         If ``DBSubnetGroupName`` is specified, and ``PubliclyAccessible`` isn't specified, the following applies:
          +  If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
          +  If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter(name="readEndpoint")
    def read_endpoint(self) -> pulumi.Output['outputs.DbClusterReadEndpoint']:
        return pulumi.get(self, "read_endpoint")

    @property
    @pulumi.getter(name="replicationSourceIdentifier")
    def replication_source_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "replication_source_identifier")

    @property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The date and time to restore the DB cluster to.
         Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
         Constraints:
          +  Must be before the latest restorable time for the DB instance
          +  Must be specified if ``UseLatestRestorableTime`` parameter isn't provided
          +  Can't be specified if the ``UseLatestRestorableTime`` parameter is enabled
          +  Can't be specified if the ``RestoreType`` parameter is ``copy-on-write``
          
         This property must be used with ``SourceDBClusterIdentifier`` property. The resulting cluster will have the identifier that matches the value of the ``DBclusterIdentifier`` property.
         Example: ``2015-03-07T23:45:00Z``
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "restore_to_time")

    @property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of restore to be performed. You can specify one of the following values:
          +  ``full-copy`` - The new DB cluster is restored as a full copy of the source DB cluster.
          +  ``copy-on-write`` - The new DB cluster is restored as a clone of the source DB cluster.
          
         If you don't specify a ``RestoreType`` value, then the new DB cluster is restored as a full copy of the source DB cluster.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "restore_type")

    @property
    @pulumi.getter(name="scalingConfiguration")
    def scaling_configuration(self) -> pulumi.Output[Optional['outputs.DbClusterScalingConfiguration']]:
        """
        The scaling configuration of an Aurora Serverless v1 DB cluster.
         This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, Use the ``ServerlessV2ScalingConfiguration`` property.
         Valid for: Aurora Serverless v1 DB clusters only
        """
        return pulumi.get(self, "scaling_configuration")

    @property
    @pulumi.getter(name="serverlessV2ScalingConfiguration")
    def serverless_v2_scaling_configuration(self) -> pulumi.Output[Optional['outputs.DbClusterServerlessV2ScalingConfiguration']]:
        """
        The scaling configuration of an Aurora Serverless V2 DB cluster. 
         This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, Use the ``ScalingConfiguration`` property.
         Valid for: Aurora Serverless v2 DB clusters only
        """
        return pulumi.get(self, "serverless_v2_scaling_configuration")

    @property
    @pulumi.getter(name="snapshotIdentifier")
    def snapshot_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The identifier for the DB snapshot or DB cluster snapshot to restore from.
         You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
         After you restore a DB cluster with a ``SnapshotIdentifier`` property, you must specify the same ``SnapshotIdentifier`` property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the ``SnapshotIdentifier`` property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified ``SnapshotIdentifier`` property, and the original DB cluster is deleted.
         If you specify the ``SnapshotIdentifier`` property to restore a DB cluster (as opposed to specifying it for DB cluster updates), then don't specify the following properties:
          +   ``GlobalClusterIdentifier`` 
          +   ``MasterUsername`` 
          +   ``MasterUserPassword`` 
          +   ``ReplicationSourceIdentifier`` 
          +   ``RestoreType`` 
          +   ``SourceDBClusterIdentifier`` 
          +   ``SourceRegion`` 
          +  ``StorageEncrypted`` (for an encrypted snapshot)
          +   ``UseLatestRestorableTime`` 
          
         Constraints:
          +  Must match the identifier of an existing Snapshot.
          
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "snapshot_identifier")

    @property
    @pulumi.getter(name="sourceDbClusterIdentifier")
    def source_db_cluster_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore.
         Constraints:
          +  Must match the identifier of an existing DBCluster.
          
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "source_db_cluster_identifier")

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS Region which contains the source DB cluster when replicating a DB cluster. For example, ``us-east-1``. 
         Valid for: Aurora DB clusters only
        """
        return pulumi.get(self, "source_region")

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether the DB cluster is encrypted.
         If you specify the ``KmsKeyId`` property, then you must enable encryption.
         If you specify the ``SourceDBClusterIdentifier`` property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified ``KmsKeyId`` property is used.
         If you specify the ``SnapshotIdentifier`` and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified ``KmsKeyId`` property is used.
         If you specify the ``SnapshotIdentifier`` and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the ``KmsKeyId`` property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to ``false``.
          If you specify both the ``StorageEncrypted`` and ``SnapshotIdentifier`` properties without specifying the ``KmsKeyId`` property, then the restored DB cluster inherits the encryption settings from the DB snapshot that provide.
          Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "storage_encrypted")

    @property
    @pulumi.getter(name="storageThroughput")
    def storage_throughput(self) -> pulumi.Output[builtins.int]:
        """
        The storage throughput for the DB cluster. The throughput is automatically set based on the IOPS that you provision, and is not configurable.

        This setting is only for non-Aurora Multi-AZ DB clusters.
        """
        return pulumi.get(self, "storage_throughput")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The storage type to associate with the DB cluster.
         For information on storage types for Aurora DB clusters, see [Storage configurations for Amazon Aurora DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type). For information on storage types for Multi-AZ DB clusters, see [Settings for creating Multi-AZ DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings).
         This setting is required to create a Multi-AZ DB cluster.
         When specified for a Multi-AZ DB cluster, a value for the ``Iops`` parameter is required.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         Valid Values:
          +  Aurora DB clusters - ``aurora | aurora-iopt1``
          +  Multi-AZ DB clusters - ``io1 | io2 | gp3``
          
         Default:
          +  Aurora DB clusters - ``aurora``
          +  Multi-AZ DB clusters - ``io1``
          
          When you create an Aurora DB cluster with the storage type set to ``aurora-iopt1``, the storage type is returned in the response. The storage type isn't returned when you set it to ``aurora``.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Tags to assign to the DB cluster.
         Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        A value that indicates whether to restore the DB cluster to the latest restorable backup time. By default, the DB cluster is not restored to the latest restorable backup time. 
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "use_latest_restorable_time")

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of EC2 VPC security groups to associate with this DB cluster.
         If you plan to update the resource, don't specify VPC security groups in a shared VPC.
         Valid for: Aurora DB clusters and Multi-AZ DB clusters
        """
        return pulumi.get(self, "vpc_security_group_ids")

