# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['CustomDbEngineVersionArgs', 'CustomDbEngineVersion']

@pulumi.input_type
class CustomDbEngineVersionArgs:
    def __init__(__self__, *,
                 engine: pulumi.Input[builtins.str],
                 engine_version: pulumi.Input[builtins.str],
                 database_installation_files_s3_bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 database_installation_files_s3_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 manifest: Optional[pulumi.Input[builtins.str]] = None,
                 source_custom_db_engine_version_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input['CustomDbEngineVersionStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 use_aws_provided_latest_image: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a CustomDbEngineVersion resource.
        :param pulumi.Input[builtins.str] engine: The database engine to use for your custom engine version (CEV).
                Valid values:
                 +   ``custom-oracle-ee`` 
                 +   ``custom-oracle-ee-cdb``
        :param pulumi.Input[builtins.str] engine_version: The name of your CEV. The name format is ``major version.customized_string``. For example, a valid CEV name is ``19.my_cev1``. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of ``Engine`` and ``EngineVersion`` is unique per customer per Region.
                 *Constraints:* Minimum length is 1. Maximum length is 60.
                 *Pattern:* ``^[a-z0-9_.-]{1,60$``}
        :param pulumi.Input[builtins.str] database_installation_files_s3_bucket_name: The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid bucket name is ``my-custom-installation-files``.
        :param pulumi.Input[builtins.str] database_installation_files_s3_prefix: The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid bucket name is ``123456789012/cev1``. If this setting isn't specified, no prefix is assumed.
        :param pulumi.Input[builtins.str] description: An optional description of your CEV.
        :param pulumi.Input[builtins.str] image_id: A value that indicates the ID of the AMI.
        :param pulumi.Input[builtins.str] kms_key_id: The AWS KMS key identifier for an encrypted CEV. A symmetric encryption KMS key is required for RDS Custom, but optional for Amazon RDS.
                If you have an existing symmetric encryption KMS key in your account, you can use it with RDS Custom. No further action is necessary. If you don't already have a symmetric encryption KMS key in your account, follow the instructions in [Creating a symmetric encryption KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk) in the *Key Management Service Developer Guide*.
                You can choose the same symmetric encryption key when you create a CEV and a DB instance, or choose different keys.
        :param pulumi.Input[builtins.str] manifest: The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which they are listed.
                The following JSON fields are valid:
                 + MediaImportTemplateVersion Version of the CEV manifest. The date is in the format YYYY-MM-DD. + databaseInstallationFileNames Ordered list of installation files for the CEV. + opatchFileNames Ordered list of OPatch installers used for the Oracle DB engine. + psuRuPatchFileNames The PSU and RU patches for this CEV. + OtherPatchFileNames The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying the PSU and RU patches. 
                For more information, see [Creating the CEV manifest](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest) in the *Amazon RDS User Guide*.
        :param pulumi.Input[builtins.str] source_custom_db_engine_version_identifier: The ARN of a CEV to use as a source for creating a new CEV. You can specify a different Amazon Machine Imagine (AMI) by using either ``Source`` or ``UseAwsProvidedLatestImage``. You can't specify a different JSON manifest when you specify ``SourceCustomDbEngineVersionIdentifier``.
        :param pulumi.Input['CustomDbEngineVersionStatus'] status: A value that indicates the status of a custom engine version (CEV).
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
        :param pulumi.Input[builtins.bool] use_aws_provided_latest_image: Specifies whether to use the latest service-provided Amazon Machine Image (AMI) for the CEV. If you specify ``UseAwsProvidedLatestImage``, you can't also specify ``ImageId``.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        if database_installation_files_s3_bucket_name is not None:
            pulumi.set(__self__, "database_installation_files_s3_bucket_name", database_installation_files_s3_bucket_name)
        if database_installation_files_s3_prefix is not None:
            pulumi.set(__self__, "database_installation_files_s3_prefix", database_installation_files_s3_prefix)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if manifest is not None:
            pulumi.set(__self__, "manifest", manifest)
        if source_custom_db_engine_version_identifier is not None:
            pulumi.set(__self__, "source_custom_db_engine_version_identifier", source_custom_db_engine_version_identifier)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_aws_provided_latest_image is not None:
            pulumi.set(__self__, "use_aws_provided_latest_image", use_aws_provided_latest_image)

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Input[builtins.str]:
        """
        The database engine to use for your custom engine version (CEV).
         Valid values:
          +   ``custom-oracle-ee`` 
          +   ``custom-oracle-ee-cdb``
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Input[builtins.str]:
        """
        The name of your CEV. The name format is ``major version.customized_string``. For example, a valid CEV name is ``19.my_cev1``. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of ``Engine`` and ``EngineVersion`` is unique per customer per Region.
          *Constraints:* Minimum length is 1. Maximum length is 60.
          *Pattern:* ``^[a-z0-9_.-]{1,60$``}
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="databaseInstallationFilesS3BucketName")
    def database_installation_files_s3_bucket_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid bucket name is ``my-custom-installation-files``.
        """
        return pulumi.get(self, "database_installation_files_s3_bucket_name")

    @database_installation_files_s3_bucket_name.setter
    def database_installation_files_s3_bucket_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_installation_files_s3_bucket_name", value)

    @property
    @pulumi.getter(name="databaseInstallationFilesS3Prefix")
    def database_installation_files_s3_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid bucket name is ``123456789012/cev1``. If this setting isn't specified, no prefix is assumed.
        """
        return pulumi.get(self, "database_installation_files_s3_prefix")

    @database_installation_files_s3_prefix.setter
    def database_installation_files_s3_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_installation_files_s3_prefix", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of your CEV.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A value that indicates the ID of the AMI.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS KMS key identifier for an encrypted CEV. A symmetric encryption KMS key is required for RDS Custom, but optional for Amazon RDS.
         If you have an existing symmetric encryption KMS key in your account, you can use it with RDS Custom. No further action is necessary. If you don't already have a symmetric encryption KMS key in your account, follow the instructions in [Creating a symmetric encryption KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk) in the *Key Management Service Developer Guide*.
         You can choose the same symmetric encryption key when you create a CEV and a DB instance, or choose different keys.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def manifest(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which they are listed.
         The following JSON fields are valid:
          + MediaImportTemplateVersion Version of the CEV manifest. The date is in the format YYYY-MM-DD. + databaseInstallationFileNames Ordered list of installation files for the CEV. + opatchFileNames Ordered list of OPatch installers used for the Oracle DB engine. + psuRuPatchFileNames The PSU and RU patches for this CEV. + OtherPatchFileNames The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying the PSU and RU patches. 
         For more information, see [Creating the CEV manifest](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest) in the *Amazon RDS User Guide*.
        """
        return pulumi.get(self, "manifest")

    @manifest.setter
    def manifest(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "manifest", value)

    @property
    @pulumi.getter(name="sourceCustomDbEngineVersionIdentifier")
    def source_custom_db_engine_version_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of a CEV to use as a source for creating a new CEV. You can specify a different Amazon Machine Imagine (AMI) by using either ``Source`` or ``UseAwsProvidedLatestImage``. You can't specify a different JSON manifest when you specify ``SourceCustomDbEngineVersionIdentifier``.
        """
        return pulumi.get(self, "source_custom_db_engine_version_identifier")

    @source_custom_db_engine_version_identifier.setter
    def source_custom_db_engine_version_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_custom_db_engine_version_identifier", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['CustomDbEngineVersionStatus']]:
        """
        A value that indicates the status of a custom engine version (CEV).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['CustomDbEngineVersionStatus']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="useAwsProvidedLatestImage")
    def use_aws_provided_latest_image(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to use the latest service-provided Amazon Machine Image (AMI) for the CEV. If you specify ``UseAwsProvidedLatestImage``, you can't also specify ``ImageId``.
        """
        return pulumi.get(self, "use_aws_provided_latest_image")

    @use_aws_provided_latest_image.setter
    def use_aws_provided_latest_image(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_aws_provided_latest_image", value)


@pulumi.type_token("aws-native:rds:CustomDbEngineVersion")
class CustomDbEngineVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_installation_files_s3_bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 database_installation_files_s3_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 manifest: Optional[pulumi.Input[builtins.str]] = None,
                 source_custom_db_engine_version_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input['CustomDbEngineVersionStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 use_aws_provided_latest_image: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Creates a custom DB engine version (CEV).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] database_installation_files_s3_bucket_name: The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid bucket name is ``my-custom-installation-files``.
        :param pulumi.Input[builtins.str] database_installation_files_s3_prefix: The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid bucket name is ``123456789012/cev1``. If this setting isn't specified, no prefix is assumed.
        :param pulumi.Input[builtins.str] description: An optional description of your CEV.
        :param pulumi.Input[builtins.str] engine: The database engine to use for your custom engine version (CEV).
                Valid values:
                 +   ``custom-oracle-ee`` 
                 +   ``custom-oracle-ee-cdb``
        :param pulumi.Input[builtins.str] engine_version: The name of your CEV. The name format is ``major version.customized_string``. For example, a valid CEV name is ``19.my_cev1``. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of ``Engine`` and ``EngineVersion`` is unique per customer per Region.
                 *Constraints:* Minimum length is 1. Maximum length is 60.
                 *Pattern:* ``^[a-z0-9_.-]{1,60$``}
        :param pulumi.Input[builtins.str] image_id: A value that indicates the ID of the AMI.
        :param pulumi.Input[builtins.str] kms_key_id: The AWS KMS key identifier for an encrypted CEV. A symmetric encryption KMS key is required for RDS Custom, but optional for Amazon RDS.
                If you have an existing symmetric encryption KMS key in your account, you can use it with RDS Custom. No further action is necessary. If you don't already have a symmetric encryption KMS key in your account, follow the instructions in [Creating a symmetric encryption KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk) in the *Key Management Service Developer Guide*.
                You can choose the same symmetric encryption key when you create a CEV and a DB instance, or choose different keys.
        :param pulumi.Input[builtins.str] manifest: The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which they are listed.
                The following JSON fields are valid:
                 + MediaImportTemplateVersion Version of the CEV manifest. The date is in the format YYYY-MM-DD. + databaseInstallationFileNames Ordered list of installation files for the CEV. + opatchFileNames Ordered list of OPatch installers used for the Oracle DB engine. + psuRuPatchFileNames The PSU and RU patches for this CEV. + OtherPatchFileNames The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying the PSU and RU patches. 
                For more information, see [Creating the CEV manifest](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest) in the *Amazon RDS User Guide*.
        :param pulumi.Input[builtins.str] source_custom_db_engine_version_identifier: The ARN of a CEV to use as a source for creating a new CEV. You can specify a different Amazon Machine Imagine (AMI) by using either ``Source`` or ``UseAwsProvidedLatestImage``. You can't specify a different JSON manifest when you specify ``SourceCustomDbEngineVersionIdentifier``.
        :param pulumi.Input['CustomDbEngineVersionStatus'] status: A value that indicates the status of a custom engine version (CEV).
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
        :param pulumi.Input[builtins.bool] use_aws_provided_latest_image: Specifies whether to use the latest service-provided Amazon Machine Image (AMI) for the CEV. If you specify ``UseAwsProvidedLatestImage``, you can't also specify ``ImageId``.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomDbEngineVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a custom DB engine version (CEV).

        :param str resource_name: The name of the resource.
        :param CustomDbEngineVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomDbEngineVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_installation_files_s3_bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 database_installation_files_s3_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 manifest: Optional[pulumi.Input[builtins.str]] = None,
                 source_custom_db_engine_version_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input['CustomDbEngineVersionStatus']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 use_aws_provided_latest_image: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomDbEngineVersionArgs.__new__(CustomDbEngineVersionArgs)

            __props__.__dict__["database_installation_files_s3_bucket_name"] = database_installation_files_s3_bucket_name
            __props__.__dict__["database_installation_files_s3_prefix"] = database_installation_files_s3_prefix
            __props__.__dict__["description"] = description
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            if engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'engine_version'")
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["manifest"] = manifest
            __props__.__dict__["source_custom_db_engine_version_identifier"] = source_custom_db_engine_version_identifier
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_aws_provided_latest_image"] = use_aws_provided_latest_image
            __props__.__dict__["db_engine_version_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["databaseInstallationFilesS3BucketName", "databaseInstallationFilesS3Prefix", "engine", "engineVersion", "imageId", "kmsKeyId", "manifest", "sourceCustomDbEngineVersionIdentifier", "useAwsProvidedLatestImage"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(CustomDbEngineVersion, __self__).__init__(
            'aws-native:rds:CustomDbEngineVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CustomDbEngineVersion':
        """
        Get an existing CustomDbEngineVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CustomDbEngineVersionArgs.__new__(CustomDbEngineVersionArgs)

        __props__.__dict__["database_installation_files_s3_bucket_name"] = None
        __props__.__dict__["database_installation_files_s3_prefix"] = None
        __props__.__dict__["db_engine_version_arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["engine"] = None
        __props__.__dict__["engine_version"] = None
        __props__.__dict__["image_id"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["manifest"] = None
        __props__.__dict__["source_custom_db_engine_version_identifier"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["use_aws_provided_latest_image"] = None
        return CustomDbEngineVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="databaseInstallationFilesS3BucketName")
    def database_installation_files_s3_bucket_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid bucket name is ``my-custom-installation-files``.
        """
        return pulumi.get(self, "database_installation_files_s3_bucket_name")

    @property
    @pulumi.getter(name="databaseInstallationFilesS3Prefix")
    def database_installation_files_s3_prefix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid bucket name is ``123456789012/cev1``. If this setting isn't specified, no prefix is assumed.
        """
        return pulumi.get(self, "database_installation_files_s3_prefix")

    @property
    @pulumi.getter(name="dbEngineVersionArn")
    def db_engine_version_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the custom engine version.
        """
        return pulumi.get(self, "db_engine_version_arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of your CEV.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[builtins.str]:
        """
        The database engine to use for your custom engine version (CEV).
         Valid values:
          +   ``custom-oracle-ee`` 
          +   ``custom-oracle-ee-cdb``
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[builtins.str]:
        """
        The name of your CEV. The name format is ``major version.customized_string``. For example, a valid CEV name is ``19.my_cev1``. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of ``Engine`` and ``EngineVersion`` is unique per customer per Region.
          *Constraints:* Minimum length is 1. Maximum length is 60.
          *Pattern:* ``^[a-z0-9_.-]{1,60$``}
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A value that indicates the ID of the AMI.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS KMS key identifier for an encrypted CEV. A symmetric encryption KMS key is required for RDS Custom, but optional for Amazon RDS.
         If you have an existing symmetric encryption KMS key in your account, you can use it with RDS Custom. No further action is necessary. If you don't already have a symmetric encryption KMS key in your account, follow the instructions in [Creating a symmetric encryption KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk) in the *Key Management Service Developer Guide*.
         You can choose the same symmetric encryption key when you create a CEV and a DB instance, or choose different keys.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def manifest(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which they are listed.
         The following JSON fields are valid:
          + MediaImportTemplateVersion Version of the CEV manifest. The date is in the format YYYY-MM-DD. + databaseInstallationFileNames Ordered list of installation files for the CEV. + opatchFileNames Ordered list of OPatch installers used for the Oracle DB engine. + psuRuPatchFileNames The PSU and RU patches for this CEV. + OtherPatchFileNames The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying the PSU and RU patches. 
         For more information, see [Creating the CEV manifest](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest) in the *Amazon RDS User Guide*.
        """
        return pulumi.get(self, "manifest")

    @property
    @pulumi.getter(name="sourceCustomDbEngineVersionIdentifier")
    def source_custom_db_engine_version_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARN of a CEV to use as a source for creating a new CEV. You can specify a different Amazon Machine Imagine (AMI) by using either ``Source`` or ``UseAwsProvidedLatestImage``. You can't specify a different JSON manifest when you specify ``SourceCustomDbEngineVersionIdentifier``.
        """
        return pulumi.get(self, "source_custom_db_engine_version_identifier")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional['CustomDbEngineVersionStatus']]:
        """
        A value that indicates the status of a custom engine version (CEV).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="useAwsProvidedLatestImage")
    def use_aws_provided_latest_image(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether to use the latest service-provided Amazon Machine Image (AMI) for the CEV. If you specify ``UseAwsProvidedLatestImage``, you can't also specify ``ImageId``.
        """
        return pulumi.get(self, "use_aws_provided_latest_image")

