# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'DbClusterDbClusterRoleArgs',
    'DbClusterDbClusterRoleArgsDict',
    'DbClusterMasterUserSecretArgs',
    'DbClusterMasterUserSecretArgsDict',
    'DbClusterScalingConfigurationArgs',
    'DbClusterScalingConfigurationArgsDict',
    'DbClusterServerlessV2ScalingConfigurationArgs',
    'DbClusterServerlessV2ScalingConfigurationArgsDict',
    'DbInstanceDbInstanceRoleArgs',
    'DbInstanceDbInstanceRoleArgsDict',
    'DbInstanceMasterUserSecretArgs',
    'DbInstanceMasterUserSecretArgsDict',
    'DbInstanceProcessorFeatureArgs',
    'DbInstanceProcessorFeatureArgsDict',
    'DbProxyAuthFormatArgs',
    'DbProxyAuthFormatArgsDict',
    'DbProxyTargetGroupConnectionPoolConfigurationInfoFormatArgs',
    'DbProxyTargetGroupConnectionPoolConfigurationInfoFormatArgsDict',
    'OptionGroupOptionConfigurationArgs',
    'OptionGroupOptionConfigurationArgsDict',
    'OptionGroupOptionSettingArgs',
    'OptionGroupOptionSettingArgsDict',
]

MYPY = False

if not MYPY:
    class DbClusterDbClusterRoleArgsDict(TypedDict):
        """
        Describes an AWS Identity and Access Management (IAM) role that is associated with a DB cluster.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
        """
        feature_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the feature associated with the AWS Identity and Access Management (IAM) role. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf. For the list of supported feature names, see the ``SupportedFeatureNames`` description in [DBEngineVersion](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html) in the *Amazon RDS API Reference*.
        """
elif False:
    DbClusterDbClusterRoleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbClusterDbClusterRoleArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[builtins.str],
                 feature_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Describes an AWS Identity and Access Management (IAM) role that is associated with a DB cluster.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
        :param pulumi.Input[builtins.str] feature_name: The name of the feature associated with the AWS Identity and Access Management (IAM) role. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf. For the list of supported feature names, see the ``SupportedFeatureNames`` description in [DBEngineVersion](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html) in the *Amazon RDS API Reference*.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if feature_name is not None:
            pulumi.set(__self__, "feature_name", feature_name)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="featureName")
    def feature_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature associated with the AWS Identity and Access Management (IAM) role. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf. For the list of supported feature names, see the ``SupportedFeatureNames`` description in [DBEngineVersion](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html) in the *Amazon RDS API Reference*.
        """
        return pulumi.get(self, "feature_name")

    @feature_name.setter
    def feature_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_name", value)


if not MYPY:
    class DbClusterMasterUserSecretArgsDict(TypedDict):
        """
        The ``MasterUserSecret`` return value specifies the secret managed by RDS in AWS Secrets Manager for the master user password.
         For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
        """
        kms_key_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The AWS KMS key identifier that is used to encrypt the secret.
        """
        secret_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the secret. This parameter is a return value that you can retrieve using the ``Fn::GetAtt`` intrinsic function. For more information, see [Return values](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#aws-resource-rds-dbcluster-return-values).
        """
elif False:
    DbClusterMasterUserSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbClusterMasterUserSecretArgs:
    def __init__(__self__, *,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 secret_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ``MasterUserSecret`` return value specifies the secret managed by RDS in AWS Secrets Manager for the master user password.
         For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
        :param pulumi.Input[builtins.str] kms_key_id: The AWS KMS key identifier that is used to encrypt the secret.
        :param pulumi.Input[builtins.str] secret_arn: The Amazon Resource Name (ARN) of the secret. This parameter is a return value that you can retrieve using the ``Fn::GetAtt`` intrinsic function. For more information, see [Return values](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#aws-resource-rds-dbcluster-return-values).
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS KMS key identifier that is used to encrypt the secret.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the secret. This parameter is a return value that you can retrieve using the ``Fn::GetAtt`` intrinsic function. For more information, see [Return values](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#aws-resource-rds-dbcluster-return-values).
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_arn", value)


if not MYPY:
    class DbClusterScalingConfigurationArgsDict(TypedDict):
        """
        The ``ScalingConfiguration`` property type specifies the scaling configuration of an Aurora Serverless v1 DB cluster. 
         For more information, see [Using Amazon Aurora Serverless](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html) in the *Amazon Aurora User Guide*.
         This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, Use the ``ServerlessV2ScalingConfiguration`` property.
         Valid for: Aurora Serverless v1 DB clusters only
        """
        auto_pause: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether to allow or disallow automatic pause for an Aurora DB cluster in ``serverless`` DB engine mode. A DB cluster can be paused only when it's idle (it has no connections).
          If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.
        """
        max_capacity: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.
         For Aurora MySQL, valid capacity values are ``1``, ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``128``, and ``256``.
         For Aurora PostgreSQL, valid capacity values are ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``192``, and ``384``.
         The maximum capacity must be greater than or equal to the minimum capacity.
        """
        min_capacity: NotRequired[pulumi.Input[builtins.int]]
        """
        The minimum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.
         For Aurora MySQL, valid capacity values are ``1``, ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``128``, and ``256``.
         For Aurora PostgreSQL, valid capacity values are ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``192``, and ``384``.
         The minimum capacity must be less than or equal to the maximum capacity.
        """
        seconds_before_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.
         Specify a value between 60 and 600 seconds.
        """
        seconds_until_auto_pause: NotRequired[pulumi.Input[builtins.int]]
        """
        The time, in seconds, before an Aurora DB cluster in ``serverless`` mode is paused.
         Specify a value between 300 and 86,400 seconds.
        """
        timeout_action: NotRequired[pulumi.Input[builtins.str]]
        """
        The action to take when the timeout is reached, either ``ForceApplyCapacityChange`` or ``RollbackCapacityChange``.
         ``ForceApplyCapacityChange`` sets the capacity to the specified value as soon as possible.
         ``RollbackCapacityChange``, the default, ignores the capacity change if a scaling point isn't found in the timeout period.
          If you specify ``ForceApplyCapacityChange``, connections that prevent Aurora Serverless v1 from finding a scaling point might be dropped.
          For more information, see [Autoscaling for Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling) in the *Amazon Aurora User Guide*.
        """
elif False:
    DbClusterScalingConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbClusterScalingConfigurationArgs:
    def __init__(__self__, *,
                 auto_pause: Optional[pulumi.Input[builtins.bool]] = None,
                 max_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 min_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 seconds_before_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 seconds_until_auto_pause: Optional[pulumi.Input[builtins.int]] = None,
                 timeout_action: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ``ScalingConfiguration`` property type specifies the scaling configuration of an Aurora Serverless v1 DB cluster. 
         For more information, see [Using Amazon Aurora Serverless](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html) in the *Amazon Aurora User Guide*.
         This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, Use the ``ServerlessV2ScalingConfiguration`` property.
         Valid for: Aurora Serverless v1 DB clusters only
        :param pulumi.Input[builtins.bool] auto_pause: Indicates whether to allow or disallow automatic pause for an Aurora DB cluster in ``serverless`` DB engine mode. A DB cluster can be paused only when it's idle (it has no connections).
                 If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.
        :param pulumi.Input[builtins.int] max_capacity: The maximum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.
                For Aurora MySQL, valid capacity values are ``1``, ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``128``, and ``256``.
                For Aurora PostgreSQL, valid capacity values are ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``192``, and ``384``.
                The maximum capacity must be greater than or equal to the minimum capacity.
        :param pulumi.Input[builtins.int] min_capacity: The minimum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.
                For Aurora MySQL, valid capacity values are ``1``, ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``128``, and ``256``.
                For Aurora PostgreSQL, valid capacity values are ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``192``, and ``384``.
                The minimum capacity must be less than or equal to the maximum capacity.
        :param pulumi.Input[builtins.int] seconds_before_timeout: The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.
                Specify a value between 60 and 600 seconds.
        :param pulumi.Input[builtins.int] seconds_until_auto_pause: The time, in seconds, before an Aurora DB cluster in ``serverless`` mode is paused.
                Specify a value between 300 and 86,400 seconds.
        :param pulumi.Input[builtins.str] timeout_action: The action to take when the timeout is reached, either ``ForceApplyCapacityChange`` or ``RollbackCapacityChange``.
                ``ForceApplyCapacityChange`` sets the capacity to the specified value as soon as possible.
                ``RollbackCapacityChange``, the default, ignores the capacity change if a scaling point isn't found in the timeout period.
                 If you specify ``ForceApplyCapacityChange``, connections that prevent Aurora Serverless v1 from finding a scaling point might be dropped.
                 For more information, see [Autoscaling for Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling) in the *Amazon Aurora User Guide*.
        """
        if auto_pause is not None:
            pulumi.set(__self__, "auto_pause", auto_pause)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if seconds_before_timeout is not None:
            pulumi.set(__self__, "seconds_before_timeout", seconds_before_timeout)
        if seconds_until_auto_pause is not None:
            pulumi.set(__self__, "seconds_until_auto_pause", seconds_until_auto_pause)
        if timeout_action is not None:
            pulumi.set(__self__, "timeout_action", timeout_action)

    @property
    @pulumi.getter(name="autoPause")
    def auto_pause(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to allow or disallow automatic pause for an Aurora DB cluster in ``serverless`` DB engine mode. A DB cluster can be paused only when it's idle (it has no connections).
          If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.
        """
        return pulumi.get(self, "auto_pause")

    @auto_pause.setter
    def auto_pause(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_pause", value)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.
         For Aurora MySQL, valid capacity values are ``1``, ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``128``, and ``256``.
         For Aurora PostgreSQL, valid capacity values are ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``192``, and ``384``.
         The maximum capacity must be greater than or equal to the minimum capacity.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum capacity for an Aurora DB cluster in ``serverless`` DB engine mode.
         For Aurora MySQL, valid capacity values are ``1``, ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``128``, and ``256``.
         For Aurora PostgreSQL, valid capacity values are ``2``, ``4``, ``8``, ``16``, ``32``, ``64``, ``192``, and ``384``.
         The minimum capacity must be less than or equal to the maximum capacity.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_capacity", value)

    @property
    @pulumi.getter(name="secondsBeforeTimeout")
    def seconds_before_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.
         Specify a value between 60 and 600 seconds.
        """
        return pulumi.get(self, "seconds_before_timeout")

    @seconds_before_timeout.setter
    def seconds_before_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "seconds_before_timeout", value)

    @property
    @pulumi.getter(name="secondsUntilAutoPause")
    def seconds_until_auto_pause(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The time, in seconds, before an Aurora DB cluster in ``serverless`` mode is paused.
         Specify a value between 300 and 86,400 seconds.
        """
        return pulumi.get(self, "seconds_until_auto_pause")

    @seconds_until_auto_pause.setter
    def seconds_until_auto_pause(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "seconds_until_auto_pause", value)

    @property
    @pulumi.getter(name="timeoutAction")
    def timeout_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take when the timeout is reached, either ``ForceApplyCapacityChange`` or ``RollbackCapacityChange``.
         ``ForceApplyCapacityChange`` sets the capacity to the specified value as soon as possible.
         ``RollbackCapacityChange``, the default, ignores the capacity change if a scaling point isn't found in the timeout period.
          If you specify ``ForceApplyCapacityChange``, connections that prevent Aurora Serverless v1 from finding a scaling point might be dropped.
          For more information, see [Autoscaling for Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling) in the *Amazon Aurora User Guide*.
        """
        return pulumi.get(self, "timeout_action")

    @timeout_action.setter
    def timeout_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout_action", value)


if not MYPY:
    class DbClusterServerlessV2ScalingConfigurationArgsDict(TypedDict):
        """
        The ``ServerlessV2ScalingConfiguration`` property type specifies the scaling configuration of an Aurora Serverless V2 DB cluster. For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
         If you have an Aurora cluster, you must set this attribute before you add a DB instance that uses the ``db.serverless`` DB instance class. For more information, see [Clusters that use Aurora Serverless v2 must have a capacity range specified](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html#aurora-serverless-v2.requirements.capacity-range) in the *Amazon Aurora User Guide*.
         This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, use the ``ScalingConfiguration`` property.
         Valid for: Aurora Serverless v2 DB clusters
        """
        max_capacity: NotRequired[pulumi.Input[builtins.float]]
        """
        The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 40, 40.5, 41, and so on. The largest value that you can use is 128.
         The maximum capacity must be higher than 0.5 ACUs. For more information, see [Choosing the maximum Aurora Serverless v2 capacity setting for a cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.setting-capacity.html#aurora-serverless-v2.max_capacity_considerations) in the *Amazon Aurora User Guide*.
         Aurora automatically sets certain parameters for Aurora Serverless V2 DB instances to values that depend on the maximum ACU value in the capacity range. When you update the maximum capacity value, the ``ParameterApplyStatus`` value for the DB instance changes to ``pending-reboot``. You can update the parameter values by rebooting the DB instance after changing the capacity range.
        """
        min_capacity: NotRequired[pulumi.Input[builtins.float]]
        """
        The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. For Aurora versions that support the Aurora Serverless v2 auto-pause feature, the smallest value that you can use is 0. For versions that don't support Aurora Serverless v2 auto-pause, the smallest value that you can use is 0.5.
        """
        seconds_until_auto_pause: NotRequired[pulumi.Input[builtins.int]]
        """
        Specifies the number of seconds an Aurora Serverless v2 DB instance must be idle before Aurora attempts to automatically pause it. 
         Specify a value between 300 seconds (five minutes) and 86,400 seconds (one day). The default is 300 seconds.
        """
elif False:
    DbClusterServerlessV2ScalingConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbClusterServerlessV2ScalingConfigurationArgs:
    def __init__(__self__, *,
                 max_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 min_capacity: Optional[pulumi.Input[builtins.float]] = None,
                 seconds_until_auto_pause: Optional[pulumi.Input[builtins.int]] = None):
        """
        The ``ServerlessV2ScalingConfiguration`` property type specifies the scaling configuration of an Aurora Serverless V2 DB cluster. For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
         If you have an Aurora cluster, you must set this attribute before you add a DB instance that uses the ``db.serverless`` DB instance class. For more information, see [Clusters that use Aurora Serverless v2 must have a capacity range specified](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html#aurora-serverless-v2.requirements.capacity-range) in the *Amazon Aurora User Guide*.
         This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, use the ``ScalingConfiguration`` property.
         Valid for: Aurora Serverless v2 DB clusters
        :param pulumi.Input[builtins.float] max_capacity: The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 40, 40.5, 41, and so on. The largest value that you can use is 128.
                The maximum capacity must be higher than 0.5 ACUs. For more information, see [Choosing the maximum Aurora Serverless v2 capacity setting for a cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.setting-capacity.html#aurora-serverless-v2.max_capacity_considerations) in the *Amazon Aurora User Guide*.
                Aurora automatically sets certain parameters for Aurora Serverless V2 DB instances to values that depend on the maximum ACU value in the capacity range. When you update the maximum capacity value, the ``ParameterApplyStatus`` value for the DB instance changes to ``pending-reboot``. You can update the parameter values by rebooting the DB instance after changing the capacity range.
        :param pulumi.Input[builtins.float] min_capacity: The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. For Aurora versions that support the Aurora Serverless v2 auto-pause feature, the smallest value that you can use is 0. For versions that don't support Aurora Serverless v2 auto-pause, the smallest value that you can use is 0.5.
        :param pulumi.Input[builtins.int] seconds_until_auto_pause: Specifies the number of seconds an Aurora Serverless v2 DB instance must be idle before Aurora attempts to automatically pause it. 
                Specify a value between 300 seconds (five minutes) and 86,400 seconds (one day). The default is 300 seconds.
        """
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if seconds_until_auto_pause is not None:
            pulumi.set(__self__, "seconds_until_auto_pause", seconds_until_auto_pause)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 40, 40.5, 41, and so on. The largest value that you can use is 128.
         The maximum capacity must be higher than 0.5 ACUs. For more information, see [Choosing the maximum Aurora Serverless v2 capacity setting for a cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.setting-capacity.html#aurora-serverless-v2.max_capacity_considerations) in the *Amazon Aurora User Guide*.
         Aurora automatically sets certain parameters for Aurora Serverless V2 DB instances to values that depend on the maximum ACU value in the capacity range. When you update the maximum capacity value, the ``ParameterApplyStatus`` value for the DB instance changes to ``pending-reboot``. You can update the parameter values by rebooting the DB instance after changing the capacity range.
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_capacity", value)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. For Aurora versions that support the Aurora Serverless v2 auto-pause feature, the smallest value that you can use is 0. For versions that don't support Aurora Serverless v2 auto-pause, the smallest value that you can use is 0.5.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "min_capacity", value)

    @property
    @pulumi.getter(name="secondsUntilAutoPause")
    def seconds_until_auto_pause(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the number of seconds an Aurora Serverless v2 DB instance must be idle before Aurora attempts to automatically pause it. 
         Specify a value between 300 seconds (five minutes) and 86,400 seconds (one day). The default is 300 seconds.
        """
        return pulumi.get(self, "seconds_until_auto_pause")

    @seconds_until_auto_pause.setter
    def seconds_until_auto_pause(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "seconds_until_auto_pause", value)


if not MYPY:
    class DbInstanceDbInstanceRoleArgsDict(TypedDict):
        """
        Information about an AWS Identity and Access Management (IAM) role that is associated with a DB instance.
        """
        feature_name: pulumi.Input[builtins.str]
        """
        The name of the feature associated with the AWS Identity and Access Management (IAM) role. IAM roles that are associated with a DB instance grant permission for the DB instance to access other AWS services on your behalf. For the list of supported feature names, see the ``SupportedFeatureNames`` description in [DBEngineVersion](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html) in the *Amazon RDS API Reference*.
        """
        role_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.
        """
elif False:
    DbInstanceDbInstanceRoleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbInstanceDbInstanceRoleArgs:
    def __init__(__self__, *,
                 feature_name: pulumi.Input[builtins.str],
                 role_arn: pulumi.Input[builtins.str]):
        """
        Information about an AWS Identity and Access Management (IAM) role that is associated with a DB instance.
        :param pulumi.Input[builtins.str] feature_name: The name of the feature associated with the AWS Identity and Access Management (IAM) role. IAM roles that are associated with a DB instance grant permission for the DB instance to access other AWS services on your behalf. For the list of supported feature names, see the ``SupportedFeatureNames`` description in [DBEngineVersion](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html) in the *Amazon RDS API Reference*.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.
        """
        pulumi.set(__self__, "feature_name", feature_name)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="featureName")
    def feature_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the feature associated with the AWS Identity and Access Management (IAM) role. IAM roles that are associated with a DB instance grant permission for the DB instance to access other AWS services on your behalf. For the list of supported feature names, see the ``SupportedFeatureNames`` description in [DBEngineVersion](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html) in the *Amazon RDS API Reference*.
        """
        return pulumi.get(self, "feature_name")

    @feature_name.setter
    def feature_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature_name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)


if not MYPY:
    class DbInstanceMasterUserSecretArgsDict(TypedDict):
        """
        The ``MasterUserSecret`` return value specifies the secret managed by RDS in AWS Secrets Manager for the master user password.
         For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
        """
        kms_key_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The AWS KMS key identifier that is used to encrypt the secret.
        """
        secret_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the secret. This parameter is a return value that you can retrieve using the ``Fn::GetAtt`` intrinsic function. For more information, see [Return values](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#aws-resource-rds-dbinstance-return-values).
        """
elif False:
    DbInstanceMasterUserSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbInstanceMasterUserSecretArgs:
    def __init__(__self__, *,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 secret_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ``MasterUserSecret`` return value specifies the secret managed by RDS in AWS Secrets Manager for the master user password.
         For more information, see [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
        :param pulumi.Input[builtins.str] kms_key_id: The AWS KMS key identifier that is used to encrypt the secret.
        :param pulumi.Input[builtins.str] secret_arn: The Amazon Resource Name (ARN) of the secret. This parameter is a return value that you can retrieve using the ``Fn::GetAtt`` intrinsic function. For more information, see [Return values](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#aws-resource-rds-dbinstance-return-values).
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS KMS key identifier that is used to encrypt the secret.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the secret. This parameter is a return value that you can retrieve using the ``Fn::GetAtt`` intrinsic function. For more information, see [Return values](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbinstance.html#aws-resource-rds-dbinstance-return-values).
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_arn", value)


if not MYPY:
    class DbInstanceProcessorFeatureArgsDict(TypedDict):
        """
        The ``ProcessorFeature`` property type specifies the processor features of a DB instance class.
        """
        name: NotRequired[pulumi.Input['DbInstanceProcessorFeatureName']]
        """
        The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore``.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The value of a processor feature.
        """
elif False:
    DbInstanceProcessorFeatureArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbInstanceProcessorFeatureArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input['DbInstanceProcessorFeatureName']] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ``ProcessorFeature`` property type specifies the processor features of a DB instance class.
        :param pulumi.Input['DbInstanceProcessorFeatureName'] name: The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore``.
        :param pulumi.Input[builtins.str] value: The value of a processor feature.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input['DbInstanceProcessorFeatureName']]:
        """
        The name of the processor feature. Valid names are ``coreCount`` and ``threadsPerCore``.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input['DbInstanceProcessorFeatureName']]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of a processor feature.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class DbProxyAuthFormatArgsDict(TypedDict):
        auth_scheme: NotRequired[pulumi.Input['DbProxyAuthFormatAuthScheme']]
        """
        The type of authentication that the proxy uses for connections from the proxy to the underlying database. 
        """
        client_password_auth_type: NotRequired[pulumi.Input['DbProxyAuthFormatClientPasswordAuthType']]
        """
        The type of authentication the proxy uses for connections from clients.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        A user-specified description about the authentication used by a proxy to log in as a specific database user. 
        """
        iam_auth: NotRequired[pulumi.Input['DbProxyAuthFormatIamAuth']]
        """
        Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy. The ENABLED value is valid only for proxies with RDS for Microsoft SQL Server.
        """
        secret_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager. 
        """
elif False:
    DbProxyAuthFormatArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbProxyAuthFormatArgs:
    def __init__(__self__, *,
                 auth_scheme: Optional[pulumi.Input['DbProxyAuthFormatAuthScheme']] = None,
                 client_password_auth_type: Optional[pulumi.Input['DbProxyAuthFormatClientPasswordAuthType']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 iam_auth: Optional[pulumi.Input['DbProxyAuthFormatIamAuth']] = None,
                 secret_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['DbProxyAuthFormatAuthScheme'] auth_scheme: The type of authentication that the proxy uses for connections from the proxy to the underlying database. 
        :param pulumi.Input['DbProxyAuthFormatClientPasswordAuthType'] client_password_auth_type: The type of authentication the proxy uses for connections from clients.
        :param pulumi.Input[builtins.str] description: A user-specified description about the authentication used by a proxy to log in as a specific database user. 
        :param pulumi.Input['DbProxyAuthFormatIamAuth'] iam_auth: Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy. The ENABLED value is valid only for proxies with RDS for Microsoft SQL Server.
        :param pulumi.Input[builtins.str] secret_arn: The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager. 
        """
        if auth_scheme is not None:
            pulumi.set(__self__, "auth_scheme", auth_scheme)
        if client_password_auth_type is not None:
            pulumi.set(__self__, "client_password_auth_type", client_password_auth_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if iam_auth is not None:
            pulumi.set(__self__, "iam_auth", iam_auth)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)

    @property
    @pulumi.getter(name="authScheme")
    def auth_scheme(self) -> Optional[pulumi.Input['DbProxyAuthFormatAuthScheme']]:
        """
        The type of authentication that the proxy uses for connections from the proxy to the underlying database. 
        """
        return pulumi.get(self, "auth_scheme")

    @auth_scheme.setter
    def auth_scheme(self, value: Optional[pulumi.Input['DbProxyAuthFormatAuthScheme']]):
        pulumi.set(self, "auth_scheme", value)

    @property
    @pulumi.getter(name="clientPasswordAuthType")
    def client_password_auth_type(self) -> Optional[pulumi.Input['DbProxyAuthFormatClientPasswordAuthType']]:
        """
        The type of authentication the proxy uses for connections from clients.
        """
        return pulumi.get(self, "client_password_auth_type")

    @client_password_auth_type.setter
    def client_password_auth_type(self, value: Optional[pulumi.Input['DbProxyAuthFormatClientPasswordAuthType']]):
        pulumi.set(self, "client_password_auth_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-specified description about the authentication used by a proxy to log in as a specific database user. 
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="iamAuth")
    def iam_auth(self) -> Optional[pulumi.Input['DbProxyAuthFormatIamAuth']]:
        """
        Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy. The ENABLED value is valid only for proxies with RDS for Microsoft SQL Server.
        """
        return pulumi.get(self, "iam_auth")

    @iam_auth.setter
    def iam_auth(self, value: Optional[pulumi.Input['DbProxyAuthFormatIamAuth']]):
        pulumi.set(self, "iam_auth", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager. 
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_arn", value)


if not MYPY:
    class DbProxyTargetGroupConnectionPoolConfigurationInfoFormatArgsDict(TypedDict):
        connection_borrow_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds for a proxy to wait for a connection to become available in the connection pool.
        """
        init_query: NotRequired[pulumi.Input[builtins.str]]
        """
        One or more SQL statements for the proxy to run when opening each new database connection.
        """
        max_connections_percent: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum size of the connection pool for each target in a target group.
        """
        max_idle_connections_percent: NotRequired[pulumi.Input[builtins.int]]
        """
        Controls how actively the proxy closes idle database connections in the connection pool.
        """
        session_pinning_filters: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection.
        """
elif False:
    DbProxyTargetGroupConnectionPoolConfigurationInfoFormatArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DbProxyTargetGroupConnectionPoolConfigurationInfoFormatArgs:
    def __init__(__self__, *,
                 connection_borrow_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 init_query: Optional[pulumi.Input[builtins.str]] = None,
                 max_connections_percent: Optional[pulumi.Input[builtins.int]] = None,
                 max_idle_connections_percent: Optional[pulumi.Input[builtins.int]] = None,
                 session_pinning_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.int] connection_borrow_timeout: The number of seconds for a proxy to wait for a connection to become available in the connection pool.
        :param pulumi.Input[builtins.str] init_query: One or more SQL statements for the proxy to run when opening each new database connection.
        :param pulumi.Input[builtins.int] max_connections_percent: The maximum size of the connection pool for each target in a target group.
        :param pulumi.Input[builtins.int] max_idle_connections_percent: Controls how actively the proxy closes idle database connections in the connection pool.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] session_pinning_filters: Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection.
        """
        if connection_borrow_timeout is not None:
            pulumi.set(__self__, "connection_borrow_timeout", connection_borrow_timeout)
        if init_query is not None:
            pulumi.set(__self__, "init_query", init_query)
        if max_connections_percent is not None:
            pulumi.set(__self__, "max_connections_percent", max_connections_percent)
        if max_idle_connections_percent is not None:
            pulumi.set(__self__, "max_idle_connections_percent", max_idle_connections_percent)
        if session_pinning_filters is not None:
            pulumi.set(__self__, "session_pinning_filters", session_pinning_filters)

    @property
    @pulumi.getter(name="connectionBorrowTimeout")
    def connection_borrow_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds for a proxy to wait for a connection to become available in the connection pool.
        """
        return pulumi.get(self, "connection_borrow_timeout")

    @connection_borrow_timeout.setter
    def connection_borrow_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "connection_borrow_timeout", value)

    @property
    @pulumi.getter(name="initQuery")
    def init_query(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        One or more SQL statements for the proxy to run when opening each new database connection.
        """
        return pulumi.get(self, "init_query")

    @init_query.setter
    def init_query(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "init_query", value)

    @property
    @pulumi.getter(name="maxConnectionsPercent")
    def max_connections_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum size of the connection pool for each target in a target group.
        """
        return pulumi.get(self, "max_connections_percent")

    @max_connections_percent.setter
    def max_connections_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_connections_percent", value)

    @property
    @pulumi.getter(name="maxIdleConnectionsPercent")
    def max_idle_connections_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Controls how actively the proxy closes idle database connections in the connection pool.
        """
        return pulumi.get(self, "max_idle_connections_percent")

    @max_idle_connections_percent.setter
    def max_idle_connections_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_idle_connections_percent", value)

    @property
    @pulumi.getter(name="sessionPinningFilters")
    def session_pinning_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection.
        """
        return pulumi.get(self, "session_pinning_filters")

    @session_pinning_filters.setter
    def session_pinning_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "session_pinning_filters", value)


if not MYPY:
    class OptionGroupOptionConfigurationArgsDict(TypedDict):
        """
        The ``OptionConfiguration`` property type specifies an individual option, and its settings, within an ``AWS::RDS::OptionGroup`` resource.
        """
        option_name: pulumi.Input[builtins.str]
        """
        The configuration of options to include in a group.
        """
        db_security_group_memberships: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of DB security groups used for this option.
        """
        option_settings: NotRequired[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionSettingArgsDict']]]]
        """
        The option settings to include in an option group.
        """
        option_version: NotRequired[pulumi.Input[builtins.str]]
        """
        The version for the option.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The optional port for the option.
        """
        vpc_security_group_memberships: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of VPC security group names used for this option.
        """
elif False:
    OptionGroupOptionConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OptionGroupOptionConfigurationArgs:
    def __init__(__self__, *,
                 option_name: pulumi.Input[builtins.str],
                 db_security_group_memberships: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 option_settings: Optional[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionSettingArgs']]]] = None,
                 option_version: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 vpc_security_group_memberships: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The ``OptionConfiguration`` property type specifies an individual option, and its settings, within an ``AWS::RDS::OptionGroup`` resource.
        :param pulumi.Input[builtins.str] option_name: The configuration of options to include in a group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] db_security_group_memberships: A list of DB security groups used for this option.
        :param pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionSettingArgs']]] option_settings: The option settings to include in an option group.
        :param pulumi.Input[builtins.str] option_version: The version for the option.
        :param pulumi.Input[builtins.int] port: The optional port for the option.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vpc_security_group_memberships: A list of VPC security group names used for this option.
        """
        pulumi.set(__self__, "option_name", option_name)
        if db_security_group_memberships is not None:
            pulumi.set(__self__, "db_security_group_memberships", db_security_group_memberships)
        if option_settings is not None:
            pulumi.set(__self__, "option_settings", option_settings)
        if option_version is not None:
            pulumi.set(__self__, "option_version", option_version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if vpc_security_group_memberships is not None:
            pulumi.set(__self__, "vpc_security_group_memberships", vpc_security_group_memberships)

    @property
    @pulumi.getter(name="optionName")
    def option_name(self) -> pulumi.Input[builtins.str]:
        """
        The configuration of options to include in a group.
        """
        return pulumi.get(self, "option_name")

    @option_name.setter
    def option_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "option_name", value)

    @property
    @pulumi.getter(name="dbSecurityGroupMemberships")
    def db_security_group_memberships(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of DB security groups used for this option.
        """
        return pulumi.get(self, "db_security_group_memberships")

    @db_security_group_memberships.setter
    def db_security_group_memberships(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "db_security_group_memberships", value)

    @property
    @pulumi.getter(name="optionSettings")
    def option_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionSettingArgs']]]]:
        """
        The option settings to include in an option group.
        """
        return pulumi.get(self, "option_settings")

    @option_settings.setter
    def option_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptionGroupOptionSettingArgs']]]]):
        pulumi.set(self, "option_settings", value)

    @property
    @pulumi.getter(name="optionVersion")
    def option_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version for the option.
        """
        return pulumi.get(self, "option_version")

    @option_version.setter
    def option_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "option_version", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The optional port for the option.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupMemberships")
    def vpc_security_group_memberships(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of VPC security group names used for this option.
        """
        return pulumi.get(self, "vpc_security_group_memberships")

    @vpc_security_group_memberships.setter
    def vpc_security_group_memberships(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vpc_security_group_memberships", value)


if not MYPY:
    class OptionGroupOptionSettingArgsDict(TypedDict):
        """
        The ``OptionSetting`` property type specifies the value for an option within an ``OptionSetting`` property.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the option that has settings that you can set.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The current value of the option setting.
        """
elif False:
    OptionGroupOptionSettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OptionGroupOptionSettingArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ``OptionSetting`` property type specifies the value for an option within an ``OptionSetting`` property.
        :param pulumi.Input[builtins.str] name: The name of the option that has settings that you can set.
        :param pulumi.Input[builtins.str] value: The current value of the option setting.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the option that has settings that you can set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current value of the option setting.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


