# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input['RuleResourceType'],
                 retention_period: pulumi.Input['RuleRetentionPeriodArgs'],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 exclude_resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]]] = None,
                 lock_configuration: Optional[pulumi.Input['RuleUnlockDelayArgs']] = None,
                 resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input['RuleResourceType'] resource_type: The resource type retained by the retention rule.
        :param pulumi.Input['RuleRetentionPeriodArgs'] retention_period: Information about the retention period for which the retention rule is to retain resources.
        :param pulumi.Input[builtins.str] description: The description of the retention rule.
        :param pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]] exclude_resource_tags: Information about the exclude resource tags used to identify resources that are excluded by the retention rule.
        :param pulumi.Input['RuleUnlockDelayArgs'] lock_configuration: Information about the retention rule lock configuration.
        :param pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]] resource_tags: Information about the resource tags used to identify resources that are retained by the retention rule.
        :param pulumi.Input[builtins.str] status: The state of the retention rule. Only retention rules that are in the available state retain resources.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Information about the tags assigned to the retention rule.
        """
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "retention_period", retention_period)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_resource_tags is not None:
            pulumi.set(__self__, "exclude_resource_tags", exclude_resource_tags)
        if lock_configuration is not None:
            pulumi.set(__self__, "lock_configuration", lock_configuration)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input['RuleResourceType']:
        """
        The resource type retained by the retention rule.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input['RuleResourceType']):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> pulumi.Input['RuleRetentionPeriodArgs']:
        """
        Information about the retention period for which the retention rule is to retain resources.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: pulumi.Input['RuleRetentionPeriodArgs']):
        pulumi.set(self, "retention_period", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the retention rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="excludeResourceTags")
    def exclude_resource_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]]]:
        """
        Information about the exclude resource tags used to identify resources that are excluded by the retention rule.
        """
        return pulumi.get(self, "exclude_resource_tags")

    @exclude_resource_tags.setter
    def exclude_resource_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]]]):
        pulumi.set(self, "exclude_resource_tags", value)

    @property
    @pulumi.getter(name="lockConfiguration")
    def lock_configuration(self) -> Optional[pulumi.Input['RuleUnlockDelayArgs']]:
        """
        Information about the retention rule lock configuration.
        """
        return pulumi.get(self, "lock_configuration")

    @lock_configuration.setter
    def lock_configuration(self, value: Optional[pulumi.Input['RuleUnlockDelayArgs']]):
        pulumi.set(self, "lock_configuration", value)

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]]]:
        """
        Information about the resource tags used to identify resources that are retained by the retention rule.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleResourceTagArgs']]]]):
        pulumi.set(self, "resource_tags", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the retention rule. Only retention rules that are in the available state retain resources.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Information about the tags assigned to the retention rule.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:rbin:Rule")
class Rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 exclude_resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleResourceTagArgs', 'RuleResourceTagArgsDict']]]]] = None,
                 lock_configuration: Optional[pulumi.Input[Union['RuleUnlockDelayArgs', 'RuleUnlockDelayArgsDict']]] = None,
                 resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleResourceTagArgs', 'RuleResourceTagArgsDict']]]]] = None,
                 resource_type: Optional[pulumi.Input['RuleResourceType']] = None,
                 retention_period: Optional[pulumi.Input[Union['RuleRetentionPeriodArgs', 'RuleRetentionPeriodArgsDict']]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Rbin::Rule

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the retention rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleResourceTagArgs', 'RuleResourceTagArgsDict']]]] exclude_resource_tags: Information about the exclude resource tags used to identify resources that are excluded by the retention rule.
        :param pulumi.Input[Union['RuleUnlockDelayArgs', 'RuleUnlockDelayArgsDict']] lock_configuration: Information about the retention rule lock configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleResourceTagArgs', 'RuleResourceTagArgsDict']]]] resource_tags: Information about the resource tags used to identify resources that are retained by the retention rule.
        :param pulumi.Input['RuleResourceType'] resource_type: The resource type retained by the retention rule.
        :param pulumi.Input[Union['RuleRetentionPeriodArgs', 'RuleRetentionPeriodArgsDict']] retention_period: Information about the retention period for which the retention rule is to retain resources.
        :param pulumi.Input[builtins.str] status: The state of the retention rule. Only retention rules that are in the available state retain resources.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Information about the tags assigned to the retention rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Rbin::Rule

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 exclude_resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleResourceTagArgs', 'RuleResourceTagArgsDict']]]]] = None,
                 lock_configuration: Optional[pulumi.Input[Union['RuleUnlockDelayArgs', 'RuleUnlockDelayArgsDict']]] = None,
                 resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleResourceTagArgs', 'RuleResourceTagArgsDict']]]]] = None,
                 resource_type: Optional[pulumi.Input['RuleResourceType']] = None,
                 retention_period: Optional[pulumi.Input[Union['RuleRetentionPeriodArgs', 'RuleRetentionPeriodArgsDict']]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["exclude_resource_tags"] = exclude_resource_tags
            __props__.__dict__["lock_configuration"] = lock_configuration
            __props__.__dict__["resource_tags"] = resource_tags
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            if retention_period is None and not opts.urn:
                raise TypeError("Missing required property 'retention_period'")
            __props__.__dict__["retention_period"] = retention_period
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["identifier"] = None
            __props__.__dict__["lock_state"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["resourceType"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Rule, __self__).__init__(
            'aws-native:rbin:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RuleArgs.__new__(RuleArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["exclude_resource_tags"] = None
        __props__.__dict__["identifier"] = None
        __props__.__dict__["lock_configuration"] = None
        __props__.__dict__["lock_state"] = None
        __props__.__dict__["resource_tags"] = None
        __props__.__dict__["resource_type"] = None
        __props__.__dict__["retention_period"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        return Rule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Rule Arn is unique for each rule.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the retention rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="excludeResourceTags")
    def exclude_resource_tags(self) -> pulumi.Output[Optional[Sequence['outputs.RuleResourceTag']]]:
        """
        Information about the exclude resource tags used to identify resources that are excluded by the retention rule.
        """
        return pulumi.get(self, "exclude_resource_tags")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        """
        The unique ID of the retention rule.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="lockConfiguration")
    def lock_configuration(self) -> pulumi.Output[Optional['outputs.RuleUnlockDelay']]:
        """
        Information about the retention rule lock configuration.
        """
        return pulumi.get(self, "lock_configuration")

    @property
    @pulumi.getter(name="lockState")
    def lock_state(self) -> pulumi.Output[builtins.str]:
        """
        The lock state for the retention rule.
        """
        return pulumi.get(self, "lock_state")

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> pulumi.Output[Optional[Sequence['outputs.RuleResourceTag']]]:
        """
        Information about the resource tags used to identify resources that are retained by the retention rule.
        """
        return pulumi.get(self, "resource_tags")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output['RuleResourceType']:
        """
        The resource type retained by the retention rule.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> pulumi.Output['outputs.RuleRetentionPeriod']:
        """
        Information about the retention period for which the retention rule is to retain resources.
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The state of the retention rule. Only retention rules that are in the available state retain resources.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Information about the tags assigned to the retention rule.
        """
        return pulumi.get(self, "tags")

