# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'RuleResourceTag',
    'RuleRetentionPeriod',
    'RuleUnlockDelay',
]

@pulumi.output_type
class RuleResourceTag(dict):
    """
    The resource tag of the rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceTagKey":
            suggest = "resource_tag_key"
        elif key == "resourceTagValue":
            suggest = "resource_tag_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleResourceTag. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleResourceTag.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleResourceTag.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_tag_key: builtins.str,
                 resource_tag_value: builtins.str):
        """
        The resource tag of the rule.
        :param builtins.str resource_tag_key: The tag key of the resource.
        :param builtins.str resource_tag_value: The tag value of the resource
        """
        pulumi.set(__self__, "resource_tag_key", resource_tag_key)
        pulumi.set(__self__, "resource_tag_value", resource_tag_value)

    @property
    @pulumi.getter(name="resourceTagKey")
    def resource_tag_key(self) -> builtins.str:
        """
        The tag key of the resource.
        """
        return pulumi.get(self, "resource_tag_key")

    @property
    @pulumi.getter(name="resourceTagValue")
    def resource_tag_value(self) -> builtins.str:
        """
        The tag value of the resource
        """
        return pulumi.get(self, "resource_tag_value")


@pulumi.output_type
class RuleRetentionPeriod(dict):
    """
    The retention period of the rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPeriodUnit":
            suggest = "retention_period_unit"
        elif key == "retentionPeriodValue":
            suggest = "retention_period_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleRetentionPeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleRetentionPeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleRetentionPeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_period_unit: 'RuleRetentionPeriodRetentionPeriodUnit',
                 retention_period_value: builtins.int):
        """
        The retention period of the rule.
        :param 'RuleRetentionPeriodRetentionPeriodUnit' retention_period_unit: The retention period unit of the rule
        :param builtins.int retention_period_value: The retention period value of the rule.
        """
        pulumi.set(__self__, "retention_period_unit", retention_period_unit)
        pulumi.set(__self__, "retention_period_value", retention_period_value)

    @property
    @pulumi.getter(name="retentionPeriodUnit")
    def retention_period_unit(self) -> 'RuleRetentionPeriodRetentionPeriodUnit':
        """
        The retention period unit of the rule
        """
        return pulumi.get(self, "retention_period_unit")

    @property
    @pulumi.getter(name="retentionPeriodValue")
    def retention_period_value(self) -> builtins.int:
        """
        The retention period value of the rule.
        """
        return pulumi.get(self, "retention_period_value")


@pulumi.output_type
class RuleUnlockDelay(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unlockDelayUnit":
            suggest = "unlock_delay_unit"
        elif key == "unlockDelayValue":
            suggest = "unlock_delay_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleUnlockDelay. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleUnlockDelay.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleUnlockDelay.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 unlock_delay_unit: Optional['RuleUnlockDelayUnlockDelayUnit'] = None,
                 unlock_delay_value: Optional[builtins.int] = None):
        """
        :param 'RuleUnlockDelayUnlockDelayUnit' unlock_delay_unit: The unit of time in which to measure the unlock delay. Currently, the unlock delay can be measure only in days.
        :param builtins.int unlock_delay_value: The unlock delay period, measured in the unit specified for UnlockDelayUnit.
        """
        if unlock_delay_unit is not None:
            pulumi.set(__self__, "unlock_delay_unit", unlock_delay_unit)
        if unlock_delay_value is not None:
            pulumi.set(__self__, "unlock_delay_value", unlock_delay_value)

    @property
    @pulumi.getter(name="unlockDelayUnit")
    def unlock_delay_unit(self) -> Optional['RuleUnlockDelayUnlockDelayUnit']:
        """
        The unit of time in which to measure the unlock delay. Currently, the unlock delay can be measure only in days.
        """
        return pulumi.get(self, "unlock_delay_unit")

    @property
    @pulumi.getter(name="unlockDelayValue")
    def unlock_delay_value(self) -> Optional[builtins.int]:
        """
        The unlock delay period, measured in the unit specified for UnlockDelayUnit.
        """
        return pulumi.get(self, "unlock_delay_value")


