# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['ResourceShareArgs', 'ResourceShare']

@pulumi.input_type
class ResourceShareArgs:
    def __init__(__self__, *,
                 allow_external_principals: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 permission_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a ResourceShare resource.
        :param pulumi.Input[builtins.bool] allow_external_principals: Specifies whether principals outside your organization in AWS Organizations can be associated with a resource share. A value of `true` lets you share with individual AWS accounts that are not in your organization. A value of `false` only has meaning if your account is a member of an AWS Organization. The default value is `true`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the resource share.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permission_arns: Specifies the [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the AWS RAM permission to associate with the resource share. If you do not specify an ARN for the permission, AWS RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] principals: Specifies the principals to associate with the resource share. The possible values are:
               
               - An AWS account ID
               
               - An Amazon Resource Name (ARN) of an organization in AWS Organizations
               
               - An ARN of an organizational unit (OU) in AWS Organizations
               
               - An ARN of an IAM role
               
               - An ARN of an IAM user
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resource_arns: Specifies a list of one or more ARNs of the resources to associate with the resource share.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sources: Specifies from which source accounts the service principal has access to the resources in this resource share.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Specifies one or more tags to attach to the resource share itself. It doesn't attach the tags to the resources associated with the resource share.
        """
        if allow_external_principals is not None:
            pulumi.set(__self__, "allow_external_principals", allow_external_principals)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permission_arns is not None:
            pulumi.set(__self__, "permission_arns", permission_arns)
        if principals is not None:
            pulumi.set(__self__, "principals", principals)
        if resource_arns is not None:
            pulumi.set(__self__, "resource_arns", resource_arns)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="allowExternalPrincipals")
    def allow_external_principals(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether principals outside your organization in AWS Organizations can be associated with a resource share. A value of `true` lets you share with individual AWS accounts that are not in your organization. A value of `false` only has meaning if your account is a member of an AWS Organization. The default value is `true`.
        """
        return pulumi.get(self, "allow_external_principals")

    @allow_external_principals.setter
    def allow_external_principals(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_external_principals", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the resource share.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="permissionArns")
    def permission_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the AWS RAM permission to associate with the resource share. If you do not specify an ARN for the permission, AWS RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.
        """
        return pulumi.get(self, "permission_arns")

    @permission_arns.setter
    def permission_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "permission_arns", value)

    @property
    @pulumi.getter
    def principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the principals to associate with the resource share. The possible values are:

        - An AWS account ID

        - An Amazon Resource Name (ARN) of an organization in AWS Organizations

        - An ARN of an organizational unit (OU) in AWS Organizations

        - An ARN of an IAM role

        - An ARN of an IAM user
        """
        return pulumi.get(self, "principals")

    @principals.setter
    def principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "principals", value)

    @property
    @pulumi.getter(name="resourceArns")
    def resource_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of one or more ARNs of the resources to associate with the resource share.
        """
        return pulumi.get(self, "resource_arns")

    @resource_arns.setter
    def resource_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "resource_arns", value)

    @property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies from which source accounts the service principal has access to the resources in this resource share.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Specifies one or more tags to attach to the resource share itself. It doesn't attach the tags to the resources associated with the resource share.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:ram:ResourceShare")
class ResourceShare(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_external_principals: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 permission_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource type definition for AWS::RAM::ResourceShare

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        myresourceshare = aws_native.ram.ResourceShare("myresourceshare",
            name="My Resource Share",
            resource_arns=["arn:aws:ec2:us-east-1:123456789012:resource-type/12345678-1234-1234-1234-12345678"],
            principals=["210987654321"],
            tags=[
                {
                    "key": "Key1",
                    "value": "Value1",
                },
                {
                    "key": "Key2",
                    "value": "Value2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        myresourceshare = aws_native.ram.ResourceShare("myresourceshare",
            name="My Resource Share",
            resource_arns=["arn:aws:ec2:us-east-1:123456789012:resource-type/12345678-1234-1234-1234-12345678"],
            principals=["210987654321"],
            tags=[
                {
                    "key": "Key1",
                    "value": "Value1",
                },
                {
                    "key": "Key2",
                    "value": "Value2",
                },
            ])

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_external_principals: Specifies whether principals outside your organization in AWS Organizations can be associated with a resource share. A value of `true` lets you share with individual AWS accounts that are not in your organization. A value of `false` only has meaning if your account is a member of an AWS Organization. The default value is `true`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the resource share.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permission_arns: Specifies the [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the AWS RAM permission to associate with the resource share. If you do not specify an ARN for the permission, AWS RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] principals: Specifies the principals to associate with the resource share. The possible values are:
               
               - An AWS account ID
               
               - An Amazon Resource Name (ARN) of an organization in AWS Organizations
               
               - An ARN of an organizational unit (OU) in AWS Organizations
               
               - An ARN of an IAM role
               
               - An ARN of an IAM user
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resource_arns: Specifies a list of one or more ARNs of the resources to associate with the resource share.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sources: Specifies from which source accounts the service principal has access to the resources in this resource share.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Specifies one or more tags to attach to the resource share itself. It doesn't attach the tags to the resources associated with the resource share.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ResourceShareArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource type definition for AWS::RAM::ResourceShare

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        myresourceshare = aws_native.ram.ResourceShare("myresourceshare",
            name="My Resource Share",
            resource_arns=["arn:aws:ec2:us-east-1:123456789012:resource-type/12345678-1234-1234-1234-12345678"],
            principals=["210987654321"],
            tags=[
                {
                    "key": "Key1",
                    "value": "Value1",
                },
                {
                    "key": "Key2",
                    "value": "Value2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        myresourceshare = aws_native.ram.ResourceShare("myresourceshare",
            name="My Resource Share",
            resource_arns=["arn:aws:ec2:us-east-1:123456789012:resource-type/12345678-1234-1234-1234-12345678"],
            principals=["210987654321"],
            tags=[
                {
                    "key": "Key1",
                    "value": "Value1",
                },
                {
                    "key": "Key2",
                    "value": "Value2",
                },
            ])

        ```

        :param str resource_name: The name of the resource.
        :param ResourceShareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceShareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_external_principals: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 permission_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceShareArgs.__new__(ResourceShareArgs)

            __props__.__dict__["allow_external_principals"] = allow_external_principals
            __props__.__dict__["name"] = name
            __props__.__dict__["permission_arns"] = permission_arns
            __props__.__dict__["principals"] = principals
            __props__.__dict__["resource_arns"] = resource_arns
            __props__.__dict__["sources"] = sources
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
        super(ResourceShare, __self__).__init__(
            'aws-native:ram:ResourceShare',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ResourceShare':
        """
        Get an existing ResourceShare resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ResourceShareArgs.__new__(ResourceShareArgs)

        __props__.__dict__["allow_external_principals"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["permission_arns"] = None
        __props__.__dict__["principals"] = None
        __props__.__dict__["resource_arns"] = None
        __props__.__dict__["sources"] = None
        __props__.__dict__["tags"] = None
        return ResourceShare(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowExternalPrincipals")
    def allow_external_principals(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether principals outside your organization in AWS Organizations can be associated with a resource share. A value of `true` lets you share with individual AWS accounts that are not in your organization. A value of `false` only has meaning if your account is a member of an AWS Organization. The default value is `true`.
        """
        return pulumi.get(self, "allow_external_principals")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the resource share.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the resource share.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="permissionArns")
    def permission_arns(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies the [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the AWS RAM permission to associate with the resource share. If you do not specify an ARN for the permission, AWS RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.
        """
        return pulumi.get(self, "permission_arns")

    @property
    @pulumi.getter
    def principals(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies the principals to associate with the resource share. The possible values are:

        - An AWS account ID

        - An Amazon Resource Name (ARN) of an organization in AWS Organizations

        - An ARN of an organizational unit (OU) in AWS Organizations

        - An ARN of an IAM role

        - An ARN of an IAM user
        """
        return pulumi.get(self, "principals")

    @property
    @pulumi.getter(name="resourceArns")
    def resource_arns(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies a list of one or more ARNs of the resources to associate with the resource share.
        """
        return pulumi.get(self, "resource_arns")

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies from which source accounts the service principal has access to the resources in this resource share.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Specifies one or more tags to attach to the resource share itself. It doesn't attach the tags to the resources associated with the resource share.
        """
        return pulumi.get(self, "tags")

