# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetResourceShareResult',
    'AwaitableGetResourceShareResult',
    'get_resource_share',
    'get_resource_share_output',
]

@pulumi.output_type
class GetResourceShareResult:
    def __init__(__self__, allow_external_principals=None, arn=None, name=None, tags=None):
        if allow_external_principals and not isinstance(allow_external_principals, bool):
            raise TypeError("Expected argument 'allow_external_principals' to be a bool")
        pulumi.set(__self__, "allow_external_principals", allow_external_principals)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="allowExternalPrincipals")
    def allow_external_principals(self) -> Optional[builtins.bool]:
        """
        Specifies whether principals outside your organization in AWS Organizations can be associated with a resource share. A value of `true` lets you share with individual AWS accounts that are not in your organization. A value of `false` only has meaning if your account is a member of an AWS Organization. The default value is `true`.
        """
        return pulumi.get(self, "allow_external_principals")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the resource share.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Specifies the name of the resource share.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Specifies one or more tags to attach to the resource share itself. It doesn't attach the tags to the resources associated with the resource share.
        """
        return pulumi.get(self, "tags")


class AwaitableGetResourceShareResult(GetResourceShareResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceShareResult(
            allow_external_principals=self.allow_external_principals,
            arn=self.arn,
            name=self.name,
            tags=self.tags)


def get_resource_share(arn: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceShareResult:
    """
    Resource type definition for AWS::RAM::ResourceShare


    :param builtins.str arn: The Amazon Resource Name (ARN) of the resource share.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ram:getResourceShare', __args__, opts=opts, typ=GetResourceShareResult).value

    return AwaitableGetResourceShareResult(
        allow_external_principals=pulumi.get(__ret__, 'allow_external_principals'),
        arn=pulumi.get(__ret__, 'arn'),
        name=pulumi.get(__ret__, 'name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_resource_share_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceShareResult]:
    """
    Resource type definition for AWS::RAM::ResourceShare


    :param builtins.str arn: The Amazon Resource Name (ARN) of the resource share.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ram:getResourceShare', __args__, opts=opts, typ=GetResourceShareResult)
    return __ret__.apply(lambda __response__: GetResourceShareResult(
        allow_external_principals=pulumi.get(__response__, 'allow_external_principals'),
        arn=pulumi.get(__response__, 'arn'),
        name=pulumi.get(__response__, 'name'),
        tags=pulumi.get(__response__, 'tags')))
