# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetTopicResult',
    'AwaitableGetTopicResult',
    'get_topic',
    'get_topic_output',
]

@pulumi.output_type
class GetTopicResult:
    def __init__(__self__, arn=None, config_options=None, data_sets=None, description=None, name=None, user_experience_version=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if config_options and not isinstance(config_options, dict):
            raise TypeError("Expected argument 'config_options' to be a dict")
        pulumi.set(__self__, "config_options", config_options)
        if data_sets and not isinstance(data_sets, list):
            raise TypeError("Expected argument 'data_sets' to be a list")
        pulumi.set(__self__, "data_sets", data_sets)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if user_experience_version and not isinstance(user_experience_version, str):
            raise TypeError("Expected argument 'user_experience_version' to be a str")
        pulumi.set(__self__, "user_experience_version", user_experience_version)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the topic.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="configOptions")
    def config_options(self) -> Optional['outputs.TopicConfigOptions']:
        """
        Configuration options for a `Topic` .
        """
        return pulumi.get(self, "config_options")

    @property
    @pulumi.getter(name="dataSets")
    def data_sets(self) -> Optional[Sequence['outputs.TopicDatasetMetadata']]:
        """
        The data sets that the topic is associated with.
        """
        return pulumi.get(self, "data_sets")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the topic.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the topic.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="userExperienceVersion")
    def user_experience_version(self) -> Optional['TopicUserExperienceVersion']:
        """
        The user experience version of the topic.
        """
        return pulumi.get(self, "user_experience_version")


class AwaitableGetTopicResult(GetTopicResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTopicResult(
            arn=self.arn,
            config_options=self.config_options,
            data_sets=self.data_sets,
            description=self.description,
            name=self.name,
            user_experience_version=self.user_experience_version)


def get_topic(aws_account_id: Optional[builtins.str] = None,
              topic_id: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTopicResult:
    """
    Definition of the AWS::QuickSight::Topic Resource Type.


    :param builtins.str aws_account_id: The ID of the AWS account that you want to create a topic in.
    :param builtins.str topic_id: The ID for the topic. This ID is unique per AWS Region for each AWS account.
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['topicId'] = topic_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:quicksight:getTopic', __args__, opts=opts, typ=GetTopicResult).value

    return AwaitableGetTopicResult(
        arn=pulumi.get(__ret__, 'arn'),
        config_options=pulumi.get(__ret__, 'config_options'),
        data_sets=pulumi.get(__ret__, 'data_sets'),
        description=pulumi.get(__ret__, 'description'),
        name=pulumi.get(__ret__, 'name'),
        user_experience_version=pulumi.get(__ret__, 'user_experience_version'))
def get_topic_output(aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
                     topic_id: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTopicResult]:
    """
    Definition of the AWS::QuickSight::Topic Resource Type.


    :param builtins.str aws_account_id: The ID of the AWS account that you want to create a topic in.
    :param builtins.str topic_id: The ID for the topic. This ID is unique per AWS Region for each AWS account.
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['topicId'] = topic_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:quicksight:getTopic', __args__, opts=opts, typ=GetTopicResult)
    return __ret__.apply(lambda __response__: GetTopicResult(
        arn=pulumi.get(__response__, 'arn'),
        config_options=pulumi.get(__response__, 'config_options'),
        data_sets=pulumi.get(__response__, 'data_sets'),
        description=pulumi.get(__response__, 'description'),
        name=pulumi.get(__response__, 'name'),
        user_experience_version=pulumi.get(__response__, 'user_experience_version')))
