# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetCustomPermissionsResult',
    'AwaitableGetCustomPermissionsResult',
    'get_custom_permissions',
    'get_custom_permissions_output',
]

@pulumi.output_type
class GetCustomPermissionsResult:
    def __init__(__self__, arn=None, capabilities=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if capabilities and not isinstance(capabilities, dict):
            raise TypeError("Expected argument 'capabilities' to be a dict")
        pulumi.set(__self__, "capabilities", capabilities)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the custom permissions profile.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def capabilities(self) -> Optional['outputs.CustomPermissionsCapabilities']:
        """
        A set of actions in the custom permissions profile.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags to associate with the custom permissions profile.
        """
        return pulumi.get(self, "tags")


class AwaitableGetCustomPermissionsResult(GetCustomPermissionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomPermissionsResult(
            arn=self.arn,
            capabilities=self.capabilities,
            tags=self.tags)


def get_custom_permissions(aws_account_id: Optional[builtins.str] = None,
                           custom_permissions_name: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomPermissionsResult:
    """
    Definition of the AWS::QuickSight::CustomPermissions Resource Type.


    :param builtins.str aws_account_id: The ID of the AWS account that contains the custom permission configuration that you want to update.
    :param builtins.str custom_permissions_name: The name of the custom permissions profile.
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['customPermissionsName'] = custom_permissions_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:quicksight:getCustomPermissions', __args__, opts=opts, typ=GetCustomPermissionsResult).value

    return AwaitableGetCustomPermissionsResult(
        arn=pulumi.get(__ret__, 'arn'),
        capabilities=pulumi.get(__ret__, 'capabilities'),
        tags=pulumi.get(__ret__, 'tags'))
def get_custom_permissions_output(aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
                                  custom_permissions_name: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomPermissionsResult]:
    """
    Definition of the AWS::QuickSight::CustomPermissions Resource Type.


    :param builtins.str aws_account_id: The ID of the AWS account that contains the custom permission configuration that you want to update.
    :param builtins.str custom_permissions_name: The name of the custom permissions profile.
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['customPermissionsName'] = custom_permissions_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:quicksight:getCustomPermissions', __args__, opts=opts, typ=GetCustomPermissionsResult)
    return __ret__.apply(lambda __response__: GetCustomPermissionsResult(
        arn=pulumi.get(__response__, 'arn'),
        capabilities=pulumi.get(__response__, 'capabilities'),
        tags=pulumi.get(__response__, 'tags')))
