# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['FolderArgs', 'Folder']

@pulumi.input_type
class FolderArgs:
    def __init__(__self__, *,
                 aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[builtins.str]] = None,
                 folder_type: Optional[pulumi.Input['FolderType']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_folder_arn: Optional[pulumi.Input[builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['FolderResourcePermissionArgs']]]] = None,
                 sharing_model: Optional[pulumi.Input['FolderSharingModel']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Folder resource.
        :param pulumi.Input[builtins.str] aws_account_id: The ID for the AWS account where you want to create the folder.
        :param pulumi.Input[builtins.str] folder_id: The ID of the folder.
        :param pulumi.Input['FolderType'] folder_type: The type of folder it is.
        :param pulumi.Input[builtins.str] name: A display name for the folder.
        :param pulumi.Input[builtins.str] parent_folder_arn: The Amazon Resource Name (ARN) for the folder.
        :param pulumi.Input[Sequence[pulumi.Input['FolderResourcePermissionArgs']]] permissions: A structure that describes the principals and the resource-level permissions of a folder.
               
               To specify no permissions, omit `Permissions` .
        :param pulumi.Input['FolderSharingModel'] sharing_model: The sharing scope of the folder.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of tags for the folders that you want to apply overrides to.
        """
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if folder_type is not None:
            pulumi.set(__self__, "folder_type", folder_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_folder_arn is not None:
            pulumi.set(__self__, "parent_folder_arn", parent_folder_arn)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if sharing_model is not None:
            pulumi.set(__self__, "sharing_model", sharing_model)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID for the AWS account where you want to create the folder.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the folder.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="folderType")
    def folder_type(self) -> Optional[pulumi.Input['FolderType']]:
        """
        The type of folder it is.
        """
        return pulumi.get(self, "folder_type")

    @folder_type.setter
    def folder_type(self, value: Optional[pulumi.Input['FolderType']]):
        pulumi.set(self, "folder_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A display name for the folder.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentFolderArn")
    def parent_folder_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the folder.
        """
        return pulumi.get(self, "parent_folder_arn")

    @parent_folder_arn.setter
    def parent_folder_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_folder_arn", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FolderResourcePermissionArgs']]]]:
        """
        A structure that describes the principals and the resource-level permissions of a folder.

        To specify no permissions, omit `Permissions` .
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FolderResourcePermissionArgs']]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="sharingModel")
    def sharing_model(self) -> Optional[pulumi.Input['FolderSharingModel']]:
        """
        The sharing scope of the folder.
        """
        return pulumi.get(self, "sharing_model")

    @sharing_model.setter
    def sharing_model(self, value: Optional[pulumi.Input['FolderSharingModel']]):
        pulumi.set(self, "sharing_model", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of tags for the folders that you want to apply overrides to.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:quicksight:Folder")
class Folder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[builtins.str]] = None,
                 folder_type: Optional[pulumi.Input['FolderType']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_folder_arn: Optional[pulumi.Input[builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FolderResourcePermissionArgs', 'FolderResourcePermissionArgsDict']]]]] = None,
                 sharing_model: Optional[pulumi.Input['FolderSharingModel']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of the AWS::QuickSight::Folder Resource Type.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] aws_account_id: The ID for the AWS account where you want to create the folder.
        :param pulumi.Input[builtins.str] folder_id: The ID of the folder.
        :param pulumi.Input['FolderType'] folder_type: The type of folder it is.
        :param pulumi.Input[builtins.str] name: A display name for the folder.
        :param pulumi.Input[builtins.str] parent_folder_arn: The Amazon Resource Name (ARN) for the folder.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FolderResourcePermissionArgs', 'FolderResourcePermissionArgsDict']]]] permissions: A structure that describes the principals and the resource-level permissions of a folder.
               
               To specify no permissions, omit `Permissions` .
        :param pulumi.Input['FolderSharingModel'] sharing_model: The sharing scope of the folder.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of tags for the folders that you want to apply overrides to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FolderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of the AWS::QuickSight::Folder Resource Type.

        :param str resource_name: The name of the resource.
        :param FolderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FolderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[builtins.str]] = None,
                 folder_type: Optional[pulumi.Input['FolderType']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_folder_arn: Optional[pulumi.Input[builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FolderResourcePermissionArgs', 'FolderResourcePermissionArgsDict']]]]] = None,
                 sharing_model: Optional[pulumi.Input['FolderSharingModel']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FolderArgs.__new__(FolderArgs)

            __props__.__dict__["aws_account_id"] = aws_account_id
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["folder_type"] = folder_type
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_folder_arn"] = parent_folder_arn
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["sharing_model"] = sharing_model
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["last_updated_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["awsAccountId", "folderId", "folderType", "parentFolderArn", "sharingModel"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Folder, __self__).__init__(
            'aws-native:quicksight:Folder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Folder':
        """
        Get an existing Folder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FolderArgs.__new__(FolderArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_account_id"] = None
        __props__.__dict__["created_time"] = None
        __props__.__dict__["folder_id"] = None
        __props__.__dict__["folder_type"] = None
        __props__.__dict__["last_updated_time"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["parent_folder_arn"] = None
        __props__.__dict__["permissions"] = None
        __props__.__dict__["sharing_model"] = None
        __props__.__dict__["tags"] = None
        return Folder(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        <p>The Amazon Resource Name (ARN) for the folder.</p>
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID for the AWS account where you want to create the folder.
        """
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[builtins.str]:
        """
        <p>The time that the folder was created.</p>
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the folder.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter(name="folderType")
    def folder_type(self) -> pulumi.Output[Optional['FolderType']]:
        """
        The type of folder it is.
        """
        return pulumi.get(self, "folder_type")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> pulumi.Output[builtins.str]:
        """
        <p>The time that the folder was last updated.</p>
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A display name for the folder.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentFolderArn")
    def parent_folder_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the folder.
        """
        return pulumi.get(self, "parent_folder_arn")

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Optional[Sequence['outputs.FolderResourcePermission']]]:
        """
        A structure that describes the principals and the resource-level permissions of a folder.

        To specify no permissions, omit `Permissions` .
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="sharingModel")
    def sharing_model(self) -> pulumi.Output[Optional['FolderSharingModel']]:
        """
        The sharing scope of the folder.
        """
        return pulumi.get(self, "sharing_model")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of tags for the folders that you want to apply overrides to.
        """
        return pulumi.get(self, "tags")

