# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['RetrieverArgs', 'Retriever']

@pulumi.input_type
class RetrieverArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[builtins.str],
                 configuration: pulumi.Input[Union['RetrieverConfiguration0PropertiesArgs', 'RetrieverConfiguration1PropertiesArgs']],
                 display_name: pulumi.Input[builtins.str],
                 type: pulumi.Input['RetrieverType'],
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Retriever resource.
        :param pulumi.Input[builtins.str] application_id: The identifier of the Amazon Q Business application using the retriever.
        :param pulumi.Input[Union['RetrieverConfiguration0PropertiesArgs', 'RetrieverConfiguration1PropertiesArgs']] configuration: Provides information on how the retriever used for your Amazon Q Business application is configured.
        :param pulumi.Input[builtins.str] display_name: The name of your retriever.
        :param pulumi.Input['RetrieverType'] type: The type of your retriever.
        :param pulumi.Input[builtins.str] role_arn: The ARN of an IAM role used by Amazon Q Business to access the basic authentication credentials stored in a Secrets Manager secret.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of key-value pairs that identify or categorize the retriever. You can also use tags to help control access to the retriever. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "type", type)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the Amazon Q Business application using the retriever.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Input[Union['RetrieverConfiguration0PropertiesArgs', 'RetrieverConfiguration1PropertiesArgs']]:
        """
        Provides information on how the retriever used for your Amazon Q Business application is configured.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input[Union['RetrieverConfiguration0PropertiesArgs', 'RetrieverConfiguration1PropertiesArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of your retriever.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['RetrieverType']:
        """
        The type of your retriever.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['RetrieverType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of an IAM role used by Amazon Q Business to access the basic authentication credentials stored in a Secrets Manager secret.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of key-value pairs that identify or categorize the retriever. You can also use tags to help control access to the retriever. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:qbusiness:Retriever")
class Retriever(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union[Union['RetrieverConfiguration0PropertiesArgs', 'RetrieverConfiguration0PropertiesArgsDict'], Union['RetrieverConfiguration1PropertiesArgs', 'RetrieverConfiguration1PropertiesArgsDict']]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input['RetrieverType']] = None,
                 __props__=None):
        """
        Definition of AWS::QBusiness::Retriever Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: The identifier of the Amazon Q Business application using the retriever.
        :param pulumi.Input[Union[Union['RetrieverConfiguration0PropertiesArgs', 'RetrieverConfiguration0PropertiesArgsDict'], Union['RetrieverConfiguration1PropertiesArgs', 'RetrieverConfiguration1PropertiesArgsDict']]] configuration: Provides information on how the retriever used for your Amazon Q Business application is configured.
        :param pulumi.Input[builtins.str] display_name: The name of your retriever.
        :param pulumi.Input[builtins.str] role_arn: The ARN of an IAM role used by Amazon Q Business to access the basic authentication credentials stored in a Secrets Manager secret.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of key-value pairs that identify or categorize the retriever. You can also use tags to help control access to the retriever. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        :param pulumi.Input['RetrieverType'] type: The type of your retriever.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RetrieverArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::QBusiness::Retriever Resource Type

        :param str resource_name: The name of the resource.
        :param RetrieverArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RetrieverArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union[Union['RetrieverConfiguration0PropertiesArgs', 'RetrieverConfiguration0PropertiesArgsDict'], Union['RetrieverConfiguration1PropertiesArgs', 'RetrieverConfiguration1PropertiesArgsDict']]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input['RetrieverType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RetrieverArgs.__new__(RetrieverArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["retriever_arn"] = None
            __props__.__dict__["retriever_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["applicationId", "type"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Retriever, __self__).__init__(
            'aws-native:qbusiness:Retriever',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Retriever':
        """
        Get an existing Retriever resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RetrieverArgs.__new__(RetrieverArgs)

        __props__.__dict__["application_id"] = None
        __props__.__dict__["configuration"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["retriever_arn"] = None
        __props__.__dict__["retriever_id"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["updated_at"] = None
        return Retriever(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon Q Business application using the retriever.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Any]:
        """
        Provides information on how the retriever used for your Amazon Q Business application is configured.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The Unix timestamp when the retriever was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of your retriever.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="retrieverArn")
    def retriever_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role associated with the retriever.
        """
        return pulumi.get(self, "retriever_arn")

    @property
    @pulumi.getter(name="retrieverId")
    def retriever_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the retriever used by your Amazon Q Business application.
        """
        return pulumi.get(self, "retriever_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARN of an IAM role used by Amazon Q Business to access the basic authentication credentials stored in a Secrets Manager secret.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['RetrieverStatus']:
        """
        The status of your retriever.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of key-value pairs that identify or categorize the retriever. You can also use tags to help control access to the retriever. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output['RetrieverType']:
        """
        The type of your retriever.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The Unix timestamp when the retriever was last updated.
        """
        return pulumi.get(self, "updated_at")

