# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PermissionArgs', 'Permission']

@pulumi.input_type
class PermissionArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 application_id: pulumi.Input[builtins.str],
                 principal: pulumi.Input[builtins.str],
                 statement_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a Permission resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] actions: The list of Amazon Q Business actions that the ISV is allowed to perform.
        :param pulumi.Input[builtins.str] application_id: The unique identifier of the Amazon Q Business application.
        :param pulumi.Input[builtins.str] principal: Provides user and group information used for filtering documents to use for generating Amazon Q Business conversation responses.
        :param pulumi.Input[builtins.str] statement_id: A unique identifier for the policy statement.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "principal", principal)
        pulumi.set(__self__, "statement_id", statement_id)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The list of Amazon Q Business actions that the ISV is allowed to perform.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        The unique identifier of the Amazon Q Business application.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Input[builtins.str]:
        """
        Provides user and group information used for filtering documents to use for generating Amazon Q Business conversation responses.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "principal", value)

    @property
    @pulumi.getter(name="statementId")
    def statement_id(self) -> pulumi.Input[builtins.str]:
        """
        A unique identifier for the policy statement.
        """
        return pulumi.get(self, "statement_id")

    @statement_id.setter
    def statement_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "statement_id", value)


@pulumi.type_token("aws-native:qbusiness:Permission")
class Permission(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 principal: Optional[pulumi.Input[builtins.str]] = None,
                 statement_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Definition of AWS::QBusiness::Permission Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] actions: The list of Amazon Q Business actions that the ISV is allowed to perform.
        :param pulumi.Input[builtins.str] application_id: The unique identifier of the Amazon Q Business application.
        :param pulumi.Input[builtins.str] principal: Provides user and group information used for filtering documents to use for generating Amazon Q Business conversation responses.
        :param pulumi.Input[builtins.str] statement_id: A unique identifier for the policy statement.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::QBusiness::Permission Resource Type

        :param str resource_name: The name of the resource.
        :param PermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 principal: Optional[pulumi.Input[builtins.str]] = None,
                 statement_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PermissionArgs.__new__(PermissionArgs)

            if actions is None and not opts.urn:
                raise TypeError("Missing required property 'actions'")
            __props__.__dict__["actions"] = actions
            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            if principal is None and not opts.urn:
                raise TypeError("Missing required property 'principal'")
            __props__.__dict__["principal"] = principal
            if statement_id is None and not opts.urn:
                raise TypeError("Missing required property 'statement_id'")
            __props__.__dict__["statement_id"] = statement_id
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["actions[*]", "applicationId", "principal", "statementId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Permission, __self__).__init__(
            'aws-native:qbusiness:Permission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Permission':
        """
        Get an existing Permission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PermissionArgs.__new__(PermissionArgs)

        __props__.__dict__["actions"] = None
        __props__.__dict__["application_id"] = None
        __props__.__dict__["principal"] = None
        __props__.__dict__["statement_id"] = None
        return Permission(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of Amazon Q Business actions that the ISV is allowed to perform.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier of the Amazon Q Business application.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Output[builtins.str]:
        """
        Provides user and group information used for filtering documents to use for generating Amazon Q Business conversation responses.
        """
        return pulumi.get(self, "principal")

    @property
    @pulumi.getter(name="statementId")
    def statement_id(self) -> pulumi.Output[builtins.str]:
        """
        A unique identifier for the policy statement.
        """
        return pulumi.get(self, "statement_id")

