# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['IndexArgs', 'Index']

@pulumi.input_type
class IndexArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 capacity_configuration: Optional[pulumi.Input['IndexCapacityConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 document_attribute_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['IndexDocumentAttributeConfigurationArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 type: Optional[pulumi.Input['IndexType']] = None):
        """
        The set of arguments for constructing a Index resource.
        :param pulumi.Input[builtins.str] application_id: The identifier of the Amazon Q Business application using the index.
        :param pulumi.Input[builtins.str] display_name: The name of the index.
        :param pulumi.Input['IndexCapacityConfigurationArgs'] capacity_configuration: The capacity units you want to provision for your index. You can add and remove capacity to fit your usage needs.
        :param pulumi.Input[builtins.str] description: A description for the Amazon Q Business index.
        :param pulumi.Input[Sequence[pulumi.Input['IndexDocumentAttributeConfigurationArgs']]] document_attribute_configurations: Configuration information for document attributes. Document attributes are metadata or fields associated with your documents. For example, the company department name associated with each document.
               
               For more information, see [Understanding document attributes](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes.html) .
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of key-value pairs that identify or categorize the index. You can also use tags to help control access to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        :param pulumi.Input['IndexType'] type: The index type that's suitable for your needs. For more information on what's included in each type of index, see [Amazon Q Business tiers](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#index-tiers) .
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "display_name", display_name)
        if capacity_configuration is not None:
            pulumi.set(__self__, "capacity_configuration", capacity_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if document_attribute_configurations is not None:
            pulumi.set(__self__, "document_attribute_configurations", document_attribute_configurations)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the Amazon Q Business application using the index.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the index.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="capacityConfiguration")
    def capacity_configuration(self) -> Optional[pulumi.Input['IndexCapacityConfigurationArgs']]:
        """
        The capacity units you want to provision for your index. You can add and remove capacity to fit your usage needs.
        """
        return pulumi.get(self, "capacity_configuration")

    @capacity_configuration.setter
    def capacity_configuration(self, value: Optional[pulumi.Input['IndexCapacityConfigurationArgs']]):
        pulumi.set(self, "capacity_configuration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the Amazon Q Business index.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="documentAttributeConfigurations")
    def document_attribute_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexDocumentAttributeConfigurationArgs']]]]:
        """
        Configuration information for document attributes. Document attributes are metadata or fields associated with your documents. For example, the company department name associated with each document.

        For more information, see [Understanding document attributes](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes.html) .
        """
        return pulumi.get(self, "document_attribute_configurations")

    @document_attribute_configurations.setter
    def document_attribute_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexDocumentAttributeConfigurationArgs']]]]):
        pulumi.set(self, "document_attribute_configurations", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of key-value pairs that identify or categorize the index. You can also use tags to help control access to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['IndexType']]:
        """
        The index type that's suitable for your needs. For more information on what's included in each type of index, see [Amazon Q Business tiers](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#index-tiers) .
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['IndexType']]):
        pulumi.set(self, "type", value)


@pulumi.type_token("aws-native:qbusiness:Index")
class Index(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_configuration: Optional[pulumi.Input[Union['IndexCapacityConfigurationArgs', 'IndexCapacityConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 document_attribute_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IndexDocumentAttributeConfigurationArgs', 'IndexDocumentAttributeConfigurationArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input['IndexType']] = None,
                 __props__=None):
        """
        Definition of AWS::QBusiness::Index Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: The identifier of the Amazon Q Business application using the index.
        :param pulumi.Input[Union['IndexCapacityConfigurationArgs', 'IndexCapacityConfigurationArgsDict']] capacity_configuration: The capacity units you want to provision for your index. You can add and remove capacity to fit your usage needs.
        :param pulumi.Input[builtins.str] description: A description for the Amazon Q Business index.
        :param pulumi.Input[builtins.str] display_name: The name of the index.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IndexDocumentAttributeConfigurationArgs', 'IndexDocumentAttributeConfigurationArgsDict']]]] document_attribute_configurations: Configuration information for document attributes. Document attributes are metadata or fields associated with your documents. For example, the company department name associated with each document.
               
               For more information, see [Understanding document attributes](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes.html) .
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of key-value pairs that identify or categorize the index. You can also use tags to help control access to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        :param pulumi.Input['IndexType'] type: The index type that's suitable for your needs. For more information on what's included in each type of index, see [Amazon Q Business tiers](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#index-tiers) .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IndexArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::QBusiness::Index Resource Type

        :param str resource_name: The name of the resource.
        :param IndexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IndexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_configuration: Optional[pulumi.Input[Union['IndexCapacityConfigurationArgs', 'IndexCapacityConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 document_attribute_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IndexDocumentAttributeConfigurationArgs', 'IndexDocumentAttributeConfigurationArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input['IndexType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IndexArgs.__new__(IndexArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["capacity_configuration"] = capacity_configuration
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["document_attribute_configurations"] = document_attribute_configurations
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["index_arn"] = None
            __props__.__dict__["index_id"] = None
            __props__.__dict__["index_statistics"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["applicationId", "type"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Index, __self__).__init__(
            'aws-native:qbusiness:Index',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Index':
        """
        Get an existing Index resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IndexArgs.__new__(IndexArgs)

        __props__.__dict__["application_id"] = None
        __props__.__dict__["capacity_configuration"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["document_attribute_configurations"] = None
        __props__.__dict__["index_arn"] = None
        __props__.__dict__["index_id"] = None
        __props__.__dict__["index_statistics"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["updated_at"] = None
        return Index(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon Q Business application using the index.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="capacityConfiguration")
    def capacity_configuration(self) -> pulumi.Output[Optional['outputs.IndexCapacityConfiguration']]:
        """
        The capacity units you want to provision for your index. You can add and remove capacity to fit your usage needs.
        """
        return pulumi.get(self, "capacity_configuration")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The Unix timestamp when the index was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for the Amazon Q Business index.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the index.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="documentAttributeConfigurations")
    def document_attribute_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.IndexDocumentAttributeConfiguration']]]:
        """
        Configuration information for document attributes. Document attributes are metadata or fields associated with your documents. For example, the company department name associated with each document.

        For more information, see [Understanding document attributes](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes.html) .
        """
        return pulumi.get(self, "document_attribute_configurations")

    @property
    @pulumi.getter(name="indexArn")
    def index_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of an Amazon Q Business index.
        """
        return pulumi.get(self, "index_arn")

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier for the index.
        """
        return pulumi.get(self, "index_id")

    @property
    @pulumi.getter(name="indexStatistics")
    def index_statistics(self) -> pulumi.Output['outputs.IndexStatistics']:
        return pulumi.get(self, "index_statistics")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['IndexStatus']:
        """
        The current status of the index. When the status is `ACTIVE` , the index is ready.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of key-value pairs that identify or categorize the index. You can also use tags to help control access to the index. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional['IndexType']]:
        """
        The index type that's suitable for your needs. For more information on what's included in each type of index, see [Amazon Q Business tiers](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/tiers.html#index-tiers) .
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The Unix timestamp when the index was last updated.
        """
        return pulumi.get(self, "updated_at")

