# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DataSourceArgs', 'DataSource']

@pulumi.input_type
class DataSourceArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[builtins.str],
                 configuration: Any,
                 display_name: pulumi.Input[builtins.str],
                 index_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 document_enrichment_configuration: Optional[pulumi.Input['DataSourceDocumentEnrichmentConfigurationArgs']] = None,
                 media_extraction_configuration: Optional[pulumi.Input['DataSourceMediaExtractionConfigurationArgs']] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 sync_schedule: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 vpc_configuration: Optional[pulumi.Input['DataSourceVpcConfigurationArgs']] = None):
        """
        The set of arguments for constructing a DataSource resource.
        :param pulumi.Input[builtins.str] application_id: The identifier of the Amazon Q Business application the data source will be attached to.
        :param Any configuration: Use this property to specify a JSON or YAML schema with configuration properties specific to your data source connector to connect your data source repository to Amazon Q Business . You must use the JSON or YAML schema provided by Amazon Q .
               
               The following links have the configuration properties and schemas for AWS CloudFormation for the following connectors:
               
               - [Amazon Simple Storage Service](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/s3-cfn.html)
               - [Amazon Q Web Crawler](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/web-crawler-cfn.html)
               
               Similarly, you can find configuration templates and properties for your specific data source using the following steps:
               
               - Navigate to the [Supported connectors](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html) page in the Amazon Q Business User Guide, and select the data source connector of your choice.
               - Then, from that specific data source connector's page, choose the topic containing *Using AWS CloudFormation* to find the schemas for your data source connector, including configuration parameter descriptions and examples.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::QBusiness::DataSource` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] display_name: The name of the Amazon Q Business data source.
        :param pulumi.Input[builtins.str] index_id: The identifier of the index the data source is attached to.
        :param pulumi.Input[builtins.str] description: A description for the data source connector.
        :param pulumi.Input['DataSourceDocumentEnrichmentConfigurationArgs'] document_enrichment_configuration: Provides the configuration information for altering document metadata and content during the document ingestion process.
               
               For more information, see [Custom document enrichment](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html) .
        :param pulumi.Input['DataSourceMediaExtractionConfigurationArgs'] media_extraction_configuration: The configuration for extracting information from media in documents.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources.
        :param pulumi.Input[builtins.str] sync_schedule: Sets the frequency for Amazon Q Business to check the documents in your data source repository and update your index. If you don't set a schedule, Amazon Q Business won't periodically update the index.
               
               Specify a `cron-` format schedule string or an empty string to indicate that the index is updated on demand. You can't specify the `Schedule` parameter when the `Type` parameter is set to `CUSTOM` . If you do, you receive a `ValidationException` exception.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        :param pulumi.Input['DataSourceVpcConfigurationArgs'] vpc_configuration: Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. For more information, see [Using Amazon VPC with Amazon Q Business connectors](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html) .
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "index_id", index_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if document_enrichment_configuration is not None:
            pulumi.set(__self__, "document_enrichment_configuration", document_enrichment_configuration)
        if media_extraction_configuration is not None:
            pulumi.set(__self__, "media_extraction_configuration", media_extraction_configuration)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if sync_schedule is not None:
            pulumi.set(__self__, "sync_schedule", sync_schedule)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_configuration is not None:
            pulumi.set(__self__, "vpc_configuration", vpc_configuration)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the Amazon Q Business application the data source will be attached to.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def configuration(self) -> Any:
        """
        Use this property to specify a JSON or YAML schema with configuration properties specific to your data source connector to connect your data source repository to Amazon Q Business . You must use the JSON or YAML schema provided by Amazon Q .

        The following links have the configuration properties and schemas for AWS CloudFormation for the following connectors:

        - [Amazon Simple Storage Service](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/s3-cfn.html)
        - [Amazon Q Web Crawler](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/web-crawler-cfn.html)

        Similarly, you can find configuration templates and properties for your specific data source using the following steps:

        - Navigate to the [Supported connectors](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html) page in the Amazon Q Business User Guide, and select the data source connector of your choice.
        - Then, from that specific data source connector's page, choose the topic containing *Using AWS CloudFormation* to find the schemas for your data source connector, including configuration parameter descriptions and examples.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::QBusiness::DataSource` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Any):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Amazon Q Business data source.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the index the data source is attached to.
        """
        return pulumi.get(self, "index_id")

    @index_id.setter
    def index_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "index_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the data source connector.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="documentEnrichmentConfiguration")
    def document_enrichment_configuration(self) -> Optional[pulumi.Input['DataSourceDocumentEnrichmentConfigurationArgs']]:
        """
        Provides the configuration information for altering document metadata and content during the document ingestion process.

        For more information, see [Custom document enrichment](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html) .
        """
        return pulumi.get(self, "document_enrichment_configuration")

    @document_enrichment_configuration.setter
    def document_enrichment_configuration(self, value: Optional[pulumi.Input['DataSourceDocumentEnrichmentConfigurationArgs']]):
        pulumi.set(self, "document_enrichment_configuration", value)

    @property
    @pulumi.getter(name="mediaExtractionConfiguration")
    def media_extraction_configuration(self) -> Optional[pulumi.Input['DataSourceMediaExtractionConfigurationArgs']]:
        """
        The configuration for extracting information from media in documents.
        """
        return pulumi.get(self, "media_extraction_configuration")

    @media_extraction_configuration.setter
    def media_extraction_configuration(self, value: Optional[pulumi.Input['DataSourceMediaExtractionConfigurationArgs']]):
        pulumi.set(self, "media_extraction_configuration", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="syncSchedule")
    def sync_schedule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets the frequency for Amazon Q Business to check the documents in your data source repository and update your index. If you don't set a schedule, Amazon Q Business won't periodically update the index.

        Specify a `cron-` format schedule string or an empty string to indicate that the index is updated on demand. You can't specify the `Schedule` parameter when the `Type` parameter is set to `CUSTOM` . If you do, you receive a `ValidationException` exception.
        """
        return pulumi.get(self, "sync_schedule")

    @sync_schedule.setter
    def sync_schedule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sync_schedule", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> Optional[pulumi.Input['DataSourceVpcConfigurationArgs']]:
        """
        Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. For more information, see [Using Amazon VPC with Amazon Q Business connectors](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html) .
        """
        return pulumi.get(self, "vpc_configuration")

    @vpc_configuration.setter
    def vpc_configuration(self, value: Optional[pulumi.Input['DataSourceVpcConfigurationArgs']]):
        pulumi.set(self, "vpc_configuration", value)


@pulumi.type_token("aws-native:qbusiness:DataSource")
class DataSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[Any] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 document_enrichment_configuration: Optional[pulumi.Input[Union['DataSourceDocumentEnrichmentConfigurationArgs', 'DataSourceDocumentEnrichmentConfigurationArgsDict']]] = None,
                 index_id: Optional[pulumi.Input[builtins.str]] = None,
                 media_extraction_configuration: Optional[pulumi.Input[Union['DataSourceMediaExtractionConfigurationArgs', 'DataSourceMediaExtractionConfigurationArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 sync_schedule: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 vpc_configuration: Optional[pulumi.Input[Union['DataSourceVpcConfigurationArgs', 'DataSourceVpcConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        Definition of AWS::QBusiness::DataSource Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: The identifier of the Amazon Q Business application the data source will be attached to.
        :param Any configuration: Use this property to specify a JSON or YAML schema with configuration properties specific to your data source connector to connect your data source repository to Amazon Q Business . You must use the JSON or YAML schema provided by Amazon Q .
               
               The following links have the configuration properties and schemas for AWS CloudFormation for the following connectors:
               
               - [Amazon Simple Storage Service](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/s3-cfn.html)
               - [Amazon Q Web Crawler](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/web-crawler-cfn.html)
               
               Similarly, you can find configuration templates and properties for your specific data source using the following steps:
               
               - Navigate to the [Supported connectors](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html) page in the Amazon Q Business User Guide, and select the data source connector of your choice.
               - Then, from that specific data source connector's page, choose the topic containing *Using AWS CloudFormation* to find the schemas for your data source connector, including configuration parameter descriptions and examples.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::QBusiness::DataSource` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] description: A description for the data source connector.
        :param pulumi.Input[builtins.str] display_name: The name of the Amazon Q Business data source.
        :param pulumi.Input[Union['DataSourceDocumentEnrichmentConfigurationArgs', 'DataSourceDocumentEnrichmentConfigurationArgsDict']] document_enrichment_configuration: Provides the configuration information for altering document metadata and content during the document ingestion process.
               
               For more information, see [Custom document enrichment](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html) .
        :param pulumi.Input[builtins.str] index_id: The identifier of the index the data source is attached to.
        :param pulumi.Input[Union['DataSourceMediaExtractionConfigurationArgs', 'DataSourceMediaExtractionConfigurationArgsDict']] media_extraction_configuration: The configuration for extracting information from media in documents.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources.
        :param pulumi.Input[builtins.str] sync_schedule: Sets the frequency for Amazon Q Business to check the documents in your data source repository and update your index. If you don't set a schedule, Amazon Q Business won't periodically update the index.
               
               Specify a `cron-` format schedule string or an empty string to indicate that the index is updated on demand. You can't specify the `Schedule` parameter when the `Type` parameter is set to `CUSTOM` . If you do, you receive a `ValidationException` exception.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        :param pulumi.Input[Union['DataSourceVpcConfigurationArgs', 'DataSourceVpcConfigurationArgsDict']] vpc_configuration: Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. For more information, see [Using Amazon VPC with Amazon Q Business connectors](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html) .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::QBusiness::DataSource Resource Type

        :param str resource_name: The name of the resource.
        :param DataSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[Any] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 document_enrichment_configuration: Optional[pulumi.Input[Union['DataSourceDocumentEnrichmentConfigurationArgs', 'DataSourceDocumentEnrichmentConfigurationArgsDict']]] = None,
                 index_id: Optional[pulumi.Input[builtins.str]] = None,
                 media_extraction_configuration: Optional[pulumi.Input[Union['DataSourceMediaExtractionConfigurationArgs', 'DataSourceMediaExtractionConfigurationArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 sync_schedule: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 vpc_configuration: Optional[pulumi.Input[Union['DataSourceVpcConfigurationArgs', 'DataSourceVpcConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataSourceArgs.__new__(DataSourceArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["document_enrichment_configuration"] = document_enrichment_configuration
            if index_id is None and not opts.urn:
                raise TypeError("Missing required property 'index_id'")
            __props__.__dict__["index_id"] = index_id
            __props__.__dict__["media_extraction_configuration"] = media_extraction_configuration
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["sync_schedule"] = sync_schedule
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_configuration"] = vpc_configuration
            __props__.__dict__["created_at"] = None
            __props__.__dict__["data_source_arn"] = None
            __props__.__dict__["data_source_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["updated_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["applicationId", "indexId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DataSource, __self__).__init__(
            'aws-native:qbusiness:DataSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DataSource':
        """
        Get an existing DataSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DataSourceArgs.__new__(DataSourceArgs)

        __props__.__dict__["application_id"] = None
        __props__.__dict__["configuration"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["data_source_arn"] = None
        __props__.__dict__["data_source_id"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["document_enrichment_configuration"] = None
        __props__.__dict__["index_id"] = None
        __props__.__dict__["media_extraction_configuration"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["sync_schedule"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["updated_at"] = None
        __props__.__dict__["vpc_configuration"] = None
        return DataSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon Q Business application the data source will be attached to.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Any]:
        """
        Use this property to specify a JSON or YAML schema with configuration properties specific to your data source connector to connect your data source repository to Amazon Q Business . You must use the JSON or YAML schema provided by Amazon Q .

        The following links have the configuration properties and schemas for AWS CloudFormation for the following connectors:

        - [Amazon Simple Storage Service](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/s3-cfn.html)
        - [Amazon Q Web Crawler](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/web-crawler-cfn.html)

        Similarly, you can find configuration templates and properties for your specific data source using the following steps:

        - Navigate to the [Supported connectors](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connectors-list.html) page in the Amazon Q Business User Guide, and select the data source connector of your choice.
        - Then, from that specific data source connector's page, choose the topic containing *Using AWS CloudFormation* to find the schemas for your data source connector, including configuration parameter descriptions and examples.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::QBusiness::DataSource` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The Unix timestamp when the Amazon Q Business data source was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dataSourceArn")
    def data_source_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of a data source in an Amazon Q Business application.
        """
        return pulumi.get(self, "data_source_arn")

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon Q Business data source.
        """
        return pulumi.get(self, "data_source_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for the data source connector.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Amazon Q Business data source.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="documentEnrichmentConfiguration")
    def document_enrichment_configuration(self) -> pulumi.Output[Optional['outputs.DataSourceDocumentEnrichmentConfiguration']]:
        """
        Provides the configuration information for altering document metadata and content during the document ingestion process.

        For more information, see [Custom document enrichment](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html) .
        """
        return pulumi.get(self, "document_enrichment_configuration")

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the index the data source is attached to.
        """
        return pulumi.get(self, "index_id")

    @property
    @pulumi.getter(name="mediaExtractionConfiguration")
    def media_extraction_configuration(self) -> pulumi.Output[Optional['outputs.DataSourceMediaExtractionConfiguration']]:
        """
        The configuration for extracting information from media in documents.
        """
        return pulumi.get(self, "media_extraction_configuration")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['DataSourceStatus']:
        """
        The status of the Amazon Q Business data source.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="syncSchedule")
    def sync_schedule(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Sets the frequency for Amazon Q Business to check the documents in your data source repository and update your index. If you don't set a schedule, Amazon Q Business won't periodically update the index.

        Specify a `cron-` format schedule string or an empty string to indicate that the index is updated on demand. You can't specify the `Schedule` parameter when the `Type` parameter is set to `CUSTOM` . If you do, you receive a `ValidationException` exception.
        """
        return pulumi.get(self, "sync_schedule")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the Amazon Q Business data source.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The Unix timestamp when the Amazon Q Business data source was last updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> pulumi.Output[Optional['outputs.DataSourceVpcConfiguration']]:
        """
        Configuration information for an Amazon VPC (Virtual Private Cloud) to connect to your data source. For more information, see [Using Amazon VPC with Amazon Q Business connectors](https://docs.aws.amazon.com/amazonq/latest/business-use-dg/connector-vpc.html) .
        """
        return pulumi.get(self, "vpc_configuration")

